/* scale.c v0.80 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "specific.h"
/*---------------------------------------------------------------------------*/
#define DELAY_MIN 0
#define DELAY_MAX 3000
#define DELAY_STEP 100

#define DIRECTION_MIN 0
#define DIRECTION_MAX 1
#define DIRECTION_STEP 1

#define END_MIN 0.02
#define END_MAX 5
#define END_STEP 0.01

#define SORT_MIN 1
#define SORT_MAX 4
#define SORT_STEP 1

#define START_MIN 0.01
#define START_MAX 4
#define START_STEP 0.01

#define STEP_MIN 0.01
#define STEP_MAX 2
#define STEP_STEP 0.01

#define X_MIN 0
#define X_MAX scr_w
#define X_STEP 10

#define Y_MIN 0
#define Y_MAX scr_h
#define Y_STEP 10
/*---------------------------------------------------------------------------*/
/* variables */
float scalef;

int delayy, direction, x, y;
float end, start, step;

static tkeyparse
  see_f8_0 = {K_0, keysee_f8_0}, /* scale.c specific */
  see_f8_1 = {K_1, keysee_f8_1},
  see_f8_2 = {K_2, keysee_f8_2},
  see_f8_3 = {K_3, keysee_f8_3},
  see_f8_4 = {K_4, keysee_f8_4},
  see_f8_5 = {K_5, keysee_f8_5},
  see_f8_6 = {K_6, keysee_f8_6},
  see_f8_7 = {K_7, keysee_f8_7},
  see_f8_8 = {K_8, keysee_f8_8},
  see_f8_9 = {K_9, keysee_f8_9},
  see_f8_A = {K_A, keysee_f8_A},
  see_f8_D = {K_D, keysee_f8_D},
  see_f8_J = {K_J, keysee_f8_J},
  see_f8_M = {K_M, keysee_f8_M},
  see_f8_N = {K_N, keysee_f8_N},
  see_f8_O = {K_O, keysee_f8_O},
  see_f8_X = {K_X, keysee_f8_X},
  see_f8_Y = {K_Y, keysee_f8_Y},
  see_f8_a = {K_a, keysee_f8_a},
  see_f8_d = {K_d, keysee_f8_d},
  see_f8_j = {K_j, keysee_f8_j},
  see_f8_m = {K_m, keysee_f8_m},
  see_f8_n = {K_n, keysee_f8_n},
  see_f8_o = {K_o, keysee_f8_o},
  see_f8_x = {K_x, keysee_f8_x},
  see_f8_y = {K_y, keysee_f8_y}
;

tkeyparse* tkeyparsetbl_scale[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */  
  &see_f8_0, /* scale.c specific */
  &see_f8_1,
  &see_f8_2,
  &see_f8_3,
  &see_f8_4,
  &see_f8_5,
  &see_f8_6,
  &see_f8_7,
  &see_f8_8,
  &see_f8_9,
  &see_f8_A,
  &see_f8_D,
  &see_f8_J,
  &see_f8_M,
  &see_f8_N,
  &see_f8_O,
  &see_f8_X,
  &see_f8_Y,
  &see_f8_a,
  &see_f8_d,
  &see_f8_j,
  &see_f8_m,
  &see_f8_n,
  &see_f8_o,
  &see_f8_x,
  &see_f8_y,
  NULL
};

teffect eff_scale =
{
  scale_init,
  scale_effect,
  scale_loop_end,
  scale_done,
  tkeyparsetbl_scale,
  1
};
/*---------------------------------------------------------------------------*/
int scale_loop_end()
{
  switch (lastkey)
    {
    COMMON_LOOP_END
    case K_A:
    case K_D:
    case K_J:
    case K_M:
    case K_N:
    case K_O:
    case K_X:
    case K_Y:
    case K_a:
    case K_d:
    case K_j:
    case K_m:
    case K_n:
    case K_o:
    case K_x:
    case K_y:
      return 0;
      break;
    default:
      return 1;
      break;
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f8_0()
{
  keysee_f8_gen("f8_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_1()
{
  keysee_f8_gen("f8_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_2()
{
  keysee_f8_gen("f8_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_3()
{
  keysee_f8_gen("f8_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_4()
{
  keysee_f8_gen("f8_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_5()
{
  keysee_f8_gen("f8_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_6()
{
  keysee_f8_gen("f8_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_7()
{
  keysee_f8_gen("f8_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_8()
{
  keysee_f8_gen("f8_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_9()
{
  keysee_f8_gen("f8_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f8_A()
{
  paraint(&eff_scale.asort, SORT_MIN, SORT_MAX, SORT_STEP, 1, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_D()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_J()
{
  paraint(&direction, DIRECTION_MIN, DIRECTION_MAX, DIRECTION_STEP, 1,1);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_M()
{
  parafloat(&start, START_MIN, START_MAX, START_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_N()
{
  parafloat(&end, END_MIN, END_MAX, END_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_O()
{
  parafloat(&step, STEP_MIN, STEP_MAX, STEP_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_X()
{
  paraint(&x, X_MIN, X_MAX, X_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_Y()
{
  paraint(&y, Y_MIN, Y_MAX, Y_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_a()
{
  paraint(&eff_scale.asort, SORT_MIN, SORT_MAX, SORT_STEP, 0, 1);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_d()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_gen(uchr s[256])
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", s, &pi);
  eff_scale.asort = atoi(tps[1]);
  delayy = atoi(tps[2]);
  direction = atoi(tps[3]);
  start = atof(tps[4]);
  end = atof(tps[5]);
  step = atof(tps[6]);
  x = atoi(tps[7]);
  y = atoi(tps[8]);

  if (direction == 0)
  {
    scalef = start;
  }
  else if (direction == 1)
  {
    scalef = end;
  }
  do_effect(&eff_scale);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_j()
{
  paraint(&direction, DIRECTION_MIN, DIRECTION_MAX, DIRECTION_STEP, 0,1);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_m()
{
  parafloat(&start, START_MIN, START_MAX, START_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_n()
{
  parafloat(&end, END_MIN, END_MAX, END_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_o()
{
  parafloat(&step, STEP_MIN, STEP_MAX, STEP_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_x()
{
  paraint(&x, X_MIN, X_MAX, X_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f8_y()
{
  paraint(&y, Y_MIN, Y_MAX, Y_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void scale_done()
{
}
/*---------------------------------------------------------------------------*/
void scale_effect(int asort)
{
  switch (asort)
    {
    case 1:
      stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, x, y,
		   pbmp->w * scalef, pbmp->h * scalef);
      break;
    case 2:
      stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, x, y,
		   pbmp->w * scalef, pbmp->h * scalef);
      stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, x + scr_w/2, y,
		   pbmp->w * scalef, pbmp->h * scalef);
      break;
    case 3:
      stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, x, y,
		   pbmp->w * scalef, pbmp->h * scalef);
      stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, x + scr_w/2, y,
		   pbmp->w * scalef, pbmp->h * scalef);
      stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, x + scr_w/2,
		   y + scr_h/2, pbmp->w * scalef, pbmp->h * scalef);
      break;
    case 4:
      stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, x, y,
		   pbmp->w * scalef, pbmp->h * scalef);
      stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, x + scr_w/2, y,
		   pbmp->w * scalef, pbmp->h * scalef);
      stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, x + scr_w/2,
		   y + scr_h/2, pbmp->w * scalef, pbmp->h * scalef);
      stretch_blit(pbmp, screen, 0, 0, pbmp->w, pbmp->h, x, y + scr_h/2,
		   pbmp->w * scalef, pbmp->h * scalef);
      break;
    }
  if (direction == 0)
    {
      scalef += step;
      if (scalef > end)
	{
	  scalef = start;
	}
    }
  else if (direction == 1)
    {
      scalef -= step;
      if (scalef < start)
	{
	  scalef = end;
	}
    }
  rest(delayy);
}
/*---------------------------------------------------------------------------*/
void scale_init()
{
  lastkey = K_d;
}
