/* palchan.c v0.80 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "specific.h"
/*---------------------------------------------------------------------------*/
#define DELAY_MIN 0
#define DELAY_MAX 3000
#define DELAY_STEP 100

#define SORT_MIN 1
#define SORT_MAX 2
#define SORT_STEP 1
/*---------------------------------------------------------------------------*/
/* variables */
char palchan_file[256];

int delayy;

static tkeyparse
  see_f6_0 = {K_0, keysee_f6_0}, /* palchan.c specific */
  see_f6_1 = {K_1, keysee_f6_1},
  see_f6_2 = {K_2, keysee_f6_2},
  see_f6_3 = {K_3, keysee_f6_3},
  see_f6_4 = {K_4, keysee_f6_4},
  see_f6_5 = {K_5, keysee_f6_5},
  see_f6_6 = {K_6, keysee_f6_6},
  see_f6_7 = {K_7, keysee_f6_7},
  see_f6_8 = {K_8, keysee_f6_8},
  see_f6_9 = {K_9, keysee_f6_9},
  see_f6_B = {K_B, keysee_f6_B},
  see_f6_D = {K_D, keysee_f6_D},
  see_f6_G = {K_G, keysee_f6_G},
  see_f6_L = {K_L, keysee_f6_L},
  see_f6_R = {K_R, keysee_f6_R},
  see_f6_b = {K_b, keysee_f6_b},
  see_f6_d = {K_d, keysee_f6_d},
  see_f6_g = {K_g, keysee_f6_g},
  see_f6_l = {K_l, keysee_f6_l},
  see_f6_r = {K_r, keysee_f6_r}
;

tkeyparse* tkeyparsetbl_palchan[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f6_0, /* palchan.c specific */
  &see_f6_1,
  &see_f6_2,
  &see_f6_3,
  &see_f6_4,
  &see_f6_5,
  &see_f6_6,
  &see_f6_7,
  &see_f6_8,
  &see_f6_9,
  &see_f6_B,
  &see_f6_D,
  &see_f6_G,
  &see_f6_L,
  &see_f6_R,
  &see_f6_b,
  &see_f6_d,
  &see_f6_g,
  &see_f6_l,
  &see_f6_r,
  NULL
};
/*---------------------------------------------------------------------------*/
teffect eff_palchan =
{
  palchan_init,
  palchan_effect,
  palchan_loop_end,
  palchan_done,
  tkeyparsetbl_palchan,
  1
};
/*---------------------------------------------------------------------------*/
int palchan_loop_end()
{
  switch (lastkey)
    {
    COMMON_LOOP_END
    case K_A:
    case K_B:
    case K_D:
    case K_G:
    case K_L:
    case K_R:
    case K_a:
    case K_b:
    case K_d:
    case K_g:
    case K_l:
    case K_r:
      return 0;
      break;
    default:
      return 1;
      break;
    }
}
/*---------------------------------------------------------------------------*/
void keysee_f6_0()
{
  keysee_f6_gen("f6_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f6_1()
{
  keysee_f6_gen("f6_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f6_2()
{
  keysee_f6_gen("f6_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f6_3()
{
  keysee_f6_gen("f6_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f6_4()
{
  keysee_f6_gen("f6_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f6_5()
{
  keysee_f6_gen("f6_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f6_6()
{
  keysee_f6_gen("f6_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f6_7()
{
  keysee_f6_gen("f6_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f6_8()
{
  keysee_f6_gen("f6_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f6_9()
{
  keysee_f6_gen("f6_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f6_B()
{
  int i = 0, j;
  int done = 0;

  do
    {
      if (eff_palchan.asort == 2)
	{
	  for (j = 0; j < 256; j++)
	    {
	      if (pal[j].b == 63)
		{
		  done = 1;
		  break;
		}
	    }
	}
      if (!done)
	{
	  if (pal[i].b < 63)
	    {
	      pal[i].b++;
	    }
	  i++;
	}
    }
  while ((i < 256) && (!done));
  set_palette(pal);
}
/*---------------------------------------------------------------------------*/
void keysee_f6_D()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f6_G()
{
  int i = 0, j;
  int done = 0;

  do
    {
      if (eff_palchan.asort == 2)
	{
	  for (j = 0; j < 256; j++)
	    {
	      if (pal[j].g == 63)
		{
		  done = 1;
		  break;
		}
	    }
	}
      if (!done)
	{
	  if (pal[i].g < 63)
	    {
	      pal[i].g++;
	    }
	  i++;
	}
    }
  while ((i < 256) && (!done));
  set_palette(pal);
}
/*---------------------------------------------------------------------------*/
void keysee_f6_L()
{
  int i = 0, j;
  int done = 0;

  do
    {
      if (eff_palchan.asort == 2)
	{
	  for (j = 0; j < 256; j++)
	    {
	      if ((pal[j].r == 63) || (pal[j].g == 63) || (pal[j].b == 63))
		{
		  done = 1;
		  break;
		}
	    }
	}
      if (!done)
	{
	  if (pal[i].r < 63)
	    {
	      pal[i].r++;
	    }
	  if (pal[i].g < 63)
	    {
	      pal[i].g++;
	    }
	  if (pal[i].b < 63)
	    {
	      pal[i].b++;
	    }
	  i++;
	}
    }
  while ((i < 256) && (!done));
  set_palette(pal);
}
/*---------------------------------------------------------------------------*/
void keysee_f6_R()
{
  int i = 0, j;
  int done = 0;

  do
    {
      if (eff_palchan.asort == 2)
	{
	  for (j = 0; j < 256; j++)
	    {
	      if (pal[j].r == 63)
		{
		  done = 1;
		  break;
		}
	    }
	}
      if (!done)
	{
	  if (pal[i].r < 63)
	    {
	      pal[i].r++;
	    }
	  i++;
	}
    }
  while ((i < 256) && (!done));
  set_palette(pal);
}
/*---------------------------------------------------------------------------*/
void keysee_f6_b()
{
  int i = 0, j;
  int done = 0;

  do
    {
      if (eff_palchan.asort == 2)
	{
	  for (j = 0; j < 256; j++)
	    {
	      if (pal[j].b == 0)
		{
		  done = 1;
		  break;
		}
	    }
	}
      if (!done)
	{
	  if (pal[i].b > 0)
	    {
	      pal[i].b--;
	    }
	  i++;
	}
    }
  while ((i < 256) && (!done));
  set_palette(pal);
}
/*---------------------------------------------------------------------------*/
void keysee_f6_d()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f6_g()
{
  int i = 0, j;
  int done = 0;

  do
    {
      if (eff_palchan.asort == 2)
	{
	  for (j = 0; j < 256; j++)
	    {
	      if (pal[j].g == 0)
		{
		  done = 1;
		  break;
		}
	    }
	}
      if (!done)
	{
	  if (pal[i].g > 0)
	    {
	      pal[i].g--;
	    }
	  i++;
	}
    }
  while ((i < 256) && (!done));
  set_palette(pal);
}
/*---------------------------------------------------------------------------*/
void keysee_f6_gen(uchr s[256])
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", s, &pi);
  delayy = atoi(tps[1]);
  strcpy(palchan_file, tps[2]);
  do_effect(&eff_palchan);
}
/*---------------------------------------------------------------------------*/
void keysee_f6_l()
{
  int i = 0, j;
  int done = 0;

  do
    {
      if (eff_palchan.asort == 2)
	{
	  for (j = 0; j < 256; j++)
	    {
	      if ((pal[j].r == 0) || (pal[j].g == 0) || (pal[j].b == 0))
		{
		  done = 1;
		  break;
		}
	    }
	}
      if (!done)
	{
	  if (pal[i].r > 0)
	    {
	      pal[i].r--;
	    }
	  if (pal[i].g > 0)
	    {
	      pal[i].g--;
	    }
	  if (pal[i].b > 0)
	    {
	      pal[i].b--;
	    }
	  i++;
	}
    }
  while ((i < 256) && (!done));
  set_palette(pal);
}
/*---------------------------------------------------------------------------*/
void keysee_f6_r()
{
  int i = 0, j;
  int done = 0;

  do
    {
      if (eff_palchan.asort == 2)
	{
	  for (j = 0; j < 256; j++)
	    {
	      if (pal[j].r == 0)
		{
		  done = 1;
		  break;
		}
	    }
	}
      if (!done)
	{
	  if (pal[i].r > 0)
	    {
	      pal[i].r--;
	    }
	  i++;
	}
    }
  while ((i < 256) && (!done));
  set_palette(pal);
}
/*---------------------------------------------------------------------------*/
void palchan_done()
{
}
/*---------------------------------------------------------------------------*/
void palchan_effect()
{
  rest(delayy);
}
/*---------------------------------------------------------------------------*/
void palchan_init()
{
  int i = 0, p;
  FILE *fp;

  if (!(strcmp(palchan_file, "pal")))
    {
      keysee_home();
    }
  else
    {
      fp = fopenm(palchan_file, "rt");
      do
	{
	  fscanf(fp, "%i", &p);
	  pal[i].r = p/4;
	  fscanf(fp, "%i", &p);
	  pal[i].g = p/4;
	  fscanf(fp, "%i", &p);
	  pal[i].b = p/4;
	  i++;
	}
      while (i < 256);
      fclose(fp);
      set_palette(pal);
    }
  lastkey = K_d;
}
