/* fades.c v0.80 */
/* EB = Edward Boone */
/* epsilonbeta@geocities.com */
/* http://www.geocities.com/SiliconValley/Vista/6617/index.html */
/* Only nothing seems to be what it looks like */
/*---------------------------------------------------------------------------*/
/* #include */
#include "specific.h"
/*---------------------------------------------------------------------------*/
/* #define */
#define DELAY_MIN 0
#define DELAY_MAX 3000
#define DELAY_STEP 100

#define EFF_MIN 1
#define EFF_MAX 64
#define EFF_STEP 1

#define END_MIN 1
#define END_MAX 255
#define END_STEP 1

#define START_MIN 0
#define START_MAX 254
#define START_STEP 1
/*---------------------------------------------------------------------------*/
/* variables */
uchr filename[255];
int i, j;
fades_pal pallst[1000];

int delayy, eff, end, start;

static tkeyparse
  see_f4_0 = {K_0, keysee_f4_0}, /* fades.c specific */
  see_f4_1 = {K_1, keysee_f4_1},
  see_f4_2 = {K_2, keysee_f4_2},
  see_f4_3 = {K_3, keysee_f4_3},
  see_f4_4 = {K_4, keysee_f4_4},
  see_f4_5 = {K_5, keysee_f4_5},
  see_f4_6 = {K_6, keysee_f4_6},
  see_f4_7 = {K_7, keysee_f4_7},
  see_f4_8 = {K_8, keysee_f4_8},
  see_f4_9 = {K_9, keysee_f4_9},
  see_f4_D = {K_D, keysee_f4_D},
  see_f4_E = {K_E, keysee_f4_E},
  see_f4_M = {K_M, keysee_f4_M},
  see_f4_N = {K_N, keysee_f4_N},
  see_f4_d = {K_d, keysee_f4_d},
  see_f4_e = {K_e, keysee_f4_e},
  see_f4_m = {K_m, keysee_f4_m},
  see_f4_n = {K_n, keysee_f4_n}
;

tkeyparse* tkeyparsetbl_fades[] =
{
  TKEYPARSETBL_SEE, /* see.c specific */
  &see_f4_0, /* fades.c specific */
  &see_f4_1,
  &see_f4_2,
  &see_f4_3,
  &see_f4_4,
  &see_f4_5,
  &see_f4_6,
  &see_f4_7,
  &see_f4_8,
  &see_f4_9,
  &see_f4_D,
  &see_f4_E,
  &see_f4_M,
  &see_f4_N,
  &see_f4_d,
  &see_f4_e,
  &see_f4_m,
  &see_f4_n,
  NULL
};

teffect eff_fades =
{
  fades_init,
  fades_effect,
  fades_loop_end,
  fades_done,
  tkeyparsetbl_fades,
  1
};
/*---------------------------------------------------------------------------*/
int fades_loop_end()
{
  switch (lastkey)
    {
    COMMON_LOOP_END
    case K_D:
    case K_E:
    case K_M:
    case K_N:
    case K_V:
    case K_d:
    case K_e:
    case K_m:
    case K_n:
    case K_v:
      return 0;
      break;
    default:
      return 1;
      break;
    }
}
/*---------------------------------------------------------------------------*/
void fades_done()
{
}
/*---------------------------------------------------------------------------*/
void fades_effect()
{
  for (i = 0; (i < j) && (!effect.loop_end()); i++)
    {
      if (i == j - 1)
	{
	  fade_from_range(pallst[i].p, pallst[0].p, eff, start, end);
	}
      else
	{
	  fade_from_range(pallst[i].p, pallst[i+1].p, eff, start, end);
	}
      rest(delayy);
      ptkeyparsetbl = tkeyparsetbl_fades;
      key_scan();
    }
}
/*---------------------------------------------------------------------------*/
void fades_init()
{
  int p;
  char s[256];
  FILE *fp, *fpl;

  i = 0;
  j = 0;
  fpl = fopenm(filename, "rt");
  while (!feof(fpl))
    {
      if (!fscanf(fpl, "%s", s))
	{
	  break;
	}
      else
	{
	  if (strcmp(s, "pal")) /* another string then "pal" */
	    {
	      fp = fopenm(s, "rt"); /* open .map-file */
	      strcpy(pallst[j].s, s);
	      i = 0;
	      do
		{
		  fscanf(fp, "%i", &p);
		  pallst[j].p[i].r = p / 4;
		  fscanf(fp, "%i", &p);
		  pallst[j].p[i].g = p / 4;
		  fscanf(fp, "%i", &p);
		  pallst[j].p[i].b = p / 4;
		  i++;
		}
	      while (i < 256);
	      fclose(fp);
	    }
	  else /* "pal" */
	    {
	      strcpy(pallst[j].s, "pal");
	      i = 0; /* pallst[j].p = pal */
	      do
		{
		  pallst[j].p[i].r = pal[i].r;
		  pallst[j].p[i].g = pal[i].g;
		  pallst[j].p[i].b = pal[i].b;
		  i++;
		}
	      while (i < 256);
	    }
	  j++;
	}
    }
  fclose(fpl);

  lastkey = K_d;
}
/*---------------------------------------------------------------------------*/
void keysee_f4_0()
{
  keysee_f4_gen("f4_0");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_1()
{
  keysee_f4_gen("f4_1");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_2()
{
  keysee_f4_gen("f4_2");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_3()
{
  keysee_f4_gen("f4_3");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_4()
{
  keysee_f4_gen("f4_4");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_5()
{
  keysee_f4_gen("f4_5");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_6()
{
  keysee_f4_gen("f4_6");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_7()
{
  keysee_f4_gen("f4_7");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_8()
{
  keysee_f4_gen("f4_8");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_9()
{
  keysee_f4_gen("f4_9");
}
/*---------------------------------------------------------------------------*/
void keysee_f4_D()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f4_E()
{
  paraint(&eff, EFF_MIN, EFF_MAX, EFF_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f4_M()
{
  paraint(&start, START_MIN, START_MAX, START_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f4_N()
{
  paraint(&end, END_MIN, END_MAX, END_STEP, 1, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f4_d()
{
  paraint(&delayy, DELAY_MIN, DELAY_MAX, DELAY_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f4_e()
{
  paraint(&eff, EFF_MIN, EFF_MAX, EFF_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f4_gen(uchr s[256])
{
  int pi;
  char **tps;

  tps = get_config_argv("[See]", s, &pi);
  delayy = atoi(tps[1]);
  eff = atoi(tps[2]);
  start = atoi(tps[3]);
  end = atoi(tps[4]);
  strcpy(filename, tps[5]);
  do_effect(&eff_fades);
}
/*---------------------------------------------------------------------------*/
void keysee_f4_m()
{
  paraint(&start, START_MIN, START_MAX, START_STEP, 0, 0);
}
/*---------------------------------------------------------------------------*/
void keysee_f4_n()
{
  paraint(&end, END_MIN, END_MAX, END_STEP, 0, 0);
}
