/* $Id: dsm-ver.c,v 1.6 2002/07/21 18:22:10 richdawe Exp $ */

/*
 * dsm-ver.c - Test program for pakke's dsm_parse_*() functions for versions.
 * Copyright (C) 2000-2002 by Richard Dawe
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libpakke/package.h>
#include <libpakke/dsm.h>

#include "testcase.h"

/* Sanity checks */
#if PACKAGE_VERSION_N_HAS != 14
#error "Need to update test to cope with PACKAGE_VERSION's has_*"
#endif

#if PACKAGE_VERSION_N_DATA != 21
#error "Need to update test to cope with PACKAGE_VERSION's data fields"
#endif

/* Test cases */
testcase_t testcases[] = {
  /* TODO: Write some test cases */

  /* Terminator */
  { NULL }
};

/* --------
 * - main -
 * -------- */

int
main (int argc, char *argv[])
{
  PACKAGE_INFO package;
  int i;
  int quiet = 0;

  /* Parse arguments. */
  for (i = 1; i < argc; i++) {
    /* Quiet operation, for automatic testing. */
    if (   (strcmp(argv[i], "--quiet") == 0)
	|| (strcmp(argv[i], "-q") == 0))
      quiet = 1;
  }

  /* Run through the test cases. */
  for (i = 0; testcases[i].str != NULL; i++) {
    if (!quiet)
      printf("Test case %i: '%s'\n", i + 1, testcases[i].str);

    /* Parse it */
    memset(&package, 0, sizeof(package));

    /*if (ver_parse(testcases[i].str, &package) != MFT_OK) {
      if (!quiet)
	printf("Parsing failed for test case %i\n", i + 1);
      return(EXIT_FAILURE);
    }*/

    if (memcmp(&package.version, &testcases[i].expected,
	       sizeof(package.version)) != 0) {
      if (!quiet)
	printf("Version comparison failed for test case %i\n", i + 1);
      return(EXIT_FAILURE);
    }
  }

  return(EXIT_SUCCESS);
}
