/* $Id: multi.c,v 1.2 2002/06/23 20:28:31 richdawe Exp $ */

/*
 * multi.c - Test program for dependencies when multiple versions of
 * a package are present.
 * Copyright (C) 2001, 2002 by Richard Dawe
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include <libpakke/package.h>
#include <libpakke/packlist.h>
#include <libpakke/packdep.h>

/* Sanity checks */
#if PACKAGE_VERSION_N_HAS != 14
#error "Need to update test to cope with PACKAGE_VERSION's has_*"
#endif

#if PACKAGE_VERSION_N_DATA != 21
#error "Need to update test to cope with PACKAGE_VERSION's data fields"
#endif

PACKAGE_VERSION bar_10_version = {
  1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, /* has_* */
  1, 0, 0, /* major, minor */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* int version components */
  NULL, NULL, NULL, NULL, /* platform components */
  TYPE_BINARIES
};

PACKAGE_VERSION bar_123_version = {
  1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, /* has_* */
  1, 2, 0, 3, 0, /* major, minor, subminor */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, /* int version components */
  NULL, NULL, NULL, NULL, /* platform components */
  TYPE_BINARIES
};

/* --------
 * - main -
 * -------- */

int
main (int argc, char *argv[])
{
  /* Fake package list */
  PACKAGE_INFO packages[3]; /* 1 version of foo, 2 versions of bar */

  /* Dependency for foo package */
  PACKAGE_DEP dep;

  /* For failures */
  PACKAGE_DEP *failed_dep[4] = { NULL, NULL, NULL };
  const int failed_dep_max   = 3;

  const char FOO_PACKAGE_NAME[] = "foo";
  const char BAR_PACKAGE_NAME[] = "bar";

  int quiet = 0;
  int i;

  /* Parse arguments. */
  for (i = 1; i < argc; i++) {
    /* Quiet operation, for automatic testing. */
    if (   (strcmp(argv[i], "--quiet") == 0)
	|| (strcmp(argv[i], "-q") == 0))
      quiet = 1;
  }

  /* Set up package list */
  memset(packages, 0, sizeof(packages));
  memset(&dep, 0, sizeof(dep));

  for (i = 0; i < 3; i++) {
    if (i < 2)
      packages[i].q_forw = &packages[i + 1];
    if (i > 0)
      packages[i].q_back = &packages[i - 1];
  }

  /* Set up foo package & its dependency */
  strcpy(packages[0].name, FOO_PACKAGE_NAME);
  packages[0].deps[0] = &dep;
  packages[0].deps[1] = NULL;
  
  dep.dep_type = PACKAGE_DEP_REQUIRES;
  dep.op       = DEP_OP_EQUAL;
  strcpy(dep.name, BAR_PACKAGE_NAME);
  memcpy(&dep.version, &bar_123_version, sizeof(bar_123_version));

  /* Set up bar packages */
  strcpy(packages[1].name, BAR_PACKAGE_NAME);
  memcpy(&packages[1].version, &bar_10_version, sizeof(bar_10_version));

  strcpy(packages[2].name, BAR_PACKAGE_NAME);
  memcpy(&packages[2].version, &bar_123_version, sizeof(bar_123_version));

  /* Generate cross-links */
  packlist_xref(&packages[0]);

  /* Check that the right dependency has been made */
  if (dep.dep != &packages[2]) {
    if (!quiet)
      puts("Dependency matching failed!");
    return(EXIT_FAILURE);
  }

  return(EXIT_SUCCESS);
}
