/* $Id: syncdb.h,v 1.7 2002/06/23 20:28:31 richdawe Exp $ */

/*
 *  syncdb.h - Header for database synchronisation routines for pakke
 *  Copyright (C) 1999-2002 by Richard Dawe
 *      
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __pakke_syncdb_h__
#define __pakke_syncdb_h__

/* --- Structures --- */

/* Database synchronisation */
typedef struct {
  int	 op;              /* db synchronisation operation     */
  int	 mod;             /* db synchronisation modifier      */
  int	 verbosity;       /* db synchronisation verbosity     */
  int    interactive;     /* Ask the user questions?          */
  char	*root;            /* DJGPP/spec'd root directory      */
  char	*prefix;          /* Prefix to use for non-db actions */
  char  *backup_prefix;   /* Prefix to store backups under    */
  char  *download_prefix; /* Prefix to store downloaded archives */
  char **dsm_path;        /* Installed DSM path list          */
  char **mft_path;        /* Installed manifest path list     */
  char **dsm_path_avail;  /* Available DSM path list          */
  char **zip_path;        /* ZIP archive path list            */
  char **tar_gzip_path;   /* .tar.gz archive path list        */
  char **tar_bzip2_path;  /* .tar.bz2 archive path list       */
} PAKKE_SYNCDB;

/* --- Functions --- */
extern int perform_syncdb (const PAKKE_SYNCDB *req);

#endif	/* __pakke_syncdb_h__ */
