create database vrpt;
use vrpt;


#
# Table structure for table 'attack'
#

# DROP TABLE IF EXISTS attack;
CREATE TABLE `ATTACK` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Year` varchar(4) NOT NULL default '',
  `Month` char(2) NOT NULL default '',
  `Day` char(2) NOT NULL default '',
  `Hour` char(2) NOT NULL default '',
  `DevID` varchar(12) NOT NULL default '',
  `Source` varchar(15) NOT NULL default '',
  `Category` varchar(100) NOT NULL default '',
  `Event` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `IATTACK` (`Year`,`Month`,`Day`,`Hour`,`DevID`,`Source`,`Category`)
) TYPE=InnoDB;

#
# Table structure for table 'config'
#

# DROP TABLE IF EXISTS config;
CREATE TABLE `CONFIG` (
  `Param` varchar(255) NOT NULL default '',
  `Value` varchar(255) NOT NULL default ''
) TYPE=MyISAM;

#
# Table structure for table 'error'
#

# DROP TABLE IF EXISTS error;
CREATE TABLE `ERROR` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Year` char(4) NOT NULL default '',
  `Month` char(2) NOT NULL default '',
  `Day` char(2) NOT NULL default '',
  `Hour` char(2) NOT NULL default '',
  `DevID` char(12) NOT NULL default '',
  `Event` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `IERROR` (`Year`,`Month`,`Day`,`Hour`,`DevID`)
) TYPE=InnoDB;

#
# Table structure for table 'ftp'
#

# DROP TABLE IF EXISTS ftp;
CREATE TABLE `FTP` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Year` varchar(4) NOT NULL default '',
  `Month` char(2) NOT NULL default '',
  `Day` char(2) NOT NULL default '',
  `Hour` char(2) NOT NULL default '',
  `DevID` varchar(12) NOT NULL default '',
  `User` varchar(15) NOT NULL default '',
  `Site` varchar(15) NOT NULL default '',
  `Event` int(11) NOT NULL default '0',
  `Byte` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `IFTP` (`Year`,`Month`,`Day`,`Hour`,`DevID`,`User`,`Site`)
) TYPE=InnoDB;

#
# Table structure for table 'mail'
#

# DROP TABLE IF EXISTS mail;
CREATE TABLE `MAIL` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Year` varchar(4) NOT NULL default '',
  `Month` char(2) NOT NULL default '',
  `Day` char(2) NOT NULL default '',
  `Hour` char(2) NOT NULL default '',
  `DevID` varchar(12) NOT NULL default '',
  `User` varchar(15) NOT NULL default '',
  `Site` varchar(15) NOT NULL default '',
  `Event` int(11) NOT NULL default '0',
  `Byte` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `IMAIL` (`Year`,`Month`,`Day`,`Hour`,`DevID`,`User`,`Site`)
) TYPE=InnoDB;

#
# Table structure for table 'reportschedule'
#

# DROP TABLE IF EXISTS reportschedule;
CREATE TABLE `REPORTSCHEDULE` (
  `ID` bigint(20) NOT NULL auto_increment,
  `DestEMail` varchar(255) NOT NULL default '',
  `EMailSubject` varchar(30) NOT NULL default '',
  `EMailBody` varchar(255) NOT NULL default '',
  `IsAttach` int(11) NOT NULL default '0',
  `IsZipFile` int(11) NOT NULL default '0',
  `IsEncryFile` int(11) NOT NULL default '0',
  `FilePwd` varchar(8) NOT NULL default '',
  `IsSingleReport` int(11) NOT NULL default '0',
  `IsArchive` int(11) NOT NULL default '0',
  `SaveDir` varchar(30) NOT NULL default '',
  `ScheduleType` int(11) NOT NULL default '0',
  `ScheduleDay` int(11) NOT NULL default '0',
  `ScheduleHour` int(11) NOT NULL default '0',
  `ScheduleMinute` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`)
) TYPE=MyISAM;

#
# Table structure for table 'scheduledevid'
#

# DROP TABLE IF EXISTS scheduledevid;
CREATE TABLE `SCHEDULEDEVID` (
  `ID` bigint(20) NOT NULL auto_increment,
  `ScheduleID` bigint(20) NOT NULL default '0',
  `DevID` char(12) NOT NULL default '',
  PRIMARY KEY  (`ID`)
) TYPE=MyISAM;

#
# Table structure for table 'schedulereports'
#

# DROP TABLE IF EXISTS schedulereports;
CREATE TABLE `SCHEDULEREPORTS` (
  `ID` bigint(20) NOT NULL auto_increment,
  `ScheduleID` bigint(20) NOT NULL default '0',
  `ReportCode` char(4) NOT NULL default '',
  PRIMARY KEY  (`ID`)
) TYPE=MyISAM;

#
# Table structure for table 'service'
#

# DROP TABLE IF EXISTS service;
CREATE TABLE `SERVICE` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Year` varchar(4) NOT NULL default '',
  `Month` char(2) NOT NULL default '',
  `Day` char(2) NOT NULL default '',
  `Hour` char(2) NOT NULL default '',
  `DevID` varchar(12) NOT NULL default '',
  `User` varchar(15) NOT NULL default '',
  `Site` varchar(15) NOT NULL default '',
  `ServiceID` int(11) NOT NULL default '0',
  `Event` int(11) NOT NULL default '0',
  `Byte` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ISERVICE` (`Year`,`Month`,`Day`,`Hour`,`DevID`,`User`,`Site`,`ServiceID`)
) TYPE=InnoDB;

#
# Table structure for table 'servicegroup'
#

# DROP TABLE IF EXISTS servicegroup;
CREATE TABLE `SERVICEGROUP` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Name` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`ID`)
) TYPE=MyISAM;

#
# Table structure for table 'servicetype'
#

# DROP TABLE IF EXISTS servicetype;
CREATE TABLE `SERVICETYPE` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Name` varchar(50) NOT NULL default '',
  `Protocol` varchar(50) NOT NULL default '',
  `StartPort` int(11) NOT NULL default '0',
  `EndPort` int(11) NOT NULL default '0',
  `IsKnown` int(11) NOT NULL default '0',
  `GroupID` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`ID`)
) TYPE=MyISAM;

#
# Table structure for table 'syslog'
#

# DROP TABLE IF EXISTS syslog;
CREATE TABLE `SYSLOG` (
  `ID` bigint(20) NOT NULL auto_increment,
  `SrcIP` varchar(15) NOT NULL default '',
  `SrcPort` varchar(11) NOT NULL default '',
  `DestIP` varchar(15) NOT NULL default '',
  `DestPort` varchar(11) NOT NULL default '',
  `Year` varchar(4) NOT NULL default '',
  `Month` char(2) NOT NULL default '',
  `Day` char(2) NOT NULL default '',
  `Hour` char(2) NOT NULL default '',
  `Minute` char(2) NOT NULL default '',
  `Second` char(2) NOT NULL default '',
  `DevID` varchar(12) NOT NULL default '',
  `DevType` varchar(30) NOT NULL default '',
  `DevName` varchar(30) NOT NULL default '',
  `Duration` int(11) NOT NULL default '0',
  `SentByte` int(11) NOT NULL default '0',
  `RcvdByte` int(11) NOT NULL default '0',
  `Direction` varchar(10) NOT NULL default '',
  `ProtoID` int(11) NOT NULL default '0',
  `Proto` varchar(30) NOT NULL default '',
  `Trans` varchar(10) NOT NULL default '',
  `Category` varchar(30) NOT NULL default '',
  `Note` varchar(30) NOT NULL default '',
  `Msg` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`ID`),
  KEY `ISYSLOG` (`Year`,`Month`,`Day`,`Hour`,`Minute`,`Second`,`DevID`),
  KEY `ISYSLOG1` (`Year`,`Month`,`Day`,`Hour`,`Minute`,`Second`,`Category`,`SrcIP`,`SrcPort`,`DestIP`,`DestPort`,`DevID`,`Msg`)
) TYPE=InnoDB;

#
# Table structure for table 'sysmtn'
#

# DROP TABLE IF EXISTS sysmtn;
CREATE TABLE `SYSMTN` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Year` varchar(4) NOT NULL default '',
  `Month` char(2) NOT NULL default '',
  `Day` char(2) NOT NULL default '',
  `Hour` char(2) NOT NULL default '',
  `Minute` char(2) NOT NULL default '',
  `Second` char(2) NOT NULL default '',
  `DevID` varchar(12) NOT NULL default '',
  `SrcIp` varchar(15) NOT NULL default '',
  `LoginType` varchar(30) NOT NULL default '',
  `LoginUser` varchar(30) NOT NULL default '',
  `LoginSuccess` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ISYSMTN` (`Year`,`Month`,`Day`,`Hour`,`Minute`,`Second`,`DevID`)
) TYPE=InnoDB;

#
# Table structure for table 'sysuser'
#

# DROP TABLE IF EXISTS sysuser;
CREATE TABLE `SYSUSER` (
  `ID` bigint(20) NOT NULL auto_increment,
  `UserName` varchar(32) NOT NULL default '',
  `UserPsw` varchar(32) NOT NULL default '',
  `Comment` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`ID`)
) TYPE=MyISAM;

#
# Table structure for table 'traffic'
#

# DROP TABLE IF EXISTS traffic;
CREATE TABLE `TRAFFIC` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Year` varchar(4) NOT NULL default '',
  `Month` char(2) NOT NULL default '',
  `Day` char(2) NOT NULL default '',
  `Hour` char(2) NOT NULL default '',
  `DevID` varchar(12) NOT NULL default '',
  `User` varchar(15) NOT NULL default '',
  `Event` int(11) NOT NULL default '0',
  `Byte` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `ITRAFFIC` (`Year`,`Month`,`Day`,`Hour`,`DevID`,`User`)
) TYPE=InnoDB;

#
# Table structure for table 'vpn'
#

# DROP TABLE IF EXISTS vpn;
CREATE TABLE `VPN` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Year` varchar(4) NOT NULL default '',
  `Month` char(2) NOT NULL default '',
  `Day` char(2) NOT NULL default '',
  `Hour` char(2) NOT NULL default '',
  `DevID` varchar(12) NOT NULL default '',
  `SrcIp` varchar(15) NOT NULL default '',
  `DestIp` varchar(15) NOT NULL default '',
  `Connection` int(11) NOT NULL default '0',
  `Byte` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `IVPN` (`Year`,`Month`,`Day`,`Hour`,`DevID`,`SrcIp`,`DestIp`)
) TYPE=InnoDB;

#
# Table structure for table 'webfilter'
#

# DROP TABLE IF EXISTS webfilter;
CREATE TABLE `WEBFILTER` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Year` varchar(4) NOT NULL default '',
  `Month` char(2) NOT NULL default '',
  `Day` char(2) NOT NULL default '',
  `Hour` char(2) NOT NULL default '',
  `DevID` varchar(12) NOT NULL default '',
  `User` varchar(15) NOT NULL default '',
  `WebSite` varchar(100) NOT NULL default '',
  `Attempt` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `IWEBFILTER` (`Year`,`Month`,`Day`,`Hour`,`DevID`,`User`,`WebSite`)
) TYPE=InnoDB;

#
# Table structure for table 'webusage'
#

# DROP TABLE IF EXISTS webusage;
CREATE TABLE `WEBUSAGE` (
  `ID` bigint(20) NOT NULL auto_increment,
  `Year` varchar(4) NOT NULL default '',
  `Month` char(2) NOT NULL default '',
  `Day` char(2) NOT NULL default '',
  `Hour` char(2) NOT NULL default '',
  `DevID` varchar(12) NOT NULL default '',
  `User` varchar(15) NOT NULL default '',
  `Destination` varchar(15) NOT NULL default '',
  `WebSite` varchar(100) NOT NULL default '',
  `Event` int(11) NOT NULL default '0',
  `Byte` int(11) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `IWEBUSAGE` (`Year`,`Month`,`Day`,`Hour`,`DevID`,`User`,`WebSite`)
) TYPE=InnoDB;

insert into SYSUSER (UserName, UserPsw) values ('root', '63A9F0EA7BB98050796B649E85481845');
insert into SERVICEGROUP (Name) values ('Service Group1');
insert into SERVICEGROUP (Name) values ('Service Group2');
insert into SERVICEGROUP (Name) values ('Service Group3');
insert into SERVICEGROUP (Name) values ('Service Group4');
insert into SERVICEGROUP (Name) values ('Service Group5');