
use vantage;
--
-- Modify ZyXELDeviceHook table
--

alter table ZyXELDeviceHook add adslLANCommonCmr BIGINT(20);
alter table ZyXELDeviceHook add DeviceModeCmr BIGINT(20);


--
-- Modify ZyXELLanUncommonZywall table
--

alter table ZyXELLanUncommonZywall add disableMacLock TINYINT(4) NOT NULL DEFAULT 0;
alter table ZyXELLanUncommonZywall add hostIPAddr VARCHAR(250) BINARY;
alter table ZyXELLanUncommonZywall add hostMACAddr VARCHAR(250) BINARY;
alter table ZyXELLanUncommonZywall add ipAddress VARCHAR(250) BINARY;
alter table ZyXELLanUncommonZywall add primaryDNS VARCHAR(250) BINARY;
alter table ZyXELLanUncommonZywall add secondaryDNS VARCHAR(250) BINARY;
alter table ZyXELLanUncommonZywall add subnetMask VARCHAR(250) BINARY;

-- 
--Modify ZyXELLanCommonPrestige table
--
 
alter table ZyXELLanCommonPrestige add anyIPsetup TINYINT(4) NOT NULL DEFAULT 0;

--
-- Create ZyXELLanUncommonPrestige table
--

create table ZyXELLanUncommonPrestige(
id BIGINT(20) NOT NULL DEFAULT 0,
staticDhcpRules LONGBLOB,
hookCmr BIGINT(20),
primary key(id),);
--
-- Create devicemode table
--

create table devicemode (
id BIGINT(20) NOT NULL DEFAULT 0,
bridgeGateway VARCHAR(250) BINARY,
bridgeHelloTime INT(11) NOT NULL DEFAULT 0,
bridgeIP VARCHAR(250) BINARY,
bridgeMaxAge INT(11) NOT NULL DEFAULT 0,
bridgePriority INT(11) NOT NULL DEFAULT 0,
bridgeSubnet VARCHAR(250) BINARY,
dmzActive TINYINT (4) NOT NULL DEFAULT 0,
dmzPathcost INT(11) NOT NULL DEFAULT 0,
dmzPriority INT(11) NOT NULL DEFAULT 0,
enableRSTP TINYINT (4) NOT NULL DEFAULT 0,
forwardDelay INT(11) NOT NULL DEFAULT 0,
hookCmr BIGINT(20),
lanActive TINYINT (4) NOT NULL DEFAULT 0,
lanPathCost INT(11) NOT NULL DEFAULT 0,
lanPriority INT(11) NOT NULL DEFAULT 0,
Mode TINYINT (4) NOT NULL DEFAULT 0,
wanActive TINYINT (4) NOT NULL DEFAULT 0,
wanPathCost INT(11) NOT NULL DEFAULT 0,
wanPriority INT(11) NOT NULL DEFAULT 0,
wlanActive TINYINT (4) NOT NULL DEFAULT 0,
wlanPathCost INT(11) NOT NULL DEFAULT 0,
wlanPriority INT(11) NOT NULL DEFAULT 0,
primary key(id),
);

--
-- Modify WLAN table
-- 
alter table WLAN add dynaWepKey TINYINT (4) NOT NULL DEFAULT 0;
alter table WLAN add keyMgmtProto INT(11) NOT NULL DEFAULT 0;
alter table WLAN add keyUpdateTimer TINYINT (4) NOT NULL DEFAULT 0;
alter table WLAN add mixedMode TINYINT (4) NOT NULL DEFAULT 0;
alter table WLAN add groupDataPrivacy TINYINT (4) NOT NULL DEFAULT 0;
alter table WLAN add preShareKey VARCHAR(250) BINARY;

--
-- Modify LogSetting table
-- 

alter table LogSetting add logContentAccessControl TINYINT (4) NOT NULL DEFAULT 0;
alter table LogSetting add logAnyIP TINYINT (4) NOT NULL DEFAULT 0;
alter table LogSetting add logAntiVirus TINYINT (4) NOT NULL DEFAULT 0;



--
--Modify mysql table
--
use mysql;

delete from user where user='VRPT';
delete from db where user='VRPT';
insert into user (host, user, password)
values ('%', 'VRPT', password('VRPT'));
insert into user (host, user, password) 
values ('localhost','VRPT', password('VRPT'));

insert into db (host,db,user,Select_priv,Insert_priv,Update_priv,Delete_priv,Create_priv,Drop_priv,References_priv,Index_priv,Alter_priv,Create_tmp_table_priv,Lock_tables_priv) values ('localhost','vrpt','VRPT','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'); 
insert into db (host,db,user,Select_priv,Insert_priv,Update_priv,Delete_priv,Create_priv,Drop_priv,References_priv,Index_priv,Alter_priv,Create_tmp_table_priv,Lock_tables_priv) 
values ('%','vrpt','VRPT','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y'); 

flush privileges;

--
--Modify vrpt table
--

drop database if exists vrpt;
create database vrpt;
use vrpt;

create table SYSLOG
(
	ID		bigint          not null auto_increment primary key,
	SrcIP		varchar(15)	not null,
	SrcPort		varchar(11)	not null,
	DestIP		varchar(15)	not null,
	DestPort	varchar(11)	not null,
	Year		char(4)		not null,
	Month		char(2)		not null,
	Day		char(2)		not null,
	Hour		char(2)		not null,
	Minute		char(2)		not null,
	Second		char(2)		not null,
	DevID		char(12)	not null,
	DevType		varchar(30)	not null,
	DevName		varchar(30)	not null,
	Duration	int		not null,
	SentByte	int		not null,
	RcvdByte	int		not null,
	Direction	varchar(10)	not null,
	ProtoID		int		not null,
	Proto		varchar(30)	not null,
	Trans           varchar(10)     not null,
	Category	varchar(30)	not null,
	Note		varchar(30)	not null,
	Msg		varchar(255)	not null
) type=InnoDB;

create table SYSMTN
(
	ID		bigint          not null auto_increment primary key,
	Year		char(4)		not null,
	Month		char(2)		not null,
	Day		char(2)		not null,
	Hour		char(2)		not null,
        Minute		char(2)		not null,
	Second		char(2)		not null,
	DevID           char(12)        not null,
	SrcIp           varchar(15)     not null,
	LoginType 	varchar(30)	not null,
	LoginUser	varchar(30)	not null,
	LoginSuccess	int		not null
) type=InnoDB;

create table WEBUSAGE
(
	ID		bigint          not null auto_increment primary key,
	Year		char(4)		not null,
	Month		char(2)		not null,
	Day		char(2)		not null,
	Hour		char(2)		not null,
	DevID           char(12)        not null,
	User		varchar(15)     not null,
	Destination	varchar(15)	not null,
	WebSite	        varchar(100)    not null,
	Event		int	        not null,
	Byte		int	        not null
) type=InnoDB;

create table WEBFILTER
(
	ID		bigint          not null auto_increment primary key,
	Year		char(4)		not null,
	Month		char(2)		not null,
	Day		char(2)		not null,
	Hour		char(2)		not null,
	DevID           char(12)        not null,
	User		varchar(15)     not null,
	WebSite	        varchar(100)    not null,
	Attempt		int	        not null
) type=InnoDB;

create table FTP
(
	ID		bigint          not null auto_increment primary key,
	Year		char(4)		not null,
	Month		char(2)		not null,
	Day		char(2)		not null,
	Hour		char(2)		not null,
	DevID           char(12)        not null,
	User		varchar(15)     not null,
        Site		varchar(15)     not null,
	Event		int	        not null,
	Byte		int	        not null
) type=InnoDB;

create table MAIL
(
	ID		bigint          not null auto_increment primary key,
	Year		char(4)		not null,
	Month		char(2)		not null,
	Day		char(2)		not null,
	Hour		char(2)		not null,
	DevID           char(12)        not null,
	User		varchar(15)     not null,
	Site		varchar(15)     not null,
	Event		int	        not null,
	Byte		int	        not null
) type=InnoDB;

create table ATTACK
(
	ID		bigint          not null auto_increment primary key,
	Year		char(4)		not null,
	Month		char(2)		not null,
	Day		char(2)		not null,
	Hour		char(2)		not null,
	DevID           char(12)        not null,
	Source		varchar(15)     not null,
	Category        varchar(100)    not null,
	Event		int	        not null
) type=InnoDB;

create table ERROR
(
	ID		bigint          not null auto_increment primary key,
	Year		char(4)		not null,
	Month		char(2)		not null,
	Day		char(2)		not null,
	Hour		char(2)		not null,
	DevID           char(12)        not null,
	Event		int	        not null
) type=InnoDB;

create table VPN
(
	ID		bigint          not null auto_increment primary key,
	Year		char(4)		not null,
	Month		char(2)		not null,
	Day		char(2)		not null,
	Hour		char(2)		not null,
	DevID           char(12)        not null,
        SrcIp           varchar(15)     not null,
        DestIp          varchar(15)     not null,
	Connection	int	        not null,
	Byte            int             not null
) type=InnoDB;

create table TRAFFIC
(
	ID		bigint          not null auto_increment primary key,
	Year		char(4)		not null,
	Month		char(2)		not null,
	Day		char(2)		not null,
	Hour		char(2)		not null,
	DevID           char(12)        not null,
	User		varchar(15)     not null,
	Event		int	        not null,
	Byte		int	        not null
) type=InnoDB;

create table SERVICE
(
	ID		bigint          not null auto_increment primary key,
	Year		char(4)		not null,
	Month		char(2)		not null,
	Day		char(2)		not null,
	Hour		char(2)		not null,
	DevID           char(12)        not null,
	User		varchar(15)     not null,
        Site            varchar(15)     not null,
	ServiceID       int             not null,
	Event		int	        not null,
	Byte		int	        not null
) type=InnoDB;

create table SERVICEGROUP
(
	ID		bigint          not null auto_increment primary key,
	Name		varchar(50)	not null
);

create table SERVICETYPE
(
	ID		bigint          not null auto_increment primary key,
	Name		varchar(50)	not null,
	Protocol	char(50)	not null,
	StartPort       int             not null,
	EndPort         int             not null,
	IsKnown         int             not null,
	GroupID         bigint          not null
);

create table SYSUSER
(
	ID		bigint          not null auto_increment primary key,
	UserName	varchar(32)	not null,
	UserPsw 	char(32)	not null,
	Comment         varchar(255)    not null
);

create table REPORTSCHEDULE
(
	ID		bigint          not null auto_increment primary key,
	DestEMail	varchar(255)	not null,
	EMailSubject	varchar(30)	not null,
	EMailBody	varchar(255)	not null,
	IsAttach	int		not null,
	IsZipFile	int		not null,
	IsEncryFile	int		not null,
	FilePwd		varchar(8)	not null,
	IsSingleReport	int		not null,
	IsArchive	int		not null,
	SaveDir		varchar(30)	not null,
	ScheduleType 	int		not null,
	ScheduleDay     int             not null,
	ScheduleHour    int             not null,
	ScheduleMinute  int             not null
);

create table SCHEDULEREPORTS
(
	ID		bigint          not null auto_increment primary key,
	ScheduleID	bigint  	not null,
	ReportCode	char(4)         not null
);

create table SCHEDULEDEVID
(
	ID		bigint          not null auto_increment primary key,
	ScheduleID      bigint          not null,
	DevID           char(12)        not null
);


create table CONFIG
(
	Param	        varchar(255)    not null,
	Value           varchar(255)    not null
);

create index ISYSLOG on SYSLOG(Year, Month, Day, Hour, Minute, Second, DevID);
create index ISYSLOG1 on SYSLOG(Year, Month, Day, Hour, Minute, Second, Category, SrcIP, SrcPort, DestIP, DestPort, DevID, Msg);

create index ISYSMTN on SYSMTN(Year, Month, Day, Hour, Minute, Second, DevID);
create index IWEBUSAGE on WEBUSAGE(Year, Month, Day, Hour, DevID, User, WebSite);
create index IWEBFILTER on WEBFILTER(Year, Month, Day, Hour, DevID, User, WebSite);
create index IFTP on FTP(Year, Month, Day, Hour, DevID, User, Site);
create index IMAIL on MAIL(Year, Month, Day, Hour, DevID, User, Site);
create index IATTACK on ATTACK(Year, Month, Day, Hour, DevID, Source, Category);
create index IERROR on ERROR(Year, Month, Day, Hour, DevID);
create index IVPN on VPN(Year, Month, Day, Hour, DevID, SrcIp, DestIp);
create index ITRAFFIC on TRAFFIC(Year, Month, Day, Hour, DevID, User);
create index ISERVICE on SERVICE(Year, Month, Day, Hour, DevID, User, Site, ServiceID);

insert into SYSUSER (UserName, UserPsw) values ('root', '63A9F0EA7BB98050796B649E85481845');
insert into SERVICEGROUP (Name) values ('Service Group1');
insert into SERVICEGROUP (Name) values ('Service Group2');
insert into SERVICEGROUP (Name) values ('Service Group3');
insert into SERVICEGROUP (Name) values ('Service Group4');
insert into SERVICEGROUP (Name) values ('Service Group5');

