/*
 * Copyright (c) 1996, 2003 VIA Networking, Inc. All rights reserved.
 *
 * This software may be redistributed and/or modified under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *
 * File: filename
 *
 * Purpose: Describe what this file is going to do.
 *
 * Author: Chuang Liang-Shing, AJ Jiang
 *
 * Date: Jan 24, 2003
 *
 * Functions:
 *      List all the functions this module provides.
 *      (This section is omitted in the header of ".h" files)
 *
 * Revision History:
 *      mm-dd-yyyy Revisor's Name: Whenever you made some changes,
 *                                 leave a record here.
 *      (This section is omitted in the header of ".h" files)
 *
 */


#ifndef RHINE_VMNS_H
#define RHINE_VMNS_H

#include "rhine.h"
#include "vmns_drv.h"
#include "rhine_cfg.h"


#define GET_VMNS_PRIVATE(pInfo) ((pInfo)->vmns_priv)

typedef
struct _vmns_drv_private {
    unsigned long       mode;
    VMNS_CALLBACK_FUNC  notify;
} VMNS_DRV_PRIVATE, *PVMNS_DRV_PRIVATE;

#define GET_DRV_PRIVATE(dev) ((PDRV_PRIVATE) ((dev)->priv)
typedef struct netdev_private DRV_PRIVATE, *PDRV_PRIVATE;

int vmns_process_ioctl(struct net_device* dev, PVMNS_DRV_SIOC_HEADER pParams);
void vmns_set_mode(struct net_device* dev,PVMNS_DRV_PRIVATE vpriv,unsigned long);
#endif
