/*
 * Copyright (c) 1996, 2003 VIA Networking, Inc. All rights reserved.
 *
 * This software may be redistributed and/or modified under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *
 * File: rhine_proc.h
 *
 * Purpose: Header file for private proc structures.
 *
 * Author: Chuang Liang-Shing, AJ Jiang
 *
 * Date: Jan 24, 2003
 *
 *
 */


#ifndef _RHINE_PROC_H
#define _RHINE_PROC_H
#include "rhine.h"

#define RHINE_PROC_READ     0x0001
#define RHINE_PROC_WRITE    0x0002
#define RHINE_PROC_DIR      0x0004
#define RHINE_PROC_EOT      0xFFFF
#define RHINE_PROC_FILE     (RHINE_PROC_READ|RHINE_PROC_WRITE)

struct __rhine_info;
struct __rhine_proc_entry;

typedef int (*RHINE_PROC_READ_FUNC) (struct __rhine_proc_entry*, char* buf);
typedef int (*RHINE_PROC_WRITE_FUNC) (struct __rhine_proc_entry*, const char* buf, unsigned long len);

typedef enum __rhine_proc_rmon_type {
    RMON_DropEvents=0,
    RMON_Octets,
    RMON_Pkts,
    RMON_BroadcastPkts,
    RMON_MulticastPkts,
    RMON_CRCAlignErrors,
    RMON_UndersizePkts,
    RMON_OversizePkts,
    RMON_Fragments,
    RMON_Jabbers,
    RMON_Collisions,
    RMON_Pkts64Octets,
    RMON_Pkts65to127Octets,
    RMON_Pkts128to255Octets,
    RMON_Pkts256to511Octets,
    RMON_Pkts512to1023Octets,
    RMON_Pkts1024to1518Octets,
    RMON_TAB_SIZE
} PROC_RMON_TYPE, *PPROC_RMON_TYPE;

typedef struct __rhine_proc_entry {
    char                                name[128];
    int                                 type;
    RHINE_PROC_READ_FUNC                read_proc;
    RHINE_PROC_WRITE_FUNC               write_proc;
    int                                 data;
    const struct __rhine_proc_entry*    childs;
    U8                                  byRevId;
    struct proc_dir_entry*              pOsEntry;
    struct proc_dir_entry*              pOsParent;
    struct __rhine_info*                pInfo;
    const struct __rhine_proc_entry*    siblings;
} RHINE_PROC_ENTRY, *PRHINE_PROC_ENTRY;


BOOL    rhine_init_proc_fs(struct __rhine_info* pInfo);
BOOL    rhine_create_proc_entry(struct __rhine_info* pInfo);

void    rhine_free_proc_fs(struct __rhine_info* pInfo);
void    rhine_free_proc_entry(struct __rhine_info* pInfo);

#endif

