/*
 * Copyright (c) 1996, 2003 VIA Networking, Inc. All rights reserved.
 *
 * This software may be redistributed and/or modified under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *
 * File: rhine_desc.h
 *
 * Purpose: Structures for MAX RX/TX descriptors.
 *
 * Author: Chuang Liang-Shing, AJ Jiang
 *
 * Date: Jan 24, 2003
 *
 *
 */


#ifndef _RHINE_DESC_H__
#define _RHINE_DESC_H__

#include "rhine_cfg.h"

#define B_OWNED_BY_CHIP     1           //
#define B_OWNED_BY_HOST     0           //

//
// Bits in the RSR0 register
//
#define RSR_DETAG          0x0080        //
#define RSR_SNTAG          0x0040        //
#define RSR_RXER           0x0020        //
#define RSR_RL             0x0010        //
#define RSR_CE             0x0008        //
#define RSR_FAE            0x0004        //
#define RSR_CRC            0x0002        //
#define RSR_VIDM           0x0001        //
//
// Bits in the RSR1 register
//
#define RSR_RXOK           0x8000        // rx OK
#define RSR_PFT            0x4000        // Perfect filtering address match
#define RSR_MAR            0x2000        // MAC accept multicast address packet
#define RSR_BAR            0x1000        // MAC accept broadcast address packet
#define RSR_PHY            0x0800        // MAC accept physical address packet
#define RSR_VTAG           0x0400        // 802.1p/1q tagging packet indicator
#define RSR_STP            0x0200        // start of packet
#define RSR_EDP            0x0100        // end of packet
//
// Bits in the RSR1 register
//
#define RSR1_RXOK           0x80        // rx OK
#define RSR1_PFT            0x40        // Perfect filtering address match
#define RSR1_MAR            0x20        // MAC accept multicast address packet
#define RSR1_BAR            0x10        // MAC accept broadcast address packet
#define RSR1_PHY            0x08        // MAC accept physical address packet
#define RSR1_VTAG           0x04        // 802.1p/1q tagging packet indicator
#define RSR1_STP            0x02        // start of packet
#define RSR1_EDP            0x01        // end of packet

//
// Bits in the CSM register
//
#define CSM_IPOK            0x40        //IP Checkusm validatiaon ok
#define CSM_TUPOK           0x20        //TCP/UDP Checkusm validatiaon ok
#define CSM_FRAG            0x10        //Fragment IP datagram
#define CSM_IPKT            0x04        //Received an IP packet
#define CSM_TCPKT           0x02        //Received a TCP packet
#define CSM_UDPKT           0x01        //Received a UDP packet

//
// Bits in the TSR0 register
//
#define TSR0_ABT            0x0080        // Tx abort because of excessive collision
#define TSR0_OWT            0x0040        // Jumbo frame Tx abort
#define TSR0_OWC            0x0020        // Out of window collision
#define TSR0_COLS           0x0010        // experience collision in this transmit event
#define TSR0_NCR3           0x0008        // collision retry counter[3]
#define TSR0_NCR2           0x0004        // collision retry counter[2]
#define TSR0_NCR1           0x0002        // collision retry counter[1]
#define TSR0_NCR0           0x0001        // collision retry counter[0]
#define TSR0_TERR           0x8000        //
#define TSR0_FDX            0x4000        // current transaction is serviced by full duplex mode
#define TSR0_GMII           0x2000        // current transaction is serviced by GMII mode
#define TSR0_LNKFL          0x1000       // packet serviced during link down
#define TSR0_SHDN           0x0400        // shutdown case
#define TSR0_CRS            0x0200        // carrier sense lost
#define TSR0_CDH            0x0100        // AQE test fail (CD heartbeat)
//
// Bits in the TSR1 register
//
#define TSR1_TERR           0x80        //
#define TSR1_FDX            0x40        // current transaction is serviced by full duplex mode
#define TSR1_GMII           0x20        // current transaction is serviced by GMII mode
#define TSR1_LNKFL          0x10        // packet serviced during link down
#define TSR1_SHDN           0x04        // shutdown case
#define TSR1_CRS            0x02        // carrier sense lost
#define TSR1_CDH            0x01        // AQE test fail (CD heartbeat)

//
// Bits in the TCR0 register
//
#define TCR0_TIC            0x80        // assert interrupt immediately while descriptor has been send complete
#define TCR0_PIC            0x40        // priority interrupt request, INA# is issued over adaptive interrupt scheme
#define TCR0_VETAG          0x20        // enable VLAN tag
#define TCR0_IPCK           0x10        // request IP  checksum calculation.
#define TCR0_UDPCK          0x08        // request UDP checksum calculation.
#define TCR0_TCPCK          0x04        // request TCP checksum calculation.
#define TCR0_JMBO           0x02        // indicate a jumbo packet in GMAC side
#define TCR0_CRC            0x01        // disable CRC generation

#define TCPLS_NORMAL        3
#define TCPLS_START         2
#define TCPLS_END           1
#define TCPLS_MED           0


// max transmit or receive buffer size
#define CB_RX_BUF_SIZE     2048UL      // max buffer size
                                        // NOTE: must be multiple of 4

#define CB_MAX_RD_NUM       512         // MAX # of RD
#define CB_MAX_TD_NUM       256         // MAX # of TD

#define CB_INIT_RD_NUM_3119 128         // init # of RD, for setup VT3119
#define CB_INIT_TD_NUM_3119 64          // init # of TD, for setup VT3119

#define CB_INIT_RD_NUM      128         // init # of RD, for setup default
#define CB_INIT_TD_NUM      64          // init # of TD, for setup default

// for 3119
#define CB_TD_RING_NUM      4           // # of TD rings.
#define CB_MAX_SEG_PER_PKT  7           // max data seg per packet (Tx)


// if collisions excess 15 times , tx will abort, and
// if tx fifo underflow, tx will fail
// we should try to resend it
#define CB_MAX_TX_ABORT_RETRY   3

/*---------------------  Export Types  ------------------------------*/

//
// receive descriptor
//
typedef struct __rdesc0 {
    U16 wRSR;
    U16 f14Length : 14;          //receive packet length
    U16 f1Resv  : 1;
    U16 f1Owner : 1;
}
__attribute__ ((__packed__))
RDESC0, *PRDESC0;

typedef struct __rdesc1 {
    U16   wPQTAG;
    U8    byCSM;
    U8    byIPKT;
}
__attribute__ ((__packed__))
RDESC1, *PRDESC1;

typedef struct __rx_desc {
    RDESC0  rdesc0;
    RDESC1  rdesc1;
    U32     dwBufAddrLo;
    U16     wBufAddrHi;
    U16     f15BufLen:15;
    U16     f1IntCtlEn:1;
}
__attribute__ ((__packed__))
RX_DESC, * PRX_DESC;


//
// transmit descriptor
//
typedef struct _tdesc0 {
//    U8    byTSR0;
//    U8    byTSR1;
    U16    wTSR;
    U16    f14PktSize   : 14;
    U16    f1Reserved   : 1;
    U16    f1Owner      : 1;
}
__attribute__ ((__packed__))
TDESC0, *PTDESC0;

typedef struct _pqinf {
    U16     f12VID       : 12;
    U16     f1CFI        : 1;
    U16     f3Priority    : 3;
}
__attribute__ ((__packed__))
PQINF, *PPQINF;

typedef struct _tdesc1 {
    PQINF   pqinf;
    U8      byTCR;
    U8      f2TCPLS      : 2;
    U8      f2Reserved   : 2;
    U8      f4CMDZ       : 4;
}
__attribute__ ((__packed__))
TDESC1, *PTDESC1;

typedef struct _td_buf {
    U32     dwBufAddrLo;
    U16     wBufAddrHi;
    U16     f14BufSize  :   14;        //TxBufSize[13:0]
    U16     f1Reserved  :   1;
    U16     f1Queue     :   1;
}
__attribute__ ((__packed__))
TD_BUF, *PTD_BUF;

typedef struct _tx_desc {
    TDESC0  tdesc0;
    TDESC1  tdesc1;
    TD_BUF  aTdBufs[7];
}
__attribute__ ((__packed__))
TX_DESC, *PTX_DESC;

typedef
struct _rhine_rd_info {
    struct sk_buff*     skb;
    dma_addr_t          skb_dma;
} RHINE_RD_INFO,    *PRHINE_RD_INFO;

static inline PRHINE_RD_INFO alloc_rd_info(void) {
    PRHINE_RD_INFO  ptr;
    if ((ptr=kmalloc(sizeof(RHINE_RD_INFO),GFP_ATOMIC))==NULL)
        return NULL;
    else {
        memset(ptr,0,sizeof(RHINE_RD_INFO));
        return ptr;
    }
}

typedef
struct _rhine_td_info {
    struct sk_buff*     skb;
    PU8                 buf;
    int                 nskb_dma;
    dma_addr_t          skb_dma[7];
    dma_addr_t          buf_dma;
} RHINE_TD_INFO,    *PRHINE_TD_INFO;

typedef
enum {
    OWNED_BY_HOST=0,
    OWNED_BY_NIC=1
} RHINE_OWNER_TYPE, *PRHINE_OWNER_TYPE;


/*---------------------  Export Macros ------------------------------*/

/*---------------------  Export Classes  ----------------------------*/

/*---------------------  Export Variables  --------------------------*/

/*---------------------  Export Functions  --------------------------*/


#endif // __DESC_H__

