/*
 * Copyright (c) 1996, 2003 VIA Networking, Inc. All rights reserved.
 *
 * This software may be redistributed and/or modified under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *
 * File: rhine_dbg.h
 *
 * Purpose: Hearder file for inline debug routine
 *
 * Author: Chuang Liang-Shing, AJ Jiang
 *
 * Date: Jan 24, 2003
 *
 */


#ifndef RHINE_DBG_H
#define RHINE_DBG_H

typedef enum __rhine_msg_level {
    MSG_LEVEL_ERR=0,            //Errors that will cause abnormal operation.
    MSG_LEVEL_NOTICE=1,         //Some errors need users to be notified.
    MSG_LEVEL_INFO=2,           //Normal message.
    MSG_LEVEL_VERBOSE=3,        //Will report all trival errors.
    MSG_LEVEL_DEBUG=4           //Only for debug purpose.
} RHINE_MSG_LEVEL, *PRHINE_MSG_LEVEL;

#ifdef RHINE_DEBUG
#define ASSERT(x) { \
    if (!(x)) { \
        printk(KERN_ERR "assertion %s failed: file %s line %d\n", #x,\
        __FUNCTION__, __LINE__);\
        *(int*) 0=0;\
    }\
}
#define RHINE_DBG(p,args...) printk(p, ##args)
#else
#define ASSERT(x)
#define RHINE_DBG(x)
#endif

#define RHINE_PRT(l, p, args...) do {if (l<=msglevel) printk( p ,##args);} while (0)

#define RHINE_PRT_CAMMASK(p,t) {\
    int i;\
    if ((t)==RHINE_MULTICAST_CAM) {\
        for (i=0;i<(MCAM_SIZE/8);i++)\
            printk("%02X",(p)->abyMCAMMask[i]);\
    }\
    else {\
        for (i=0;i<(VCAM_SIZE/8);i++)\
            printk("%02X",(p)->abyVCAMMask[i]);\
    }\
    printk("\n");\
}

#endif
