/*
 * Copyright (c) 1996, 2003 VIA Networking, Inc. All rights reserved.
 *
 * This software may be redistributed and/or modified under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *
 * File: rhine_cfg.h
 *
 * Purpose: The OS dependent types & constants.
 *
 * Author: Chuang Liang-Shing, AJ Jiang
 *
 * Date: Jan 24, 2003
 *
 */


/*
* Description: This file defined OS dependent macros & defines
*/

#ifndef RHINE_CFG_H
#define RHINE_CFG_H

#include <linux/config.h>
#include <linux/types.h>

typedef __u8    UCHAR,  *PUCHAR;
typedef __u16   U16,    *PU16;
typedef __u8    UINT8,  *PUINT8;
typedef __u32   U32,    *PU32;
typedef __u32   UINT32, *PUINT32;
typedef __u32   UINT,   *PUINT;
typedef __u8    BYTE,   *PBYTE;
typedef __u8    U8,     *PU8;
typedef __u32   BOOL,   *PBOOL;
typedef __u16   WORD,   *PWORD;
typedef __u32   DWORD,  *PDWORD;
typedef unsigned long   ULONG,  *PULONG;

typedef
struct _version {
    UINT8   major;
    UINT8   minor;
    UINT8   build;
} version_t, *pversion_t;

#ifndef FALSE
#define FALSE   (0)
#endif

#ifndef TRUE
#define TRUE    (!(FALSE))
#endif


#define RHINE_NAME          "rhineget"
#define RHINE_FULL_DRV_NAM  "ZyXEL GN650 1000Base-T Adapter Driver"

#ifndef MAJOR_VERSION
#define MAJOR_VERSION       1
#endif

#ifndef MINOR_VERSION
#define MINOR_VERSION       05
#endif

#ifndef RHINE_VERSION
#define RHINE_VERSION       "1.05"
#endif

#define PKT_BUF_SZ          1540

#define MALLOC(x,y)         kmalloc((x),(y))
#define KFREE(x)            kfree((x))

#define MAX_UINTS           8
#define OPTION_DEFAULT      { [0 ... MAX_UINTS-1] = -1}

#define REV_ID_VT6110       (0)
#ifdef  PRE_BUILD
#define DEVICE_ID           (0x3119)
#else
#define DEVICE_ID           (0x3053)
#endif

#define BYTE_REG_BITS_ON(x,p)       do { writeb(readb((p))|(x),(p));} while (0)
#define WORD_REG_BITS_ON(x,p)       do { writew(readw((p))|(x),(p));} while (0)
#define DWORD_REG_BITS_ON(x,p)      do { writel(readl((p))|(x),(p));} while (0)

#define BYTE_REG_BITS_IS_ON(x,p)    (readb((p)) & (x))
#define WORD_REG_BITS_IS_ON(x,p)    (readw((p)) & (x))
#define DWORD_REG_BITS_IS_ON(x,p)   (readl((p)) & (x))

#define BYTE_REG_BITS_OFF(x,p)      do { writeb(readb((p)) & (~(x)),(p));} while (0)
#define WORD_REG_BITS_OFF(x,p)      do { writew(readw((p)) & (~(x)),(p));} while (0)
#define DWORD_REG_BITS_OFF(x,p)     do { writel(readl((p)) & (~(x)),(p));} while (0)

#define BYTE_REG_BITS_SET(x,m,p)    do { writeb( (readb((p)) & (~(m))) |(x),(p));} while (0)
#define WORD_REG_BITS_SET(x,m,p)    do { writew( (readw((p)) & (~(m))) |(x),(p));} while (0)
#define DWORD_REG_BITS_SET(x,m,p)   do { writel( (readl((p)) & (~(m)))|(x),(p));}  while (0)

#define VAR_USED(p)     do {(p)=(p);} while (0)
#endif
