/*
 * Copyright (c) 1996, 2003 VIA Networking, Inc. All rights reserved.
 *
 * This software may be redistributed and/or modified under
 * the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 *
 * File: rhine.h
 *
 * Purpose: Header file to define driver's private structures.
 *
 * Author: Chuang Liang-Shing, AJ Jiang
 *
 * Date: Jan 24, 2003
 *
 */


#ifndef RHINE_H
#define RHINE_H

#ifdef MODULE
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif /* MODVERSIONS */
#include <linux/module.h>
#endif /* MODULE */

#include <linux/types.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/delay.h>
#include <linux/timer.h>
#include <linux/slab.h>
#include <linux/interrupt.h>
#include <linux/version.h>
#include <linux/string.h>
#include <linux/wait.h>
#include <asm/io.h>

#include <linux/if.h>
#include <linux/config.h>
#include <asm/uaccess.h>
#include <linux/proc_fs.h>
#include <linux/inetdevice.h>
#include <linux/reboot.h>
#ifdef SIOCETHTOOL
#define RHINE_ETHTOOL_IOCTL_SUPPORT
#include <linux/ethtool.h>
#else
#undef RHINE_ETHTOOL_IOCTL_SUPPORT
#endif

#ifdef SIOCGMIIPHY
#define RHINE_MII_IOCTL_SUPPORT
#include <linux/mii.h>
#else
#undef RHINE_MII_IOCTL_SUPPORT
#endif

#if 0
//The skb fragments of this version isn't be tested.
#ifdef MAX_SKB_FRAGS
#define RHINE_ZERO_COPY_SUPPORT
#else
#undef  RHINE_ZERO_COPY_SUPPORT
#endif
#endif

#ifdef NETIF_F_IP_CSUM
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>
#define RHINE_TX_CSUM_SUPPORT
#else
#undef RHINE_TX_CSUM_SUPPORT
#endif

#include "kcompat.h"
#include "rhine_cfg.h"
#include "rhine_desc.h"
#include "rhine_mac.h"
#include "rhine_proc.h"
#include "rhine_wol.h"
#include "rhine_mii.h"
#ifdef VMNS
#include "rhine_vmns.h"
#endif
#include "rhine_dbg.h"


#define     RHINE_WOL_MAGIC             0x00000000UL
#define     RHINE_WOL_PHY               0x00000001UL
#define     RHINE_WOL_ARP               0x00000002UL
#define     RHINE_WOL_UCAST             0x00000004UL
#define     RHINE_WOL_BCAST             0x00000010UL
#define     RHINE_WOL_MCAST             0x00000020UL
#define     RHINE_WOL_MAGIC_SEC         0x00000040UL

//flags for options
#define     RHINE_FLAGS_TAGGING         0x00000001UL
#define     RHINE_FLAGS_TX_CSUM         0x00000002UL
#define     RHINE_FLAGS_RX_CSUM         0x00000004UL
#define     RHINE_FLAGS_IP_ALIGN        0x00000008UL
#define     RHINE_FLAGS_VAL_PKT_LEN     0x00000010UL

#define     RHINE_FLAGS_FLOW_CTRL       0x01000000UL

//flags for driver status
#define     RHINE_FLAGS_OPENED          0x00010000UL
#define     RHINE_FLAGS_VMNS_CONNECTED  0x00020000UL
#define     RHINE_FLAGS_VMNS_COMMITTED  0x00040000UL
#define     RHINE_FLAGS_WOL_ENABLED     0x00080000UL

//flags for MII status
#define     RHINE_LINK_FAIL             0x00000001UL
#define     RHINE_SPEED_10              0x00000002UL
#define     RHINE_SPEED_100             0x00000004UL
#define     RHINE_SPEED_1000            0x00000008UL
#define     RHINE_DUPLEX_FULL           0x00000010UL
#define     RHINE_AUTONEG_ENABLE        0x00000020UL
#define     RHINE_FORCED_BY_EEPROM      0x00000040UL
//for rhine_set_media_duplex
#define     RHINE_LINK_CHANGE           0x00000001UL

typedef enum _speed_opt {
    SPD_DPX_AUTO=0,
    SPD_DPX_100_HALF=1,
    SPD_DPX_100_FULL=2,
    SPD_DPX_10_HALF=3,
    SPD_DPX_10_FULL=4
} SPD_DPX_OPT, *PSPD_DPX_OPT;

typedef enum __rhine_init_type {
    RHINE_INIT_COLD=0,
    RHINE_INIT_RESET,
    RHINE_INIT_WOL
} RHINE_INIT_TYPE, *PRHINE_INIT_TYPE;

typedef enum __rhine_flow_cntl_type {
    FLOW_CNTL_DEFAULT=1,
    FLOW_CNTL_TX,
    FLOW_CNTL_RX,
    FLOW_CNTL_TX_RX,
    FLOW_CNTL_DISABLE,
}
RHINE_FLOW_CNTL_TYPE, *PRHINE_FLOW_CNTL_TYPE;

typedef struct __rhine_opt {
    int         nRxDescs;       //Number of RX descriptors
    int         nTxDescs;       //Number of TX descriptors
    SPD_DPX_OPT spd_dpx;        //Media link mode
    int         vid;            //vlan id
    int         DMA_length;     //DMA length
    int         rx_thresh;      //RX_THRESH
    int         flow_cntl;
    int         wol_opts;       //Wake on lan options
    int         td_int_count;
    int         int_works;
    int         rx_bandwidth_hi;
    int         rx_bandwidth_lo;
    int         rx_bandwidth_en;
    U32         flags;
} OPTIONS, *POPTIONS;

typedef struct __rhine_info {
    struct __rhine_info*        next;
    struct __rhine_info*        prev;

    struct pci_dev*             pcid;
    struct net_device*          dev;
    struct net_device_stats     stats;

#if CONFIG_PM
    U32                         pci_state[16];
#endif

    void*                       pool;
    dma_addr_t                  pool_dma;
    dma_addr_t                  rd_pool_dma;
    dma_addr_t                  td_pool_dma[TX_QUEUE_NO];

    dma_addr_t                  tx_bufs_dma;
    PU8                         tx_bufs;

    U8                          abyIPAddr[4];
    CHIP_TYPE                   chip_id;

    PMAC_REGS                   pMacRegs;
    U32                         memaddr;
    U32                         ioaddr;
    U32                         io_size;

    U8                          byRevId;
    U16                         SubSystemID;
    U16                         SubVendorID;

#define AVAIL_TD(p,q)   ((p)->sOpts.nTxDescs-((p)->iTDUsed[(q)]))

    int                         nTxQueues;

    volatile int                iTDUsed[TX_QUEUE_NO];
    int                         aiCurrTDIdx[TX_QUEUE_NO];
    int                         aiTailTDIdx[TX_QUEUE_NO];
    PTX_DESC                    apTDRings[TX_QUEUE_NO];
    PRHINE_TD_INFO              apTDInfos[TX_QUEUE_NO]; //its a d

    int                         iCurrRDIdx;
    int                         iRDUsed;
    PRX_DESC                    aRDRing;
    PRHINE_RD_INFO              aRDInfo; //it's an array

#define GET_RD_BY_IDX(pInfo, idx)   (pInfo->aRDRing[idx])
    U32                         adwRMONStats[RMON_TAB_SIZE];
    U32                         adwHWMIBCounters[MAX_HW_MIB_COUNTER];
    OPTIONS                     sOpts;

    U32                         IntMask;

    U32                         flags;

    int                         rx_buf_sz;
    U32                         mii_status;
    U32                         dwPHYid;
    int                         multicast_limit;

    U8                          abyVCAMMask[(VCAM_SIZE/8)];
    U8                          abyMCAMMask[(MCAM_SIZE/8)];

    spinlock_t                  lock;
    spinlock_t                  xmit_lock;

    int                         wol_opts;
    U8                          wol_passwd[6];

    RHINE_CONTEXT               context;

#ifdef CONFIG_PROC_FS
    PRHINE_PROC_ENTRY           pProcDir;
#endif
    U32                         ticks;
    U32                         rx_bytes;
#ifdef  VMNS
    PVMNS_DRV_PRIVATE           vmns_priv;
#endif

} RHINE_INFO, *PRHINE_INFO;

inline static BOOL rhine_get_ip(PRHINE_INFO pInfo) {
    struct in_device* in_dev=(struct in_device*) pInfo->dev->ip_ptr;
    struct in_ifaddr* ifa;

    if (in_dev!=NULL) {
        ifa=(struct in_ifaddr*) in_dev->ifa_list;
        if (ifa!=NULL) {
            memcpy(pInfo->abyIPAddr,&ifa->ifa_address,4);
            return TRUE;
        }
    }
    return FALSE;
}

inline static void rhine_update_hw_mibs(PRHINE_INFO pInfo) {
    U32 dwTmp;
    int i;
    BYTE_REG_BITS_ON(MIBCR_MIBFLSH,&(pInfo->pMacRegs->byMIBCR));

    while (BYTE_REG_BITS_IS_ON(MIBCR_MIBFLSH,&(pInfo->pMacRegs->byMIBCR)));

    BYTE_REG_BITS_ON(MIBCR_MPTRINI,&(pInfo->pMacRegs->byMIBCR));
    for (i=0;i<HW_MIB_SIZE;i++) {
        dwTmp=readl(&(pInfo->pMacRegs->dwMIBData)) & 0x00FFFFFFUL;
        pInfo->adwHWMIBCounters[i]+=dwTmp;
    }
}

static inline void enable_flow_control(PRHINE_INFO pInfo) {
    PMAC_REGS   pMacRegs=pInfo->pMacRegs;
    /* Set {XHITH1, XHITH0, XLTH1, XLTH0} in FlowCR1 to {1, 0, 1, 1}
        depend on RD=64, and Turn on XNOEN in FlowCR1*/
    DWORD_REG_BITS_ON((CR0_XONEN|CR0_XHITH1|CR0_XLTH1|CR0_XLTH0),
        &pMacRegs->dwCR0Clr);
    DWORD_REG_BITS_ON((CR0_XONEN|CR0_XHITH1|CR0_XLTH1|CR0_XLTH0),
        &pMacRegs->dwCR0Set);

    /* Set TxPauseTimer to 0xFFFF */
    writew(0xFFFF, &pMacRegs->wTxPauseTimer);

    /* Initialize RBRDU to Rx buffer count.*/
    writeb(pInfo->sOpts.nRxDescs,&pMacRegs->wRBRDU);
}

U32 mii_check_media_mode(PMAC_REGS pMacRegs);
U32 mac_check_connectiontype(PMAC_REGS pMacRegs);
int rhine_set_media_mode(PRHINE_INFO pInfo, U32 mii_status);
void rhine_init_cam_filter(PRHINE_INFO pInfo);
BOOL rhine_mii_read(PMAC_REGS, U8 byIdx, PU16 pdata);
BOOL rhine_mii_write (PMAC_REGS, BYTE byMiiAddr, WORD wData);
#endif

