/*
 * Copyright (c) 1996, 2003 VIA Networking Technologies, Inc.
 * All rights reserved.
 *
 * This software is copyrighted by and is the sole property of
 * VIA Networking Technologies, Inc. This software may only be used
 * in accordance with the corresponding license agreement. Any unauthorized
 * use, duplication, transmission, distribution, or disclosure of this
 * software is expressly forbidden.
 *
 * This software is provided by VIA Networking Technologies, Inc. "as is"
 * and any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose
 * are disclaimed. In no event shall VIA Networking Technologies, Inc.
 * be liable for any direct, indirect, incidental, special, exemplary, or
 * consequential damages.
 *
 *
 * File: velocity_wol.h
 *
 * Purpose: Hearder for WOL definitions.
 *
 * Author: Chuang Liang-Shing, AJ Jiang
 *
 * Date: Jan 24, 2003
 *
 */
 
#ifndef VELOCITY_WOL_H
#define VELOCITY_WOL_H

#include "velocity.h"
struct __velocity_info;

typedef U8  MCAM_ADDR[ETH_ALEN];

typedef
struct _arp_packet {
    U8  abyDMAC[ETH_ALEN];
    U8  abySMAC[ETH_ALEN];
    U16 wType;
    U16 ar_hrd;
    U16 ar_pro;
    U8  ar_hln;
    U8  ar_pln;
    U16 ar_op;
    U8  ar_sha[ETH_ALEN];
    U8  ar_sip[4];
    U8  ar_tha[ETH_ALEN];
    U8  ar_tip[4];
} __attribute__ ((__packed__))
ARP_PACKET, *PARP_PACKET;

typedef
struct _magic_packet {
    U8  abyDMAC[6];
    U8  abySMAC[6];
    U16 wType;
    U8  abyMAC[16][6];
    U8  abyPassword[6];
}
__attribute__ ((__packed__))
MAGIC_PACKET, *PMAGIC_PACKET;

typedef
struct __velocity_context {
    U8          abyMacRegs[256];
    MCAM_ADDR   aMcamAddr[MCAM_SIZE];
    U16         awVcam[VCAM_SIZE];
    U32         dwCammask[2];
    U32         dwPatCRC[2];
    U32         dwPattern[8];
} VELOCITY_CONTEXT, *PVELOCITY_CONTEXT;


BOOL velocity_set_wol(struct __velocity_info*);
void velocity_save_context(struct __velocity_info* pInfo,PVELOCITY_CONTEXT pContext);
void velocity_restore_context(struct __velocity_info* pInfo,PVELOCITY_CONTEXT pContext);
#endif
