/*
 * Copyright (c) 1996, 2003 VIA Networking Technologies, Inc.
 * All rights reserved.
 *
 * This software is copyrighted by and is the sole property of
 * VIA Networking Technologies, Inc. This software may only be used
 * in accordance with the corresponding license agreement. Any unauthorized
 * use, duplication, transmission, distribution, or disclosure of this
 * software is expressly forbidden.
 *
 * This software is provided by VIA Networking Technologies, Inc. "as is"
 * and any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose
 * are disclaimed. In no event shall VIA Networking Technologies, Inc.
 * be liable for any direct, indirect, incidental, special, exemplary, or
 * consequential damages.
 *
 *
 * File: velocity_vmns.h
 *
 * Purpose: The vmns driver support header file.
 *
 * Author: Chuang Liang-Shing, AJ Jiang
 *
 * Date: Jan 24, 2003
 *
 */


#ifndef VELOCITY_VMNS_H
#define VELOCITY_VMNS_H

#include "velocity.h"
#include "vmns_drv.h"
#include "velocity_cfg.h"


#define GET_VMNS_PRIVATE(pInfo) ((pInfo)->vmns_priv)

typedef
struct _vmns_drv_private {
    unsigned long       mode;
    VMNS_CALLBACK_FUNC  notify;
} VMNS_DRV_PRIVATE, *PVMNS_DRV_PRIVATE;

#define GET_DRV_PRIVATE(dev) ((PDRV_PRIVATE) ((dev)->priv)
typedef struct netdev_private DRV_PRIVATE, *PDRV_PRIVATE;

int vmns_process_ioctl(struct net_device* dev, PVMNS_DRV_SIOC_HEADER pParams);
void vmns_set_mode(struct net_device* dev,PVMNS_DRV_PRIVATE vpriv,unsigned long);
#endif
