/*
 * Copyright (c) 1996, 2003 VIA Networking Technologies, Inc.
 * All rights reserved.
 *
 * This software is copyrighted by and is the sole property of
 * VIA Networking Technologies, Inc. This software may only be used
 * in accordance with the corresponding license agreement. Any unauthorized
 * use, duplication, transmission, distribution, or disclosure of this
 * software is expressly forbidden.
 *
 * This software is provided by VIA Networking Technologies, Inc. "as is"
 * and any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose
 * are disclaimed. In no event shall VIA Networking Technologies, Inc.
 * be liable for any direct, indirect, incidental, special, exemplary, or
 * consequential damages.
 *
 *
 * File: velocity_proc.h
 *
 * Purpose: Header file for private proc structures.
 *
 * Author: Chuang Liang-Shing, AJ Jiang
 *
 * Date: Jan 24, 2003
 *
 */


#ifndef _VELOCITY_PROC_H
#define _VELOCITY_PROC_H
#include "velocity.h"

#define VELOCITY_PROC_READ     0x0001
#define VELOCITY_PROC_WRITE    0x0002
#define VELOCITY_PROC_DIR      0x0004
#define VELOCITY_PROC_EOT      0xFFFF
#define VELOCITY_PROC_FILE     (VELOCITY_PROC_READ|VELOCITY_PROC_WRITE)

struct __velocity_info;
struct __velocity_proc_entry;

typedef int (*VELOCITY_PROC_READ_FUNC) (struct __velocity_proc_entry*, char* buf);
typedef int (*VELOCITY_PROC_WRITE_FUNC) (struct __velocity_proc_entry*, const char* buf, unsigned long len);

typedef enum __velocity_proc_rmon_type {
    RMON_DropEvents=0,
    RMON_Octets,
    RMON_Pkts,
    RMON_BroadcastPkts,
    RMON_MulticastPkts,
    RMON_CRCAlignErrors,
    RMON_UndersizePkts,
    RMON_OversizePkts,
    RMON_Fragments,
    RMON_Jabbers,
    RMON_Collisions,
    RMON_Pkts64Octets,
    RMON_Pkts65to127Octets,
    RMON_Pkts128to255Octets,
    RMON_Pkts256to511Octets,
    RMON_Pkts512to1023Octets,
    RMON_Pkts1024to1518Octets,
    RMON_TAB_SIZE
} PROC_RMON_TYPE, *PPROC_RMON_TYPE;

typedef struct __velocity_proc_entry {
    char                                name[128];
    int                                 type;
    VELOCITY_PROC_READ_FUNC                read_proc;
    VELOCITY_PROC_WRITE_FUNC               write_proc;
    int                                 data;
    const struct __velocity_proc_entry*    childs;
    U8                                  byRevId;
    struct proc_dir_entry*              pOsEntry;
    struct proc_dir_entry*              pOsParent;
    struct __velocity_info*                pInfo;
    const struct __velocity_proc_entry*    siblings;
} VELOCITY_PROC_ENTRY, *PVELOCITY_PROC_ENTRY;


BOOL    velocity_init_proc_fs(struct __velocity_info* pInfo);
BOOL    velocity_create_proc_entry(struct __velocity_info* pInfo);

void    velocity_free_proc_fs(struct __velocity_info* pInfo);
void    velocity_free_proc_entry(struct __velocity_info* pInfo);

#endif

