/*
 * Copyright (c) 1996, 2003 VIA Networking Technologies, Inc.
 * All rights reserved.
 *
 * This software is copyrighted by and is the sole property of
 * VIA Networking Technologies, Inc. This software may only be used
 * in accordance with the corresponding license agreement. Any unauthorized
 * use, duplication, transmission, distribution, or disclosure of this
 * software is expressly forbidden.
 *
 * This software is provided by VIA Networking Technologies, Inc. "as is"
 * and any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose
 * are disclaimed. In no event shall VIA Networking Technologies, Inc.
 * be liable for any direct, indirect, incidental, special, exemplary, or
 * consequential damages.
 *
 *
 * File: velocity_dbg.h
 *
 * Purpose: Hearder file for inline debug routine
 *
 * Author: Chuang Liang-Shing, AJ Jiang
 *
 * Date: Jan 24, 2003
 *
 */


#ifndef VELOCITY_DBG_H
#define VELOCITY_DBG_H

typedef enum __velocity_msg_level {
    MSG_LEVEL_ERR=0,            //Errors that will cause abnormal operation.
    MSG_LEVEL_NOTICE=1,         //Some errors need users to be notified.
    MSG_LEVEL_INFO=2,           //Normal message.
    MSG_LEVEL_VERBOSE=3,        //Will report all trival errors.
    MSG_LEVEL_DEBUG=4           //Only for debug purpose.
} VELOCITY_MSG_LEVEL, *PVELOCITY_MSG_LEVEL;

#ifdef VELOCITY_DEBUG
#define ASSERT(x) { \
    if (!(x)) { \
        printk(KERN_ERR "assertion %s failed: file %s line %d\n", #x,\
        __FUNCTION__, __LINE__);\
        *(int*) 0=0;\
    }\
}
#define VELOCITY_DBG(p,args...) printk(p, ##args)
#else
#define ASSERT(x)
#define VELOCITY_DBG(x)
#endif

#define VELOCITY_PRT(l, p, args...) do {if (l<=msglevel) printk( p ,##args);} while (0)

#define VELOCITY_PRT_CAMMASK(p,t) {\
    int i;\
    if ((t)==VELOCITY_MULTICAST_CAM) {\
        for (i=0;i<(MCAM_SIZE/8);i++)\
            printk("%02X",(p)->abyMCAMMask[i]);\
    }\
    else {\
        for (i=0;i<(VCAM_SIZE/8);i++)\
            printk("%02X",(p)->abyVCAMMask[i]);\
    }\
    printk("\n");\
}

#endif
