/*
 * Copyright (c) 1996, 2003 VIA Networking Technologies, Inc.
 * All rights reserved.
 *
 * This software is copyrighted by and is the sole property of
 * VIA Networking Technologies, Inc. This software may only be used
 * in accordance with the corresponding license agreement. Any unauthorized
 * use, duplication, transmission, distribution, or disclosure of this
 * software is expressly forbidden.
 *
 * This software is provided by VIA Networking Technologies, Inc. "as is"
 * and any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose
 * are disclaimed. In no event shall VIA Networking Technologies, Inc.
 * be liable for any direct, indirect, incidental, special, exemplary, or
 * consequential damages.
 *
 *
 * File: velocity_cfg.h
 *
 * Purpose: The OS dependent types & constants.
 *
 * Author: Chuang Liang-Shing, AJ Jiang
 *
 * Date: Jan 24, 2003
 *
 */


/*
* Description: This file defined OS dependent macros & defines
*/

#ifndef VELOCITY_CFG_H
#define VELOCITY_CFG_H

#include <linux/config.h>
#include <linux/types.h>

typedef __u8    UCHAR,  *PUCHAR;
typedef __u16   U16,    *PU16;
typedef __u8    UINT8,  *PUINT8;
typedef __u32   U32,    *PU32;
typedef __u32   UINT32, *PUINT32;
typedef __u32   UINT,   *PUINT;
typedef __u8    BYTE,   *PBYTE;
typedef __u8    U8,     *PU8;
typedef __u32   BOOL,   *PBOOL;
typedef __u16   WORD,   *PWORD;
typedef __u32   DWORD,  *PDWORD;
typedef unsigned long   ULONG,  *PULONG;

typedef
struct _version {
    UINT8   major;
    UINT8   minor;
    UINT8   build;
} version_t, *pversion_t;

#ifndef FALSE
#define FALSE   (0)
#endif

#ifndef TRUE
#define TRUE    (!(FALSE))
#endif


#define VELOCITY_NAME          "velocityget"
#define VELOCITY_FULL_DRV_NAM  "ZyXEL GN600 series 1000Base-T Adapter Driver"

#ifndef MAJOR_VERSION
#define MAJOR_VERSION       1
#endif

#ifndef MINOR_VERSION
#define MINOR_VERSION       11
#endif

#ifndef VELOCITY_VERSION
#define VELOCITY_VERSION       "1.11"
#endif

#define PKT_BUF_SZ          1540

#define MALLOC(x,y)         kmalloc((x),(y))
#define KFREE(x)            kfree((x))

#define MAX_UINTS           8
#define OPTION_DEFAULT      { [0 ... MAX_UINTS-1] = -1}

#define REV_ID_VT6110       (0)
#define DEVICE_ID           (0x3119)

#define BYTE_REG_BITS_ON(x,p)       do { writeb(readb((p))|(x),(p));} while (0)
#define WORD_REG_BITS_ON(x,p)       do { writew(readw((p))|(x),(p));} while (0)
#define DWORD_REG_BITS_ON(x,p)      do { writel(readl((p))|(x),(p));} while (0)

#define BYTE_REG_BITS_IS_ON(x,p)    (readb((p)) & (x))
#define WORD_REG_BITS_IS_ON(x,p)    (readw((p)) & (x))
#define DWORD_REG_BITS_IS_ON(x,p)   (readl((p)) & (x))

#define BYTE_REG_BITS_OFF(x,p)      do { writeb(readb((p)) & (~(x)),(p));} while (0)
#define WORD_REG_BITS_OFF(x,p)      do { writew(readw((p)) & (~(x)),(p));} while (0)
#define DWORD_REG_BITS_OFF(x,p)     do { writel(readl((p)) & (~(x)),(p));} while (0)

#define BYTE_REG_BITS_SET(x,m,p)    do { writeb( (readb((p)) & (~(m))) |(x),(p));} while (0)
#define WORD_REG_BITS_SET(x,m,p)    do { writew( (readw((p)) & (~(m))) |(x),(p));} while (0)
#define DWORD_REG_BITS_SET(x,m,p)   do { writel( (readl((p)) & (~(m)))|(x),(p));}  while (0)

#define VAR_USED(p)     do {(p)=(p);} while (0)
#endif
