/*
 * Copyright (c) 1996, 2003 VIA Networking Technologies, Inc.
 * All rights reserved.
 *
 * This software is copyrighted by and is the sole property of
 * VIA Networking Technologies, Inc. This software may only be used
 * in accordance with the corresponding license agreement. Any unauthorized
 * use, duplication, transmission, distribution, or disclosure of this
 * software is expressly forbidden.
 *
 * This software is provided by VIA Networking Technologies, Inc. "as is"
 * and any express or implied warranties, including, but not limited to, the
 * implied warranties of merchantability and fitness for a particular purpose
 * are disclaimed. In no event shall VIA Networking Technologies, Inc.
 * be liable for any direct, indirect, incidental, special, exemplary, or
 * consequential damages.
 *
 *
 * File: velocity.h
 *
 * Purpose: Header file to define driver's private structures.
 *
 * Author: Chuang Liang-Shing, AJ Jiang
 *
 * Date: Jan 24, 2003
 *
 */


#ifndef VELOCITY_H
#define VELOCITY_H

#ifdef MODULE
#ifdef MODVERSIONS
#include <linux/modversions.h>
#endif /* MODVERSIONS */
#include <linux/module.h>
#endif /* MODULE */

#include <linux/types.h>
#include <linux/init.h>
#include <linux/mm.h>
#include <linux/errno.h>
#include <linux/ioport.h>
#include <linux/pci.h>
#include <linux/kernel.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/delay.h>
#include <linux/timer.h>
#include <linux/slab.h>
#include <linux/interrupt.h>
#include <linux/version.h>
#include <linux/string.h>
#include <linux/wait.h>
#include <asm/io.h>

#include <linux/if.h>
#include <linux/config.h>
#include <asm/uaccess.h>
#include <linux/proc_fs.h>
#include <linux/inetdevice.h>
#include <linux/reboot.h>
#ifdef SIOCETHTOOL
#define VELOCITY_ETHTOOL_IOCTL_SUPPORT
#include <linux/ethtool.h>
#else
#undef VELOCITY_ETHTOOL_IOCTL_SUPPORT
#endif

#ifdef SIOCGMIIPHY
#define VELOCITY_MII_IOCTL_SUPPORT
#include <linux/mii.h>
#else
#undef VELOCITY_MII_IOCTL_SUPPORT
#endif

#if 0
//The skb fragments of this version isn't be tested.
#ifdef MAX_SKB_FRAGS
#define VELOCITY_ZERO_COPY_SUPPORT
#else
#undef  VELOCITY_ZERO_COPY_SUPPORT
#endif
#endif

#ifdef NETIF_F_IP_CSUM
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include <linux/udp.h>
#define VELOCITY_TX_CSUM_SUPPORT
#else
#undef VELOCITY_TX_CSUM_SUPPORT
#endif

#include "kcompat.h"
#include "velocity_cfg.h"
#include "velocity_desc.h"
#include "velocity_mac.h"
#include "velocity_proc.h"
#include "velocity_wol.h"
#include "velocity_mii.h"
#ifdef VMNS
#include "velocity_vmns.h"
#endif
#include "velocity_dbg.h"


#define     VELOCITY_WOL_MAGIC             0x00000000UL
#define     VELOCITY_WOL_PHY               0x00000001UL
#define     VELOCITY_WOL_ARP               0x00000002UL
#define     VELOCITY_WOL_UCAST             0x00000004UL
#define     VELOCITY_WOL_BCAST             0x00000010UL
#define     VELOCITY_WOL_MCAST             0x00000020UL
#define     VELOCITY_WOL_MAGIC_SEC         0x00000040UL

//flags for options
#define     VELOCITY_FLAGS_TAGGING         0x00000001UL
#define     VELOCITY_FLAGS_TX_CSUM         0x00000002UL
#define     VELOCITY_FLAGS_RX_CSUM         0x00000004UL
#define     VELOCITY_FLAGS_IP_ALIGN        0x00000008UL
#define     VELOCITY_FLAGS_VAL_PKT_LEN     0x00000010UL

#define     VELOCITY_FLAGS_FLOW_CTRL       0x01000000UL

//flags for driver status
#define     VELOCITY_FLAGS_OPENED          0x00010000UL
#define     VELOCITY_FLAGS_VMNS_CONNECTED  0x00020000UL
#define     VELOCITY_FLAGS_VMNS_COMMITTED  0x00040000UL
#define     VELOCITY_FLAGS_WOL_ENABLED     0x00080000UL

//flags for MII status
#define     VELOCITY_LINK_FAIL             0x00000001UL
#define     VELOCITY_SPEED_10              0x00000002UL
#define     VELOCITY_SPEED_100             0x00000004UL
#define     VELOCITY_SPEED_1000            0x00000008UL
#define     VELOCITY_DUPLEX_FULL           0x00000010UL
#define     VELOCITY_AUTONEG_ENABLE        0x00000020UL
#define     VELOCITY_FORCED_BY_EEPROM      0x00000040UL
//for velocity_set_media_duplex
#define     VELOCITY_LINK_CHANGE           0x00000001UL

typedef enum _speed_opt {
    SPD_DPX_AUTO=0,
    SPD_DPX_100_HALF=1,
    SPD_DPX_100_FULL=2,
    SPD_DPX_10_HALF=3,
    SPD_DPX_10_FULL=4
} SPD_DPX_OPT, *PSPD_DPX_OPT;

typedef enum __velocity_init_type {
    VELOCITY_INIT_COLD=0,
    VELOCITY_INIT_RESET,
    VELOCITY_INIT_WOL
} VELOCITY_INIT_TYPE, *PVELOCITY_INIT_TYPE;

typedef enum __velocity_flow_cntl_type {
    FLOW_CNTL_DEFAULT=1,
    FLOW_CNTL_TX,
    FLOW_CNTL_RX,
    FLOW_CNTL_TX_RX,
    FLOW_CNTL_DISABLE,
}
VELOCITY_FLOW_CNTL_TYPE, *PVELOCITY_FLOW_CNTL_TYPE;

typedef struct __velocity_opt {
    int         nRxDescs;       //Number of RX descriptors
    int         nTxDescs;       //Number of TX descriptors
    SPD_DPX_OPT spd_dpx;        //Media link mode
    int         vid;            //vlan id
    int         DMA_length;     //DMA length
    int         rx_thresh;      //RX_THRESH
    int         flow_cntl;
    int         wol_opts;       //Wake on lan options
    int         td_int_count;
    int         int_works;
    int         rx_bandwidth_hi;
    int         rx_bandwidth_lo;
    int         rx_bandwidth_en;
    U32         flags;
} OPTIONS, *POPTIONS;

typedef struct __velocity_info {
    struct __velocity_info*        next;
    struct __velocity_info*        prev;

    struct pci_dev*             pcid;
    struct net_device*          dev;
    struct net_device_stats     stats;

#if CONFIG_PM
    U32                         pci_state[16];
#endif

    void*                       pool;
    dma_addr_t                  pool_dma;
    dma_addr_t                  rd_pool_dma;
    dma_addr_t                  td_pool_dma[TX_QUEUE_NO];

    dma_addr_t                  tx_bufs_dma;
    PU8                         tx_bufs;

    U8                          abyIPAddr[4];
    CHIP_TYPE                   chip_id;

    PMAC_REGS                   pMacRegs;
    U32                         memaddr;
    U32                         ioaddr;
    U32                         io_size;

    U8                          byRevId;
    U16                         SubSystemID;
    U16                         SubVendorID;

#define AVAIL_TD(p,q)   ((p)->sOpts.nTxDescs-((p)->iTDUsed[(q)]))

    int                         nTxQueues;

    volatile int                iTDUsed[TX_QUEUE_NO];
    int                         aiCurrTDIdx[TX_QUEUE_NO];
    int                         aiTailTDIdx[TX_QUEUE_NO];
    PTX_DESC                    apTDRings[TX_QUEUE_NO];
    PVELOCITY_TD_INFO              apTDInfos[TX_QUEUE_NO]; //its a d

    int                         iCurrRDIdx;
    int                         iRDUsed;
    PRX_DESC                    aRDRing;
    PVELOCITY_RD_INFO              aRDInfo; //it's an array

#define GET_RD_BY_IDX(pInfo, idx)   (pInfo->aRDRing[idx])
    U32                         adwRMONStats[RMON_TAB_SIZE];
    U32                         adwHWMIBCounters[MAX_HW_MIB_COUNTER];
    OPTIONS                     sOpts;

    U32                         IntMask;

    U32                         flags;

    int                         rx_buf_sz;
    U32                         mii_status;
    U32                         dwPHYid;
    int                         multicast_limit;

    U8                          abyVCAMMask[(VCAM_SIZE/8)];
    U8                          abyMCAMMask[(MCAM_SIZE/8)];

    spinlock_t                  lock;
    spinlock_t                  xmit_lock;

    int                         wol_opts;
    U8                          wol_passwd[6];

    VELOCITY_CONTEXT               context;

#ifdef CONFIG_PROC_FS
    PVELOCITY_PROC_ENTRY           pProcDir;
#endif
    U32                         ticks;
    U32                         rx_bytes;
#ifdef  VMNS
    PVMNS_DRV_PRIVATE           vmns_priv;
#endif

} VELOCITY_INFO, *PVELOCITY_INFO;

inline static BOOL velocity_get_ip(PVELOCITY_INFO pInfo) {
    struct in_device* in_dev=(struct in_device*) pInfo->dev->ip_ptr;
    struct in_ifaddr* ifa;

    if (in_dev!=NULL) {
        ifa=(struct in_ifaddr*) in_dev->ifa_list;
        if (ifa!=NULL) {
            memcpy(pInfo->abyIPAddr,&ifa->ifa_address,4);
            return TRUE;
        }
    }
    return FALSE;
}

inline static void velocity_update_hw_mibs(PVELOCITY_INFO pInfo) {
    U32 dwTmp;
    int i;
    BYTE_REG_BITS_ON(MIBCR_MIBFLSH,&(pInfo->pMacRegs->byMIBCR));

    while (BYTE_REG_BITS_IS_ON(MIBCR_MIBFLSH,&(pInfo->pMacRegs->byMIBCR)));

    BYTE_REG_BITS_ON(MIBCR_MPTRINI,&(pInfo->pMacRegs->byMIBCR));
    for (i=0;i<HW_MIB_SIZE;i++) {
        dwTmp=readl(&(pInfo->pMacRegs->dwMIBData)) & 0x00FFFFFFUL;
        pInfo->adwHWMIBCounters[i]+=dwTmp;
    }
}

static inline void init_flow_control_register(PVELOCITY_INFO pInfo) {
    PMAC_REGS   pMacRegs=pInfo->pMacRegs;

    /* Set {XHITH1, XHITH0, XLTH1, XLTH0} in FlowCR1 to {1, 0, 1, 1}
        depend on RD=64, and Turn on XNOEN in FlowCR1*/
    writel((CR0_XONEN|CR0_XHITH1|CR0_XLTH1|CR0_XLTH0), &pMacRegs->dwCR0Set);
    writel((CR0_FDXTFCEN|CR0_FDXRFCEN|CR0_HDXFCEN|CR0_XHITH0), &pMacRegs->dwCR0Clr);

    /* Set TxPauseTimer to 0xFFFF */
    writew(0xFFFF, &pMacRegs->wTxPauseTimer);

    /* Initialize RBRDU to Rx buffer count.*/
    writeb(pInfo->sOpts.nRxDescs,&pMacRegs->wRBRDU);
}

U32 mii_check_media_mode(PMAC_REGS pMacRegs);
U32 check_connectiontype(PMAC_REGS pMacRegs);
int velocity_set_media_mode(PVELOCITY_INFO pInfo, U32 mii_status);
void velocity_init_cam_filter(PVELOCITY_INFO pInfo);
BOOL velocity_mii_read(PMAC_REGS, U8 byIdx, PU16 pdata);
BOOL velocity_mii_write(PMAC_REGS, BYTE byMiiAddr, WORD wData);
#endif

