/*
 * Decompiled with CFR 0.152.
 */
package com.denova.runtime;

import com.denova.io.Log;
import com.denova.io.TempFiles;
import com.denova.lang.LangUtilities;
import com.denova.runtime.Exec;
import com.denova.runtime.JRE;
import com.denova.runtime.OS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.StringTokenizer;

public class WindowsOS {
    public static final String WindowsCommandsFilename = "WinCmds.exe";
    public static final String WindowsOsLogFilename = "wincmds";
    public static final String WindowsProgramsMenuCommand = "programsMenu";
    public static final String WindowsStartupMenuCommand = "startupMenu";
    public static final String WindowsDesktopCommand = "desktop";
    public static final String WindowsAddProgramsMenu = "addProgramsMenu";
    public static final String WindowsDelProgramsMenu = "deleteProgramsMenu";
    public static final String WindowsAddStartupMenu = "addStartupMenu";
    public static final String WindowsDelStartupMenu = "deleteStartupMenu";
    public static final String WindowsAddDesktop = "addDesktop";
    public static final String WindowsDelDesktop = "deleteDesktop";
    public static final String WindowsRegistryEditorCommand = "registry";
    public static final String WindowsPathShortenerCommand = "shortname";
    public static final String WindowsNtCommand = "nt";
    public static final String WindowsDirCommand = "windir";
    public static final String WindowsProgramManagerDirCommand = "progmandir";
    public static final String WindowsFreeDiskSpaceCommand = "freespace";
    public static final String MenuSpecFilename = "specmenu";
    public static final String DesktopSpecFilename = "specdesktop";
    public static final String RegistrySpecFilename = "specreg";
    public static final String ShortnameFilename = "winsname.txt";
    public static final String RegistryResultsFilename = "regstats.txt";
    public static final String NtResultsFilename = "winnt.txt";
    public static final String DirectoryResultsFilename = "windir.txt";
    public static final String FreeDiskSpaceResultsFilename = "winspace.txt";
    public static final String AddRegistryEntry = "add";
    public static final String ReplaceRegistryEntry = "replace";
    public static final String AppendRegistryEntry = "append";
    public static final String PrependRegistryEntry = "prepend";
    public static final String DeleteRegistryEntry = "delete";
    public static final String QueryRegistryEntry = "query";
    public static final String InvokerFilename = "invoker.exe";
    static final boolean debugging = false;
    public static final String StringType = "String";
    public static final String DWordType = "DWord";
    static File winCmdsExe = null;
    static File invokerExe = null;
    static Log log = null;

    public boolean addMenuItem(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return this.addMenuItem(string, string2, string3, false, false, false, "", string4, string5, string6, string7);
    }

    public boolean addMenuItem(String string, String string2, String string3, boolean bl, boolean bl2, String string4, String string5, String string6, String string7, String string8) {
        boolean bl3 = false;
        return this.addShortcutItem(WindowsProgramsMenuCommand, WindowsAddProgramsMenu, MenuSpecFilename, string, string2, string3, bl, false, bl2, string4, string5, string6, string7, string8);
    }

    public boolean addMenuItem(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, String string4, String string5, String string6, String string7, String string8) {
        return this.addShortcutItem(WindowsProgramsMenuCommand, WindowsAddProgramsMenu, MenuSpecFilename, string, string2, string3, bl, bl2, bl3, string4, string5, string6, string7, string8);
    }

    public boolean deleteMenuItem(String string, String string2) {
        return this.deleteShortcutItem(WindowsProgramsMenuCommand, WindowsDelProgramsMenu, MenuSpecFilename, string, string2);
    }

    public boolean addStartupMenuItem(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return this.addStartupMenuItem(string2, string3, false, false, "", string4, string5, string6, string7);
    }

    public boolean addStartupMenuItem(String string, String string2, boolean bl, boolean bl2, String string3, String string4, String string5, String string6, String string7) {
        boolean bl3 = false;
        return this.addShortcutItem(WindowsStartupMenuCommand, WindowsAddStartupMenu, MenuSpecFilename, "", string, string2, bl, false, bl2, string3, string4, string5, string6, string7);
    }

    public boolean addStartupMenuItem(String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3, String string4, String string5, String string6, String string7) {
        return this.addShortcutItem(WindowsStartupMenuCommand, WindowsAddStartupMenu, MenuSpecFilename, "", string, string2, bl, bl2, bl3, string3, string4, string5, string6, string7);
    }

    public boolean deleteStartupMenuItem(String string) {
        return this.deleteShortcutItem(WindowsStartupMenuCommand, WindowsDelStartupMenu, MenuSpecFilename, "", string);
    }

    public boolean addDesktopShortcut(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        return this.addDesktopShortcut(string, string2, string3, false, false, "", string4, string5, string6, string7);
    }

    public boolean addDesktopShortcut(String string, String string2, String string3, boolean bl, boolean bl2, String string4, String string5, String string6, String string7, String string8) {
        boolean bl3 = false;
        return this.addShortcutItem(WindowsDesktopCommand, WindowsAddDesktop, DesktopSpecFilename, string2, string, string3, bl, false, bl2, string4, string5, string6, string7, string8);
    }

    public boolean deleteDesktopShortcut(String string, String string2) {
        return this.deleteShortcutItem(WindowsDesktopCommand, WindowsDelDesktop, DesktopSpecFilename, string2, string);
    }

    private boolean addShortcutItem(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2, boolean bl3, String string7, String string8, String string9, String string10, String string11) {
        boolean bl4 = false;
        if (this.WinCmdsExe() != null) {
            File file;
            String string12 = string8;
            log.write("execFile before getExecutable " + string8);
            string8 = this.getExecutable(string6, bl, bl2, bl3, string7, string8);
            log.write("execFile after getExecutable " + string8);
            log.write("cmdLineArgs before getArguments " + string9);
            string9 = this.getArguments(string6, bl, bl3, string7, string12, string9);
            log.write("cmdLineArgs after getArguments " + string9);
            if (!(bl || string8.startsWith("jre ") || string8.startsWith("jrew "))) {
                log.write("dir before adding to execFile " + string6);
                file = string6 != null && string6.length() > 0 ? new File(string6, string8) : new File(string8);
                string8 = file.getPath();
                log.write("execFile after adding dir " + string8);
            }
            if ((file = new File(string8)).exists()) {
                try {
                    String string13 = this.tempFilename(string3);
                    File file2 = new File(string13);
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    PrintWriter printWriter = new PrintWriter(fileOutputStream);
                    printWriter.println(string2);
                    printWriter.println(string4);
                    printWriter.println(string5);
                    printWriter.println(string8);
                    printWriter.println(string9);
                    printWriter.println(string6);
                    printWriter.println(string10);
                    printWriter.println(string11);
                    printWriter.close();
                    fileOutputStream.close();
                    String string14 = this.winCmdFilename();
                    if (string14 != null && string14.length() > 0) {
                        String[] stringArray = new String[]{string14, string, "\"" + string13 + "\""};
                        this.runCommand(stringArray);
                        bl4 = true;
                    } else {
                        bl4 = false;
                        this.rememberError("Unable to create menu because WinCmds.exe not found.");
                    }
                    if (!log.getLogging()) {
                        file2.delete();
                    }
                }
                catch (Exception exception) {
                    this.rememberError("Unable to create menu", exception);
                }
            } else {
                bl4 = false;
                this.rememberError("No executable file for menu");
            }
        }
        return bl4;
    }

    private boolean deleteShortcutItem(String string, String string2, String string3, String string4, String string5) {
        boolean bl = false;
        if (this.WinCmdsExe() != null) {
            try {
                String string6 = this.tempFilename(string3);
                File file = new File(string6);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println(string2);
                printWriter.println(string4);
                printWriter.println(string5);
                printWriter.close();
                fileOutputStream.close();
                String string7 = this.winCmdFilename();
                if (string7 != null && string7.length() > 0) {
                    String[] stringArray = new String[]{string7, string, "\"" + string6 + "\""};
                    this.runCommand(stringArray);
                    bl = true;
                } else {
                    bl = false;
                    this.rememberError("Unable to delete menu because WinCmds.exe not found.");
                }
                if (!log.getLogging()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                this.rememberError("Unable to delete menu", exception);
            }
        }
        return bl;
    }

    public String getExecutable(String string, boolean bl, boolean bl2, String string2, String string3) {
        boolean bl3 = false;
        return this.getExecutable(string, bl, false, bl2, string2, string3);
    }

    public String getExecutable(String string, boolean bl, boolean bl2, boolean bl3, String string2, String string3) {
        String string4 = null;
        if (this.WinCmdsExe() != null) {
            int n;
            int n2;
            if (bl) {
                String string5 = "jre ";
                String string6 = "jrew ";
                String string7 = "java ";
                String string8 = "javaw ";
                if (!bl2) {
                    if (string2.startsWith("jre ")) {
                        string2 = "jrew " + string2.substring("jre ".length());
                    } else if (string2.startsWith("java ")) {
                        string2 = "javaw " + string2.substring("java ".length());
                    }
                }
                string3 = string2 + string3;
            }
            string4 = (string3 = JRE.adjustJreClasspath(string3, string, false, bl3)).startsWith("\"") ? ((n2 = string3.indexOf("\"", 1)) >= 0 ? string3.substring(1, n2) : ((n2 = string3.indexOf(" ")) > 0 ? string3.substring(0, n2) : string3.trim())) : ((n = string3.indexOf(" ")) > 0 ? string3.substring(0, n) : string3.trim());
        }
        return string4;
    }

    public String getArguments(String string, boolean bl, boolean bl2, String string2, String string3, String string4) {
        boolean bl3 = false;
        return this.getArguments(string, bl, false, bl2, string2, string3, string4);
    }

    public String getArguments(String string, boolean bl, boolean bl2, boolean bl3, String string2, String string3, String string4) {
        String string5 = null;
        if (this.WinCmdsExe() != null) {
            String string6;
            if (bl) {
                String string7 = "jre ";
                string6 = "jrew ";
                String string8 = "java ";
                String string9 = "javaw ";
                if (!bl2) {
                    if (string2.startsWith("jre ")) {
                        string2 = "jrew " + string2.substring("jre ".length());
                    } else if (string2.startsWith("java ")) {
                        string2 = "javaw " + string2.substring("java ".length());
                    }
                }
                string3 = string2 + string3;
            }
            string3 = JRE.adjustJreClasspath(string3, string, false, bl3);
            string6 = "";
            if (string3.startsWith("\"")) {
                int n = string3.indexOf("\"", 1);
                if (n >= 0) {
                    string6 = string3.substring(n + 1);
                    string3 = string3.substring(1, n);
                }
            } else {
                int n = string3.indexOf(" ");
                if (n > 0) {
                    string6 = string3.substring(n);
                    string3 = string3.substring(0, n);
                }
            }
            string5 = string6 + " " + string4;
            string5 = string5.trim();
        }
        return string5;
    }

    public String getAncientShortPath(String string) {
        String string2 = string;
        File file = new File(string);
        if (file.exists() && OS.isWindows()) {
            String[] stringArray;
            boolean bl = false;
            String string3 = this.winCmdFilename();
            if (string3 != null && string3.length() > 0) {
                stringArray = new String[]{string3, WindowsPathShortenerCommand, "\"" + string + "\"", "\"" + this.getTempDir() + "\""};
                try {
                    this.runCommand(stringArray);
                    bl = true;
                }
                catch (Exception exception) {
                    this.rememberError("Unable to execute command " + stringArray, exception);
                    bl = false;
                }
            }
            if (bl) {
                try {
                    stringArray = new File(this.tempFilename(ShortnameFilename));
                    FileReader fileReader = new FileReader((File)stringArray);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    String string4 = bufferedReader.readLine();
                    if (string4 != null) {
                        string2 = string4.trim();
                    }
                    fileReader.close();
                    bufferedReader.close();
                    stringArray.delete();
                }
                catch (Exception exception) {
                    this.rememberError("Unable to read " + this.winCmdFilename(), exception);
                }
            }
        } else {
            string2 = string;
        }
        return string2;
    }

    public boolean windowsNT() {
        return OS.isWindowsNT();
    }

    private String getDirName(String string) {
        String string2 = null;
        if (OS.isWindows()) {
            String[] stringArray = new String[]{this.winCmdFilename(), string, "\"" + this.getTempDir() + "\""};
            try {
                this.runCommand(stringArray);
                String string3 = this.tempFilename(DirectoryResultsFilename);
                try {
                    File file = new File(string3);
                    FileReader fileReader = new FileReader(file);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    String string4 = bufferedReader.readLine();
                    if (string4 != null) {
                        string2 = string4.trim();
                    }
                    fileReader.close();
                    bufferedReader.close();
                    file.delete();
                }
                catch (Exception exception) {
                    this.rememberError("Unable to read " + string3, exception);
                }
            }
            catch (Exception exception) {
                this.rememberError("Unable to execute command " + stringArray, exception);
            }
        }
        return string2;
    }

    public String windowsDirectory() {
        return this.getDirName(WindowsDirCommand);
    }

    public String programManagerDirectory() {
        return this.getDirName(WindowsProgramManagerDirCommand);
    }

    public Long getFreeDiskSpace(String string) {
        Long l = new Long(-1L);
        if (OS.isWindows()) {
            String[] stringArray = new String[]{this.winCmdFilename(), WindowsFreeDiskSpaceCommand, "\"" + string + "\"", "\"" + this.getTempDir() + "\""};
            try {
                this.runCommand(stringArray);
                String string2 = this.tempFilename(FreeDiskSpaceResultsFilename);
                try {
                    File file = new File(string2);
                    FileReader fileReader = new FileReader(file);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    String string3 = bufferedReader.readLine();
                    if (string3 != null) {
                        l = new Long(Long.parseLong(string3.trim()));
                    }
                    fileReader.close();
                    bufferedReader.close();
                    file.delete();
                }
                catch (Exception exception) {
                    this.rememberError("Unable to read " + string2, exception);
                }
            }
            catch (Exception exception) {
                this.rememberError("Unable to execute command " + stringArray, exception);
            }
        }
        return l;
    }

    public boolean installService(String string, String string2, String string3, boolean bl) {
        boolean bl2 = false;
        if (this.supportsWindowServices()) {
            String string4 = bl ? "automatic" : "manual";
            String[] stringArray = new String[]{this.invokerFilename(), "install", string, string2, string3, string4};
            try {
                this.runCommand(stringArray);
                String string5 = this.queryWindowsRegistry("HKEY_LOCAL_MACHINE\\System\\CurrentControlSet\\Services\\" + string + "\\Parameters", "Application");
                if (string5 != null && string5.length() > 0) {
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                this.rememberError("Unable to register service" + stringArray, exception);
            }
        }
        return bl2;
    }

    public boolean removeService(String string) {
        boolean bl = false;
        if (this.supportsWindowServices()) {
            String[] stringArray = new String[]{this.invokerFilename(), "remove", string};
            try {
                this.runCommand(stringArray);
                bl = true;
            }
            catch (Exception exception) {
                this.rememberError("Unable to remove service" + stringArray, exception);
            }
        }
        return bl;
    }

    private boolean manageWindowsRegistry(String string, String string2, String string3, String string4, Object object) {
        boolean bl = false;
        if (OS.isWindows()) {
            String string5 = this.tempFilename(RegistryResultsFilename);
            File file = new File(string5);
            file.delete();
            String string6 = this.tempFilename(RegistrySpecFilename);
            File file2 = new File(string6);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                String string7 = string + "\t" + string2 + "\t" + string3 + "\t" + string4 + "\t" + object;
                printWriter.println(string7);
                printWriter.close();
                fileOutputStream.close();
                String[] stringArray = new String[]{this.winCmdFilename(), WindowsRegistryEditorCommand, "\"" + string6 + "\""};
                this.runCommand(stringArray);
                file2.delete();
                try {
                    FileReader fileReader = new FileReader(file);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    String string8 = bufferedReader.readLine();
                    int n = 0;
                    String string9 = "";
                    StringTokenizer stringTokenizer = new StringTokenizer(string8, "\t");
                    while (stringTokenizer.hasMoreTokens() && n < 2) {
                        string9 = stringTokenizer.nextToken();
                        ++n;
                    }
                    if (string9.equalsIgnoreCase("ok")) {
                        bl = true;
                    }
                    bufferedReader.close();
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
            file.delete();
        }
        return bl;
    }

    public boolean addWindowsRegistry(String string, String string2, String string3) {
        return this.manageWindowsRegistry(AddRegistryEntry, string, string2, StringType, string3);
    }

    public boolean addWindowsRegistry(String string, String string2, Integer n) {
        return this.manageWindowsRegistry(AddRegistryEntry, string, string2, DWordType, n);
    }

    public boolean replaceWindowsRegistry(String string, String string2, String string3) {
        return this.manageWindowsRegistry(ReplaceRegistryEntry, string, string2, StringType, string3);
    }

    public boolean replaceWindowsRegistry(String string, String string2, Integer n) {
        return this.manageWindowsRegistry(ReplaceRegistryEntry, string, string2, DWordType, n);
    }

    public boolean appendWindowsRegistry(String string, String string2, String string3) {
        return this.manageWindowsRegistry(AppendRegistryEntry, string, string2, StringType, string3);
    }

    public boolean prependWindowsRegistry(String string, String string2, String string3) {
        return this.manageWindowsRegistry(PrependRegistryEntry, string, string2, StringType, string3);
    }

    public boolean deleteWindowsRegistry(String string, String string2) {
        return this.manageWindowsRegistry(DeleteRegistryEntry, string, string2, StringType, "");
    }

    public String queryWindowsRegistry(String string, String string2) {
        String string3 = null;
        if (OS.isWindows()) {
            String string4 = this.tempFilename(RegistryResultsFilename);
            File file = new File(string4);
            file.delete();
            String string5 = this.tempFilename(RegistrySpecFilename);
            File file2 = new File(string5);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file2);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                printWriter.println("query\t" + string + "\t" + string2);
                printWriter.close();
                fileOutputStream.close();
                String[] stringArray = new String[]{this.winCmdFilename(), WindowsRegistryEditorCommand, "\"" + string5 + "\""};
                this.runCommand(stringArray);
                file2.delete();
                try {
                    FileReader fileReader = new FileReader(file);
                    BufferedReader bufferedReader = new BufferedReader(fileReader);
                    String string6 = bufferedReader.readLine();
                    int n = 0;
                    String string7 = "";
                    String string8 = "";
                    StringTokenizer stringTokenizer = new StringTokenizer(string6, "\t");
                    while (stringTokenizer.hasMoreTokens()) {
                        string7 = stringTokenizer.nextToken();
                        if (n == 1) {
                            string8 = string7;
                        }
                        ++n;
                    }
                    if (string8.equalsIgnoreCase("ok")) {
                        string3 = string7;
                    }
                    bufferedReader.close();
                    fileReader.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
            file.delete();
        }
        return string3;
    }

    public boolean importWindowsRegistryEntries(String string) {
        File file;
        boolean bl = false;
        if (OS.isWindows() && (file = new File(string)).exists()) {
            String string2 = this.windowsDirectory();
            file = new File(string2, "Regedit.exe");
            if (!file.exists()) {
                file = new File(string2, "Regedit32.exe");
            }
            if (file.exists()) {
                try {
                    String[] stringArray = new String[]{file.getPath(), string};
                    this.runCommand(stringArray);
                    bl = true;
                }
                catch (Exception exception) {
                    this.rememberError("Unable to import registry entries", exception);
                }
            }
        }
        return bl;
    }

    String tempFilename(String string) {
        String string2 = "";
        File file = new File(TempFiles.getDefaultDirectory(), string);
        try {
            string2 = file.getCanonicalPath();
        }
        catch (Exception exception) {
            string2 = file.getAbsolutePath();
        }
        return string2;
    }

    String winCmdFilename() {
        String string = "";
        if (OS.isWindows()) {
            if (winCmdsExe == null) {
                this.WinCmdsExe();
            }
            if (winCmdsExe != null) {
                try {
                    string = winCmdsExe.getCanonicalPath();
                }
                catch (Exception exception) {
                    string = winCmdsExe.getAbsolutePath();
                }
            }
        }
        return string;
    }

    File WinCmdsExe() {
        if (OS.isWindows() && winCmdsExe == null) {
            winCmdsExe = new File(TempFiles.getDefaultDirectory(), WindowsCommandsFilename);
            if (winCmdsExe != null && !winCmdsExe.exists()) {
                TempFiles.add(winCmdsExe);
            }
            if (winCmdsExe != null && !winCmdsExe.exists() && !LangUtilities.getResourceAsFile(winCmdsExe.getPath())) {
                winCmdsExe = null;
            }
        }
        return winCmdsExe;
    }

    String invokerFilename() {
        String string = "";
        if (this.supportsWindowServices()) {
            if (invokerExe == null) {
                this.InvokerExe();
            }
            try {
                string = invokerExe.getCanonicalPath();
            }
            catch (Exception exception) {
                string = invokerExe.getAbsolutePath();
            }
        }
        return string;
    }

    File InvokerExe() {
        if (OS.isWindows() && invokerExe == null && (invokerExe = TempFiles.getFile(InvokerFilename)) != null && !invokerExe.exists() && !LangUtilities.getResourceAsFile(invokerExe.getPath())) {
            invokerExe = null;
        }
        return invokerExe;
    }

    private void runCommand(String[] stringArray) throws Exception {
        Exec.runCommand(stringArray);
    }

    private String getTempDir() {
        String string;
        File file = TempFiles.getDefaultDirectory();
        try {
            string = file.getCanonicalPath();
        }
        catch (Exception exception) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static boolean isError() {
        return LangUtilities.isError();
    }

    public static Exception getLastException() {
        return LangUtilities.getLastException();
    }

    public static String getLastError() {
        return LangUtilities.getLastError();
    }

    public static void clearError() {
        LangUtilities.clearError();
    }

    boolean supportsWindowServices() {
        return OS.isWindowsNT() || OS.isWindows2000();
    }

    void rememberError(Exception exception) {
        LangUtilities.rememberError(exception);
    }

    void rememberError(String string) {
        LangUtilities.rememberError(string);
    }

    void rememberError(String string, Exception exception) {
        LangUtilities.rememberError(string, exception);
    }

    void debug(String string) {
    }

    public WindowsOS() {
        this.WinCmdsExe();
        log = new Log(WindowsOsLogFilename);
    }
}

