/*
 * Decompiled with CFR 0.152.
 */
package com.denova.JExpress.Uninstaller;

import com.denova.JExpress.JExpressConstants;
import com.denova.JExpress.JExpressStatusLog;
import com.denova.JExpress.Uninstaller.Command;
import com.denova.io.FileSystem;
import com.denova.io.JarManifest;
import com.denova.io.Log;
import com.denova.io.TempFiles;
import com.denova.runtime.Exec;
import com.denova.ui.AutoProgressBar;
import com.denova.ui.GridBagControl;
import com.denova.ui.LocaleTranslator;
import com.denova.ui.UiUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;

public class JUninstall
extends JFrame
implements JExpressConstants,
Runnable {
    final boolean debug;
    final int Margin;
    Log uninstallLog;
    String programName = "";
    String installDir = "";
    String instructionsFilename;
    String[] programArgs;
    boolean ok = true;
    JarManifest localManifest;
    Thread programThread;
    LocaleTranslator locale;
    Vector commands;
    JLabel action;
    JLabel status;
    JButton finishedButton;
    JProgressBar summaryProgressBar;
    AutoProgressBar autoProgress = null;
    boolean summaryProgressCountUpdates;
    int summaryProgressCount;
    int maxProgress;

    public void run() {
        this.uninstallProgram();
    }

    boolean readyToUninstall() {
        String string = this.getLocalizedString("UninstallNow2");
        string = string == null || string.length() <= 0 ? "" : " " + string;
        String string2 = this.getLocalizedString("UninstallNow1") + " " + this.programName + string + "?";
        return UiUtilities.ask(string2, this.getLocalizedString("Question"), this.getLocalizedString("Yes"), this.getLocalizedString("No"));
    }

    void createPanels() {
        int n = UiUtilities.getDefaultMargin();
        EmptyBorder emptyBorder = new EmptyBorder(n, n, n, n);
        GridBagConstraints gridBagConstraints = GridBagControl.getDefaultConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        GridBagControl gridBagControl = new GridBagControl(jPanel2);
        gridBagControl.addVerticalSpace();
        gridBagControl.addCentered(this.createNoticesPanel());
        gridBagControl.addVerticalSpace();
        gridBagControl.endRow(gridBagConstraints, this.createProgressPanel());
        this.finishedButton = new JButton(this.getLocalizedString("FinishedButton"));
        this.finishedButton.setEnabled(false);
        gridBagControl.addCentered(this.finishedButton);
        gridBagControl.addBlankRow();
        gridBagControl.addVerticalSpace();
        gridBagControl.addCentered(this.createCopyrightPanel());
        gridBagControl.addBlankRow();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(emptyBorder);
        jPanel3.add(UiUtilities.addBevel(jPanel2, 1));
        jPanel.add(jPanel3);
        container.add((Component)jPanel, "Center");
        JUninstall jUninstall = this;
        if (jUninstall == null) {
            throw null;
        }
        JUninstallAction jUninstallAction = jUninstall.new JUninstallAction();
        this.finishedButton.addActionListener(jUninstallAction);
        new JExpressStatusLog("Uninstalling " + this.programName);
        this.pack();
        this.setResizable(false);
        UiUtilities.centerOnScreen(this);
        String string = this.getLocalizedString("PreparingToUninstall") + " " + this.programName;
        this.setStatus(string);
    }

    JPanel createNoticesPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        String string = "     " + this.getLocalizedString("Uninstalling") + " " + this.programName + "     ";
        this.action = new JLabel(string, 0);
        LocaleTranslator.setFont(this.action, new Font("Dialog", 1, 12));
        jPanel.add((Component)this.action, "North");
        jPanel.add(new JLabel(""));
        return jPanel;
    }

    JPanel createCopyrightPanel() {
        JPanel jPanel = new JPanel();
        Font font = new Font("Dialog", 0, 10);
        GridBagControl gridBagControl = new GridBagControl(jPanel);
        JLabel jLabel = new JLabel("Copyright (c) 1997-2001 DeNova, Inc.", 0);
        LocaleTranslator.setFont(jLabel, font);
        JLabel jLabel2 = new JLabel(this.getLocalizedString("RightsReserved"), 0);
        LocaleTranslator.setFont(jLabel2, font);
        gridBagControl.add(jLabel);
        gridBagControl.endRow(jLabel2);
        return jPanel;
    }

    JPanel createProgressPanel() {
        int n = 25;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(25, 25, 25, 25));
        jPanel.setLayout(new GridLayout(2, 1));
        this.summaryProgressBar = new JProgressBar();
        jPanel.add((Component)this.summaryProgressBar, "Center");
        this.status = new JLabel("");
        jPanel.add(this.status);
        return jPanel;
    }

    JPanel createLabel(String string) {
        return this.createLabelPanel(new JLabel(string, 0));
    }

    JPanel createLabelPanel(JLabel jLabel) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(jLabel);
        return jPanel;
    }

    public void uninstallProgram() {
        this.ok = this.uninstall();
        UiUtilities.update((Component)this.summaryProgressBar, this.maxProgress);
        this.finishedButton.setEnabled(true);
        if (this.ok) {
            this.log("Program uninstalled");
            String string = this.getLocalizedString("Done");
            this.setAction(string);
        } else {
            String string = this.getLocalizedString("UnableToUninstall");
            this.setAction(string);
            new JExpressStatusLog("JUninstall: " + string);
        }
    }

    void exit() {
        ((Component)this).setVisible(false);
        System.exit(0);
    }

    boolean parseCommands() {
        boolean bl = true;
        this.setStatus(this.getLocalizedString("ParsingCommands"));
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.instructionsFilename));
            try {
                String string = bufferedReader.readLine();
                while (bl && string != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
                    if (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        Vector<String> vector = new Vector<String>();
                        while (stringTokenizer.hasMoreTokens()) {
                            vector.addElement(stringTokenizer.nextToken());
                        }
                        try {
                            if (string2.equalsIgnoreCase("title") && vector.size() > 0) {
                                if (this.programName.length() <= 0) {
                                    this.programName = (String)vector.firstElement();
                                }
                            } else if (string2.equalsIgnoreCase("installdir") && vector.size() > 0 && this.installDir.length() <= 0) {
                                this.installDir = (String)vector.firstElement();
                            }
                            this.commands.addElement(new Command(string2, vector));
                        }
                        catch (Exception exception) {
                            UiUtilities.note(this.getLocalizedString("BadCommand") + " \"" + string + "\": " + exception, this.getLocalizedString("Ok"));
                            bl = false;
                        }
                    } else {
                        UiUtilities.note(this.getLocalizedString("BadCommandInFile") + " " + this.instructionsFilename, this.getLocalizedString("Ok"));
                        bl = false;
                    }
                    string = bufferedReader.readLine();
                    Thread.yield();
                }
            }
            catch (IOException iOException) {
                UiUtilities.note(this.getLocalizedString("ErrorReadingFile") + " " + this.instructionsFilename, this.getLocalizedString("Ok"));
                bl = false;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            UiUtilities.note(this.getLocalizedString("NoInstructionsFile") + " " + this.instructionsFilename, this.getLocalizedString("Ok"));
            bl = false;
        }
        return bl;
    }

    boolean uninstall() {
        Object object;
        boolean bl = true;
        Enumeration enumeration = this.commands.elements();
        while (bl && enumeration.hasMoreElements()) {
            object = (Command)enumeration.nextElement();
            try {
                this.runCommand(((Command)object).name, ((Command)object).args);
            }
            catch (Exception exception) {
                bl = false;
                UiUtilities.note(this.getLocalizedString("BadCommand") + " " + ((Command)object).name + " " + exception, this.getLocalizedString("Ok"));
                exception.printStackTrace();
            }
            Thread.yield();
        }
        if (bl && this.installDir.length() > 0) {
            object = new File(this.installDir, "JExpress");
            FileSystem.removeDirectory((File)object);
            this.deleteDirTreeIfEmpty(this.installDir);
        }
        if (this.installDir.length() > 0) {
            this.deleteDirTreeIfEmpty(this.installDir);
            this.deleteDirIfEmpty(this.installDir);
        }
        return bl;
    }

    void runCommand(String string, Vector vector) throws Exception {
        if (this.isInternalCommand(string)) {
            this.runInternalCommand(string, vector);
        } else {
            Object object;
            this.startAutoProgress();
            String string2 = this.getLocalizedString("ExecutingCommand") + " " + string;
            String[] stringArray = new String[vector.size() + 1];
            int n = 0;
            if (string.indexOf("WinCmds.exe") != -1 && vector.size() > 0) {
                object = (String)vector.firstElement();
                if (((String)object).indexOf("registry") != -1) {
                    string2 = this.getLocalizedString("UpdatingRegistry");
                } else if (((String)object).indexOf("programsMenu") != -1) {
                    string2 = this.getLocalizedString("RemovingMenus");
                }
            }
            this.setStatus(string2);
            stringArray[n] = string;
            object = vector.elements();
            while (object.hasMoreElements()) {
                String string3 = (String)object.nextElement();
                stringArray[++n] = string3;
            }
            Exec.runCommand(stringArray);
            this.stopAutoProgress();
        }
    }

    boolean isInternalCommand(String string) {
        boolean bl = false;
        if (string.equalsIgnoreCase("title") || string.equalsIgnoreCase("delmanifest") || string.equalsIgnoreCase("deltree") || string.equalsIgnoreCase("delfile") || string.equalsIgnoreCase("installdir")) {
            bl = true;
        }
        return bl;
    }

    void runInternalCommand(String string, Vector vector) {
        block0: {
            String string2;
            block2: {
                block1: {
                    Enumeration enumeration = vector.elements();
                    if (!enumeration.hasMoreElements()) break block0;
                    string2 = (String)enumeration.nextElement();
                    if (!string.equalsIgnoreCase("delmanifest")) break block1;
                    this.deleteManifest(string2);
                    break block0;
                }
                if (!string.equalsIgnoreCase("deltree")) break block2;
                this.deleteTree(string2);
                break block0;
            }
            if (!string.equalsIgnoreCase("delfile")) break block0;
            this.deleteFile(string2);
        }
    }

    void deleteManifest(String string) {
        Object object;
        boolean bl = true;
        String string2 = this.getLocalizedString("DeletingManifest");
        this.setStatus(string2);
        this.startAutoProgress();
        String string3 = JarManifest.getManifestPathname().replace('/', File.separatorChar);
        File file = new File(string, string3);
        try {
            object = new FileInputStream(file);
            this.localManifest = new JarManifest((InputStream)object);
            ((FileInputStream)object).close();
            this.stopAutoProgress();
            bl = false;
            try {
                this.deleteManifestFiles(string, this.localManifest);
            }
            catch (Exception exception) {
                this.log(exception);
            }
        }
        catch (Exception exception) {
            File file2 = new File(string, string3);
            String string4 = this.getLocalizedString("ManifestMissing") + " " + file2.getPath();
            UiUtilities.note(string4, this.getLocalizedString("Ok"));
        }
        string3 = JarManifest.getManifestPathname().replace('/', File.separatorChar);
        object = new File(string, string3);
        ((File)object).delete();
        object = new File(string, JarManifest.getManifestDirname());
        this.deleteDirIfEmpty(((File)object).getPath());
        this.deleteDirIfEmpty(string);
        if (bl) {
            this.stopAutoProgress();
            bl = false;
        }
    }

    void deleteFile(String string) {
        this.startAutoProgress();
        String string2 = this.getLocalizedString("Deleting") + " " + string;
        this.setStatus(string2);
        File file = new File(string);
        if (file != null && file.exists()) {
            file.delete();
        }
        if (file != null && file.getParent() != null) {
            this.deleteDirIfEmpty(file.getParent());
        }
        this.stopAutoProgress();
    }

    void deleteTree(String string) {
        this.startAutoProgress();
        String string2 = this.getLocalizedString("DeletingDirectory") + " " + string;
        this.setStatus(string2);
        FileSystem.removeDirectory(string);
        this.stopAutoProgress();
    }

    void deleteManifestFiles(String string, JarManifest jarManifest) {
        int n;
        Enumeration enumeration = jarManifest.getItems().elements();
        String string2 = this.getLocalizedString("Deleting");
        String string3 = this.getLocalizedString("Of");
        int n2 = 0;
        this.maxProgress = n = jarManifest.getItems().size();
        this.summaryProgressBar.setMaximum(this.maxProgress);
        this.summaryProgressCount = 0;
        this.summaryProgressCountUpdates = true;
        while (enumeration.hasMoreElements()) {
            Properties properties = (Properties)enumeration.nextElement();
            String string4 = properties.getProperty("Name");
            File file = new File(string, string4 = string4.replace('/', File.separatorChar));
            if (file.exists()) {
                file.delete();
            }
            this.displaySummaryProgress(string2 + " " + string4 + " " + String.valueOf(++n2) + " " + string3 + " " + String.valueOf(n));
            File file2 = new File(string);
            try {
                boolean bl = true;
                file = new File(file.getCanonicalPath());
                String string5 = file.getParent();
                while (bl && string5 != null && !string5.equalsIgnoreCase(file2.getCanonicalPath())) {
                    bl = this.deleteDirIfEmpty(string5);
                    file = new File(string5);
                    string5 = file.getParent();
                    Thread.yield();
                }
            }
            catch (Exception exception) {
                this.ok = false;
                this.log(exception);
            }
            Thread.yield();
        }
        if (this.ok) {
            this.setStatus(this.getLocalizedString("DeletedAllFiles"));
        }
        this.summaryProgressCountUpdates = false;
    }

    boolean deleteDirIfEmpty(String string) {
        String[] stringArray;
        boolean bl = false;
        File file = new File(string);
        if (file.isDirectory() && (stringArray = file.list()) != null && stringArray.length <= 0) {
            if (file.exists()) {
                file.delete();
            }
            bl = true;
        }
        return bl;
    }

    void deleteDirTreeIfEmpty(String string) {
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                this.deleteDirIfEmpty(stringArray[n]);
                ++n;
            }
        }
    }

    void showCommand(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(String.valueOf(n) + ": " + stringArray[n]);
            ++n;
        }
    }

    void centerOnScreen(Container container) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = container.getBounds();
        container.setLocation((dimension.width - rectangle.width) / 2, (dimension.height - rectangle.height) / 2);
        container.paintAll(container.getGraphics());
    }

    void setStatus(String string) {
        if (this.status != null) {
            UiUtilities.update((Component)this.status, (Object)string);
        }
        this.log(string);
    }

    void displaySummaryProgress(String string) {
        if (this.summaryProgressCountUpdates) {
            ++this.summaryProgressCount;
            UiUtilities.update((Component)this.summaryProgressBar, this.summaryProgressCount);
        }
        this.setStatus(string);
    }

    void setAction(String string) {
        if (this.action != null) {
            LocaleTranslator.setFont(this.action, new Font("Dialog", 1, 12));
            UiUtilities.update((Component)this.action, (Object)string);
        }
    }

    void startAutoProgress() {
        if (this.autoProgress != null) {
            this.autoProgress.start();
        } else {
            this.autoProgress = new AutoProgressBar(this.summaryProgressBar);
        }
    }

    void stopAutoProgress() {
        if (this.autoProgress != null) {
            this.autoProgress.stop();
        }
    }

    String getLocalizedString(String string) {
        return this.locale.getString(string);
    }

    void log(String string) {
        this.uninstallLog.write(string);
    }

    void log(Throwable throwable) {
        this.uninstallLog.write(throwable);
    }

    void log(String string, Throwable throwable) {
        this.log(string);
        this.log(throwable);
    }

    public static void main(String[] stringArray) {
        Object var1_1 = null;
        String string = null;
        String[] stringArray2 = null;
        int n = 0;
        if (stringArray.length > n && stringArray[n].equals("com.denova.JExpress.Uninstaller.JUninstall")) {
            ++n;
        }
        if (stringArray.length > n) {
            string = stringArray[n];
            ++n;
        }
        if (stringArray.length > n) {
            stringArray2 = new String[stringArray.length - n];
            int n2 = 0;
            int n3 = n;
            while (n3 < stringArray.length) {
                stringArray2[n2++] = stringArray[n3];
                ++n3;
            }
        } else {
            stringArray2 = new String[]{""};
        }
        if (string != null) {
            JUninstall jUninstall = new JUninstall(string, stringArray2);
        } else {
            UiUtilities.note("usage: jre -cp <classpath> JUninstall <path>uninstall");
            System.exit(0);
        }
    }

    void finishedButton_Clicked(ActionEvent actionEvent) {
        this.exit();
    }

    public JUninstall(String string, String[] stringArray) {
        this.debug = false;
        this.Margin = 20;
        TempFiles.setDefaultDirectory(System.getProperty("java.home"));
        Log.setUseTempDirectory(true);
        this.uninstallLog = new Log("JUninstall.log");
        this.locale = new LocaleTranslator(".resources");
        this.commands = new Vector();
        this.instructionsFilename = string.trim();
        this.log("Instructions in " + this.instructionsFilename);
        UiUtilities.setLookAndFeel();
        if (this.parseCommands() && this.readyToUninstall()) {
            this.createPanels();
            this.setTitle("JExpress Uninstaller");
            this.show();
            new Thread(this).start();
        } else {
            this.exit();
        }
    }

    class JUninstallAction
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JUninstall.this.finishedButton) {
                JUninstall.this.finishedButton_Clicked(actionEvent);
            }
        }

        JUninstallAction() {
        }
    }
}

