/*
 * Decompiled with CFR 0.152.
 */
package estadisticas.icmp;

public final class PingICMP {
    private int sock = 0;

    public final boolean begin() {
        if (this.sock != 0) {
            return false;
        }
        this.sock = this.open();
        return this.sock > 0;
    }

    public final boolean end() {
        if (this.sock == 0) {
            return false;
        }
        boolean bl = this.close(this.sock);
        this.sock = 0;
        return bl;
    }

    public final boolean ping(String string, int n, int n2) {
        short s;
        if (string == null || string.length() < 7 || string.length() > 15) {
            return false;
        }
        if (n < 0 || n > 65535) {
            return false;
        }
        if (n2 < 0 || n2 > 65535) {
            return false;
        }
        PingICMP pingICMP = this;
        synchronized (pingICMP) {
            s = this.sendPing(this.sock, string, n, n2);
        }
        switch (s) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public final boolean pong(String[] stringArray) {
        byte[] byArray = new byte[16];
        int[] nArray = new int[3];
        int n = 0;
        if (stringArray == null || stringArray.length < 4) {
            return false;
        }
        block9: while (true) {
            short s;
            PingICMP pingICMP = this;
            synchronized (pingICMP) {
                s = this.recvPing(this.sock, (short)0, byArray, nArray);
            }
            switch (s) {
                case -10: 
                case -5: 
                case -4: 
                case -2: {
                    n = 5;
                    try {
                        Thread.sleep(n);
                    }
                    catch (Exception exception) {}
                    continue block9;
                }
                case 0: {
                    int n2 = 0;
                    while (n2 < byArray.length) {
                        if (byArray[n2] == 0) break;
                        ++n2;
                    }
                    stringArray[0] = new String(byArray, 0, n2);
                    stringArray[1] = new String(Integer.toString(nArray[0]));
                    stringArray[2] = new String(Integer.toString(nArray[1]));
                    int n3 = nArray[2] - n;
                    if (n != 0 && n3 < 0) {
                        n3 = n - n3;
                    }
                    stringArray[3] = new String(Integer.toString(n3));
                    return true;
                }
            }
            break;
        }
        return false;
    }

    private native int open();

    private native boolean close(int var1);

    private native short sendPing(int var1, String var2, int var3, int var4);

    private native short recvPing(int var1, short var2, byte[] var3, int[] var4);

    static {
        try {
            System.loadLibrary("PINGICMP");
            return;
        }
        catch (SecurityException securityException) {
            System.out.println("PingICMP: ERROR cargando libreria nativa PINGICMP.DLL");
            System.out.println("PingICMP: ERROR while loading native library PINGICMP.DLL");
            throw securityException;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("PingICMP: ERROR. No se encuentra la libreria PINGICMP.DLL");
            System.out.println("PingICMP: ERROR. Native library PINGICMP.DLL not found.");
            throw unsatisfiedLinkError;
        }
    }
}

