/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathBuilderResult;
import java.security.cert.CertPathBuilderSpi;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import sun.security.provider.certpath.AdjacencyList;
import sun.security.provider.certpath.BasicChecker;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.ForwardBuilder;
import sun.security.provider.certpath.ForwardState;
import sun.security.provider.certpath.PolicyChecker;
import sun.security.provider.certpath.PolicyNodeImpl;
import sun.security.provider.certpath.ReverseBuilder;
import sun.security.provider.certpath.ReverseState;
import sun.security.provider.certpath.SunCertPathBuilderException;
import sun.security.provider.certpath.SunCertPathBuilderParameters;
import sun.security.provider.certpath.SunCertPathBuilderResult;
import sun.security.provider.certpath.Vertex;
import sun.security.util.Debug;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X500Name;

public final class SunCertPathBuilder
extends CertPathBuilderSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private PKIXBuilderParameters buildParams;
    private CertificateFactory cf;
    private boolean pathCompleted = false;
    private X500Name targetSubjectDN;
    private PolicyNode policyTreeResult;
    private TrustAnchor trustAnchor;
    private PublicKey finalPublicKey;

    public SunCertPathBuilder() throws CertPathBuilderException {
        try {
            this.cf = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException certificateException) {
            throw new CertPathBuilderException(certificateException);
        }
    }

    /*
     * Unable to fully structure code
     */
    public CertPathBuilderResult engineBuild(CertPathParameters var1_1) throws CertPathBuilderException, InvalidAlgorithmParameterException {
        if (SunCertPathBuilder.debug != null) {
            SunCertPathBuilder.debug.println("SunCertPathBuilder.engineBuild(" + var1_1 + ")");
        }
        if (!(var1_1 instanceof PKIXBuilderParameters)) {
            throw new InvalidAlgorithmParameterException("inappropriate parameter type, must be an instance of PKIXBuilderParameters");
        }
        var2_2 = true;
        if (var1_1 instanceof SunCertPathBuilderParameters) {
            var2_2 = ((SunCertPathBuilderParameters)var1_1).getBuildForward();
        }
        if (SunCertPathBuilder.debug != null) {
            SunCertPathBuilder.debug.println("buildForward = " + var2_2);
        }
        this.buildParams = (PKIXBuilderParameters)var1_1;
        var3_3 = this.buildParams.getTrustAnchors().iterator();
        if (var3_3.hasNext()) ** GOTO lbl18
        throw new InvalidAlgorithmParameterException("must specify at least one trust anchor");
lbl-1000:
        // 1 sources

        {
            var4_4 = (TrustAnchor)var3_3.next();
            if (var4_4.getNameConstraints() == null) continue;
            var5_5 = "name constraints in trust anchor not supported";
            throw new InvalidAlgorithmParameterException(var5_5);
lbl18:
            // 2 sources

            ** while (var3_3.hasNext())
        }
lbl19:
        // 1 sources

        var4_4 = this.buildParams.getTargetCertConstraints();
        if (!(var4_4 instanceof X509CertSelector)) {
            throw new InvalidAlgorithmParameterException("the targetCertConstraints parameter must be an X509CertSelector");
        }
        var5_6 = (X509CertSelector)var4_4;
        try {
            if (var5_6 == null || var5_6.getSubjectAsBytes() == null) {
                throw new InvalidAlgorithmParameterException("the targetSubject parameter must not be null");
            }
            this.targetSubjectDN = new X500Name(var5_6.getSubjectAsBytes());
        }
        catch (IOException var6_7) {
            throw new CertPathBuilderException("malformed target subject distinguished name", var6_7);
        }
        this.pathCompleted = false;
        this.trustAnchor = null;
        this.finalPublicKey = null;
        this.policyTreeResult = null;
        var6_8 = new LinkedList();
        var7_9 = new ArrayList();
        try {
            if (var2_2) {
                this.buildForward(var7_9, var6_8);
            } else {
                this.buildReverse(var7_9, var6_8);
            }
        }
        catch (Exception var8_10) {
            if (SunCertPathBuilder.debug != null) {
                SunCertPathBuilder.debug.println("SunCertPathBuilder.engineBuild() exception in build");
                var8_10.printStackTrace();
            }
            throw new SunCertPathBuilderException("unable to find valid certification path to requested target", var8_10, new AdjacencyList(var7_9));
        }
        try {
            if (this.pathCompleted) {
                if (SunCertPathBuilder.debug != null) {
                    SunCertPathBuilder.debug.println("SunCertPathBuilder.engineBuild() pathCompleted");
                }
                Collections.reverse(var6_8);
                return new SunCertPathBuilderResult(this.cf.generateCertPath(var6_8), this.trustAnchor, this.policyTreeResult, this.finalPublicKey, new AdjacencyList(var7_9));
            }
        }
        catch (Exception var8_11) {
            if (SunCertPathBuilder.debug != null) {
                SunCertPathBuilder.debug.println("SunCertPathBuilder.engineBuild() exception in wrap-up");
                var8_11.printStackTrace();
            }
            throw new SunCertPathBuilderException("unable to find valid certification path to requested target", var8_11, new AdjacencyList(var7_9));
        }
        throw new SunCertPathBuilderException("unable to find valid certification path to requested target", new AdjacencyList(var7_9));
    }

    private void buildReverse(List list, LinkedList linkedList) throws Exception {
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildReverse()...");
        }
        ReverseState reverseState = new ReverseState();
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildReverse() InitialPolicies: " + this.buildParams.getInitialPolicies());
        }
        list.clear();
        list.add(new LinkedList());
        Iterator iterator = this.buildParams.getTrustAnchors().iterator();
        while (iterator.hasNext()) {
            reverseState.initState(this.buildParams.getMaxPathLength(), this.buildParams.isExplicitPolicyRequired(), this.buildParams.isPolicyMappingInhibited(), this.buildParams.isAnyPolicyInhibited(), this.buildParams.getCertPathCheckers());
            reverseState.updateState((TrustAnchor)iterator.next());
            reverseState.crlChecker = new CrlRevocationChecker(null, this.buildParams.getCertStores(), this.buildParams.getSigProvider(), this.buildParams.getDate());
            try {
                this.depthFirstSearchReverse(null, reverseState, new ReverseBuilder(this.buildParams, this.targetSubjectDN), list, linkedList);
                break;
            }
            catch (Exception exception) {
                if (iterator.hasNext()) continue;
                throw exception;
            }
        }
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildReverse() returned from depthFirstSearchReverse()");
            debug.println("SunCertPathBuilder.buildReverse() certPathList.size: " + linkedList.size());
        }
    }

    private void buildForward(List list, LinkedList linkedList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildForward()...");
        }
        ForwardState forwardState = new ForwardState();
        forwardState.initState(this.buildParams.getCertPathCheckers());
        list.clear();
        list.add(new LinkedList());
        forwardState.crlChecker = new CrlRevocationChecker(null, this.buildParams.getCertStores(), this.buildParams.getSigProvider(), this.buildParams.getDate());
        this.depthFirstSearchForward(this.targetSubjectDN, forwardState, new ForwardBuilder(this.buildParams, this.targetSubjectDN), list, linkedList);
        if (debug != null) {
            debug.println("SunCertPathBuilder.buildForward() returned from depthFirstSearchForward()");
        }
    }

    void depthFirstSearchForward(Principal principal, ForwardState forwardState, ForwardBuilder forwardBuilder, List list, LinkedList linkedList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchForward(" + principal + ", " + forwardState.toString() + ")");
        }
        LinkedList linkedList2 = this.addVertices(forwardBuilder.getMatchingCerts(forwardState), list);
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchForward(): certs.size=" + linkedList2.size());
        }
        ListIterator listIterator = linkedList2.listIterator();
        block4: while (listIterator.hasNext()) {
            ForwardState forwardState2 = (ForwardState)forwardState.clone();
            Vertex vertex = (Vertex)listIterator.next();
            X509Certificate x509Certificate = (X509Certificate)vertex.getCertificate();
            try {
                forwardBuilder.verifyCert(x509Certificate, forwardState2, linkedList);
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): validation failed: " + generalSecurityException);
                }
                vertex.setThrowable(generalSecurityException);
                continue;
            }
            if (forwardBuilder.isPathCompleted(x509Certificate)) {
                BasicChecker basicChecker = null;
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): commencing final verification");
                }
                PKIXCertPathChecker pKIXCertPathChecker = null;
                X509Certificate x509Certificate2 = null;
                ArrayList arrayList = new ArrayList(linkedList);
                if (forwardBuilder.trustAnchor.getTrustedCert() == null) {
                    arrayList.add(0, x509Certificate);
                }
                int n2 = 0;
                HashSet hashSet = new HashSet(1);
                hashSet.add("2.5.29.32.0");
                PolicyNodeImpl policyNodeImpl = new PolicyNodeImpl(null, "2.5.29.32.0", null, false, hashSet, false);
                PolicyChecker policyChecker = new PolicyChecker(this.buildParams.getInitialPolicies(), arrayList.size(), this.buildParams.isExplicitPolicyRequired(), this.buildParams.isPolicyMappingInhibited(), this.buildParams.isAnyPolicyInhibited(), this.buildParams.getPolicyQualifiersRejected(), policyNodeImpl);
                ArrayList arrayList2 = new ArrayList(this.buildParams.getCertPathCheckers());
                arrayList2.add(n2, policyChecker);
                ++n2;
                if (forwardState2.keyParamsNeeded()) {
                    PublicKey publicKey = x509Certificate.getPublicKey();
                    if (forwardBuilder.trustAnchor.getTrustedCert() == null) {
                        publicKey = forwardBuilder.trustAnchor.getCAPublicKey();
                        if (debug != null) {
                            debug.println("SunCertPathBuilder.depthFirstSearchForward using buildParams public key: " + publicKey.toString());
                        }
                    }
                    basicChecker = new BasicChecker(publicKey, x509Certificate.getSubjectX500Principal(), this.buildParams.getDate(), this.buildParams.getSigProvider(), true);
                    arrayList2.add(n2, basicChecker);
                    ++n2;
                    if (this.buildParams.isRevocationEnabled()) {
                        arrayList2.add(n2, new CrlRevocationChecker(publicKey, this.buildParams.getCertStores(), this.buildParams.getSigProvider(), this.buildParams.getDate()));
                        ++n2;
                    }
                }
                int n3 = 0;
                while (n3 < arrayList.size()) {
                    Set set;
                    x509Certificate2 = (X509Certificate)arrayList.get(n3);
                    if (debug != null) {
                        debug.println("current subject = " + x509Certificate2.getSubjectDN());
                    }
                    if ((set = x509Certificate2.getCriticalExtensionOIDs()) == null) {
                        set = Collections.EMPTY_SET;
                    }
                    int n4 = 0;
                    while (n4 < arrayList2.size()) {
                        pKIXCertPathChecker = (PKIXCertPathChecker)arrayList2.get(n4);
                        if (n4 < n2 || !pKIXCertPathChecker.isForwardCheckingSupported()) {
                            if (n3 == 0) {
                                pKIXCertPathChecker.init(false);
                            }
                            try {
                                pKIXCertPathChecker.check(x509Certificate2, set);
                            }
                            catch (CertPathValidatorException certPathValidatorException) {
                                if (debug != null) {
                                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): final verification failed: " + certPathValidatorException);
                                }
                                vertex.setThrowable(certPathValidatorException);
                                continue block4;
                            }
                        }
                        ++n4;
                    }
                    Iterator iterator = this.buildParams.getCertPathCheckers().iterator();
                    while (iterator.hasNext()) {
                        Set set2;
                        PKIXCertPathChecker pKIXCertPathChecker2 = (PKIXCertPathChecker)iterator.next();
                        if (!pKIXCertPathChecker2.isForwardCheckingSupported() || (set2 = pKIXCertPathChecker2.getSupportedExtensions()) == null) continue;
                        Iterator iterator2 = set2.iterator();
                        while (iterator2.hasNext()) {
                            set.remove(iterator2.next());
                        }
                    }
                    if (!set.isEmpty()) {
                        set.remove(PKIXExtensions.BasicConstraints_Id.toString());
                        set.remove(PKIXExtensions.NameConstraints_Id.toString());
                        set.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                        set.remove(PKIXExtensions.PolicyMappings_Id.toString());
                        set.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                        set.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                        set.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                        set.remove(PKIXExtensions.KeyUsage_Id.toString());
                        set.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                        if (!set.isEmpty()) {
                            throw new CertPathValidatorException("unrecognized critical extension(s)");
                        }
                    }
                    ++n3;
                }
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchForward(): final verification succeeded - path completed!");
                }
                this.pathCompleted = true;
                if (forwardBuilder.trustAnchor.getTrustedCert() == null) {
                    forwardBuilder.addCertToPath(x509Certificate, linkedList);
                }
                this.trustAnchor = forwardBuilder.trustAnchor;
                this.finalPublicKey = basicChecker != null ? basicChecker.getPublicKey() : x509Certificate.getPublicKey();
                this.policyTreeResult = policyChecker.getPolicyTree();
                return;
            }
            forwardBuilder.addCertToPath(x509Certificate, linkedList);
            forwardState2.updateState(x509Certificate);
            list.add(new LinkedList());
            vertex.setIndex(list.size() - 1);
            this.depthFirstSearchForward(x509Certificate.getIssuerDN(), forwardState2, forwardBuilder, list, linkedList);
            if (this.pathCompleted) {
                return;
            }
            if (debug != null) {
                debug.println("SunCertPathBuilder.depthFirstSearchForward(): backtracking");
            }
            forwardBuilder.removeFinalCertFromPath(linkedList);
        }
    }

    void depthFirstSearchReverse(Principal principal, ReverseState reverseState, ReverseBuilder reverseBuilder, List list, LinkedList linkedList) throws GeneralSecurityException, IOException {
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse(" + principal + ", " + reverseState.toString() + ")");
        }
        LinkedList linkedList2 = this.addVertices(reverseBuilder.getMatchingCerts(reverseState), list);
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse(): certs.size=" + linkedList2.size());
        }
        ListIterator listIterator = linkedList2.listIterator();
        while (listIterator.hasNext()) {
            ReverseState reverseState2 = (ReverseState)reverseState.clone();
            Vertex vertex = (Vertex)listIterator.next();
            X509Certificate x509Certificate = (X509Certificate)vertex.getCertificate();
            try {
                reverseBuilder.verifyCert(x509Certificate, reverseState2, linkedList);
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchReverse(): validation failed: " + generalSecurityException);
                }
                vertex.setThrowable(generalSecurityException);
                continue;
            }
            if (!reverseState.isInitial()) {
                reverseBuilder.addCertToPath(x509Certificate, linkedList);
            }
            this.trustAnchor = reverseState.trustAnchor;
            if (reverseBuilder.isPathCompleted(x509Certificate)) {
                if (debug != null) {
                    debug.println("SunCertPathBuilder.depthFirstSearchReverse(): path completed!");
                }
                this.pathCompleted = true;
                PolicyNodeImpl policyNodeImpl = reverseState2.rootNode;
                if (policyNodeImpl == null) {
                    this.policyTreeResult = null;
                } else {
                    this.policyTreeResult = policyNodeImpl.copyTree();
                    ((PolicyNodeImpl)this.policyTreeResult).setImmutable();
                }
                this.finalPublicKey = x509Certificate.getPublicKey();
                if (this.finalPublicKey instanceof DSAPublicKey && ((DSAPublicKey)this.finalPublicKey).getParams() == null) {
                    this.finalPublicKey = BasicChecker.makeInheritedParamsKey(this.finalPublicKey, reverseState.pubKey);
                }
                return;
            }
            reverseState2.updateState(x509Certificate);
            list.add(new LinkedList());
            vertex.setIndex(list.size() - 1);
            this.depthFirstSearchReverse(x509Certificate.getSubjectDN(), reverseState2, reverseBuilder, list, linkedList);
            if (this.pathCompleted) {
                return;
            }
            if (debug != null) {
                debug.println("SunCertPathBuilder.depthFirstSearchReverse(): backtracking");
            }
            if (reverseState.isInitial()) continue;
            reverseBuilder.removeFinalCertFromPath(linkedList);
        }
        if (debug != null) {
            debug.println("SunCertPathBuilder.depthFirstSearchReverse() all certs in this adjacency list checked");
        }
    }

    private LinkedList addVertices(Collection collection, List list) {
        LinkedList linkedList = (LinkedList)list.get(list.size() - 1);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            Vertex vertex = new Vertex(x509Certificate);
            linkedList.add(vertex);
        }
        return linkedList;
    }
}

