/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.pipe;

import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.VolatileImage;
import sun.awt.image.AcceleratedOffScreenImage;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.image.BytePackedRaster;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.OffScreenImage;
import sun.java2d.InvalidPipeException;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.BlitBg;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.ScaledBlit;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.DrawImagePipe;
import sun.java2d.pipe.SpanIterator;

public class DrawImage
implements DrawImagePipe {
    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, Color color) {
        if (sunGraphics2D.transformState < 2) {
            return this.copyImage(sunGraphics2D, image, n2, n3, 0, 0, image.getWidth(null), image.getHeight(null), color);
        }
        this.transformImage(sunGraphics2D, image, n2, n3, null, null, color);
        return true;
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, int n6, int n7, Color color) {
        if (sunGraphics2D.transformState < 2) {
            SurfaceData surfaceData = SurfaceData.getSurfaceDataFromImage(image, sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color);
            if (surfaceData != null) {
                this.clipAndRenderSurfaceData(sunGraphics2D, surfaceData, color, n2 + sunGraphics2D.transX, n3 + sunGraphics2D.transY, n4, n5, n6, n7);
                return true;
            }
            return false;
        }
        this.scaleImage(sunGraphics2D, image, n2, n3, n2 + n6, n3 + n7, n4, n5, n4 + n6, n5 + n7, color);
        return true;
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, Color color) {
        SurfaceType surfaceType;
        SurfaceType surfaceType2;
        Object object;
        Rectangle rectangle = sunGraphics2D.getCompBounds();
        if (n4 > 0 && n5 > 0 && sunGraphics2D.transformState < 3 && !DrawImage.isBgOperation((SurfaceData)(object = SurfaceData.getSurfaceDataFromImage(image, sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color)), color) && this.scaleSurfaceData(sunGraphics2D, (SurfaceData)object, sunGraphics2D.surfaceData, surfaceType2 = ((SurfaceData)object).getSurfaceType(), surfaceType = sunGraphics2D.surfaceData.getSurfaceType(), n2, n3, 0, 0, n4, n5, image.getWidth(null), image.getHeight(null))) {
            return true;
        }
        object = this.getTransform(image, n2, n3, n4, n5);
        this.transformImage(sunGraphics2D, image, 0, 0, null, (AffineTransform)object, color);
        return true;
    }

    protected AffineTransform getTransform(Image image, int n2, int n3, int n4, int n5) {
        AffineTransform affineTransform = null;
        if (n4 != image.getWidth(null) || n5 != image.getHeight(null) || n2 != 0 || n3 != 0) {
            affineTransform = new AffineTransform();
            affineTransform.translate(n2, n3);
            affineTransform.scale((double)n4 / (double)image.getWidth(null), (double)n5 / (double)image.getHeight(null));
        }
        return affineTransform;
    }

    protected void transformImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, BufferedImageOp bufferedImageOp, AffineTransform affineTransform, Color color) {
        Object object;
        int n4;
        Object object2;
        Object object3;
        Object object4;
        Rectangle rectangle = sunGraphics2D.getCompBounds();
        int n5 = sunGraphics2D.interpolationHint;
        if (bufferedImageOp == null && sunGraphics2D.transformState != 3) {
            if (sunGraphics2D.transformState < 2 && (affineTransform == null || affineTransform.isIdentity())) {
                this.copyImage(sunGraphics2D, image, n2, n3, 0, 0, image.getWidth(null), image.getHeight(null), color);
                return;
            }
            if (!(affineTransform != null && (affineTransform.getType() & 0x78) != 0 || DrawImage.isBgOperation((SurfaceData)(object4 = SurfaceData.getSurfaceDataFromImage(image, sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color)), color))) {
                object3 = ((SurfaceData)object4).getSurfaceType();
                object2 = sunGraphics2D.surfaceData.getSurfaceType();
                n4 = n2;
                int n6 = n3;
                int n7 = image.getWidth(null);
                int n8 = image.getHeight(null);
                if (affineTransform != null) {
                    double[] dArray = new double[]{n4, n6, n4 + n7, n6 + n8};
                    affineTransform.transform(dArray, 0, dArray, 0, 2);
                    n4 = (int)(dArray[0] + 0.5);
                    n6 = (int)(dArray[1] + 0.5);
                    n7 = (int)(dArray[2] + 0.5);
                    n8 = (int)(dArray[3] + 0.5);
                    n7 -= n4;
                    n8 -= n6;
                }
                if (this.scaleSurfaceData(sunGraphics2D, (SurfaceData)object4, sunGraphics2D.surfaceData, (SurfaceType)object3, (SurfaceType)object2, n4, n6, 0, 0, n7, n8, image.getWidth(null), image.getHeight(null))) {
                    return;
                }
            }
        }
        object4 = this.getBufferedImage(image);
        object3 = null;
        if (bufferedImageOp != null) {
            if (bufferedImageOp instanceof AffineTransformOp) {
                object2 = (AffineTransformOp)bufferedImageOp;
                object3 = ((AffineTransformOp)object2).getTransform();
                n5 = ((AffineTransformOp)object2).getInterpolationType();
            } else {
                object4 = bufferedImageOp.filter((BufferedImage)object4, null);
            }
        }
        int n9 = ((BufferedImage)object4).getWidth();
        n4 = ((BufferedImage)object4).getHeight();
        AffineTransform affineTransform2 = new AffineTransform(sunGraphics2D.transform);
        affineTransform2.translate(n2, n3);
        if (affineTransform != null && !affineTransform.isIdentity()) {
            affineTransform2.concatenate(affineTransform);
        }
        if (object3 != null && !((AffineTransform)object3).isIdentity()) {
            affineTransform2.concatenate((AffineTransform)object3);
        }
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        if (dArray[0] == 1.0 && dArray[1] == 0.0 && dArray[2] == 0.0 && dArray[3] == 1.0) {
            n2 = (int)Math.round(dArray[4]);
            object = new Rectangle(n2, n3 = (int)Math.round(dArray[5]), n9, n4);
            if ((rectangle = rectangle.intersection((Rectangle)object)).isEmpty()) {
                return;
            }
            if (!rectangle.equals(object)) {
                object4 = ((BufferedImage)object4).getSubimage(rectangle.x - n2, rectangle.y - n3, rectangle.width, rectangle.height);
                n9 = rectangle.width;
                n4 = rectangle.height;
            }
        } else {
            BufferedImage bufferedImage;
            AffineTransformOp affineTransformOp;
            Rectangle rectangle2;
            object = this.getTransformColorModel(sunGraphics2D, (BufferedImage)object4, affineTransform2);
            int n10 = n5;
            if (n5 == -1) {
                int n11 = n10 = sunGraphics2D.renderHint == 2 ? 2 : 1;
            }
            if ((rectangle = rectangle.intersection(rectangle2 = (affineTransformOp = new AffineTransformOp(affineTransform2, n10)).getBounds2D((BufferedImage)object4).getBounds())).isEmpty()) {
                return;
            }
            n2 = rectangle.x;
            n3 = rectangle.y;
            n9 = rectangle.width;
            n4 = rectangle.height;
            if (n2 != 0 || n3 != 0) {
                affineTransform2.preConcatenate(new AffineTransform(1.0, 0.0, 0.0, 1.0, (double)(-n2), (double)(-n3)));
                affineTransformOp = new AffineTransformOp(affineTransform2, n10);
            }
            if ((object4 = affineTransformOp.filter((BufferedImage)object4, bufferedImage = object == ((BufferedImage)object4).getColorModel() ? new BufferedImage((ColorModel)object, ((BufferedImage)object4).getRaster().createCompatibleWritableRaster(n9, n4), ((ColorModel)object).isAlphaPremultiplied(), null) : new BufferedImage((ColorModel)object, ((ColorModel)object).createCompatibleWritableRaster(n9, n4), ((ColorModel)object).isAlphaPremultiplied(), null))) == null) {
                return;
            }
        }
        object = object4 instanceof OffScreenImage ? ((OffScreenImage)object4).getSourceSurfaceData(sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color) : BufImgSurfaceData.createData((BufferedImage)object4);
        this.clipAndRenderSurfaceData(sunGraphics2D, (SurfaceData)object, color, rectangle.x, rectangle.y, 0, 0, rectangle.width, rectangle.height);
    }

    protected void clipAndRenderSurfaceData(SunGraphics2D sunGraphics2D, SurfaceData surfaceData, Color color, int n2, int n3, int n4, int n5, int n6, int n7) {
        sunGraphics2D.getCompBounds();
        if (sunGraphics2D.clipState == 2) {
            n4 -= n2;
            n5 -= n3;
            int[] nArray = new int[]{n2, n3, n2 + n6, n3 + n7};
            SpanIterator spanIterator = sunGraphics2D.clipRegion.getSpanIterator(nArray);
            while (spanIterator.nextSpan(nArray)) {
                DrawImage.renderSurfaceData(sunGraphics2D, surfaceData, color, n4 + nArray[0], n5 + nArray[1], nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
            }
        } else {
            int n8 = sunGraphics2D.clipX1;
            int n9 = sunGraphics2D.clipY1;
            int n10 = sunGraphics2D.clipX2;
            int n11 = sunGraphics2D.clipY2;
            if (n8 < n2) {
                n8 = n2;
            }
            if (n9 < n3) {
                n9 = n3;
            }
            if (n10 > n2 + n6) {
                n10 = n2 + n6;
            }
            if (n11 > n3 + n7) {
                n11 = n3 + n7;
            }
            if (n10 > n8 && n11 > n9) {
                DrawImage.renderSurfaceData(sunGraphics2D, surfaceData, color, n4 + (n8 - n2), n5 + (n9 - n3), n8, n9, n10 - n8, n11 - n9);
            }
        }
    }

    public static void renderSurfaceData(SunGraphics2D sunGraphics2D, SurfaceData surfaceData, Color color, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        while (true) {
            try {
                SurfaceType surfaceType = surfaceData.getSurfaceType();
                SurfaceType surfaceType2 = sunGraphics2D.surfaceData.getSurfaceType();
                DrawImage.blitSurfaceData(sunGraphics2D, surfaceData, sunGraphics2D.surfaceData, surfaceType, surfaceType2, n2, n3, n4, n5, n6, n7, color);
                return;
            }
            catch (NullPointerException nullPointerException) {
                if (sunGraphics2D.surfaceData != null) {
                    throw nullPointerException;
                }
                return;
            }
            catch (InvalidPipeException invalidPipeException) {
                surfaceData = surfaceData.getReplacement();
                if (sunGraphics2D.surfaceData != null && surfaceData != null && ++n8 < 1) continue;
                return;
            }
            break;
        }
    }

    protected boolean scaleBufferedImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, Color color, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        AffineTransform affineTransform = null;
        if (n4 - n2 != n8 - n6 || n5 - n3 != n9 - n7) {
            affineTransform = new AffineTransform();
            affineTransform.translate(n2, n3);
            double d2 = (double)(n4 - n2) / (double)(n8 - n6);
            double d3 = (double)(n5 - n3) / (double)(n9 - n7);
            affineTransform.scale(d2, d3);
            affineTransform.translate(n10 - n6, n11 - n7);
            n13 = 0;
            n12 = 0;
        }
        if (n10 >= 0 && n11 >= 0) {
            int n16 = bufferedImage.getWidth();
            int n17 = bufferedImage.getHeight();
            if (n10 + n14 > n16) {
                n14 = n16 - n10;
            }
            if (n11 + n15 > n17) {
                n15 = n17 - n11;
            }
            bufferedImage = bufferedImage.getSubimage(n10 + bufferedImage.getMinX(), n11 + bufferedImage.getMinY(), n14, n15);
        }
        this.transformImage(sunGraphics2D, bufferedImage, n12, n13, null, affineTransform, color);
        return true;
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color) {
        SurfaceType surfaceType;
        SurfaceType surfaceType2;
        Object object;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (n8 > n6) {
            n17 = n8 - n6;
            n16 = n6;
        } else {
            bl2 = true;
            n17 = n6 - n8;
            n16 = n8;
        }
        if (n9 > n7) {
            n15 = n9 - n7;
            n14 = n7;
        } else {
            bl3 = true;
            n15 = n7 - n9;
            n14 = n9;
        }
        if (n4 > n2) {
            n13 = n4 - n2;
            n12 = n2;
        } else {
            n13 = n2 - n4;
            bl4 = true;
            n12 = n4;
        }
        if (n5 > n3) {
            n11 = n5 - n3;
            n10 = n3;
        } else {
            n11 = n3 - n5;
            bl5 = true;
            n10 = n5;
        }
        if (n17 <= 0 || n15 <= 0) {
            return true;
        }
        if (bl2 == bl4 && bl3 == bl5 && sunGraphics2D.transformState < 3 && !DrawImage.isBgOperation((SurfaceData)(object = SurfaceData.getSurfaceDataFromImage(image, sunGraphics2D.surfaceData, sunGraphics2D.imageComp, color)), color) && this.scaleSurfaceData(sunGraphics2D, (SurfaceData)object, sunGraphics2D.surfaceData, surfaceType2 = ((SurfaceData)object).getSurfaceType(), surfaceType = sunGraphics2D.surfaceData.getSurfaceType(), n12, n10, n16, n14, n13, n11, n17, n15)) {
            return true;
        }
        object = this.getBufferedImage(image);
        return this.scaleBufferedImage(sunGraphics2D, (BufferedImage)object, color, n2, n3, n4, n5, n6, n7, n8, n9, n16, n14, n12, n10, n17, n15);
    }

    protected static boolean isBgOperation(SurfaceData surfaceData, Color color) {
        return surfaceData == null || color != null && surfaceData.getTransparency() != 1;
    }

    protected BufferedImage getBufferedImage(Image image) {
        if (image instanceof AcceleratedOffScreenImage) {
            return ((AcceleratedOffScreenImage)image).getSnapshot();
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        return ((VolatileImage)image).getSnapshot();
    }

    private ColorModel getTransformColorModel(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, AffineTransform affineTransform) {
        Object object;
        boolean bl2;
        ColorModel colorModel;
        ColorModel colorModel2 = colorModel = bufferedImage.getColorModel();
        if (affineTransform.isIdentity()) {
            return colorModel2;
        }
        int n2 = affineTransform.getType();
        boolean bl3 = bl2 = (n2 & (0x18 | 0x20)) != 0;
        if (!bl2 && n2 != 1 && n2 != 0) {
            object = new double[4];
            affineTransform.getMatrix((double[])object);
            boolean bl4 = bl2 = object[0] != (double)((int)object[0]) || object[3] != (double)((int)object[3]);
        }
        if (sunGraphics2D.renderHint != 2) {
            if (colorModel instanceof IndexColorModel) {
                object = bufferedImage.getRaster();
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                if (bl2 && colorModel.getTransparency() == 1) {
                    if (object instanceof BytePackedRaster) {
                        colorModel2 = ColorModel.getRGBdefault();
                    } else {
                        double[] dArray = new double[6];
                        affineTransform.getMatrix(dArray);
                        if (dArray[1] != 0.0 || dArray[2] != 0.0 || dArray[4] != 0.0 || dArray[5] != 0.0) {
                            int n3 = indexColorModel.getMapSize();
                            if (n3 < 256) {
                                int[] nArray = new int[n3 + 1];
                                indexColorModel.getRGBs(nArray);
                                nArray[n3] = 0;
                                colorModel2 = new IndexColorModel(indexColorModel.getPixelSize(), n3 + 1, nArray, 0, true, n3, 0);
                            } else {
                                colorModel2 = ColorModel.getRGBdefault();
                            }
                        }
                    }
                }
            } else if (bl2 && colorModel.getTransparency() == 1) {
                colorModel2 = ColorModel.getRGBdefault();
            }
        } else if (colorModel instanceof IndexColorModel || bl2 && colorModel.getTransparency() == 1) {
            colorModel2 = ColorModel.getRGBdefault();
        }
        return colorModel2;
    }

    protected static void blitSurfaceData(SunGraphics2D sunGraphics2D, SurfaceData surfaceData, SurfaceData surfaceData2, SurfaceType surfaceType, SurfaceType surfaceType2, int n2, int n3, int n4, int n5, int n6, int n7, Color color) {
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (CompositeType.SrcOverNoEa.equals(compositeType) && (surfaceData.getTransparency() == 1 || color != null)) {
            compositeType = CompositeType.SrcNoEa;
        }
        if (!DrawImage.isBgOperation(surfaceData, color)) {
            Blit blit = Blit.getFromCache(surfaceType, compositeType, surfaceType2);
            blit.Blit(surfaceData, surfaceData2, sunGraphics2D.composite, n2, n3, n4, n5, n6, n7);
        } else {
            BlitBg blitBg = BlitBg.getFromCache(surfaceType, compositeType, surfaceType2);
            blitBg.BlitBg(surfaceData, surfaceData2, sunGraphics2D.composite, color, n2, n3, n4, n5, n6, n7);
        }
    }

    protected boolean areaWithinRect(Rectangle rectangle, int n2, int n3, int n4, int n5) {
        return rectangle.x <= n2 && rectangle.y <= n3 && rectangle.x + rectangle.width >= n2 + n4 && rectangle.y + rectangle.height >= n3 + n5;
    }

    protected boolean scaleSurfaceData(SunGraphics2D sunGraphics2D, SurfaceData surfaceData, SurfaceData surfaceData2, SurfaceType surfaceType, SurfaceType surfaceType2, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        Object object;
        if (sunGraphics2D.interpolationHint != -1) {
            return false;
        }
        CompositeType compositeType = sunGraphics2D.imageComp;
        if (CompositeType.SrcOverNoEa.equals(compositeType) && surfaceData.getTransparency() == 1) {
            compositeType = CompositeType.SrcNoEa;
        }
        if (sunGraphics2D.transformState == 1) {
            n2 += sunGraphics2D.transX;
            n3 += sunGraphics2D.transY;
        } else if (sunGraphics2D.transformState == 2) {
            object = new double[]{n2, n3, n2 + n6, n3 + n7};
            sunGraphics2D.transform.transform((double[])object, 0, (double[])object, 0, 2);
            n2 = (int)(object[0] + 0.5);
            n3 = (int)(object[1] + 0.5);
            n6 = (int)(object[2] + 0.5);
            n7 = (int)(object[3] + 0.5);
            n6 -= n2;
            n7 -= n3;
        }
        object = ScaledBlit.getFromCache(surfaceType, compositeType, surfaceType2);
        if (object != null) {
            if (sunGraphics2D.clipState == 2) {
                int[] nArray = new int[]{n2, n3, n2 + n6, n3 + n7};
                SpanIterator spanIterator = sunGraphics2D.clipRegion.getSpanIterator(nArray);
                while (spanIterator.nextSpan(nArray)) {
                    ((ScaledBlit)object).Scale(surfaceData, surfaceData2, sunGraphics2D.composite, n4, n5, n2, n3, n8, n9, n6, n7, nArray[0], nArray[1], nArray[2], nArray[3]);
                }
            } else {
                ((ScaledBlit)object).Scale(surfaceData, surfaceData2, sunGraphics2D.composite, n4, n5, n2, n3, n8, n9, n6, n7, sunGraphics2D.clipX1, sunGraphics2D.clipY1, sunGraphics2D.clipX2, sunGraphics2D.clipY2);
            }
            return true;
        }
        return false;
    }

    protected boolean imageReady(sun.awt.image.Image image, ImageObserver imageObserver) {
        if (image.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        return true;
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        if (!(image instanceof sun.awt.image.Image)) {
            return this.copyImage(sunGraphics2D, image, n2, n3, color);
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, n2, n3, color, imageObserver);
    }

    public boolean copyImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, int n6, int n7, Color color, ImageObserver imageObserver) {
        if (!(image instanceof sun.awt.image.Image)) {
            return this.copyImage(sunGraphics2D, image, n2, n3, n4, n5, n6, n7, color);
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, n2, n3, n2 + n6, n3 + n7, n4, n5, n4 + n6, n5 + n7, null, imageObserver);
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        if (!(image instanceof sun.awt.image.Image)) {
            return this.scaleImage(sunGraphics2D, image, n2, n3, n4, n5, color);
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, n2, n3, n4, n5, color, imageObserver);
    }

    public boolean scaleImage(SunGraphics2D sunGraphics2D, Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        if (!(image instanceof sun.awt.image.Image)) {
            return this.scaleImage(sunGraphics2D, image, n2, n3, n4, n5, n6, n7, n8, n9, color);
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, n2, n3, n4, n5, n6, n7, n8, n9, color, imageObserver);
    }

    public boolean transformImage(SunGraphics2D sunGraphics2D, Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        if (!(image instanceof sun.awt.image.Image)) {
            this.transformImage(sunGraphics2D, image, 0, 0, null, affineTransform, null);
            return true;
        }
        sun.awt.image.Image image2 = (sun.awt.image.Image)image;
        if (!this.imageReady(image2, imageObserver)) {
            return false;
        }
        ImageRepresentation imageRepresentation = image2.getImageRep();
        return imageRepresentation.drawToBufImage(sunGraphics2D, image2, affineTransform, imageObserver);
    }

    public void transformImage(SunGraphics2D sunGraphics2D, BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
        this.transformImage(sunGraphics2D, bufferedImage, n2, n3, bufferedImageOp, null, null);
    }
}

