/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.security.AccessController;
import sun.awt.Win32GraphicsDevice;
import sun.awt.windows.WVolatileImage;
import sun.awt.windows.Win32BlitLoops;
import sun.awt.windows.Win32DDRenderer;
import sun.awt.windows.Win32OffScreenImage;
import sun.awt.windows.Win32ScaleLoops;
import sun.awt.windows.Win32SurfaceData;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.SurfaceType;
import sun.java2d.pipe.PixelToShapeConverter;
import sun.security.action.GetPropertyAction;

public class Win32OffScreenSurfaceData
extends SurfaceData {
    int width;
    int height;
    int transparency;
    private GraphicsConfiguration graphicsConfig;
    private Image image;
    private static boolean forceDDVram;
    protected static Win32DDRenderer win32pipe;
    protected static PixelToShapeConverter win32txpipe;
    private boolean disposed = false;

    private static native void initDDraw();

    private static native void initIDs();

    public static Win32OffScreenSurfaceData createData(int n2, int n3, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, boolean bl2) {
        if (!((Win32GraphicsDevice)graphicsConfiguration.getDevice()).isOffscreenAccelerationEnabled()) {
            return null;
        }
        Win32OffScreenSurfaceData win32OffScreenSurfaceData = new Win32OffScreenSurfaceData(n2, n3, Win32SurfaceData.getSurfaceType(colorModel, bl2), colorModel, graphicsConfiguration, image, bl2);
        Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)graphicsConfiguration.getDevice();
        win32OffScreenSurfaceData.initSurface(colorModel.getPixelSize(), n2, n3, win32GraphicsDevice.getScreen(), bl2, forceDDVram);
        return win32OffScreenSurfaceData;
    }

    public void validatePipe(SunGraphics2D sunGraphics2D) {
        if (sunGraphics2D.antialiasHint != 2 && sunGraphics2D.paintState == 0 && sunGraphics2D.compositeState == 0 && sunGraphics2D.clipState != 2) {
            sunGraphics2D.imagepipe = SurfaceData.imagepipe;
            if (sunGraphics2D.transformState > 1) {
                sunGraphics2D.drawpipe = win32txpipe;
                sunGraphics2D.fillpipe = win32txpipe;
            } else if (sunGraphics2D.strokeState != 0) {
                sunGraphics2D.drawpipe = win32txpipe;
                sunGraphics2D.fillpipe = win32pipe;
            } else {
                sunGraphics2D.drawpipe = win32pipe;
                sunGraphics2D.fillpipe = win32pipe;
            }
            sunGraphics2D.shapepipe = win32pipe;
            sunGraphics2D.textpipe = sunGraphics2D.textAntialiasHint == 2 ? SurfaceData.aaTextRenderer : SurfaceData.solidTextRenderer;
        } else {
            super.validatePipe(sunGraphics2D);
        }
    }

    public Raster getRaster(int n2, int n3, int n4, int n5) {
        throw new InternalError("not implemented yet");
    }

    public void lock() {
    }

    public void unlock() {
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    private native void initOps(int var1);

    public native void initSurface(int var1, int var2, int var3, int var4, boolean var5, boolean var6);

    public native void restoreSurface();

    protected Win32OffScreenSurfaceData(int n2, int n3, SurfaceType surfaceType, ColorModel colorModel, GraphicsConfiguration graphicsConfiguration, Image image, boolean bl2) {
        super(surfaceType, colorModel);
        this.width = n2;
        this.height = n3;
        this.graphicsConfig = graphicsConfiguration;
        this.image = image;
        this.initOps(colorModel.getPixelSize());
        this.transparency = bl2 ? 2 : 1;
    }

    public int getTransparency() {
        return this.transparency;
    }

    public SurfaceData getReplacement() {
        if (this.image instanceof Win32OffScreenImage) {
            return ((Win32OffScreenImage)this.image).restoreContents();
        }
        if (this.image instanceof WVolatileImage) {
            return ((WVolatileImage)this.image).restoreContents();
        }
        return null;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.width, this.height);
    }

    protected void finalize() {
        this.dispose();
    }

    protected native void nativeDispose();

    public final void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            this.invalidate();
            this.nativeDispose();
        }
    }

    private native void nativeInvalidate();

    public void invalidate() {
        if (this.isValid()) {
            this.nativeInvalidate();
            super.invalidate();
        }
    }

    public native void setTransparentPixel(int var1);

    public native void flush();

    static {
        String string;
        boolean bl2;
        Win32OffScreenSurfaceData.initIDs();
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.noddraw"));
        String string3 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddoffscreen"));
        String string4 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddforcevram"));
        String string5 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddblit"));
        String string6 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddscale"));
        boolean bl3 = string3 != null && (string3.equals("false") || string3.equals("f"));
        forceDDVram = string4 != null && (string4.equals("true") || string4.equals("t"));
        boolean bl4 = string5 != null && (string5.equals("false") || string5.equals("f"));
        boolean bl5 = bl2 = string6 == null || string6.equals("false") || string6.equals("f");
        if (!(string2 != null || bl3 || (string = (String)AccessController.doPrivileged(new GetPropertyAction("javax.accessibility.screen_magnifier_present"))) != null && string.equals("true"))) {
            Win32OffScreenSurfaceData.initDDraw();
            if (!bl4) {
                Win32BlitLoops.register();
            } else {
                System.out.println("DirectDraw Blits disabled");
            }
            if (!bl2) {
                Win32ScaleLoops.register();
                System.out.println("DirectDraw Scaling enabled");
            }
            if (forceDDVram) {
                System.out.println("DirectDraw surfaces constrained to use vram");
            }
        }
        win32pipe = new Win32DDRenderer();
        if (GraphicsPrimitive.tracingEnabled()) {
            win32pipe = win32pipe.traceWrapDD();
        }
        win32txpipe = new PixelToShapeConverter(win32pipe);
    }
}

