/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import java.util.Hashtable;
import sun.awt.DisplayChangedListener;
import sun.awt.Win32GraphicsConfig;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.image.AcceleratedOffScreenImage;
import sun.awt.windows.Win32OffScreenSurfaceData;
import sun.awt.windows.Win32SurfaceData;
import sun.java2d.InvalidPipeException;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.security.action.GetPropertyAction;

public class Win32OffScreenImage
extends AcceleratedOffScreenImage
implements DisplayChangedListener {
    private Hashtable cachedHWSD = new Hashtable();

    private static native void initIDs();

    public Win32OffScreenImage(Component component, ColorModel colorModel, WritableRaster writableRaster, boolean bl2) {
        super(component, colorModel, writableRaster, bl2);
        ((Win32GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment()).addDisplayChangedListener(this);
    }

    protected boolean isValidHWSD(GraphicsConfiguration graphicsConfiguration) {
        return this.surfaceDataHw != null && this.surfaceDataHw == this.cachedHWSD.get(graphicsConfiguration.getDevice());
    }

    protected ColorModel getDeviceColorModel() {
        return this.c.getColorModel();
    }

    protected boolean isTransparent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAcceleratedBackground(GraphicsConfiguration graphicsConfiguration, int n2, int n3) {
        Win32OffScreenImage win32OffScreenImage = this;
        synchronized (win32OffScreenImage) {
            try {
                this.surfaceDataHw = (SurfaceData)this.cachedHWSD.get(graphicsConfiguration.getDevice());
                if (this.surfaceDataHw == null) {
                    this.surfaceDataHw = Win32OffScreenSurfaceData.createData(this.getWidth(), this.getHeight(), ((Win32GraphicsConfig)graphicsConfiguration).getDeviceColorModel(), graphicsConfiguration, this, this.isTransparent());
                    if (this.surfaceDataHw != null) {
                        this.cachedHWSD.put(graphicsConfiguration.getDevice(), this.surfaceDataHw);
                    }
                }
            }
            catch (InvalidPipeException invalidPipeException) {
                this.surfaceDataHw = null;
            }
        }
    }

    protected boolean operationSupported(CompositeType compositeType, Color color) {
        return CompositeType.SrcNoEa.equals(compositeType) || CompositeType.SrcOverNoEa.equals(compositeType);
    }

    protected boolean destSurfaceAccelerated(SurfaceData surfaceData) {
        return surfaceData instanceof Win32OffScreenSurfaceData || surfaceData instanceof Win32SurfaceData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SurfaceData restoreContents() {
        if (AcceleratedOffScreenImage.accelerationEnabled) {
            this.surfaceLossHw = true;
            Win32OffScreenImage win32OffScreenImage = this;
            synchronized (win32OffScreenImage) {
                if (this.surfaceDataHw != null) {
                    this.validate(this.surfaceDataHw.getDeviceConfiguration());
                }
            }
        }
        return super.restoreContents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreSurfaceDataHw() {
        Win32OffScreenImage win32OffScreenImage = this;
        synchronized (win32OffScreenImage) {
            if (this.surfaceDataHw != null) {
                ((Win32OffScreenSurfaceData)this.surfaceDataHw).restoreSurface();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayChanged() {
        if (!AcceleratedOffScreenImage.accelerationEnabled) {
            return;
        }
        Win32OffScreenImage win32OffScreenImage = this;
        synchronized (win32OffScreenImage) {
            if (this.surfaceDataHw != null) {
                Hashtable hashtable = this.cachedHWSD;
                this.surfaceDataHw = null;
                this.cachedHWSD = new Hashtable();
                Object[] objectArray = hashtable.values().toArray();
                int n2 = 0;
                while (n2 < objectArray.length) {
                    ((SurfaceData)objectArray[n2]).invalidate();
                    ++n2;
                }
            }
        }
    }

    public void paletteChanged() {
        this.surfaceDataSw.setNeedsBackup(true);
    }

    public void flush() {
        this.surfaceLossHw = true;
        this.surfaceDataHw = null;
        Hashtable hashtable = this.cachedHWSD;
        this.cachedHWSD = new Hashtable();
        Object[] objectArray = hashtable.values().toArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            ((Win32OffScreenSurfaceData)objectArray[n2]).flush();
            ++n2;
        }
    }

    static {
        Win32OffScreenImage.initIDs();
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.noddraw"));
        String string2 = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.ddoffscreen"));
        boolean bl2 = string2 != null && (string2.equals("false") || string2.equals("f"));
        AcceleratedOffScreenImage.accelerationEnabled = string == null && !bl2;
    }
}

