/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.peer.TextFieldPeer;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WTextComponentPeer;

class WTextFieldPeer
extends WTextComponentPeer
implements TextFieldPeer {
    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = this.getFontMetrics(((TextField)this.target).getFont());
        return new Dimension(fontMetrics.stringWidth(this.getText()) + 24, fontMetrics.getHeight() + 8);
    }

    public void handleEvent(AWTEvent aWTEvent) {
        KeyEvent keyEvent;
        char c2;
        int n2 = aWTEvent.getID();
        if (n2 == 400 && (c2 = (keyEvent = (KeyEvent)aWTEvent).getKeyChar()) == '\n' && !keyEvent.isAltDown() && !keyEvent.isControlDown()) {
            this.postEvent(new ActionEvent(this.target, 1001, this.getText(), keyEvent.getWhen(), keyEvent.getModifiers()));
            return;
        }
        super.handleEvent(aWTEvent);
    }

    public void setEchoChar(char c2) {
        this.setEchoCharacter(c2);
    }

    public Dimension getPreferredSize(int n2) {
        return this.getMinimumSize(n2);
    }

    public Dimension getMinimumSize(int n2) {
        FontMetrics fontMetrics = this.getFontMetrics(((TextField)this.target).getFont());
        return new Dimension(fontMetrics.charWidth('0') * n2 + 24, fontMetrics.getHeight() + 8);
    }

    WTextFieldPeer(TextField textField) {
        super(textField);
    }

    native void create(WComponentPeer var1);

    void initialize() {
        TextField textField = (TextField)this.target;
        if (textField.echoCharIsSet()) {
            this.setEchoChar(textField.getEchoChar());
        }
        super.initialize();
    }

    public native void setEchoCharacter(char var1);

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension minimumSize(int n2) {
        return this.getMinimumSize(n2);
    }

    public Dimension preferredSize(int n2) {
        return this.getPreferredSize(n2);
    }
}

