/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.ScrollPaneAdjustable;
import java.awt.peer.ScrollPanePeer;
import sun.awt.DebugHelper;
import sun.awt.PeerEvent;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WToolkit;

class WScrollPanePeer
extends WPanelPeer
implements ScrollPanePeer {
    private static final DebugHelper dbg = DebugHelper.create(class$sun$awt$windows$WScrollPanePeer == null ? (class$sun$awt$windows$WScrollPanePeer = WScrollPanePeer.class$("sun.awt.windows.WScrollPanePeer")) : class$sun$awt$windows$WScrollPanePeer);
    int scrollbarWidth = this._getVScrollbarWidth();
    int scrollbarHeight = this._getHScrollbarHeight();
    int prevx;
    int prevy;
    static /* synthetic */ Class class$sun$awt$windows$WScrollPanePeer;

    static native void initIDs();

    native void create(WComponentPeer var1);

    native int getOffset(int var1);

    WScrollPanePeer(Component component) {
        super(component);
    }

    void initialize() {
        super.initialize();
        this.setInsets();
        Insets insets = this.getInsets();
        this.setScrollPosition(-insets.left, -insets.top);
    }

    public void setUnitIncrement(Adjustable adjustable, int n2) {
    }

    public Insets insets() {
        return this.getInsets();
    }

    private native void setInsets();

    public synchronized native void setScrollPosition(int var1, int var2);

    public int getHScrollbarHeight() {
        return this.scrollbarHeight;
    }

    private native int _getHScrollbarHeight();

    public int getVScrollbarWidth() {
        return this.scrollbarWidth;
    }

    private native int _getVScrollbarWidth();

    public Point getScrollOffset() {
        int n2 = this.getOffset(0);
        int n3 = this.getOffset(1);
        return new Point(n2, n3);
    }

    public void childResized(int n2, int n3) {
        ScrollPane scrollPane = (ScrollPane)this.target;
        Dimension dimension = scrollPane.getSize();
        this.setSpans(dimension.width, dimension.height, n2, n3);
        this.setInsets();
    }

    synchronized native void setSpans(int var1, int var2, int var3, int var4);

    public void setValue(Adjustable adjustable, int n2) {
        Component component = this.getScrollChild();
        Point point = component.getLocation();
        switch (adjustable.getOrientation()) {
            case 1: {
                this.setScrollPosition(-point.x, n2);
                break;
            }
            case 0: {
                this.setScrollPosition(n2, -point.y);
            }
        }
    }

    private native Component getScrollChild();

    private void postScrollEvent(int n2, int n3, int n4, boolean bl2) {
        Adjustor adjustor = new Adjustor(n2, n3, n4, bl2);
        WToolkit.executeOnEventHandlerThread(new ScrollEvent(this.target, adjustor));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        WScrollPanePeer.initIDs();
    }

    class Adjustor
    implements Runnable {
        int orient;
        int type;
        int pos;
        boolean isAdjusting;

        Adjustor(int n2, int n3, int n4, boolean bl2) {
            this.orient = n2;
            this.type = n3;
            this.pos = n4;
            this.isAdjusting = bl2;
        }

        public void run() {
            ScrollPane scrollPane = (ScrollPane)WScrollPanePeer.this.target;
            ScrollPaneAdjustable scrollPaneAdjustable = null;
            if (this.orient == 1) {
                scrollPaneAdjustable = (ScrollPaneAdjustable)scrollPane.getVAdjustable();
            } else if (this.orient == 0) {
                scrollPaneAdjustable = (ScrollPaneAdjustable)scrollPane.getHAdjustable();
            } else {
                dbg;
            }
            if (scrollPaneAdjustable == null) {
                return;
            }
            int n2 = scrollPaneAdjustable.getValue();
            switch (this.type) {
                case 2: {
                    n2 -= scrollPaneAdjustable.getUnitIncrement();
                    break;
                }
                case 1: {
                    n2 += scrollPaneAdjustable.getUnitIncrement();
                    break;
                }
                case 3: {
                    n2 -= scrollPaneAdjustable.getBlockIncrement();
                    break;
                }
                case 4: {
                    n2 += scrollPaneAdjustable.getBlockIncrement();
                    break;
                }
                case 5: {
                    n2 = this.pos;
                    break;
                }
                default: {
                    dbg;
                    return;
                }
            }
            n2 = Math.max(scrollPaneAdjustable.getMinimum(), n2);
            n2 = Math.min(scrollPaneAdjustable.getMaximum(), n2);
            scrollPaneAdjustable.setValueIsAdjusting(this.isAdjusting);
            scrollPaneAdjustable.setValue(n2);
            Component component = WScrollPanePeer.this.getScrollChild();
            while (component != null && !(component.getPeer() instanceof WComponentPeer)) {
                component = component.getParent();
            }
            dbg;
            WComponentPeer wComponentPeer = (WComponentPeer)component.getPeer();
            wComponentPeer.paintDamagedAreaImmediately();
        }
    }

    class ScrollEvent
    extends PeerEvent {
        ScrollEvent(Object object, Runnable runnable) {
            super(object, runnable, 0L);
        }

        public PeerEvent coalesceEvents(PeerEvent peerEvent) {
            dbg;
            if (peerEvent instanceof ScrollEvent) {
                return peerEvent;
            }
            return null;
        }
    }
}

