/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.ShellFolderManager;
import sun.awt.shell.Win32ShellFolder;
import sun.security.action.LoadLibraryAction;

public class Win32ShellFolderManager
extends ShellFolderManager {
    private static Win32ShellFolder desktop;
    private static Win32ShellFolder drives;
    private static Win32ShellFolder recent;
    private static Win32ShellFolder network;
    private static Win32ShellFolder personal;
    private static File[] roots;
    private Comparator driveComparator = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((ShellFolder)object).getPath().compareTo(((ShellFolder)object2).getPath());
        }
    };

    public ShellFolder createShellFolder(File file) throws FileNotFoundException {
        return new Win32ShellFolder(null, file);
    }

    static Win32ShellFolder getDesktop() {
        if (desktop == null) {
            try {
                desktop = new Win32ShellFolder(null, 0);
            }
            catch (IOException iOException) {
                desktop = null;
            }
        }
        return desktop;
    }

    static Win32ShellFolder getDrives() {
        if (drives == null) {
            try {
                drives = new Win32ShellFolder((ShellFolder)Win32ShellFolderManager.getDesktop(), 17);
            }
            catch (IOException iOException) {
                drives = null;
            }
        }
        return drives;
    }

    static Win32ShellFolder getRecent() {
        if (recent == null) {
            try {
                String string = Win32ShellFolder.getFileSystemPath(8);
                if (string != null) {
                    recent = new Win32ShellFolder(null, string);
                }
            }
            catch (IOException iOException) {
                recent = null;
            }
        }
        return recent;
    }

    static Win32ShellFolder getNetwork() {
        if (network == null) {
            try {
                network = new Win32ShellFolder((ShellFolder)Win32ShellFolderManager.getDesktop(), 18);
            }
            catch (IOException iOException) {
                network = null;
            }
        }
        return network;
    }

    static Win32ShellFolder getPersonal() {
        if (personal == null) {
            try {
                String string = Win32ShellFolder.getFileSystemPath(5);
                if (string != null && (personal = Win32ShellFolderManager.getDesktop().getChildByPath(string)) == null) {
                    personal = new Win32ShellFolder(null, string);
                }
            }
            catch (IOException iOException) {
                personal = null;
            }
        }
        return personal;
    }

    public Object get(String string) {
        if (string.equals("fileChooserDefaultFolder")) {
            Win32ShellFolder win32ShellFolder = Win32ShellFolderManager.getPersonal();
            if (win32ShellFolder == null) {
                win32ShellFolder = Win32ShellFolderManager.getDesktop();
            }
            return win32ShellFolder;
        }
        if (string.equals("roots")) {
            if (roots == null) {
                Win32ShellFolder win32ShellFolder = Win32ShellFolderManager.getDesktop();
                roots = win32ShellFolder != null ? new File[]{win32ShellFolder} : (File[])super.get(string);
            }
            return roots;
        }
        if (string.equals("fileChooserComboBoxFolders")) {
            Win32ShellFolder win32ShellFolder = Win32ShellFolderManager.getDesktop();
            if (win32ShellFolder != null) {
                ArrayList arrayList = new ArrayList();
                Win32ShellFolder win32ShellFolder2 = Win32ShellFolderManager.getDrives();
                arrayList.add(win32ShellFolder);
                Object[] objectArray = ((File)win32ShellFolder).listFiles();
                Arrays.sort(objectArray);
                int n2 = 0;
                while (n2 < objectArray.length) {
                    ShellFolder shellFolder = (ShellFolder)objectArray[n2];
                    if (!shellFolder.isFileSystem() || shellFolder.isDirectory()) {
                        Object[] objectArray2;
                        arrayList.add(shellFolder);
                        if (shellFolder.equals(win32ShellFolder2) && (objectArray2 = shellFolder.listFiles()) != null) {
                            Arrays.sort(objectArray2, this.driveComparator);
                            int n3 = 0;
                            while (n3 < objectArray2.length) {
                                arrayList.add(objectArray2[n3]);
                                ++n3;
                            }
                        }
                    }
                    ++n2;
                }
                return arrayList.toArray(new File[arrayList.size()]);
            }
            return super.get(string);
        }
        if (string.equals("fileChooserShortcutPanelFolders")) {
            File[] fileArray = new File[]{Win32ShellFolderManager.getRecent(), Win32ShellFolderManager.getDesktop(), Win32ShellFolderManager.getPersonal(), Win32ShellFolderManager.getDrives(), Win32ShellFolderManager.getNetwork()};
            ArrayList arrayList = new ArrayList();
            int n4 = 0;
            while (n4 < fileArray.length) {
                if (fileArray[n4] != null) {
                    arrayList.add(fileArray[n4]);
                }
                ++n4;
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
        if (string.startsWith("fileChooserIcon ")) {
            try {
                int n5 = Integer.parseInt(string.substring(string.indexOf(" ") + 1));
                return Win32ShellFolder.getFileChooserIcon(n5);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isComputerNode(File file) {
        if (file != null && file.equals(Win32ShellFolderManager.getDrives())) {
            return true;
        }
        String string = file.getAbsolutePath();
        return string.startsWith("\\\\") && string.indexOf("\\", 2) < 0;
    }

    public boolean isFileSystemRoot(File file) {
        if (file != null) {
            Object object;
            Win32ShellFolder win32ShellFolder = Win32ShellFolderManager.getDrives();
            if (file instanceof Win32ShellFolder) {
                object = (Win32ShellFolder)file;
                if (((Win32ShellFolder)object).isFileSystem()) {
                    if (((Win32ShellFolder)object).parent != null) {
                        return ((Win32ShellFolder)object).parent.equals(win32ShellFolder);
                    }
                } else {
                    return false;
                }
            }
            return ((String)(object = file.getPath())).length() == 3 && ((String)object).charAt(1) == ':' && Arrays.asList(win32ShellFolder.listFiles()).contains(file);
        }
        return false;
    }

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
    }
}

