/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.Win32ShellFolderManager;

final class Win32ShellFolder
extends ShellFolder {
    public static final int DESKTOP = 0;
    public static final int INTERNET = 1;
    public static final int PROGRAMS = 2;
    public static final int CONTROLS = 3;
    public static final int PRINTERS = 4;
    public static final int PERSONAL = 5;
    public static final int FAVORITES = 6;
    public static final int STARTUP = 7;
    public static final int RECENT = 8;
    public static final int SENDTO = 9;
    public static final int BITBUCKET = 10;
    public static final int STARTMENU = 11;
    public static final int DESKTOPDIRECTORY = 16;
    public static final int DRIVES = 17;
    public static final int NETWORK = 18;
    public static final int NETHOOD = 19;
    public static final int FONTS = 20;
    public static final int TEMPLATES = 21;
    public static final int COMMON_STARTMENU = 22;
    public static final int COMMON_PROGRAMS = 23;
    public static final int COMMON_STARTUP = 24;
    public static final int COMMON_DESKTOPDIRECTORY = 25;
    public static final int APPDATA = 26;
    public static final int PRINTHOOD = 27;
    public static final int ALTSTARTUP = 29;
    public static final int COMMON_ALTSTARTUP = 30;
    public static final int COMMON_FAVORITES = 31;
    public static final int INTERNET_CACHE = 32;
    public static final int COOKIES = 33;
    public static final int HISTORY = 34;
    public static final int ATTRIB_CANCOPY = 1;
    public static final int ATTRIB_CANMOVE = 2;
    public static final int ATTRIB_CANLINK = 4;
    public static final int ATTRIB_CANRENAME = 16;
    public static final int ATTRIB_CANDELETE = 32;
    public static final int ATTRIB_HASPROPSHEET = 64;
    public static final int ATTRIB_DROPTARGET = 256;
    public static final int ATTRIB_LINK = 65536;
    public static final int ATTRIB_SHARE = 131072;
    public static final int ATTRIB_READONLY = 262144;
    public static final int ATTRIB_GHOSTED = 524288;
    public static final int ATTRIB_HIDDEN = 524288;
    public static final int ATTRIB_FILESYSANCESTOR = 0x10000000;
    public static final int ATTRIB_FOLDER = 0x20000000;
    public static final int ATTRIB_FILESYSTEM = 0x40000000;
    public static final int ATTRIB_HASSUBFOLDER = Integer.MIN_VALUE;
    public static final int ATTRIB_VALIDATE = 0x1000000;
    public static final int ATTRIB_REMOVABLE = 0x2000000;
    public static final int ATTRIB_COMPRESSED = 0x4000000;
    public static final int ATTRIB_BROWSABLE = 0x8000000;
    public static final int ATTRIB_NONENUMERATED = 0x100000;
    public static final int ATTRIB_NEWCONTENT = 0x200000;
    private long pIShellFolder = 0L;
    private long relativePIDL = 0L;
    private long pIDL = 0L;
    static int[] fileChooserBitmapBits;
    static Image[] fileChooserIcons;
    private List topFolderList = null;

    private static native void initIDs();

    Win32ShellFolder(ShellFolder shellFolder, int n2) throws IOException {
        super(shellFolder, Win32ShellFolder.getFileSystemPath(n2) == null ? "ShellFolder: 0x" + Integer.toHexString(n2) : Win32ShellFolder.getFileSystemPath(n2));
        if (n2 == 0) {
            this.initDesktop();
        } else {
            this.initSpecial(this.getDesktop().getIShellFolder(), n2);
        }
    }

    public Win32ShellFolder(ShellFolder shellFolder, String string) throws FileNotFoundException {
        super(shellFolder, string);
        try {
            this.pIDL = this.initFile(this.getDesktopIShellFolder(), string);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(string + " (" + iOException.getMessage() + ")");
        }
    }

    public Win32ShellFolder(ShellFolder shellFolder, File file) throws FileNotFoundException {
        this(shellFolder, file.getAbsolutePath());
    }

    Win32ShellFolder(Win32ShellFolder win32ShellFolder, long l2, long l3, String string) {
        super(win32ShellFolder, string != null ? string : "ShellFolder: ");
        this.pIShellFolder = l2;
        this.relativePIDL = l3;
    }

    private native void initDesktop();

    private native void initSpecial(long var1, int var3);

    private native long initFile(long var1, String var3) throws IOException;

    protected Object writeReplace() throws ObjectStreamException {
        File[] fileArray;
        if (this.isFileSystem()) {
            return new File(this.getPath());
        }
        Win32ShellFolder win32ShellFolder = Win32ShellFolderManager.getDrives();
        if (win32ShellFolder != null && (fileArray = win32ShellFolder.listFiles()) != null) {
            int n2 = 0;
            while (n2 < fileArray.length) {
                Win32ShellFolder win32ShellFolder2;
                if (fileArray[n2] instanceof Win32ShellFolder && (win32ShellFolder2 = (Win32ShellFolder)fileArray[n2]).isFileSystem() && !win32ShellFolder2.hasAttribute(0x2000000)) {
                    return new File(win32ShellFolder2.getPath());
                }
                ++n2;
            }
        }
        return new File("C:\\");
    }

    protected void finalize() throws Throwable {
        if (this.pIDL != 0L && this.pIShellFolder == 0L) {
            this.releasePIDL(this.pIDL);
            this.pIDL = 0L;
            if (this.relativePIDL != 0L) {
                this.releasePIDL(this.relativePIDL);
                this.relativePIDL = 0L;
            }
        } else {
            this.pIShellFolder = 0L;
        }
    }

    private native void releasePIDL(long var1);

    public long getIShellFolder() {
        return this.pIShellFolder;
    }

    public long getParentIShellFolder() {
        Win32ShellFolder win32ShellFolder = (Win32ShellFolder)this.getParentFile();
        if (win32ShellFolder == null) {
            if (this.equals(this.getDesktop())) {
                return this.getIShellFolder();
            }
            return 0L;
        }
        return win32ShellFolder.getIShellFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getRelativePIDL(long l2, long l3) {
        if (l2 == 0L) return 0L;
        if (l3 == 0L) {
            return 0L;
        }
        long l4 = this.getEnumObjects(l2);
        if (l4 == 0L) {
            return 0L;
        }
        try {
            long l5 = 0L;
            do {
                if ((l5 = this.getNextChild(l4)) == 0L) continue;
                long l6 = this.bindToObject(l2, l5);
                if (l6 == l3) {
                    long l7 = l5;
                    Object var14_7 = null;
                    this.releaseEnumObjects(l4);
                    return l7;
                }
                this.releasePIDL(l5);
            } while (l5 != 0L);
        }
        catch (Throwable throwable) {
            Object var14_9 = null;
            this.releaseEnumObjects(l4);
            throw throwable;
        }
        Object var14_8 = null;
        this.releaseEnumObjects(l4);
        return 0L;
    }

    public long getRelativePIDL() {
        if (this.relativePIDL == 0L) {
            this.relativePIDL = this.getRelativePIDL(this.getParentIShellFolder(), this.getIShellFolder());
        }
        return this.relativePIDL;
    }

    public long getPIDL() {
        return this.pIDL;
    }

    public Win32ShellFolder getDesktop() {
        return Win32ShellFolderManager.getDesktop();
    }

    public long getDesktopIShellFolder() {
        return this.getDesktop().getIShellFolder();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Win32ShellFolder)) {
            if (this.isFileSystem()) {
                return super.equals(object);
            }
            return false;
        }
        Win32ShellFolder win32ShellFolder = (Win32ShellFolder)object;
        ShellFolder shellFolder = (ShellFolder)this.getParentFile();
        if (shellFolder != null && !shellFolder.equals(win32ShellFolder.getParentFile())) {
            return false;
        }
        if (this.isFileSystem() || !this.getPath().startsWith("ShellFolder: ")) {
            return this.getAbsolutePath().equals(win32ShellFolder.getAbsolutePath());
        }
        return this.getIShellFolder() == win32ShellFolder.getIShellFolder();
    }

    public boolean isFileSystem() {
        return this.getPIDL() != 0L;
    }

    private native boolean hasAttribute(long var1, int var3);

    private native boolean hasAttribute(long var1, long var3, int var5);

    public boolean hasAttribute(int n2) {
        boolean bl2 = false;
        if (this.isFileSystem()) {
            bl2 = this.hasAttribute(this.getPIDL(), n2);
        }
        if (this.pIShellFolder != 0L) {
            bl2 = bl2 || this.hasAttribute(this.getParentIShellFolder(), this.getRelativePIDL(), n2);
        }
        return bl2;
    }

    private boolean behavesLikeFileSystem(long l2, long l3) {
        return this.hasAttribute(l2, l3, 0x40000000);
    }

    static native String getFileSystemPath(long var0, long var2);

    static native String getFileSystemPath(int var0) throws IOException;

    private static boolean isNetworkRoot(String string) {
        return string.equals("\\\\") || string.equals("\\") || string.equals("//") || string.equals("/");
    }

    public File getParentFile() {
        if (this.parent == null && this.isFileSystem()) {
            String string = this.getParent();
            if (string == null) {
                String string2 = this.getAbsolutePath();
                this.parent = string2.startsWith("\\") ? Win32ShellFolderManager.getNetwork() : Win32ShellFolderManager.getDrives();
            } else if (Win32ShellFolder.isNetworkRoot(string)) {
                this.parent = Win32ShellFolderManager.getNetwork();
            } else {
                try {
                    this.parent = new Win32ShellFolder(null, super.getParentFile());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        return this.parent;
    }

    public boolean isDirectory() {
        return this.hasAttribute(Integer.MIN_VALUE) || this.isFileSystem() && super.isDirectory();
    }

    private long getEnumObjects(long l2) {
        boolean bl2 = l2 == this.getDesktopIShellFolder();
        return this.getEnumObjects(l2, bl2);
    }

    private native long getEnumObjects(long var1, boolean var3);

    private native long getNextChild(long var1);

    private native void releaseEnumObjects(long var1);

    private native long bindToObject(long var1, long var3);

    /*
     * Unable to fully structure code
     */
    public File[] listFiles() {
        block13: {
            block14: {
                block12: {
                    var1_1 = Win32ShellFolderManager.getDesktop();
                    var2_2 = Win32ShellFolderManager.getPersonal();
                    var3_3 = null;
                    if (!this.isFileSystem()) break block12;
                    var4_4 = super.listFiles();
                    if (var4_4 != null) {
                        var3_3 = new File[var4_4.length];
                        var5_6 = 0;
                        var6_8 = 0;
                        while (var6_8 < var4_4.length) {
                            try {
                                var7_9 = new Win32ShellFolder((ShellFolder)this, var4_4[var6_8]);
                                var3_3[var5_6++] = var7_9;
                            }
                            catch (FileNotFoundException var7_10) {
                                // empty catch block
                            }
                            ++var6_8;
                        }
                        if (var5_6 < var4_4.length) {
                            var4_4 = new File[var5_6];
                            System.arraycopy(var3_3, 0, var4_4, 0, var5_6);
                            var3_3 = var4_4;
                        }
                    }
                    break block13;
                }
                var4_5 = new ArrayList();
                var5_7 = this.getIShellFolder();
                if (var5_7 == 0L) break block13;
                var7_11 = this.getEnumObjects(var5_7);
                if (var7_11 == 0L) break block14;
                var9_12 = 0L;
                do {
                    block11: {
                        if ((var9_12 = this.getNextChild(var7_11)) == 0L) continue;
                        var11_13 = null;
                        if (!this.hasAttribute(var5_7, var9_12, 0x40000000)) ** GOTO lbl46
                        var12_14 = Win32ShellFolder.getFileSystemPath(var5_7, var9_12);
                        if (!new File(var12_14).isAbsolute()) continue;
                        if (this == var1_1 && var2_2 != null && var12_14.equalsIgnoreCase(var2_2.getAbsolutePath())) {
                            var11_13 = var2_2;
                        } else {
                            try {
                                var11_13 = new Win32ShellFolder((ShellFolder)this, var12_14);
                                break block11;
                            }
                            catch (FileNotFoundException var13_16) {
                                continue;
                            }
lbl46:
                            // 1 sources

                            if (this.hasAttribute(var5_7, var9_12, 0x10000000)) {
                                var12_15 = this.bindToObject(var5_7, var9_12);
                                var11_13 = new Win32ShellFolder(this, var12_15, var9_12, null);
                            }
                        }
                    }
                    if (var11_13 == null) continue;
                    var4_5.add(var11_13);
                } while (var9_12 != 0L);
            }
            this.releaseEnumObjects(var7_11);
            var3_3 = (ShellFolder[])var4_5.toArray(new ShellFolder[var4_5.size()]);
        }
        return var3_3;
    }

    Win32ShellFolder getChildByPath(String string) {
        long l2 = this.getIShellFolder();
        long l3 = this.getEnumObjects(l2);
        Win32ShellFolder win32ShellFolder = null;
        long l4 = 0L;
        while ((l4 = this.getNextChild(l3)) != 0L) {
            String string2;
            if (!this.hasAttribute(l2, l4, 0x40000000) || !(string2 = Win32ShellFolder.getFileSystemPath(l2, l4)).equalsIgnoreCase(string)) continue;
            long l5 = this.bindToObject(l2, l4);
            win32ShellFolder = new Win32ShellFolder(this, l5, l4, string2);
            break;
        }
        this.releaseEnumObjects(l3);
        return win32ShellFolder;
    }

    public boolean isLink() {
        return this.hasAttribute(65536);
    }

    public boolean isHidden() {
        return this.hasAttribute(524288);
    }

    private native String getLinkLocation(long var1, long var3);

    public ShellFolder getLinkLocation() throws FileNotFoundException {
        if (!this.isLink()) {
            return null;
        }
        String string = null;
        string = this.isFileSystem() ? this.getLinkLocation(this.getDesktopIShellFolder(), this.getPIDL()) : this.getLinkLocation(this.getParentIShellFolder(), this.getRelativePIDL());
        if (string == null) {
            return null;
        }
        return new Win32ShellFolder(null, string);
    }

    private native String getDisplayName(long var1);

    private native String getDisplayName(long var1, long var3);

    public String getDisplayName() {
        if (this.isFileSystem()) {
            return this.getDisplayName(this.getPIDL());
        }
        return this.getDisplayName(this.getParentIShellFolder(), this.getRelativePIDL());
    }

    private native String getFolderType(long var1);

    public String getFolderType() {
        if (this.isFileSystem()) {
            return this.getFolderType(this.getPIDL());
        }
        return this.getFolderType(this.getRelativePIDL());
    }

    private native String getExecutableType(byte[] var1);

    public String getExecutableType() {
        if (!this.isFileSystem()) {
            return null;
        }
        return this.getExecutableType(this.getAbsolutePath().getBytes());
    }

    private native long getIcon(long var1, boolean var3);

    private native long getIcon(long var1, long var3, boolean var5);

    private native int[] getIconBits(long var1, int var3);

    private native void disposeIcon(long var1);

    public static native int[] getFileChooserBitmapBits();

    private int[] getIconBits(boolean bl2) {
        long l2 = 0L;
        l2 = this.isFileSystem() ? this.getIcon(this.getPIDL(), bl2) : this.getIcon(this.getParentIShellFolder(), this.getRelativePIDL(), bl2);
        if (l2 == 0L) {
            return null;
        }
        int[] nArray = this.getIconBits(l2, bl2 ? 32 : 16);
        this.disposeIcon(l2);
        return nArray;
    }

    static Image getFileChooserIcon(int n2) {
        if (fileChooserIcons[n2] != null) {
            return fileChooserIcons[n2];
        }
        if (fileChooserBitmapBits == null) {
            fileChooserBitmapBits = Win32ShellFolder.getFileChooserBitmapBits();
        }
        if (fileChooserBitmapBits != null) {
            int[] nArray = new int[256];
            int n3 = 0;
            while (n3 < 16) {
                int n4 = 0;
                while (n4 < 16) {
                    nArray[n3 * 16 + n4] = fileChooserBitmapBits[n3 * 192 + n2 * 16 + n4];
                    ++n4;
                }
                ++n3;
            }
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            bufferedImage.setRGB(0, 0, 16, 16, nArray, 0, 16);
            Win32ShellFolder.fileChooserIcons[n2] = bufferedImage;
        }
        return fileChooserIcons[n2];
    }

    public Image getIcon(boolean bl2) {
        int n2 = bl2 ? 32 : 16;
        int[] nArray = this.getIconBits(bl2);
        if (nArray == null) {
            return super.getIcon(bl2);
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n2, 2);
        bufferedImage.setRGB(0, 0, n2, n2, nArray, 0, n2);
        return bufferedImage;
    }

    public File getCanonicalFile() throws IOException {
        if (this.isFileSystem()) {
            return new Win32ShellFolder(this.parent, super.getCanonicalPath());
        }
        return this;
    }

    public int compareTo(File file) {
        if (file == null || !(file instanceof Win32ShellFolder) || file instanceof ShellFolder && ((ShellFolder)file).isFileSystem()) {
            if (this.isFileSystem()) {
                return super.compareTo(file);
            }
            return -1;
        }
        if (this.isFileSystem()) {
            return 1;
        }
        if (this.topFolderList == null) {
            this.topFolderList = new ArrayList();
            this.topFolderList.add(Win32ShellFolderManager.getPersonal());
            this.topFolderList.add(Win32ShellFolderManager.getDesktop());
            this.topFolderList.add(Win32ShellFolderManager.getDrives());
            this.topFolderList.add(Win32ShellFolderManager.getNetwork());
        }
        int n2 = this.topFolderList.indexOf(this);
        int n3 = this.topFolderList.indexOf(file);
        if (n2 >= 0 && n3 >= 0) {
            return n2 - n3;
        }
        if (n2 >= 0) {
            return -1;
        }
        if (n3 >= 0) {
            return 1;
        }
        return this.getName().compareTo(file.getName());
    }

    static {
        Win32ShellFolder.initIDs();
        fileChooserBitmapBits = null;
        fileChooserIcons = new Image[12];
    }
}

