/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import javax.security.auth.kerberos.KrbServicePermissionCollection;

public final class ServicePermission
extends Permission
implements Serializable {
    private static final int INITIATE = 1;
    private static final int ACCEPT = 2;
    private static final int ALL = 3;
    private static final int NONE = 0;
    private transient int mask;
    private String actions;

    public ServicePermission(String string, String string2) {
        super(string);
        this.init(string, ServicePermission.getMask(string2));
    }

    private void init(String string, int n2) {
        if (string == null) {
            throw new NullPointerException("service principal can't be null");
        }
        if ((n2 & 3) != n2) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.mask = n2;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)permission;
        return (this.mask & servicePermission.mask) == servicePermission.mask && this.impliesIgnoreMask(servicePermission);
    }

    boolean impliesIgnoreMask(ServicePermission servicePermission) {
        return this.getName().equals("*") || this.getName().equals(servicePermission.getName());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ServicePermission)) {
            return false;
        }
        ServicePermission servicePermission = (ServicePermission)object;
        return (this.mask & servicePermission.mask) == servicePermission.mask && this.getName().equals(servicePermission.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.mask;
    }

    private static String getActions(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        if ((n2 & 1) == 1) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("initiate");
        }
        if ((n2 & 2) == 2) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("accept");
        }
        return stringBuffer.toString();
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = ServicePermission.getActions(this.mask);
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new KrbServicePermissionCollection();
    }

    int getMask() {
        return this.mask;
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String var0) {
        if (var0 == null) {
            throw new NullPointerException("action can't be null");
        }
        if (var0.equals("")) {
            throw new IllegalArgumentException("action can't be empty");
        }
        var1_1 = 0;
        if (var0 == null) {
            return var1_1;
        }
        var2_2 = var0.toCharArray();
        var3_3 = var2_2.length - 1;
        if (var3_3 >= 0) ** GOTO lbl36
        return var1_1;
        {
            --var3_3;
            do {
                if (var3_3 != -1 && ((var4_4 = var2_2[var3_3]) == ' ' || var4_4 == '\r' || var4_4 == '\n' || var4_4 == '\f' || var4_4 == '\t')) continue block4;
                if (!(var3_3 < 7 || var2_2[var3_3 - 7] != 'i' && var2_2[var3_3 - 7] != 'I' || var2_2[var3_3 - 6] != 'n' && var2_2[var3_3 - 6] != 'N' || var2_2[var3_3 - 5] != 'i' && var2_2[var3_3 - 5] != 'I' || var2_2[var3_3 - 4] != 't' && var2_2[var3_3 - 4] != 'T' || var2_2[var3_3 - 3] != 'i' && var2_2[var3_3 - 3] != 'I' || var2_2[var3_3 - 2] != 'a' && var2_2[var3_3 - 2] != 'A' || var2_2[var3_3 - 1] != 't' && var2_2[var3_3 - 1] != 'T' || var2_2[var3_3] != 'e' && var2_2[var3_3] != 'E')) {
                    var5_5 = 8;
                    var1_1 |= 1;
                } else if (!(var3_3 < 5 || var2_2[var3_3 - 5] != 'a' && var2_2[var3_3 - 5] != 'A' || var2_2[var3_3 - 4] != 'c' && var2_2[var3_3 - 4] != 'C' || var2_2[var3_3 - 3] != 'c' && var2_2[var3_3 - 3] != 'C' || var2_2[var3_3 - 2] != 'e' && var2_2[var3_3 - 2] != 'E' || var2_2[var3_3 - 1] != 'p' && var2_2[var3_3 - 1] != 'P' || var2_2[var3_3] != 't' && var2_2[var3_3] != 'T')) {
                    var5_5 = 6;
                    var1_1 |= 2;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + var0);
                }
                var6_6 = false;
                while (var3_3 >= var5_5 && !var6_6) {
                    switch (var2_2[var3_3 - var5_5]) {
                        case ',': {
                            var6_6 = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + var0);
                        }
                    }
                    --var3_3;
                }
                var3_3 -= var5_5;
lbl36:
                // 2 sources

            } while (var3_3 != -1);
        }
        return var1_1;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName(), ServicePermission.getMask(this.actions));
    }
}

