/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.nio.DirectByteBuffer;
import java.nio.DirectDoubleBufferRS;
import java.nio.DoubleBuffer;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectDoubleBufferS
extends DoubleBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe;
    protected static final boolean unaligned;
    protected boolean allocated;
    protected Object viewedBuffer = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$nio$DirectDoubleBufferS;

    public Object viewedBuffer() {
        return this.viewedBuffer;
    }

    DirectDoubleBufferS(DirectByteBuffer directByteBuffer) {
        super(-1, 0, directByteBuffer.remaining() >> 3, directByteBuffer.remaining() >> 3);
        int n2 = this.capacity();
        this.limit(n2);
        int n3 = this.position();
        if (!$assertionsDisabled && n3 > n2) {
            throw new AssertionError();
        }
        this.address = directByteBuffer.address() + (long)n3;
        this.allocated = false;
        this.viewedBuffer = directByteBuffer;
    }

    DirectDoubleBufferS(DirectBuffer directBuffer, int n2, int n3, int n4, int n5, int n6) {
        super(n2, n3, n4, n5);
        this.address = directBuffer.address() + (long)n6;
        this.allocated = false;
        this.viewedBuffer = directBuffer;
    }

    public DoubleBuffer slice() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        int n5 = n2 << 3;
        return new DirectDoubleBufferS(this, -1, 0, n4, n4, n5);
    }

    public DoubleBuffer duplicate() {
        return new DirectDoubleBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public DoubleBuffer asReadOnlyBuffer() {
        return new DirectDoubleBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public long address() {
        return this.address;
    }

    private long ix(int n2) {
        return this.address + (long)(n2 << 3);
    }

    public double get() {
        return Bits.swap(unsafe.getDouble(this.ix(this.nextGetIndex())));
    }

    public double get(int n2) {
        return Bits.swap(unsafe.getDouble(this.ix(this.checkIndex(n2))));
    }

    public DoubleBuffer put(double d2) {
        unsafe.putDouble(this.ix(this.nextPutIndex()), Bits.swap(d2));
        return this;
    }

    public DoubleBuffer put(int n2, double d2) {
        unsafe.putDouble(this.ix(this.checkIndex(n2)), Bits.swap(d2));
        return this;
    }

    public DoubleBuffer put(DoubleBuffer doubleBuffer) {
        if (doubleBuffer instanceof DirectDoubleBufferS) {
            int n2;
            if (doubleBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectDoubleBufferS directDoubleBufferS = (DirectDoubleBufferS)doubleBuffer;
            int n3 = directDoubleBufferS.position();
            int n4 = directDoubleBufferS.limit();
            if (!$assertionsDisabled && n3 > n4) {
                throw new AssertionError();
            }
            int n5 = n3 <= n4 ? n4 - n3 : 0;
            int n6 = this.position();
            int n7 = this.limit();
            if (!$assertionsDisabled && n6 > n7) {
                throw new AssertionError();
            }
            int n8 = n2 = n6 <= n7 ? n7 - n6 : 0;
            if (n5 > n2) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directDoubleBufferS.ix(n3), this.ix(n6), n5 << 3);
            directDoubleBufferS.position(n3 + n5);
            this.position(n6 + n5);
        } else {
            super.put(doubleBuffer);
        }
        return this;
    }

    public DoubleBuffer compact() {
        int n2 = this.position();
        int n3 = this.limit();
        if (!$assertionsDisabled && n2 > n3) {
            throw new AssertionError();
        }
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        unsafe.copyMemory(this.ix(n2), this.ix(0), n4 << 3);
        this.position(n4);
        this.limit(this.capacity());
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$java$nio$DirectDoubleBufferS == null ? (class$java$nio$DirectDoubleBufferS = DirectDoubleBufferS.class$("java.nio.DirectDoubleBufferS")) : class$java$nio$DirectDoubleBufferS).desiredAssertionStatus();
        unsafe = Bits.unsafe();
        unaligned = Bits.unaligned();
    }
}

