/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import sun.misc.Unsafe;
import sun.security.action.GetPropertyAction;

class Bits {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static ByteOrder byteOrder = null;
    private static int pageSize = -1;
    private static boolean unaligned;
    private static boolean unalignedKnown;

    private Bits() {
    }

    static short swap(short s2) {
        return (short)(s2 << 8 | s2 >> 8 & 0xFF);
    }

    static char swap(char c2) {
        return (char)(c2 << 8 | c2 >> 8 & 0xFF);
    }

    static int swap(int n2) {
        return Bits.swap((short)n2) << 16 | Bits.swap((short)(n2 >> 16)) & 0xFFFF;
    }

    static long swap(long l2) {
        return (long)Bits.swap((int)l2) << 32 | (long)Bits.swap((int)(l2 >> 32)) & 0xFFFFFFFFL;
    }

    static float swap(float f2) {
        return Float.intBitsToFloat(Bits.swap(Float.floatToRawIntBits(f2)));
    }

    static double swap(double d2) {
        return Double.longBitsToDouble(Bits.swap(Double.doubleToRawLongBits(d2)));
    }

    private static char makeChar(byte by, byte by2) {
        return (char)(by << 8 | by2 & 0xFF);
    }

    static char getCharL(ByteBuffer byteBuffer, int n2) {
        return Bits.makeChar(byteBuffer._get(n2 + 1), byteBuffer._get(n2 + 0));
    }

    static char getCharL(long l2) {
        return Bits.makeChar(Bits._get(l2 + 1L), Bits._get(l2 + 0L));
    }

    static char getCharB(ByteBuffer byteBuffer, int n2) {
        return Bits.makeChar(byteBuffer._get(n2 + 0), byteBuffer._get(n2 + 1));
    }

    static char getCharB(long l2) {
        return Bits.makeChar(Bits._get(l2 + 0L), Bits._get(l2 + 1L));
    }

    static char getChar(ByteBuffer byteBuffer, int n2, boolean bl2) {
        return bl2 ? Bits.getCharB(byteBuffer, n2) : Bits.getCharL(byteBuffer, n2);
    }

    static char getChar(long l2, boolean bl2) {
        return bl2 ? Bits.getCharB(l2) : Bits.getCharL(l2);
    }

    private static byte char1(char c2) {
        return (byte)(c2 >> 8);
    }

    private static byte char0(char c2) {
        return (byte)(c2 >> 0);
    }

    static void putCharL(ByteBuffer byteBuffer, int n2, char c2) {
        byteBuffer._put(n2 + 0, Bits.char0(c2));
        byteBuffer._put(n2 + 1, Bits.char1(c2));
    }

    static void putCharL(long l2, char c2) {
        Bits._put(l2 + 0L, Bits.char0(c2));
        Bits._put(l2 + 1L, Bits.char1(c2));
    }

    static void putCharB(ByteBuffer byteBuffer, int n2, char c2) {
        byteBuffer._put(n2 + 0, Bits.char1(c2));
        byteBuffer._put(n2 + 1, Bits.char0(c2));
    }

    static void putCharB(long l2, char c2) {
        Bits._put(l2 + 0L, Bits.char1(c2));
        Bits._put(l2 + 1L, Bits.char0(c2));
    }

    static void putChar(ByteBuffer byteBuffer, int n2, char c2, boolean bl2) {
        if (bl2) {
            Bits.putCharB(byteBuffer, n2, c2);
        } else {
            Bits.putCharL(byteBuffer, n2, c2);
        }
    }

    static void putChar(long l2, char c2, boolean bl2) {
        if (bl2) {
            Bits.putCharB(l2, c2);
        } else {
            Bits.putCharL(l2, c2);
        }
    }

    private static short makeShort(byte by, byte by2) {
        return (short)(by << 8 | by2 & 0xFF);
    }

    static short getShortL(ByteBuffer byteBuffer, int n2) {
        return Bits.makeShort(byteBuffer._get(n2 + 1), byteBuffer._get(n2 + 0));
    }

    static short getShortL(long l2) {
        return Bits.makeShort(Bits._get(l2 + 1L), Bits._get(l2));
    }

    static short getShortB(ByteBuffer byteBuffer, int n2) {
        return Bits.makeShort(byteBuffer._get(n2 + 0), byteBuffer._get(n2 + 1));
    }

    static short getShortB(long l2) {
        return Bits.makeShort(Bits._get(l2), Bits._get(l2 + 1L));
    }

    static short getShort(ByteBuffer byteBuffer, int n2, boolean bl2) {
        return bl2 ? Bits.getShortB(byteBuffer, n2) : Bits.getShortL(byteBuffer, n2);
    }

    static short getShort(long l2, boolean bl2) {
        return bl2 ? Bits.getShortB(l2) : Bits.getShortL(l2);
    }

    private static byte short1(short s2) {
        return (byte)(s2 >> 8);
    }

    private static byte short0(short s2) {
        return (byte)(s2 >> 0);
    }

    static void putShortL(ByteBuffer byteBuffer, int n2, short s2) {
        byteBuffer._put(n2 + 0, Bits.short0(s2));
        byteBuffer._put(n2 + 1, Bits.short1(s2));
    }

    static void putShortL(long l2, short s2) {
        Bits._put(l2, Bits.short0(s2));
        Bits._put(l2 + 1L, Bits.short1(s2));
    }

    static void putShortB(ByteBuffer byteBuffer, int n2, short s2) {
        byteBuffer._put(n2 + 0, Bits.short1(s2));
        byteBuffer._put(n2 + 1, Bits.short0(s2));
    }

    static void putShortB(long l2, short s2) {
        Bits._put(l2, Bits.short1(s2));
        Bits._put(l2 + 1L, Bits.short0(s2));
    }

    static void putShort(ByteBuffer byteBuffer, int n2, short s2, boolean bl2) {
        if (bl2) {
            Bits.putShortB(byteBuffer, n2, s2);
        } else {
            Bits.putShortL(byteBuffer, n2, s2);
        }
    }

    static void putShort(long l2, short s2, boolean bl2) {
        if (bl2) {
            Bits.putShortB(l2, s2);
        } else {
            Bits.putShortL(l2, s2);
        }
    }

    private static int makeInt(byte by, byte by2, byte by3, byte by4) {
        return (by & 0xFF) << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | (by4 & 0xFF) << 0;
    }

    static int getIntL(ByteBuffer byteBuffer, int n2) {
        return Bits.makeInt(byteBuffer._get(n2 + 3), byteBuffer._get(n2 + 2), byteBuffer._get(n2 + 1), byteBuffer._get(n2 + 0));
    }

    static int getIntL(long l2) {
        return Bits.makeInt(Bits._get(l2 + 3L), Bits._get(l2 + 2L), Bits._get(l2 + 1L), Bits._get(l2 + 0L));
    }

    static int getIntB(ByteBuffer byteBuffer, int n2) {
        return Bits.makeInt(byteBuffer._get(n2 + 0), byteBuffer._get(n2 + 1), byteBuffer._get(n2 + 2), byteBuffer._get(n2 + 3));
    }

    static int getIntB(long l2) {
        return Bits.makeInt(Bits._get(l2 + 0L), Bits._get(l2 + 1L), Bits._get(l2 + 2L), Bits._get(l2 + 3L));
    }

    static int getInt(ByteBuffer byteBuffer, int n2, boolean bl2) {
        return bl2 ? Bits.getIntB(byteBuffer, n2) : Bits.getIntL(byteBuffer, n2);
    }

    static int getInt(long l2, boolean bl2) {
        return bl2 ? Bits.getIntB(l2) : Bits.getIntL(l2);
    }

    private static byte int3(int n2) {
        return (byte)(n2 >> 24);
    }

    private static byte int2(int n2) {
        return (byte)(n2 >> 16);
    }

    private static byte int1(int n2) {
        return (byte)(n2 >> 8);
    }

    private static byte int0(int n2) {
        return (byte)(n2 >> 0);
    }

    static void putIntL(ByteBuffer byteBuffer, int n2, int n3) {
        byteBuffer._put(n2 + 3, Bits.int3(n3));
        byteBuffer._put(n2 + 2, Bits.int2(n3));
        byteBuffer._put(n2 + 1, Bits.int1(n3));
        byteBuffer._put(n2 + 0, Bits.int0(n3));
    }

    static void putIntL(long l2, int n2) {
        Bits._put(l2 + 3L, Bits.int3(n2));
        Bits._put(l2 + 2L, Bits.int2(n2));
        Bits._put(l2 + 1L, Bits.int1(n2));
        Bits._put(l2 + 0L, Bits.int0(n2));
    }

    static void putIntB(ByteBuffer byteBuffer, int n2, int n3) {
        byteBuffer._put(n2 + 0, Bits.int3(n3));
        byteBuffer._put(n2 + 1, Bits.int2(n3));
        byteBuffer._put(n2 + 2, Bits.int1(n3));
        byteBuffer._put(n2 + 3, Bits.int0(n3));
    }

    static void putIntB(long l2, int n2) {
        Bits._put(l2 + 0L, Bits.int3(n2));
        Bits._put(l2 + 1L, Bits.int2(n2));
        Bits._put(l2 + 2L, Bits.int1(n2));
        Bits._put(l2 + 3L, Bits.int0(n2));
    }

    static void putInt(ByteBuffer byteBuffer, int n2, int n3, boolean bl2) {
        if (bl2) {
            Bits.putIntB(byteBuffer, n2, n3);
        } else {
            Bits.putIntL(byteBuffer, n2, n3);
        }
    }

    static void putInt(long l2, int n2, boolean bl2) {
        if (bl2) {
            Bits.putIntB(l2, n2);
        } else {
            Bits.putIntL(l2, n2);
        }
    }

    private static long makeLong(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        return ((long)by & 0xFFL) << 56 | ((long)by2 & 0xFFL) << 48 | ((long)by3 & 0xFFL) << 40 | ((long)by4 & 0xFFL) << 32 | ((long)by5 & 0xFFL) << 24 | ((long)by6 & 0xFFL) << 16 | ((long)by7 & 0xFFL) << 8 | ((long)by8 & 0xFFL) << 0;
    }

    static long getLongL(ByteBuffer byteBuffer, int n2) {
        return Bits.makeLong(byteBuffer._get(n2 + 7), byteBuffer._get(n2 + 6), byteBuffer._get(n2 + 5), byteBuffer._get(n2 + 4), byteBuffer._get(n2 + 3), byteBuffer._get(n2 + 2), byteBuffer._get(n2 + 1), byteBuffer._get(n2 + 0));
    }

    static long getLongL(long l2) {
        return Bits.makeLong(Bits._get(l2 + 7L), Bits._get(l2 + 6L), Bits._get(l2 + 5L), Bits._get(l2 + 4L), Bits._get(l2 + 3L), Bits._get(l2 + 2L), Bits._get(l2 + 1L), Bits._get(l2 + 0L));
    }

    static long getLongB(ByteBuffer byteBuffer, int n2) {
        return Bits.makeLong(byteBuffer._get(n2 + 0), byteBuffer._get(n2 + 1), byteBuffer._get(n2 + 2), byteBuffer._get(n2 + 3), byteBuffer._get(n2 + 4), byteBuffer._get(n2 + 5), byteBuffer._get(n2 + 6), byteBuffer._get(n2 + 7));
    }

    static long getLongB(long l2) {
        return Bits.makeLong(Bits._get(l2 + 0L), Bits._get(l2 + 1L), Bits._get(l2 + 2L), Bits._get(l2 + 3L), Bits._get(l2 + 4L), Bits._get(l2 + 5L), Bits._get(l2 + 6L), Bits._get(l2 + 7L));
    }

    static long getLong(ByteBuffer byteBuffer, int n2, boolean bl2) {
        return bl2 ? Bits.getLongB(byteBuffer, n2) : Bits.getLongL(byteBuffer, n2);
    }

    static long getLong(long l2, boolean bl2) {
        return bl2 ? Bits.getLongB(l2) : Bits.getLongL(l2);
    }

    private static byte long7(long l2) {
        return (byte)(l2 >> 56);
    }

    private static byte long6(long l2) {
        return (byte)(l2 >> 48);
    }

    private static byte long5(long l2) {
        return (byte)(l2 >> 40);
    }

    private static byte long4(long l2) {
        return (byte)(l2 >> 32);
    }

    private static byte long3(long l2) {
        return (byte)(l2 >> 24);
    }

    private static byte long2(long l2) {
        return (byte)(l2 >> 16);
    }

    private static byte long1(long l2) {
        return (byte)(l2 >> 8);
    }

    private static byte long0(long l2) {
        return (byte)(l2 >> 0);
    }

    static void putLongL(ByteBuffer byteBuffer, int n2, long l2) {
        byteBuffer._put(n2 + 7, Bits.long7(l2));
        byteBuffer._put(n2 + 6, Bits.long6(l2));
        byteBuffer._put(n2 + 5, Bits.long5(l2));
        byteBuffer._put(n2 + 4, Bits.long4(l2));
        byteBuffer._put(n2 + 3, Bits.long3(l2));
        byteBuffer._put(n2 + 2, Bits.long2(l2));
        byteBuffer._put(n2 + 1, Bits.long1(l2));
        byteBuffer._put(n2 + 0, Bits.long0(l2));
    }

    static void putLongL(long l2, long l3) {
        Bits._put(l2 + 7L, Bits.long7(l3));
        Bits._put(l2 + 6L, Bits.long6(l3));
        Bits._put(l2 + 5L, Bits.long5(l3));
        Bits._put(l2 + 4L, Bits.long4(l3));
        Bits._put(l2 + 3L, Bits.long3(l3));
        Bits._put(l2 + 2L, Bits.long2(l3));
        Bits._put(l2 + 1L, Bits.long1(l3));
        Bits._put(l2 + 0L, Bits.long0(l3));
    }

    static void putLongB(ByteBuffer byteBuffer, int n2, long l2) {
        byteBuffer._put(n2 + 0, Bits.long7(l2));
        byteBuffer._put(n2 + 1, Bits.long6(l2));
        byteBuffer._put(n2 + 2, Bits.long5(l2));
        byteBuffer._put(n2 + 3, Bits.long4(l2));
        byteBuffer._put(n2 + 4, Bits.long3(l2));
        byteBuffer._put(n2 + 5, Bits.long2(l2));
        byteBuffer._put(n2 + 6, Bits.long1(l2));
        byteBuffer._put(n2 + 7, Bits.long0(l2));
    }

    static void putLongB(long l2, long l3) {
        Bits._put(l2 + 0L, Bits.long7(l3));
        Bits._put(l2 + 1L, Bits.long6(l3));
        Bits._put(l2 + 2L, Bits.long5(l3));
        Bits._put(l2 + 3L, Bits.long4(l3));
        Bits._put(l2 + 4L, Bits.long3(l3));
        Bits._put(l2 + 5L, Bits.long2(l3));
        Bits._put(l2 + 6L, Bits.long1(l3));
        Bits._put(l2 + 7L, Bits.long0(l3));
    }

    static void putLong(ByteBuffer byteBuffer, int n2, long l2, boolean bl2) {
        if (bl2) {
            Bits.putLongB(byteBuffer, n2, l2);
        } else {
            Bits.putLongL(byteBuffer, n2, l2);
        }
    }

    static void putLong(long l2, long l3, boolean bl2) {
        if (bl2) {
            Bits.putLongB(l2, l3);
        } else {
            Bits.putLongL(l2, l3);
        }
    }

    static float getFloatL(ByteBuffer byteBuffer, int n2) {
        return Float.intBitsToFloat(Bits.getIntL(byteBuffer, n2));
    }

    static float getFloatL(long l2) {
        return Float.intBitsToFloat(Bits.getIntL(l2));
    }

    static float getFloatB(ByteBuffer byteBuffer, int n2) {
        return Float.intBitsToFloat(Bits.getIntB(byteBuffer, n2));
    }

    static float getFloatB(long l2) {
        return Float.intBitsToFloat(Bits.getIntB(l2));
    }

    static float getFloat(ByteBuffer byteBuffer, int n2, boolean bl2) {
        return bl2 ? Bits.getFloatB(byteBuffer, n2) : Bits.getFloatL(byteBuffer, n2);
    }

    static float getFloat(long l2, boolean bl2) {
        return bl2 ? Bits.getFloatB(l2) : Bits.getFloatL(l2);
    }

    static void putFloatL(ByteBuffer byteBuffer, int n2, float f2) {
        Bits.putIntL(byteBuffer, n2, Float.floatToRawIntBits(f2));
    }

    static void putFloatL(long l2, float f2) {
        Bits.putIntL(l2, Float.floatToRawIntBits(f2));
    }

    static void putFloatB(ByteBuffer byteBuffer, int n2, float f2) {
        Bits.putIntB(byteBuffer, n2, Float.floatToRawIntBits(f2));
    }

    static void putFloatB(long l2, float f2) {
        Bits.putIntB(l2, Float.floatToRawIntBits(f2));
    }

    static void putFloat(ByteBuffer byteBuffer, int n2, float f2, boolean bl2) {
        if (bl2) {
            Bits.putFloatB(byteBuffer, n2, f2);
        } else {
            Bits.putFloatL(byteBuffer, n2, f2);
        }
    }

    static void putFloat(long l2, float f2, boolean bl2) {
        if (bl2) {
            Bits.putFloatB(l2, f2);
        } else {
            Bits.putFloatL(l2, f2);
        }
    }

    static double getDoubleL(ByteBuffer byteBuffer, int n2) {
        return Double.longBitsToDouble(Bits.getLongL(byteBuffer, n2));
    }

    static double getDoubleL(long l2) {
        return Double.longBitsToDouble(Bits.getLongL(l2));
    }

    static double getDoubleB(ByteBuffer byteBuffer, int n2) {
        return Double.longBitsToDouble(Bits.getLongB(byteBuffer, n2));
    }

    static double getDoubleB(long l2) {
        return Double.longBitsToDouble(Bits.getLongB(l2));
    }

    static double getDouble(ByteBuffer byteBuffer, int n2, boolean bl2) {
        return bl2 ? Bits.getDoubleB(byteBuffer, n2) : Bits.getDoubleL(byteBuffer, n2);
    }

    static double getDouble(long l2, boolean bl2) {
        return bl2 ? Bits.getDoubleB(l2) : Bits.getDoubleL(l2);
    }

    static void putDoubleL(ByteBuffer byteBuffer, int n2, double d2) {
        Bits.putLongL(byteBuffer, n2, Double.doubleToRawLongBits(d2));
    }

    static void putDoubleL(long l2, double d2) {
        Bits.putLongL(l2, Double.doubleToRawLongBits(d2));
    }

    static void putDoubleB(ByteBuffer byteBuffer, int n2, double d2) {
        Bits.putLongB(byteBuffer, n2, Double.doubleToRawLongBits(d2));
    }

    static void putDoubleB(long l2, double d2) {
        Bits.putLongB(l2, Double.doubleToRawLongBits(d2));
    }

    static void putDouble(ByteBuffer byteBuffer, int n2, double d2, boolean bl2) {
        if (bl2) {
            Bits.putDoubleB(byteBuffer, n2, d2);
        } else {
            Bits.putDoubleL(byteBuffer, n2, d2);
        }
    }

    static void putDouble(long l2, double d2, boolean bl2) {
        if (bl2) {
            Bits.putDoubleB(l2, d2);
        } else {
            Bits.putDoubleL(l2, d2);
        }
    }

    private static byte _get(long l2) {
        return unsafe.getByte(l2);
    }

    private static void _put(long l2, byte by) {
        unsafe.putByte(l2, by);
    }

    static Unsafe unsafe() {
        return unsafe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ByteOrder byteOrder() {
        if (byteOrder != null) {
            return byteOrder;
        }
        long l2 = unsafe.allocateMemory(8L);
        try {
            unsafe.putLong(l2, 72623859790382856L);
            byte by = unsafe.getByte(l2);
            switch (by) {
                case 1: {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                    break;
                }
                case 8: {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                    break;
                }
                default: {
                    throw new Error("Unknown byte order");
                }
            }
            Object var4_2 = null;
            unsafe.freeMemory(l2);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            unsafe.freeMemory(l2);
            throw throwable;
        }
        return byteOrder;
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Bits.unsafe().pageSize();
        }
        return pageSize;
    }

    static boolean unaligned() {
        if (unalignedKnown) {
            return unaligned;
        }
        GetPropertyAction getPropertyAction = new GetPropertyAction("os.arch");
        String string = (String)AccessController.doPrivileged(getPropertyAction);
        unaligned = string.equals("i386");
        unalignedKnown = true;
        return unaligned;
    }

    static {
        unalignedKnown = false;
    }
}

