/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileSystem;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class Win32FileSystem
extends FileSystem {
    private final char slash = ((String)AccessController.doPrivileged(new GetPropertyAction("file.separator"))).charAt(0);
    private final char altSlash;
    private final char semicolon = ((String)AccessController.doPrivileged(new GetPropertyAction("path.separator"))).charAt(0);
    private static String[] driveDirCache = new String[26];

    public Win32FileSystem() {
        this.altSlash = (char)(this.slash == '\\' ? 47 : 92);
    }

    private boolean isSlash(char c2) {
        return c2 == '\\' || c2 == '/';
    }

    private boolean isLetter(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z';
    }

    private String slashify(String string) {
        if (string.length() > 0 && string.charAt(0) != this.slash) {
            return this.slash + string;
        }
        return string;
    }

    public char getSeparator() {
        return this.slash;
    }

    public char getPathSeparator() {
        return this.semicolon;
    }

    private int normalizePrefix(String string, int n2, StringBuffer stringBuffer) {
        char c2;
        int n3 = 0;
        while (n3 < n2 && this.isSlash(string.charAt(n3))) {
            ++n3;
        }
        if (n2 - n3 >= 2 && this.isLetter(c2 = string.charAt(n3)) && string.charAt(n3 + 1) == ':') {
            stringBuffer.append(c2);
            stringBuffer.append(':');
            n3 += 2;
        } else {
            n3 = 0;
            if (n2 >= 2 && this.isSlash(string.charAt(0)) && this.isSlash(string.charAt(1))) {
                n3 = 1;
                stringBuffer.append(this.slash);
            }
        }
        return n3;
    }

    private String normalize(String string, int n2, int n3) {
        int n4;
        if (n2 == 0) {
            return string;
        }
        if (n3 < 3) {
            n3 = 0;
        }
        char c2 = this.slash;
        StringBuffer stringBuffer = new StringBuffer(n2);
        if (n3 == 0) {
            n4 = this.normalizePrefix(string, n2, stringBuffer);
        } else {
            n4 = n3;
            stringBuffer.append(string.substring(0, n3));
        }
        while (n4 < n2) {
            char c3;
            if (this.isSlash(c3 = string.charAt(n4++))) {
                while (n4 < n2 && this.isSlash(string.charAt(n4))) {
                    ++n4;
                }
                if (n4 == n2) {
                    int n5 = stringBuffer.length();
                    if (n5 == 2 && stringBuffer.charAt(1) == ':') {
                        stringBuffer.append(c2);
                        break;
                    }
                    if (n5 == 0) {
                        stringBuffer.append(c2);
                        break;
                    }
                    if (n5 != 1 || !this.isSlash(stringBuffer.charAt(0))) break;
                    stringBuffer.append(c2);
                    break;
                }
                stringBuffer.append(c2);
                continue;
            }
            stringBuffer.append(c3);
        }
        String string2 = stringBuffer.toString();
        return string2;
    }

    public String normalize(String string) {
        int n2 = string.length();
        char c2 = this.slash;
        char c3 = this.altSlash;
        char c4 = '\u0000';
        int n3 = 0;
        while (n3 < n2) {
            char c5 = string.charAt(n3);
            if (c5 == c3) {
                return this.normalize(string, n2, c4 == c2 ? n3 - 1 : n3);
            }
            if (c5 == c2 && c4 == c2 && n3 > 1) {
                return this.normalize(string, n2, n3 - 1);
            }
            if (c5 == ':' && n3 > 1) {
                return this.normalize(string, n2, 0);
            }
            c4 = c5;
            ++n3;
        }
        if (c4 == c2) {
            return this.normalize(string, n2, n2 - 1);
        }
        return string;
    }

    public int prefixLength(String string) {
        char c2;
        char c3 = this.slash;
        int n2 = string.length();
        if (n2 == 0) {
            return 0;
        }
        char c4 = string.charAt(0);
        char c5 = c2 = n2 > 1 ? string.charAt(1) : (char)'\u0000';
        if (c4 == c3) {
            if (c2 == c3) {
                return 2;
            }
            return 1;
        }
        if (this.isLetter(c4) && c2 == ':') {
            if (n2 > 2 && string.charAt(2) == c3) {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    public String resolve(String string, String string2) {
        String string3;
        char c2 = this.slash;
        int n2 = string.length();
        if (n2 == 0) {
            return string2;
        }
        int n3 = string2.length();
        if (n3 == 0) {
            return string;
        }
        String string4 = string2;
        if (n3 > 1 && string4.charAt(0) == c2) {
            string4 = string4.charAt(1) == c2 ? string4.substring(2) : string4.substring(1);
        }
        if ((string3 = string).charAt(n2 - 1) == c2) {
            string3 = string3.substring(0, n2 - 1);
        }
        return string3 + this.slashify(string4);
    }

    public String getDefaultParent() {
        return "" + this.slash;
    }

    public String fromURIPath(String string) {
        String string2 = string;
        if (string2.length() > 2 && string2.charAt(2) == ':') {
            if ((string2 = string2.substring(1)).length() > 3 && string2.endsWith("/")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
        } else if (string2.length() > 1 && string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public boolean isAbsolute(File file) {
        int n2 = file.getPrefixLength();
        return n2 == 2 && file.getPath().charAt(0) == this.slash || n2 == 3;
    }

    native String getDriveDirectory(int var1);

    private static int driveIndex(char c2) {
        if (c2 >= 'a' && c2 <= 'z') {
            return c2 - 97;
        }
        if (c2 >= 'A' && c2 <= 'Z') {
            return c2 - 65;
        }
        return -1;
    }

    private String getDriveDirectory(char c2) {
        int n2 = Win32FileSystem.driveIndex(c2);
        if (n2 < 0) {
            return null;
        }
        String string = driveDirCache[n2];
        if (string != null) {
            return string;
        }
        Win32FileSystem.driveDirCache[n2] = string = this.getDriveDirectory(n2 + 1);
        return string;
    }

    private String getUserPath() {
        return this.normalize(System.getProperty("user.dir"));
    }

    private String getDrive(String string) {
        int n2 = this.prefixLength(string);
        return n2 == 3 ? string.substring(0, 2) : null;
    }

    public String resolve(File file) {
        String string = file.getPath();
        int n2 = file.getPrefixLength();
        if (n2 == 2 && string.charAt(0) == this.slash) {
            return string;
        }
        if (n2 == 3) {
            return string;
        }
        if (n2 == 0) {
            return this.getUserPath() + this.slashify(string);
        }
        if (n2 == 1) {
            String string2 = this.getUserPath();
            String string3 = this.getDrive(string2);
            if (string3 != null) {
                return string3 + string;
            }
            return string2 + string;
        }
        if (n2 == 2) {
            String string4 = this.getUserPath();
            String string5 = this.getDrive(string4);
            if (string5 != null && string.startsWith(string5)) {
                return string4 + this.slashify(string.substring(2));
            }
            char c2 = string.charAt(0);
            String string6 = this.getDriveDirectory(c2);
            if (string6 != null) {
                String string7 = "" + c2 + ':' + string6 + this.slashify(string.substring(2));
                SecurityManager securityManager = System.getSecurityManager();
                try {
                    if (securityManager != null) {
                        securityManager.checkRead(string7);
                    }
                }
                catch (SecurityException securityException) {
                    throw new SecurityException("Cannot resolve path " + string);
                }
                return string7;
            }
            return c2 + ":" + this.slashify(string.substring(2));
        }
        throw new InternalError("Unresolvable path: " + string);
    }

    public native String canonicalize(String var1) throws IOException;

    public native int getBooleanAttributes(File var1);

    public native boolean checkAccess(File var1, boolean var2);

    public native long getLastModifiedTime(File var1);

    public native long getLength(File var1);

    public native boolean createFileExclusively(String var1) throws IOException;

    public native boolean delete(File var1);

    public synchronized native boolean deleteOnExit(File var1);

    public native String[] list(File var1);

    public native boolean createDirectory(File var1);

    public native boolean rename(File var1, File var2);

    public native boolean setLastModifiedTime(File var1, long var2);

    public native boolean setReadOnly(File var1);

    private boolean access(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead(string);
            }
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static native int listRoots0();

    public File[] listRoots() {
        int n2 = Win32FileSystem.listRoots0();
        int n3 = 0;
        int n4 = 0;
        while (n4 < 26) {
            if ((n2 >> n4 & 1) != 0) {
                if (!this.access((char)(65 + n4) + ":" + this.slash)) {
                    n2 &= ~(1 << n4);
                } else {
                    ++n3;
                }
            }
            ++n4;
        }
        File[] fileArray = new File[n3];
        int n5 = 0;
        char c2 = this.slash;
        int n6 = 0;
        while (n6 < 26) {
            if ((n2 >> n6 & 1) != 0) {
                fileArray[n5++] = new File((char)(65 + n6) + ":" + c2);
            }
            ++n6;
        }
        return fileArray;
    }

    public int compare(File file, File file2) {
        return file.getPath().compareToIgnoreCase(file2.getPath());
    }

    public int hashCode(File file) {
        return file.getPath().toLowerCase().hashCode() ^ 0x12D591;
    }

    private static native void initIDs();

    static {
        Win32FileSystem.initIDs();
    }
}

