/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.module;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

public class Krb5LoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean storeKey = false;
    private boolean doNotPrompt = false;
    private boolean useTicketCache = false;
    private boolean useKeyTab = false;
    private String ticketCacheName = null;
    private String keyTabName = null;
    private String princName = null;
    private boolean useFirstPass = false;
    private boolean tryFirstPass = false;
    private boolean storePass = false;
    private boolean clearPass = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private EncryptionKey encKey;
    private Credentials cred = null;
    private PrincipalName principal = null;
    private KerberosPrincipal kerbClientPrinc = null;
    private KerberosTicket kerbTicket = null;
    private KerberosKey kerbKey = null;
    private StringBuffer krb5PrincName = null;
    private char[] password;
    private static final String NAME = "javax.security.auth.login.name";
    private static final String PWD = "javax.security.auth.login.password";
    static final ResourceBundle rb = ResourceBundle.getBundle("sun.security.util.AuthResources");

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = map;
        this.options = map2;
        this.debug = "true".equalsIgnoreCase((String)map2.get("debug"));
        this.storeKey = "true".equalsIgnoreCase((String)map2.get("storeKey"));
        this.doNotPrompt = "true".equalsIgnoreCase((String)map2.get("doNotPrompt"));
        this.useTicketCache = "true".equalsIgnoreCase((String)map2.get("useTicketCache"));
        this.useKeyTab = "true".equalsIgnoreCase((String)map2.get("useKeyTab"));
        this.ticketCacheName = (String)map2.get("ticketCache");
        this.keyTabName = (String)map2.get("keyTab");
        this.princName = (String)map2.get("principal");
        this.tryFirstPass = "true".equalsIgnoreCase((String)map2.get("tryFirstPass"));
        this.useFirstPass = "true".equalsIgnoreCase((String)map2.get("useFirstPass"));
        this.storePass = "true".equalsIgnoreCase((String)map2.get("storePass"));
        this.clearPass = "true".equalsIgnoreCase((String)map2.get("clearPass"));
        if (this.debug) {
            System.out.print("Debug is  " + this.debug + " storeKey " + this.storeKey + " useTicketCache " + this.useTicketCache + " useKeyTab " + this.useKeyTab + " doNotPrompt " + this.doNotPrompt + " ticketCache is " + this.ticketCacheName + " KeyTab is " + this.keyTabName + " principal is " + this.princName + " tryFirstPass is " + this.tryFirstPass + " useFirstPass is " + this.useFirstPass + " storePass is " + this.storePass + " clearPass is " + this.clearPass + "\n");
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean login() throws LoginException {
        this.validateConfiguration();
        var2_1 = System.getProperty("sun.security.krb5.principal");
        if (var2_1 != null) {
            this.krb5PrincName = new StringBuffer(var2_1);
        } else if (this.princName != null) {
            this.krb5PrincName = new StringBuffer(this.princName);
        }
        if (this.tryFirstPass) {
            try {
                this.attemptAuthentication(true);
                if (this.debug) {
                    System.out.println("\t\t[Krb5LoginModule] authentication succeeded");
                }
                this.succeeded = true;
                this.cleanState();
                return true;
            }
            catch (LoginException var3_2) {
                this.cleanState();
                if (!this.debug) ** GOTO lbl33
                System.out.println("\t\t[Krb5LoginModule] tryFirstPass failed with:" + var3_2.getMessage());
            }
        } else if (this.useFirstPass) {
            try {
                this.attemptAuthentication(true);
                this.succeeded = true;
                this.cleanState();
                return true;
            }
            catch (LoginException var3_3) {
                if (this.debug) {
                    System.out.println("\t\t[Krb5LoginModule] authentication failed \n" + var3_3.getMessage());
                }
                this.succeeded = false;
                this.cleanState();
                throw var3_3;
            }
        }
lbl33:
        // 4 sources

        try {
            this.attemptAuthentication(false);
            this.succeeded = true;
            this.cleanState();
            return true;
        }
        catch (LoginException var3_4) {
            if (this.debug) {
                System.out.println("\t\t[Krb5LoginModule] authentication failed \n" + var3_4.getMessage());
            }
            this.succeeded = false;
            this.cleanState();
            throw var3_4;
        }
    }

    private void attemptAuthentication(boolean bl2) throws LoginException {
        if (this.krb5PrincName != null) {
            try {
                this.principal = new PrincipalName(this.krb5PrincName.toString(), 1);
            }
            catch (KrbException krbException) {
                LoginException loginException = new LoginException(krbException.getMessage());
                loginException.initCause(krbException);
                throw loginException;
            }
        }
        try {
            if (this.useTicketCache) {
                this.cred = Credentials.acquireTGTFromCache(this.principal, this.ticketCacheName);
                if (this.cred != null && this.principal == null) {
                    this.principal = this.cred.getClient();
                }
                if (this.debug) {
                    System.out.println("Principal is " + this.principal);
                    if (this.cred == null) {
                        System.out.println("null credentials from Ticket Cache");
                    }
                }
            }
            if (this.cred == null) {
                if (this.principal == null) {
                    this.promptForName(bl2);
                    this.principal = new PrincipalName(this.krb5PrincName.toString(), 1);
                }
                if (this.useKeyTab) {
                    this.encKey = EncryptionKey.acquireSecretKey(this.principal, this.keyTabName);
                    if (this.debug) {
                        if (this.encKey != null) {
                            System.out.println("principal's key obtained from the keytab");
                        } else {
                            System.out.println("Key for the principal " + this.principal + " not available in " + (this.keyTabName == null ? "default key tab" : this.keyTabName));
                        }
                    }
                }
                if (this.encKey == null) {
                    this.promptForPass(bl2);
                    this.encKey = new EncryptionKey(new String(this.password), this.principal.getSalt());
                }
                if (this.debug) {
                    System.out.println("principal is " + this.principal);
                }
                this.cred = Credentials.acquireTGT(this.principal, this.encKey);
                if (this.cred == null) {
                    throw new LoginException("TGT Can not be obtained from the KDC ");
                }
            }
        }
        catch (KrbException krbException) {
            LoginException loginException = new LoginException(krbException.getMessage());
            loginException.initCause(krbException);
            throw loginException;
        }
        catch (IOException iOException) {
            LoginException loginException = new LoginException(iOException.getMessage());
            loginException.initCause(iOException);
            throw loginException;
        }
    }

    private void promptForName(boolean bl2) throws LoginException {
        this.krb5PrincName = new StringBuffer("");
        if (bl2) {
            this.username = (String)this.sharedState.get(NAME);
            if (this.debug) {
                System.out.println("username from shared state is " + this.username + "\n");
            }
            if (this.username == null) {
                System.out.println("username from shared state is null\n");
                throw new LoginException("Username can not be obtained from sharedstate ");
            }
            if (this.debug) {
                System.out.println("username from shared state is " + this.username + "\n");
            }
            if (this.username != null && this.username.length() > 0) {
                this.krb5PrincName.insert(0, this.username);
                return;
            }
        }
        if (this.doNotPrompt) {
            throw new LoginException("Unable to obtain Princpal Name for authentication ");
        }
        if (this.callbackHandler == null) {
            throw new LoginException("No CallbackHandler available to garner authentication information from the user");
        }
        try {
            String string = System.getProperty("user.name");
            Callback[] callbackArray = new Callback[1];
            MessageFormat messageFormat = new MessageFormat(rb.getString("Kerberos username [[defUsername]]: "));
            Object[] objectArray = new Object[]{string};
            callbackArray[0] = new NameCallback(messageFormat.format(objectArray));
            this.callbackHandler.handle(callbackArray);
            this.username = ((NameCallback)callbackArray[0]).getName();
            if (this.username == null || this.username.length() == 0) {
                this.username = string;
            }
            this.krb5PrincName.insert(0, this.username);
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.getMessage());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException(unsupportedCallbackException.getMessage() + " not available to garner " + " authentication information " + " from the user");
        }
    }

    private void promptForPass(boolean bl2) throws LoginException {
        if (bl2) {
            this.password = (char[])this.sharedState.get(PWD);
            if (this.password == null) {
                if (this.debug) {
                    System.out.println("Password from shared state is null");
                }
                throw new LoginException("Password can not be obtained from sharedstate ");
            }
            if (this.debug) {
                System.out.println("password is " + new String(this.password));
            }
            return;
        }
        if (this.doNotPrompt) {
            throw new LoginException("Unable to obtain password from user\n");
        }
        try {
            Callback[] callbackArray = new Callback[1];
            String string = this.krb5PrincName.toString();
            MessageFormat messageFormat = new MessageFormat(rb.getString("Kerberos password for [username]: "));
            Object[] objectArray = new Object[]{string};
            callbackArray[0] = new PasswordCallback(messageFormat.format(objectArray), false);
            this.callbackHandler.handle(callbackArray);
            char[] cArray = ((PasswordCallback)callbackArray[0]).getPassword();
            if (cArray == null) {
                cArray = new char[]{};
            }
            this.password = new char[cArray.length];
            System.arraycopy(cArray, 0, this.password, 0, cArray.length);
            ((PasswordCallback)callbackArray[0]).clearPassword();
            int n2 = 0;
            while (n2 < cArray.length) {
                cArray[n2] = 32;
                ++n2;
            }
            cArray = null;
            if (this.debug) {
                System.out.println("\t\t[Krb5LoginModule] user entered username: " + this.krb5PrincName);
                System.out.println();
            }
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.getMessage());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException(unsupportedCallbackException.getMessage() + " not available to garner " + " authentication information " + "from the user");
        }
    }

    private void validateConfiguration() throws LoginException {
        if (this.doNotPrompt && !this.useTicketCache && !this.useKeyTab) {
            throw new LoginException("Configuration Error - either doNotPrompt should be  false or useTicketCache/useKeyTab  should be true");
        }
        if (this.ticketCacheName != null && !this.useTicketCache) {
            throw new LoginException("Configuration Error  - useTicketCache should be set to true to use the ticket cache" + this.ticketCacheName);
        }
        if (this.keyTabName != null & !this.useKeyTab) {
            throw new LoginException("Configuration Error - useKeyTab should be set to true to use the keytab" + this.keyTabName);
        }
        if (this.storeKey && this.doNotPrompt && !this.useKeyTab) {
            throw new LoginException("Configuration Error - either doNotPrompt should be set to false or useKeyTab must be set to true for storeKey option");
        }
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        Set set = this.subject.getPrivateCredentials();
        Set set2 = this.subject.getPrincipals();
        this.kerbClientPrinc = new KerberosPrincipal(this.principal.getName());
        if (this.cred == null) {
            this.succeeded = false;
            if (this.debug) {
                System.out.println("Null Client Credentials ");
            }
            throw new LoginException("Null Client Credential");
        }
        EncryptionKey encryptionKey = this.cred.getSessionKey();
        this.kerbTicket = new KerberosTicket(this.cred.getEncoded(), new KerberosPrincipal(this.cred.getClient().getName()), new KerberosPrincipal(this.cred.getServer().getName()), encryptionKey.getBytes(), encryptionKey.getEType(), this.cred.getFlags(), this.cred.getAuthTime(), this.cred.getStartTime(), this.cred.getEndTime(), this.cred.getRenewTill(), this.cred.getClientAddresses());
        if (this.storeKey) {
            if (this.encKey == null) {
                this.succeeded = false;
                throw new LoginException("Null Server Key ");
            }
            Integer n2 = this.encKey.getKeyVersionNumber();
            this.kerbKey = new KerberosKey(this.kerbClientPrinc, this.encKey.getBytes(), this.encKey.getEType(), n2 == null ? 0 : n2);
        }
        if (!set2.contains(set2)) {
            set2.add(this.kerbClientPrinc);
        }
        if (!set.contains(this.kerbTicket)) {
            set.add(this.kerbTicket);
        }
        if (this.storeKey) {
            if (!set.contains(this.kerbKey)) {
                set.add(this.kerbKey);
            }
            this.encKey.destroy();
            this.encKey = null;
            if (this.debug) {
                System.out.println("Added server's key" + this.kerbKey);
                System.out.println("\t\t[Krb5LoginModule] added Krb5Principal  " + this.kerbClientPrinc.toString() + " to Subject");
            }
        }
        this.commitSucceeded = true;
        if (this.debug) {
            System.out.println("Commit Succeeded \n");
        }
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            try {
                if (this.kerbTicket != null) {
                    this.kerbTicket.destroy();
                }
                if (this.kerbKey != null) {
                    this.kerbKey.destroy();
                }
            }
            catch (DestroyFailedException destroyFailedException) {
                throw new LoginException("Destroy Failed on Kerberos Private Credentials");
            }
            this.kerbTicket = null;
            this.kerbKey = null;
            this.kerbClientPrinc = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.kerbClientPrinc);
        this.subject.getPrivateCredentials().remove(this.kerbTicket);
        if (this.storeKey) {
            this.subject.getPrivateCredentials().remove(this.kerbKey);
        }
        try {
            if (this.kerbTicket != null) {
                this.kerbTicket.destroy();
            }
            if (this.kerbKey != null) {
                this.kerbKey.destroy();
            }
        }
        catch (DestroyFailedException destroyFailedException) {
            throw new LoginException("Destroy Failed on Kerberos Private Credentials");
        }
        this.kerbTicket = null;
        this.kerbKey = null;
        this.kerbClientPrinc = null;
        this.succeeded = false;
        this.commitSucceeded = false;
        this.username = null;
        if (this.debug) {
            System.out.println("\t\t[Krb5LoginModule]: logged out Subject");
        }
        return true;
    }

    private void cleanState() {
        if (this.succeeded && this.storePass && !this.sharedState.containsKey(NAME) && !this.sharedState.containsKey(PWD)) {
            this.sharedState.put(NAME, this.username);
            this.sharedState.put(PWD, this.password);
        }
        this.username = null;
        this.password = null;
        if (this.krb5PrincName != null && this.krb5PrincName.length() != 0) {
            this.krb5PrincName.delete(0, this.krb5PrincName.length());
        }
        this.krb5PrincName = null;
        if (this.clearPass) {
            this.sharedState.remove(NAME);
            this.sharedState.remove(PWD);
        }
    }
}

