/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AiffFileFormat;
import com.sun.media.sound.SunFileReader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AiffFileReader
extends SunFileReader {
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.AIFF};

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFormat audioFormat = null;
        AiffFileFormat aiffFileFormat = null;
        int n2 = 8;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.mark(n2);
        n3 = dataInputStream.readInt();
        n4 = dataInputStream.readInt();
        if (n3 != 1179603533) {
            dataInputStream.reset();
            throw new UnsupportedAudioFileException("not an AIFF file");
        }
        if (n4 <= 0) {
            n4 = -1;
            n5 = -1;
        } else {
            n5 = n4 + 8;
        }
        audioFormat = new AudioFormat(-1.0f, -1, -1, true, true);
        aiffFileFormat = new AiffFileFormat(AudioFileFormat.Type.AIFF, n5, audioFormat, -1);
        dataInputStream.reset();
        return aiffFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        DataInputStream dataInputStream = null;
        AudioFileFormat audioFileFormat = null;
        Object var6_6 = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        audioFileFormat = this.getAudioFileFormat(bufferedInputStream);
        dataInputStream = new DataInputStream(bufferedInputStream);
        audioFileFormat = this.getCOMM(dataInputStream, audioFileFormat);
        bufferedInputStream.close();
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        DataInputStream dataInputStream = null;
        AudioFileFormat audioFileFormat = null;
        Object var6_6 = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 4096);
        audioFileFormat = this.getAudioFileFormat(bufferedInputStream);
        dataInputStream = new DataInputStream(bufferedInputStream);
        audioFileFormat = this.getCOMM(dataInputStream, audioFileFormat);
        bufferedInputStream.close();
        return audioFileFormat;
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        DataInputStream dataInputStream = null;
        boolean bl2 = false;
        AudioFileFormat audioFileFormat = null;
        audioFileFormat = this.getAudioFileFormat(inputStream);
        dataInputStream = new DataInputStream(inputStream);
        audioFileFormat = this.getCOMM(dataInputStream, audioFileFormat);
        return new AudioInputStream(dataInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Object var4_4 = null;
        inputStream = uRL.openStream();
        bufferedInputStream = new BufferedInputStream(inputStream, 4096);
        return this.getAudioInputStream(bufferedInputStream);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        Object var4_4 = null;
        fileInputStream = new FileInputStream(file);
        bufferedInputStream = new BufferedInputStream(fileInputStream, 4096);
        return this.getAudioInputStream(bufferedInputStream);
    }

    private AudioFileFormat getCOMM(DataInputStream dataInputStream, AudioFileFormat audioFileFormat) throws UnsupportedAudioFileException, IOException {
        AudioFormat.Encoding encoding = null;
        float f2 = -1.0f;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        float f3 = -1.0f;
        boolean bl2 = true;
        int n5 = 0;
        boolean bl3 = false;
        byte[] byArray = new byte[4];
        int n6 = dataInputStream.readInt();
        n5 += 4;
        int n7 = dataInputStream.readInt();
        n5 += 4;
        int n8 = dataInputStream.read(byArray, 0, 4);
        if (n8 != 4) {
            throw new IOException("Stream read error");
        }
        n5 += 4;
        String string = new String(byArray);
        if (string.startsWith("AIFC")) {
            bl3 = true;
        }
        while (true) {
            int n9;
            int n10 = dataInputStream.readInt();
            byArray[0] = (byte)(n10 >> 24 & 0xFF);
            byArray[1] = (byte)(n10 >> 16 & 0xFF);
            byArray[2] = (byte)(n10 >> 8 & 0xFF);
            byArray[3] = (byte)(n10 & 0xFF);
            string = new String(byArray);
            if (string.startsWith("FVER")) {
                dataInputStream.readLong();
                n5 += 8;
                continue;
            }
            if (string.startsWith("COMM")) {
                n9 = dataInputStream.readInt();
                n5 += 4;
                if (n9 != 18 && n9 != 34) {
                    throw new UnsupportedAudioFileException("Invalid AIFF chunksize");
                }
                n3 = dataInputStream.readShort();
                n5 += 2;
                dataInputStream.readInt();
                n5 += 4;
                n2 = dataInputStream.readShort();
                n5 += 2;
                f2 = (float)this.read_ieee_extended(dataInputStream);
                n5 += 10;
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                if (!bl3) continue;
                dataInputStream.read(byArray, 0, 4);
                n5 += 4;
                string = new String(byArray);
                if (string.startsWith("NONE")) {
                    encoding = AudioFormat.Encoding.PCM_SIGNED;
                    continue;
                }
                if (string.startsWith("ULAW")) {
                    encoding = AudioFormat.Encoding.ULAW;
                    continue;
                }
                if (string.startsWith("ALAW")) {
                    encoding = AudioFormat.Encoding.ALAW;
                    continue;
                }
                throw new UnsupportedAudioFileException("Invalid AIFF encoding");
            }
            if (string.startsWith("SSND")) {
                n9 = dataInputStream.readInt();
                n5 += 4;
                int n11 = dataInputStream.readInt();
                n5 += 4;
                int n12 = dataInputStream.readInt();
                n5 += 4;
                if (n9 < n7) {
                    n7 = n9 - 8;
                    break;
                }
                n7 -= n5;
                break;
            }
            n9 = dataInputStream.readInt();
            n5 += 4;
            n5 += dataInputStream.skipBytes(n9);
        }
        switch (n2) {
            case 8: {
                break;
            }
            case 16: {
                break;
            }
        }
        int n13 = n5;
        n4 = n2 / 8 * n3;
        f3 = f2;
        if (n2 == 8) {
            encoding = AudioFormat.Encoding.PCM_SIGNED;
        }
        AudioFormat audioFormat = new AudioFormat(encoding, f2, n2, n3, n4, f3, true);
        return new AiffFileFormat(AudioFileFormat.Type.AIFF, audioFileFormat.getByteLength(), audioFormat, n7 / n4);
    }

    private void write_ieee_extended(DataOutputStream dataOutputStream, double d2) throws IOException {
        int n2 = 16398;
        double d3 = d2;
        while (d3 < 44000.0) {
            d3 *= 2.0;
            --n2;
        }
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeInt((int)d3 << 16);
        dataOutputStream.writeInt(0);
    }

    private double read_ieee_extended(DataInputStream dataInputStream) throws IOException {
        double d2 = 0.0;
        int n2 = 0;
        long l2 = 0L;
        long l3 = 0L;
        double d3 = 3.4028234663852886E38;
        n2 = dataInputStream.readUnsignedShort();
        long l4 = dataInputStream.readUnsignedShort();
        long l5 = dataInputStream.readUnsignedShort();
        l2 = l4 << 16 | l5;
        l4 = dataInputStream.readUnsignedShort();
        l5 = dataInputStream.readUnsignedShort();
        l3 = l4 << 16 | l5;
        if (n2 == 0 && l2 == 0L && l3 == 0L) {
            d2 = 0.0;
        } else if (n2 == Short.MAX_VALUE) {
            d2 = d3;
        } else {
            n2 -= 16383;
            d2 = (double)l2 * Math.pow(2.0, n2 -= 31);
            d2 += (double)l3 * Math.pow(2.0, n2 -= 32);
        }
        return d2;
    }
}

