/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import sun.plugin.cache.JarCacheViewer;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;
import sun.plugin.usability.DialogFactory;

public class CachePanel
extends ActivatorSubPanel
implements ActionListener {
    JCheckBox enabled = null;
    JTextField location = null;
    JButton choose = null;
    JRadioButton unlimited = null;
    JRadioButton maximum = null;
    JTextField size = null;
    JComboBox units = null;
    JSlider compression = null;
    JButton clear = null;
    JButton view = null;
    private MessageHandler mh = new MessageHandler("jarcache");

    public CachePanel(final ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.enabled = new JCheckBox(this.mh.getMessage("enabled"));
        this.enabled.addActionListener(this);
        jPanel.add(this.enabled);
        jPanel.add(Box.createHorizontalGlue());
        this.view = new JButton(this.mh.getMessage("view"));
        this.view.setMnemonic(86);
        this.view.addActionListener(this);
        jPanel.add(this.view);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.clear = new JButton(this.mh.getMessage("clear"));
        this.clear.setMnemonic(67);
        this.clear.addActionListener(this);
        jPanel.add(this.clear);
        jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        Border border = BorderFactory.createEtchedBorder();
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createTitledBorder(border, this.mh.getMessage("settings"))));
        JLabel jLabel = new JLabel(this.mh.getMessage("location"));
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 3.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.location = new LocationField();
        this.location.setDocument(new LocationDocument());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(5, 0, 5, 2);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.location, gridBagConstraints);
        jPanel2.add(this.location);
        this.choose = new JButton(UIManager.getIcon("FileView.directoryIcon"));
        this.choose.setMnemonic(79);
        this.choose.setMargin(new Insets(0, 2, 0, 2));
        this.choose.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 2, 5, 10);
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.choose, gridBagConstraints);
        jPanel2.add(this.choose);
        jLabel = new JLabel(this.mh.getMessage("size"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.unlimited = new JRadioButton(this.mh.getMessage("unlimited"));
        this.unlimited.addActionListener(this);
        this.unlimited.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagLayout.setConstraints(this.unlimited, gridBagConstraints);
        buttonGroup.add(this.unlimited);
        jPanel2.add(this.unlimited);
        this.maximum = new JRadioButton(this.mh.getMessage("maximum"));
        this.maximum.setMargin(new Insets(0, 0, 0, 0));
        this.maximum.addActionListener(this);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagLayout.setConstraints(this.maximum, gridBagConstraints);
        buttonGroup.add(this.maximum);
        jPanel2.add(this.maximum);
        this.size = new JTextField(7);
        this.size.setDocument(new SizeDocument());
        gridBagConstraints.gridx = -1;
        gridBagLayout.setConstraints(this.size, gridBagConstraints);
        jPanel2.add(this.size);
        String[] stringArray = new String[]{this.mh.getMessage("mb"), this.mh.getMessage("kb"), this.mh.getMessage("bytes")};
        this.units = new JComboBox<String>(stringArray);
        this.units.addActionListener(this);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 2, 10, 10);
        gridBagLayout.setConstraints(this.units, gridBagConstraints);
        jPanel2.add(this.units);
        jLabel = new JLabel(this.mh.getMessage("compression"));
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        this.compression = new JSlider(0, 9, 0);
        this.compression.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() == CachePanel.this.compression) {
                    configurationInfo.setJARCacheCompression(CachePanel.this.compression.getValue());
                }
            }
        });
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>(2);
        hashtable.put(new Integer(0), new JLabel(this.mh.getMessage("no_compression")));
        hashtable.put(new Integer(9), new JLabel(this.mh.getMessage("high_compression")));
        this.compression.setLabelTable(hashtable);
        this.compression.setPaintLabels(true);
        this.compression.setMajorTickSpacing(1);
        this.compression.setPaintTicks(true);
        this.compression.setSnapToTicks(true);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 10);
        gridBagLayout.setConstraints(this.compression, gridBagConstraints);
        jPanel2.add(this.compression);
        this.add(jPanel2);
        this.add(Box.createRigidArea(new Dimension(10, 10)));
        this.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block12: {
            try {
                if (actionEvent.getSource() == this.enabled) {
                    boolean bl = this.enabled.isSelected();
                    this.enableComponents(bl);
                    this.model.setCacheEnabled(bl);
                    break block12;
                }
                if (actionEvent.getSource() == this.unlimited) {
                    this.model.setCacheSize("0");
                    break block12;
                }
                if (actionEvent.getSource() == this.maximum) {
                    this.updateSize();
                    break block12;
                }
                if (actionEvent.getSource() == this.clear) {
                    String string;
                    MessageFormat messageFormat = new MessageFormat(this.mh.getMessage("confirm"));
                    String string2 = this.model.getCacheLocation();
                    String string3 = messageFormat.format(new Object[]{string2});
                    int n = DialogFactory.showConfirmDialog(string3, string = this.mh.getMessage("clear"));
                    if (n == 0) {
                        String string4 = File.separator;
                        this.deleteFiles(new File(string2 + string4 + "jar" + string4 + "1.0"));
                        this.deleteFiles(new File(string2 + string4 + "file" + string4 + "1.0"));
                    }
                    break block12;
                }
                if (actionEvent.getSource() == this.units) {
                    this.maximum.setSelected(true);
                    this.updateSize();
                    break block12;
                }
                if (actionEvent.getSource() == this.choose) {
                    String string;
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(1);
                    jFileChooser.setDialogTitle(this.mh.getMessage("select_title"));
                    jFileChooser.setApproveButtonText(this.mh.getMessage("select"));
                    String string5 = this.mh.getMessage("select_tooltip");
                    jFileChooser.setApproveButtonToolTipText(string5);
                    char c = this.mh.getMessage("select_mnemonic").charAt(0);
                    jFileChooser.setApproveButtonMnemonic(c);
                    File file = new File(this.model.getCacheLocation());
                    jFileChooser.setCurrentDirectory(file);
                    if (jFileChooser.showDialog(this, null) != 0) break block12;
                    try {
                        string = jFileChooser.getSelectedFile().getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string = jFileChooser.getSelectedFile().getPath();
                    }
                    this.model.setCacheLocation(string);
                    this.location.setText(string);
                    break block12;
                }
                if (actionEvent.getSource() == this.view) {
                    new JarCacheViewer(this.model.getCacheLocation());
                }
            }
            catch (Exception exception) {
                DialogFactory.showExceptionDialog(exception);
            }
        }
    }

    private void enableComponents(boolean bl) {
        this.setEnabled(this.location, bl);
        this.setEnabled(this.choose, bl);
        this.setEnabled(this.unlimited, bl);
        this.setEnabled(this.maximum, bl);
        this.setEnabled(this.size, bl);
        this.setEnabled(this.units, bl);
        this.setEnabled(this.compression, bl);
        this.setEnabled(this.clear, bl);
        this.setEnabled(this.view, bl);
    }

    private void setEnabled(JComponent jComponent, boolean bl) {
        jComponent.setEnabled(bl);
        jComponent.repaint();
    }

    private void updateSize() {
        String string = this.size.getText().trim();
        if (string.equals("")) {
            string = "0";
        }
        long l = Long.valueOf(string);
        string = Long.toString(l);
        int n = this.units.getSelectedIndex();
        String[] stringArray = new String[]{"m", "k", ""};
        string = string + stringArray[n];
        this.model.setCacheSize(string);
    }

    void reset() {
        long l;
        Object object;
        boolean bl = this.model.getCacheEnabled();
        this.enabled.setSelected(bl);
        this.enableComponents(bl);
        this.location.setText(this.model.getCacheLocation());
        try {
            object = this.model.getCacheSize().trim();
            int n = 0;
            if (((String)object).endsWith("M") || ((String)object).endsWith("m")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
                n = 0;
            } else if (((String)object).endsWith("K") || ((String)object).endsWith("k")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
                n = 1;
            } else {
                n = 2;
            }
            l = Long.valueOf((String)object);
            if (l == 0L) {
                this.unlimited.setSelected(true);
            } else {
                this.maximum.setSelected(true);
                this.units.setSelectedIndex(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            l = 50L;
            this.maximum.setSelected(true);
            this.units.setSelectedIndex(0);
        }
        if (l != 0L) {
            object = NumberFormat.getInstance();
            ((NumberFormat)object).setGroupingUsed(false);
            this.size.setText(((NumberFormat)object).format(l));
        }
        this.compression.setValue(this.model.getJARCacheCompression());
    }

    private void deleteFiles(File file) {
        try {
            if (file.exists() && file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    fileArray[n].delete();
                    ++n;
                }
            }
        }
        catch (Throwable throwable) {
            DialogFactory.showExceptionDialog(throwable);
        }
    }

    private class LocationField
    extends JTextField {
        private LocationField() {
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.width = 10;
            return dimension;
        }
    }

    private class LocationDocument
    extends PlainDocument {
        private LocationDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            super.insertString(n, string, attributeSet);
            CachePanel.this.model.setCacheLocation(CachePanel.this.location.getText());
        }

        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            CachePanel.this.model.setCacheLocation(CachePanel.this.location.getText());
        }
    }

    private class SizeDocument
    extends PlainDocument {
        private SizeDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (this.isNumeric(string)) {
                super.insertString(n, string, attributeSet);
                CachePanel.this.maximum.setSelected(true);
                CachePanel.this.updateSize();
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public void remove(int n, int n2) throws BadLocationException {
            super.remove(n, n2);
            CachePanel.this.maximum.setSelected(true);
            CachePanel.this.updateSize();
        }

        private boolean isNumeric(String string) {
            try {
                Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }
    }
}

