/*
 * Author: Steven Ludtke, 04/10/2003 (sludtke@bcm.edu)
 * Copyright (c) 2000-2006 Baylor College of Medicine
 * 
 * This software is issued under a joint BSD/GNU license. You may use the
 * source code in this file under either license. However, note that the
 * complete EMAN2 and SPARX software packages have some GPL dependencies,
 * so you are responsible for compliance with the licenses of these packages
 * if you opt to use BSD licensing. The warranty disclaimer below holds
 * in either instance.
 * 
 * This complete copyright notice must be included in any revised version of the
 * source code. Additional authorship citations may be added, but existing
 * author citations must be preserved.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * */

#include "emdata.h"
#include "testutil.h"
#include <cmath>

using namespace EMAN;

void rotate(EMData * image, float alt, float phi, const char * imagename)
{
	char outfile[128];
	
	float f = (float)M_PI / 180;
	string imagefile = TestUtil::get_debug_image(imagename);
	image->read_image(imagefile, 0, false, 0, true);
	image->rotate(alt*f, 0, phi*f);
	
	sprintf(outfile, "%s_%d_%d.mrc", imagename, (int)alt, (int)phi);
	image->write_image(outfile, 0, EMUtil::IMAGE_MRC);
}

void test_rotate(EMData * image, const char * imagename)
{
	rotate(image, 0, 45, imagename);
#if 1
	rotate(image, 0, 90, imagename);
	rotate(image, 0, 180, imagename);
	
	rotate(image, 45, 0, imagename);
	rotate(image, 90, 0, imagename);
	rotate(image, 180, 0, imagename);
#endif
}


int main()
{
	EMData *image = new EMData();

	//test_rotate(image, "lattice.mrc");
	//test_rotate(image, "3d.mrc");
	test_rotate(image, "3d99.hed");
	if( image )
	{
		delete image;
		image = 0;
	}

	return 0;
}
