/**
 * $Id$
 */

/*
 * Author: Steven Ludtke, 04/10/2003 (sludtke@bcm.edu)
 * Copyright (c) 2000-2006 Baylor College of Medicine
 * 
 * This software is issued under a joint BSD/GNU license. You may use the
 * source code in this file under either license. However, note that the
 * complete EMAN2 and SPARX software packages have some GPL dependencies,
 * so you are responsible for compliance with the licenses of these packages
 * if you opt to use BSD licensing. The warranty disclaimer below holds
 * in either instance.
 * 
 * This complete copyright notice must be included in any revised version of the
 * source code. Additional authorship citations may be added, but existing
 * author citations must be preserved.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * */

#include "interp.h"
#include "util.h"

using namespace EMAN;

float Interp::HYPERGEOM[] = {
	-0.8897845446054171f, -0.889783548398795f, -0.8897805597844328f,
	-0.889775578778844f, -0.8897686054095494f, -0.8897596397150786f,
	-0.8897486817449696f, -0.8897357315597666f, -0.8897207892310222f,
	-0.8897038548412945f, -0.8896849284841485f, -0.8896640102641528f,
	-0.8896411002968815f, -0.8896161987089111f, -0.8895893056378213f,
	-0.889560421232192f, -0.8895295456516038f, -0.8894966790666359f,
	-0.8894618216588641f, -0.8894249736208614f, -0.8893861351561943f,
	-0.889345306479422f, -0.8893024878160955f, -0.889257679402754f,
	-0.8892108814869246f, -0.8891620943271199f, -0.8891113181928352f,
	-0.8890585533645475f, -0.8890038001337122f, -0.8889470588027618f,
	-0.8888883296851027f, -0.8888276131051123f, -0.8887649093981378f,
	-0.8887002189104929f, -0.8886335419994543f, -0.8885648790332595f,
	-0.8884942303911046f, -0.8884215964631385f, -0.8883469776504647f,
	-0.8882703743651319f, -0.8881917870301366f, -0.8881112160794158f,
	-0.8880286619578445f, -0.887944125121233f, -0.8878576060363231f,
	-0.8877691051807827f, -0.8876786230432045f, -0.8875861601231001f,
	-0.8874917169308968f, -0.8873952939879339f, -0.8872968918264575f,
	-0.8871965109896173f, -0.8870941520314616f, -0.8869898155169336f,
	-0.8868835020218648f, -0.8867752121329742f, -0.8866649464478598f,
	-0.8865527055749959f, -0.8864384901337276f, -0.8863223007542655f,
	-0.8862041380776831f, -0.8860840027559074f, -0.885961895451717f,
	-0.8858378168387362f, -0.8857117676014288f, -0.8855837484350931f,
	-0.8854537600458563f, -0.8853218031506694f, -0.8851878784773001f,
	-0.8850519867643289f, -0.8849141287611409f, -0.8847743052279227f,
	-0.8846325169356532f, -0.8844887646660996f, -0.8843430492118111f,
	-0.8841953713761103f, -0.8840457319730905f, -0.8838941318276059f,
	-0.8837405717752664f, -0.8835850526624312f, -0.8834275753462017f,
	-0.8832681406944145f, -0.8831067495856339f, -0.8829434029091469f,
	-0.8827781015649541f, -0.8826108464637631f, -0.8824416385269811f,
	-0.8822704786867088f, -0.8820973678857313f, -0.8819223070775116f,
	-0.8817452972261815f, -0.8815663393065364f, -0.8813854343040262f,
	-0.8812025832147456f, -0.8810177870454303f, -0.8808310468134456f,
	-0.880642363546779f, -0.8804517382840328f, -0.8802591720744153f,
	-0.8800646659777326f, -0.8798682210643793f, -0.8796698384153321f,
	-0.8794695191221382f, -0.8792672642869096f, -0.8790630750223121f,
	-0.8788569524515574f, -0.8786488977083941f, -0.8784389119370985f,
	-0.8782269962924658f, -0.8780131519398f, -0.8777973800549062f,
	-0.8775796818240795f, -0.8773600584440966f, -0.8771385111222057f,
	-0.8769150410761184f, -0.8766896495339974f, -0.8764623377344491f,
	-0.8762331069265123f, -0.8760019583696486f, -0.8757688933337329f,
	-0.8755339130990423f, -0.8752970189562477f, -0.8750582122064011f,
	-0.8748174941609271f, -0.8745748661416113f, -0.8743303294805913f,
	-0.8740838855203442f, -0.8738355356136777f, -0.8735852811237169f,
	-0.8733331234238971f, -0.8730790638979494f, -0.872823103939892f,
	-0.8725652449540179f, -0.8723054883548835f, -0.8720438355672985f,
	-0.8717802880263144f, -0.8715148471772117f, -0.8712475144754904f,
	-0.8709782913868567f, -0.8707071793872124f, -0.870434179962643f,
	-0.8701592946094054f, -0.8698825248339165f, -0.8696038721527417f,
	-0.8693233380925812f, -0.86904092419026f, -0.8687566319927134f,
	-0.8684704630569772f, -0.8681824189501735f, -0.8678925012494989f,
	-0.8676007115422116f, -0.8673070514256204f, -0.8670115225070688f,
	-0.8667141264039257f, -0.8664148647435702f, -0.8661137391633804f,
	-0.8658107513107189f, -0.8655059028429212f, -0.86519919542728f,
	-0.8648906307410355f, -0.8645802104713601f, -0.8642679363153444f,
	-0.8639538099799855f, -0.8636378331821713f, -0.8633200076486703f,
	-0.8630003351161132f, -0.8626788173309844f, -0.862355456049603f,
	-0.8620302530381128f, -0.8617032100724669f, -0.8613743289384126f,
	-0.8610436114314799f, -0.8607110593569636f, -0.8603766745299131f,
	-0.8600404587751143f, -0.8597024139270775f, -0.8593625418300232f,
	-0.8590208443378648f, -0.858677323314197f, -0.8583319806322787f,
	-0.8579848181750202f, -0.8576358378349663f, -0.8572850415142831f,
	-0.856932431124742f, -0.8565780085877047f, -0.8562217758341081f,
	-0.855863734804449f, -0.8555038874487683f, -0.8551422357266373f,
	-0.85477878160714f, -0.8544135270688588f, -0.8540464740998586f,
	-0.853677624697671f, -0.8533069808692792f, -0.8529345446311003f,
	-0.8525603180089722f, -0.8521843030381347f, -0.851806501763216f,
	-0.8514269162382147f, -0.8510455485264841f, -0.8506624007007166f,
	-0.8502774748429263f, -0.8498907730444337f, -0.8495022974058477f,
	-0.8491120500370506f, -0.8487200330571813f, -0.8483262485946172f,
	-0.8479306987869586f, -0.8475333857810118f, -0.8471343117327716f,
	-0.8467334788074047f, -0.8463308891792333f, -0.8459265450317163f,
	-0.8455204485574341f, -0.8451126019580694f, -0.8447030074443913f,
	-0.8442916672362377f, -0.8438785835624969f, -0.8434637586610909f,
	-0.8430471947789575f, -0.8426288941720338f, -0.842208859105235f,
	-0.8417870918524418f, -0.841363594696477f, -0.8409383699290927f,
	-0.8405114198509474f, -0.8400827467715927f, -0.8396523530094508f,
	-0.839220240891799f, -0.8387864127547512f, -0.8383508709432387f,
	-0.8379136178109916f, -0.8374746557205218f, -0.8370339870431022f,
	-0.836591614158751f, -0.8361475394562098f, -0.8357017653329277f,
	-0.835254294195041f, -0.8348051284573536f, -0.8343542705433202f,
	-0.8339017228850259f, -0.8334474879231674f, -0.8329915681070328f,
	-0.8325339658944855f, -0.8320746837519411f, -0.8316137241543506f,
	-0.83115108958518f, -0.8306867825363914f, -0.8302208055084232f,
	-0.8297531610101705f, -0.8292838515589654f, -0.8288128796805576f,
	-0.8283402479090945f, -0.8278659587871006f, -0.8273900148654597f,
	-0.8269124187033924f, -0.8264331728684375f, -0.8259522799364322f,
	-0.8254697424914914f, -0.8249855631259864f, -0.8244997444405278f,
	-0.8240122890439421f, -0.8235231995532517f, -0.8230324785936568f,
	-0.8225401287985121f, -0.8220461528093087f, -0.8215505532756505f,
	-0.8210533328552365f, -0.8205544942138393f, -0.8200540400252819f,
	-0.8195519729714211f, -0.8190482957421229f, -0.8185430110352427f,
	-0.8180361215566058f, -0.8175276300199833f, -0.8170175391470742f,
	-0.8165058516674825f, -0.8159925703186949f, -0.815477697846062f,
	-0.8149612370027751f, -0.8144431905498452f, -0.813923561256082f,
	-0.8134023518980713f, -0.8128795652601555f, -0.8123552041344089f,
	-0.8118292713206189f, -0.8113017696262621f, -0.8107727018664839f,
	-0.8102420708640764f, -0.8097098794494547f, -0.8091761304606382f,
	-0.8086408267432256f, -0.8081039711503747f, -0.807565566542779f,
	-0.8070256157886461f, -0.8064841217636756f, -0.8059410873510362f,
	-0.8053965154413441f, -0.8048504089326405f, -0.8043027707303673f,
	-0.8037536037473486f, -0.8032029109037637f, -0.8026506951271271f,
	-0.802096959352265f, -0.8015417065212934f, -0.800984939583594f,
	-0.800426661495792f, -0.7998668752217343f, -0.7993055837324641f,
	-0.7987427900062009f, -0.7981784970283147f, -0.7976127077913048f,
	-0.797045425294776f, -0.7964766525454157f, -0.79590639255697f,
	-0.7953346483502219f, -0.7947614229529651f, -0.7941867193999843f,
	-0.79361054073303f, -0.793032890000793f, -0.7924537702588855f,
	-0.7918731845698133f, -0.7912911360029538f, -0.7907076276345338f,
	-0.7901226625476033f, -0.7895362438320129f, -0.7889483745843897f,
	-0.7883590579081145f, -0.7877682969132965f, -0.7871760947167503f,
	-0.7865824544419716f, -0.7859873792191123f, -0.7853908721849589f,
	-0.784792936482905f, -0.7841935752629304f, -0.7835927916815753f,
	-0.7829905889019145f, -0.7823869700935372f, -0.7817819384325181f,
	-0.7811754971013968f, -0.7805676492891508f, -0.7799583981911722f,
	-0.779347747009243f, -0.7787356989515105f, -0.7781222572324628f,
	-0.7775074250729043f, -0.77689120569993f, -0.7762736023469026f,
	-0.7756546182534264f, -0.7750342566653218f, -0.7744125208346036f,
	-0.7737894140194523f, -0.7731649394841912f, -0.7725391004992618f,
	-0.7719119003411972f, -0.771283342292599f, -0.7706534296421097f,
	-0.7700221656843909f, -0.7693895537200951f, -0.7687555970558421f,
	-0.768120299004193f, -0.7674836628836265f, -0.7668456920185104f,
	-0.7662063897390803f, -0.7655657593814106f, -0.7649238042873914f,
	-0.7642805278047028f, -0.7636359332867872f, -0.762990024092827f,
	-0.7623428035877165f, -0.7616942751420381f, -0.7610444421320351f,
	-0.7603933079395869f, -0.759740875952183f, -0.7590871495628979f,
	-0.7584321321703644f, -0.7577758271787483f, -0.7571182379977221f,
	-0.7564593680424394f, -0.7557992207335098f, -0.7551377994969708f,
	-0.7544751077642648f, -0.7538111489722099f, -0.7531459265629764f,
	-0.7524794439840592f, -0.7518117046882526f, -0.7511427121336231f,
	-0.7504724697834843f, -0.7498009811063707f, -0.7491282495760096f,
	-0.7484542786712977f, -0.7477790718762723f, -0.7471026326800869f,
	-0.7464249645769824f, -0.7457460710662643f, -0.7450659556522722f,
	-0.7443846218443566f, -0.7437020731568502f, -0.7430183131090434f,
	-0.7423333452251562f, -0.741647173034311f, -0.7409598000705097f,
	-0.7402712298726016f, -0.7395814659842612f, -0.7388905119539601f,
	-0.7381983713349395f, -0.7375050476851839f, -0.7368105445673954f,
	-0.7361148655489654f, -0.7354180142019483f, -0.734719994103035f,
	-0.7340208088335268f, -0.7333204619793054f, -0.7326189571308095f,
	-0.7319162978830064f, -0.731212487835365f, -0.7305075305918284f,
	-0.7298014297607878f, -0.7290941889550548f, -0.7283858117918347f,
	-0.7276763018926998f, -0.7269656628835605f, -0.7262538983946403f,
	-0.7255410120604476f, -0.724827007519749f, -0.7241118884155413f,
	-0.7233956583950246f, -0.7226783211095757f, -0.7219598802147199f,
	-0.721240339370105f, -0.720519702239472f, -0.71979797249063f,
	-0.719075153795427f, -0.7183512498297234f, -0.7176262642733646f,
	-0.7169002008101541f, -0.716173063127824f, -0.7154448549180109f,
	-0.7147155798762248f, -0.7139852417018248f, -0.7132538440979891f,
	-0.7125213907716889f, -0.7117878854336609f, -0.7110533317983788f,
	-0.7103177335840268f, -0.7095810945124707f, -0.7088434183092319f,
	-0.7081047087034586f, -0.7073649694278985f, -0.7066242042188707f,
	-0.70588241681624f, -0.7051396109633857f, -0.7043957904071771f,
	-0.7036509588979442f, -0.7029051201894514f, -0.7021582780388666f,
	-0.7014104362067371f, -0.7006615984569602f, -0.6999117685567551f,
	-0.699160950276635f, -0.6984091473903807f, -0.6976563636750114f,
	-0.6969026029107572f, -0.6961478688810318f, -0.6953921653724036f,
	-0.6946354961745687f, -0.6938778650803223f, -0.693119275885532f,
	-0.6923597323891085f, -0.6915992383929784f, -0.6908377977020565f,
	-0.6900754141242165f, -0.689312091470266f, -0.6885478335539146f,
	-0.6877826441917488f, -0.6870165272032028f, -0.686249486410532f,
	-0.685481525638782f, -0.6847126487157641f, -0.6839428594720251f,
	-0.6831721617408188f, -0.6824005593580811f, -0.681628056162398f,
	-0.68085465599498f, -0.6800803626996342f, -0.6793051801227343f,
	-0.6785291121131951f, -0.6777521625224409f, -0.6769743352043821f,
	-0.6761956340153835f, -0.6754160628142367f, -0.6746356254621337f,
	-0.6738543258226375f, -0.6730721677616538f, -0.6722891551474033f,
	-0.6715052918503944f, -0.6707205817433936f, -0.6699350287013984f,
	-0.6691486366016091f, -0.6683614093233999f, -0.6675733507482916f,
	-0.6667844647599229f, -0.6659947552440237f, -0.6652042260883844f,
	-0.6644128811828301f, -0.6636207244191913f, -0.6628277596912759f,
	-0.6620339908948416f, -0.6612394219275669f, -0.6604440566890239f,
	-0.6596478990806496f, -0.6588509530057169f, -0.6580532223693089f,
	-0.6572547110782882f, -0.6564554230412706f, -0.6556553621685955f,
	-0.6548545323722992f, -0.6540529375660851f, -0.6532505816652967f,
	-0.6524474685868909f, -0.6516436022494058f, -0.6508389865729371f,
	-0.6500336254791063f, -0.6492275228910353f, -0.6484206827333163f,
	-0.6476131089319856f, -0.6468048054144932f, -0.6459957761096775f,
	-0.645186024947735f, -0.6443755558601922f, -0.6435643727798785f,
	-0.6427524796408981f, -0.6419398803786021f, -0.641126578929559f,
	-0.6403125792315281f, -0.6394978852234309f, -0.6386825008453231f,
	-0.6378664300383658f, -0.6370496767448001f, -0.6362322449079149f,
	-0.6354141384720222f, -0.6345953613824287f, -0.6337759175854059f,
	-0.6329558110281638f, -0.6321350456588223f, -0.6313136254263849f,
	-0.630491554280706f, -0.6296688361724685f, -0.6288454750531534f,
	-0.6280214748750109f, -0.6271968395910343f, -0.6263715731549305f,
	-0.6255456795210932f, -0.6247191626445751f, -0.6238920264810589f,
	-0.62306427498683f, -0.6222359121187494f, -0.621406941834225f,
	-0.6205773680911828f, -0.6197471948480411f, -0.6189164260636824f,
	-0.6180850656974229f, -0.6172531177089888f, -0.6164205860584854f,
	-0.6155874747063706f, -0.614753787613427f, -0.6139195287407337f,
	-0.6130847020496396f, -0.6122493115017344f, -0.6114133610588221f,
	-0.6105768546828924f, -0.6097397963360936f, -0.6089021899807046f,
	-0.6080640395791072f, -0.6072253490937602f, -0.6063861224871676f,
	-0.6055463637218558f, -0.6047060767603439f, -0.6038652655651146f,
	-0.6030239340985897f, -0.6021820863231008f, -0.6013397262008619f,
	-0.600496857693942f, -0.5996534847642386f, -0.5988096113734485f,
	-0.5979652414830418f, -0.5971203790542327f, -0.5962750280479567f,
	-0.5954291924248364f, -0.594582876145159f, -0.5937360831688481f,
	-0.5928888174554355f, -0.5920410829640343f, -0.5911928836533116f,
	-0.5903442234814619f, -0.5894951064061782f, -0.5886455363846275f,
	-0.5877955173734203f, -0.5869450533285859f, -0.586094148205545f,
	-0.5852428059590812f, -0.5843910305433157f, -0.5835388259116776f,
	-0.5826861960168808f, -0.5818331448108933f, -0.5809796762449119f,
	-0.580125794269335f, -0.5792715028337356f, -0.5784168058868344f,
	-0.5775617073764718f, -0.5767062112495841f, -0.5758503214521731f,
	-0.5749940419292808f, -0.5741373766249631f, -0.5732803294822625f,
	-0.5724229044431801f, -0.571565105448652f, -0.5707069364385186f,
	-0.5698484013515017f, -0.5689895041251753f, -0.5681302486959394f,
	-0.5672706389989951f, -0.5664106789683147f, -0.5655503725366197f,
	-0.5646897236353495f, -0.5638287361946387f, -0.562967414143288f,
	-0.5621057614087396f, -0.5612437819170499f, -0.5603814795928627f,
	-0.5595188583593851f, -0.5586559221383573f, -0.5577926748500302f,
	-0.5569291204131367f, -0.5560652627448666f, -0.5552011057608401f,
	-0.5543366533750812f, -0.5534719094999922f, -0.5526068780463269f,
	-0.5517415629231663f, -0.5508759680378902f, -0.5500100972961514f,
	-0.5491439546018524f, -0.5482775438571165f, -0.5474108689622632f,
	-0.5465439338157819f, -0.5456767423143067f, -0.5448092983525896f,
	-0.5439416058234752f, -0.5430736686178756f, -0.5422054906247439f,
	-0.5413370757310483f, -0.540468427821747f, -0.539599550779762f,
	-0.5387304484859553f, -0.5378611248191007f, -0.5369915836558593f,
	-0.5361218288707563f, -0.5352518643361512f, -0.5343816939222168f,
	-0.5335113214969092f, -0.5326407509259478f, -0.5317699860727858f,
	-0.5308990307985865f, -0.530027888962198f, -0.5291565644201282f,
	-0.5282850610265192f, -0.527413382633123f, -0.5265415330892745f,
	-0.5256695162418685f, -0.5247973359353347f, -0.5239249960116108f,
	-0.5230525003101201f, -0.5221798526677434f, -0.5213070569187983f,
	-0.5204341168950098f, -0.51956103642549f, -0.5186878193367094f,
	-0.5178144694524759f, -0.5169409905939057f, -0.5160673865794047f,
	-0.5151936612246372f, -0.5143198183425068f, -0.5134458617431287f,
	-0.5125717952338062f, -0.5116976226190077f, -0.5108233477003394f,
	-0.5099489742765229f, -0.5090745061433718f, -0.5081999470937649f,
	-0.5073253009176239f, -0.5064505714018888f, -0.5055757623304932f,
	-0.5047008774843409f, -0.5038259206412818f, -0.5029508955760872f,
	-0.5020758060604273f, -0.5012006558628447f, -0.500325448748735f,
	-0.4994501884803169f, -0.4985748788166142f, -0.4976995235134284f,
	-0.4968241263233163f, -0.4959486909955667f, -0.4950732212761752f,
	-0.4941977209078237f, -0.4933221936298527f, -0.4924466431782415f,
	-0.4915710732855835f, -0.4906954876810615f, -0.4898198900904273f,
	-0.488944284235974f, -0.4880686738365186f, -0.487193062607373f,
	-0.4863174542603251f, -0.4854418525036134f, -0.484566261041905f,
	-0.4836906835762718f, -0.4828151238041677f, -0.4819395854194061f,
	-0.4810640721121385f, -0.4801885875688273f, -0.4793131354722276f,
	-0.4784377195013618f, -0.4775623433314989f, -0.476687010634129f,
	-0.4758117250769442f, -0.4749364903238135f, -0.4740613100347608f,
	-0.4731861878659433f, -0.4723111274696285f, -0.4714361324941727f,
	-0.4705612065839964f, -0.4696863533795657f, -0.4688115765173662f,
	-0.4679368796298839f, -0.4670622663455814f, -0.4661877402888769f,
	-0.4653133050801211f, -0.4644389643355763f, -0.4635647216673945f,
	-0.4626905806835944f, -0.4618165449880414f, -0.4609426181804234f,
	-0.460068803856232f, -0.4591951056067382f, -0.4583215270189739f,
	-0.4574480716757066f, -0.4565747431554201f, -0.4557015450322948f,
	-0.4548284808761831f, -0.4539555542525879f, -0.4530827687226448f,
	-0.4522101278430988f, -0.4513376351662833f, -0.4504652942400968f,
	-0.4495931086079865f, -0.448721081808924f, -0.4478492173773855f,
	-0.4469775188433291f, -0.4461059897321768f, -0.4452346335647925f,
	-0.44436345385746f, -0.4434924541218634f, -0.4426216378650687f,
	-0.4417510085894988f, -0.4408805697929153f, -0.440010324968399f,
	-0.4391402776043285f, -0.4382704311843593f, -0.437400789187404f,
	-0.4365313550876123f, -0.4356621323543508f, -0.4347931244521825f,
	-0.4339243348408476f, -0.4330557669752415f, -0.432187424305397f,
	-0.4313193102764641f, -0.4304514283286891f, -0.429583781897395f,
	-0.4287163744129629f, -0.4278492093008111f, -0.4269822899813768f,
	-0.4261156198700942f, -0.4252492023773772f, -0.4243830409086002f,
	-0.4235171388640768f, -0.4226514996390408f, -0.4217861266236297f,
	-0.4209210232028611f, -0.4200561927566173f, -0.4191916386596249f,
	-0.4183273642814339f, -0.4174633729864027f, -0.4165996681336751f,
	-0.4157362530771637f, -0.4148731311655318f, -0.4140103057421718f,
	-0.4131477801451889f, -0.4122855577073837f, -0.4114236417562281f,
	-0.4105620356138532f, -0.4097007425970277f, -0.4088397660171389f,
	-0.4079791091801762f, -0.4071187753867122f, -0.406258767931884f,
	-0.4053990901053753f, -0.4045397451913979f, -0.4036807364686771f,
	-0.4028220672104264f, -0.4019637406843374f, -0.4011057601525567f,
	-0.4002481288716717f, -0.3993908500926901f, -0.3985339270610232f,
	-0.3976773630164689f, -0.3968211611931944f, -0.3959653248197167f,
	-0.3951098571188874f, -0.3942547613078742f, -0.3934000405981439f,
	-0.3925456981954467f, -0.3916917372997944f, -0.3908381611054489f,
	-0.3899849728009028f, -0.3891321755688601f, -0.3882797725862248f,
	-0.3874277670240776f, -0.3865761620476646f, -0.3857249608163772f,
	-0.3848741664837355f, -0.3840237821973761f, -0.3831738110990283f,
	-0.3823242563245041f, -0.3814751210036782f, -0.3806264082604719f,
	-0.3797781212128403f, -0.3789302629727503f, -0.378082836646169f,
	-0.3772358453330465f, -0.3763892921272983f, -0.3755431801167914f,
	-0.3746975123833281f, -0.3738522920026286f, -0.3730075220443167f,
	-0.3721632055719028f, -0.3713193456427712f, -0.3704759453081607f,
	-0.3696330076131515f, -0.3687905355966489f, -0.3679485322913676f,
	-0.3671070007238187f, -0.3662659439142912f, -0.3654253648768381f,
	-0.3645852666192631f, -0.3637456521431019f, -0.3629065244436109f,
	-0.3620678865097499f, -0.3612297413241674f, -0.3603920918631875f,
	-0.3595549410967937f, -0.3587182919886139f, -0.3578821474959083f,
	-0.357046510569551f, -0.3562113841540185f, -0.3553767711873748f,
	-0.3545426746012564f, -0.3537090973208585f, -0.3528760422649206f,
	-0.3520435123457115f, -0.3512115104690184f, -0.3503800395341288f,
	-0.3495491024338185f, -0.3487187020543389f, -0.3478888412754007f,
	-0.3470595229701628f, -0.3462307500052169f, -0.3454025252405728f,
	-0.3445748515296495f, -0.3437477317192552f, -0.3429211686495792f,
	-0.342095165154177f, -0.3412697240599568f, -0.3404448481871652f,
	-0.3396205403493759f, -0.338796803353476f, -0.3379736399996523f,
	-0.3371510530813806f, -0.3363290453854096f, -0.3355076196917497f,
	-0.334686778773662f, -0.3338665253976426f, -0.3330468623234128f,
	-0.3322277923039033f, -0.3314093180852457f, -0.3305914424067569f,
	-0.329774168000928f, -0.3289574975934137f, -0.3281414339030161f,
	-0.3273259796416776f, -0.3265111375144638f, -0.3256969102195559f,
	-0.3248833004482356f, -0.3240703108848765f, -0.3232579442069285f,
	-0.3224462030849084f, -0.3216350901823897f, -0.3208246081559872f,
	-0.320014759655348f, -0.3192055473231416f, -0.318396973795044f,
	-0.3175890416997312f, -0.3167817536588646f, -0.3159751122870819f,
	-0.3151691201919846f, -0.3143637799741284f, -0.3135590942270115f,
	-0.3127550655370636f, -0.3119516964836353f, -0.3111489896389871f,
	-0.3103469475682799f, -0.3095455728295628f, -0.3087448679737638f,
	-0.3079448355446791f, -0.3071454780789611f, -0.3063467981061116f,
	-0.3055487981484686f, -0.3047514807211965f, -0.3039548483322774f,
	-0.3031589034824997f, -0.3023636486654494f, -0.3015690863674978f,
	-0.300775219067796f, -0.2999820492382598f, -0.2991895793435649f,
	-0.2983978118411327f, -0.2976067491811273f, -0.2968163938064371f,
	-0.2960267481526734f, -0.2952378146481576f, -0.2944495957139108f,
	-0.2936620937636479f, -0.292875311203764f, -0.2920892504333317f,
	-0.2913039138440866f, -0.2905193038204187f, -0.289735422739367f,
	-0.2889522729706097f, -0.288169856876451f, -0.2873881768118206f,
	-0.286607235124257f, -0.2858270341539055f, -0.2850475762335042f,
	-0.2842688636883803f, -0.2834908988364399f, -0.2827136839881596f,
	-0.2819372214465774f, -0.2811615135072875f, -0.28038656245843f,
	-0.2796123705806838f, -0.2788389401472575f, -0.2780662734238845f,
	-0.2772943726688112f, -0.2765232401327946f, -0.2757528780590883f,
	-0.274983288683442f, -0.2742144742340875f, -0.2734464369317362f,
	-0.2726791789895697f, -0.2719127026132313f, -0.271147010000823f,
	-0.2703821033428936f, -0.2696179848224353f, -0.2688546566148752f,
	-0.2680921208880675f, -0.2673303798022883f, -0.266569435510229f,
	-0.2658092901569897f, -0.2650499458800692f, -0.2642914048093645f,
	-0.2635336690671579f, -0.262776740768116f, -0.2620206220192813f,
	-0.2612653149200647f, -0.2605108215622402f, -0.2597571440299406f,
	-0.2590042843996485f, -0.2582522447401931f, -0.2575010271127415f,
	-0.2567506335707963f, -0.2560010661601861f, -0.2552523269190629f,
	-0.2545044178778947f, -0.2537573410594613f, -0.2530110984788467f,
	-0.252265692143436f, -0.2515211240529093f, -0.2507773961992367f,
	-0.2500345105666716f, -0.2492924691317475f, -0.2485512738632704f,
	-0.2478109267223196f, -0.2470714296622344f, -0.2463327846286162f,
	-0.24559499355932f, -0.2448580583844526f, -0.2441219810263648f,
	-0.243386763399648f, -0.2426524074111309f, -0.2419189149598746f,
	-0.2411862879371653f, -0.2404545282265173f, -0.2397236377036595f,
	-0.2389936182365384f, -0.2382644716853112f, -0.2375361999023402f,
	-0.2368088047321939f, -0.2360822880116375f, -0.2353566515696325f,
	-0.2346318972273329f, -0.233908026798079f, -0.2331850420873975f,
	-0.2324629448929933f, -0.2317417370047523f, -0.231021420204732f,
	-0.2303019962671621f, -0.2295834669584397f, -0.2288658340371247f,
	-0.2281490992539405f, -0.2274332643517689f, -0.2267183310656448f,
	-0.2260043011227572f, -0.2252911762424452f, -0.2245789581361934f,
	-0.2238676485076318f, -0.223157249052531f, -0.2224477614588018f,
	-0.2217391874064911f, -0.2210315285677795f, -0.2203247866069797f,
	-0.2196189631805349f, -0.2189140599370138f, -0.2182100785171132f,
	-0.2175070205536502f, -0.216804887671564f, -0.216103681487914f,
	-0.2154034036118759f, -0.2147040556447419f, -0.2140056391799165f,
	-0.2133081558029181f, -0.2126116070913766f, -0.2119159946150279f,
	-0.2112213199357175f, -0.2105275846073977f, -0.2098347901761246f,
	-0.2091429381800586f, -0.2084520301494623f, -0.2077620676067009f,
	-0.2070730520662382f, -0.2063849850346397f, -0.2056978680105663f,
	-0.2050117024847795f, -0.2043264899401369f, -0.2036422318515906f,
	-0.20295892968619f, -0.2022765849030792f, -0.2015951989534985f,
	-0.2009147732807778f, -0.2002353093203441f, -0.1995568084997172f,
	-0.1988792722385106f, -0.1982027019484282f, -0.1975270990332704f,
	-0.1968524648889267f, -0.1961788009033829f, -0.1955061084567146f,
	-0.1948343889210932f, -0.194163643660782f, -0.193493874032137f,
	-0.1928250813836116f, -0.1921572670557494f, -0.1914904323811919f,
	-0.1908245786846749f, -0.1901597072830296f, -0.1894958194851856f,
	-0.1888329165921709f, -0.1881709998971075f, -0.1875100706852204f,
	-0.1868501302338339f, -0.1861911798123736f, -0.1855332206823672f,
	-0.1848762540974462f, -0.1842202813033457f, -0.1835653035379081f,
	-0.1829113220310818f, -0.1822583380049263f, -0.1816063526736078f,
	-0.1809553672434074f, -0.1803053829127168f, -0.1796564008720449f,
	-0.1790084223040162f, -0.1783614483833744f, -0.1777154802769835f,
	-0.1770705191438284f, -0.1764265661350208f, -0.175783622393796f,
	-0.1751416890555195f, -0.1745007672476879f, -0.1738608580899292f,
	-0.1732219626940074f, -0.1725840821638251f, -0.1719472175954221f,
	-0.1713113700769826f, -0.1706765406888384f, -0.1700427305034626f,
	-0.1694099405854856f, -0.1687781719916865f, -0.168147425771002f,
	-0.1675177029645273f, -0.1668890046055198f, -0.1662613317194014f,
	-0.1656346853237615f, -0.1650090664283612f, -0.1643844760351349f,
	-0.1637609151381955f, -0.163138384723837f, -0.162516885770535f,
	-0.1618964192489558f, -0.1612769861219551f, -0.1606585873445831f,
	-0.1600412238640904f, -0.1594248966199249f, -0.158809606543746f,
	-0.1581953545594187f, -0.1575821415830238f, -0.156969968522856f,
	-0.1563588362794354f, -0.155748745745504f, -0.1551396978060362f,
	-0.1545316933382383f, -0.1539247332115547f, -0.153318818287673f,
	-0.1527139494205262f, -0.152110127456299f, -0.1515073532334307f,
	-0.1509056275826217f, -0.150304951326837f, -0.1497053252813091f,
	-0.1491067502535463f, -0.1485092270433354f, -0.1479127564427469f,
	-0.1473173392361377f, -0.1467229762001609f, -0.1461296681037673f,
	-0.1455374157082101f, -0.1449462197670539f, -0.1443560810261721f,
	-0.1437670002237623f, -0.1431789780903445f, -0.1425920153487687f,
	-0.1420061127142195f, -0.1414212708942217f, -0.1408374905886491f,
	-0.1402547724897249f, -0.13967311728203f, -0.139092525642509f,
	-0.138512998240476f, -0.1379345357376193f, -0.1373571387880068f,
	-0.1367808080380967f, -0.1362055441267346f, -0.13563134768517f,
	-0.1350582193370519f, -0.134486159698447f, -0.1339151693778324f,
	-0.1333452489761133f, -0.132776399086623f, -0.132208620295132f,
	-0.1316419131798511f, -0.1310762783114438f, -0.1305117162530267f,
	-0.1299482275601808f, -0.1293858127809541f, -0.128824472455874f,
	-0.1282642071179445f, -0.1277050172926657f, -0.1271469034980297f,
	-0.1265898662445339f, -0.1260339060351851f, -0.1254790233655074f,
	-0.1249252187235532f, -0.1243724925898981f, -0.1238208454376659f,
	-0.12327027773252f, -0.1227207899326807f, -0.1221723824889306f,
	-0.1216250558446163f, -0.1210788104356625f, -0.1205336466905793f,
	-0.1199895650304632f, -0.1194465658690133f, -0.1189046496125345f,
	-0.1183638166599447f, -0.1178240674027848f, -0.1172854022252238f,
	-0.1167478215040727f, -0.1162113256087835f, -0.1156759149014632f,
	-0.115141589736883f, -0.1146083504624817f, -0.1140761974183766f,
	-0.1135451309373729f, -0.1130151513449684f, -0.1124862589593644f,
	-0.1119584540914775f, -0.1114317370449378f, -0.1109061081161073f,
	-0.1103815675940866f, -0.1098581157607168f, -0.1093357528905973f,
	-0.108814479251089f, -0.108294295102326f, -0.1077752006972179f,
	-0.1072571962814701f, -0.1067402820935812f, -0.1062244583648581f,
	-0.1057097253194254f, -0.1051960831742313f, -0.1046835321390577f,
	-0.1041720724165311f, -0.1036617042021301f, -0.1031524276841966f,
	-0.1026442430439389f, -0.1021371504554511f, -0.1016311500857132f,
	-0.1011262420946061f, -0.1006224266349207f, -0.1001197038523617f,
	-0.09961807388556898f, -0.09911753686611124f, -0.09861809291851075f,
	-0.0981197421602431f, -0.09762248470175283f, -0.09712632064645898f,
	-0.096631250090768f, -0.09613727312408038f, -0.09564438982880751f,
	-0.09515260028037131f, -0.09466190454722189f, -0.09417230269084964f,
	-0.09368379476578425f, -0.09319638081961789f, -0.09271006089300604f,
	-0.0922248350196817f, -0.09174070322646743f, -0.09125766553328373f,
	-0.09077572195315442f, -0.09029487249222789f, -0.08981511714977719f,
	-0.08933645591821859f, -0.08885888878311609f, -0.08838241572319738f,
	-0.08790703671035648f, -0.08743275170967734f, -0.08695956067943066f,
	-0.08648746357109304f, -0.08601646032935938f, -0.08554655089214113f,
	-0.08507773519059735f, -0.08461001314912719f, -0.08414338468539162f,
	-0.08367784971031966f, -0.08321340812812216f, -0.08275005983630201f,
	-0.08228780472566654f, -0.08182664268033112f, -0.08136657357774623f,
	-0.08090759728869256f, -0.08044971367729969f, -0.07999292260106294f,
	-0.07953722391083895f, -0.07908261745087674f, -0.07862910305881198f,
	-0.07817668056569004f, -0.07772534979597534f, -0.07727511056755753f,
	-0.07682596269176666f, -0.07637790597339f, -0.0759309402106747f,
	-0.0754850651953447f, -0.07504028071261448f, -0.07459658654119305f,
	-0.07415398245330839f, -0.07371246821470522f, -0.07327204358466721f,
	-0.07283270831602761f, -0.07239446215517464f, -0.07195730484207141f,
	-0.0715212361102675f, -0.07108625568690252f, -0.07065236329273139f,
	-0.07021955864212348f, -0.06978784144308702f, -0.06935721139727224f,
	-0.06892766819998774f, -0.06849921154021254f, -0.06807184110060893f,
	-0.06764555655753534f, -0.06722035758105349f, -0.06679624383495186f,
	-0.06637321497674841f, -0.06595127065770478f, -0.06553041052284447f,
	-0.06511063421096263f, -0.06469194135463274f, -0.06427433158022877f,
	-0.06385780450793543f, -0.06344235975175527f, -0.06302799691952909f,
	-0.06261471561294484f, -0.0622025154275505f, -0.06179139595277094f,
	-0.06138135677191458f, -0.06097239746219207f, -0.06056451759472425f,
	-0.06015771673456482f, -0.05975199444069811f, -0.05934735026606796f,
	-0.05894378375758169f, -0.05854129445612565f, -0.05813988189657681f,
	-0.05773954560782224f, -0.05734028511276578f, -0.05694209992834187f,
	-0.05654498956553366f, -0.05614895352938242f, -0.05575399131900304f,
	-0.05536010242759603f, -0.05496728634246306f, -0.05457554254501895f,
	-0.05418487051080367f, -0.05379526970950099f, -0.05340673960494957f,
	-0.05301927965514918f, -0.05263288931229181f, -0.05224756802275765f,
	-0.05186331522714171f, -0.05148013036025655f, -0.05109801285115622f,
	-0.05071696212314558f, -0.0503369775937914f, -0.04995805867494373f,
	-0.04958020477274338f, -0.04920341528763572f, -0.04882768961439065f,
	-0.0484530271421133f, -0.04807942725425373f, -0.0477068893286292f,
	-0.0473354127374348f, -0.04696499684725319f, -0.04659564101907509f,
	-0.04622734460831257f, -0.04586010696480968f, -0.04549392743286118f,
	-0.04512880535122221f, -0.04476474005312525f, -0.04440173086629739f,
	-0.04403977711296835f, -0.04367887810988824f, -0.04331903316834662f,
	-0.0429602415941761f, -0.04260250268777499f, -0.04224581574412278f,
	-0.0418901800527891f, -0.04153559489795144f, -0.04118205955840892f,
	-0.04082957330759784f, -0.04047813541360545f, -0.0401277451391846f,
	-0.03977840174177016f, -0.03943010447349148f, -0.03908285258118704f,
	-0.03873664530642129f, -0.03839148188549801f, -0.03804736154947541f,
	-0.03770428352418164f, -0.03736224703022683f, -0.03702125128302435f,
	-0.03668129549279575f, -0.03634237886459601f, -0.03600450059832249f,
	-0.03566765988873088f, -0.03533185592545207f, -0.03499708789300237f,
	-0.03466335497080486f, -0.03433065633320397f, -0.0339989911494718f,
	-0.03366835858383243f, -0.03333875779547579f, -0.03301018793857091f,
	-0.03268264816227661f, -0.03235613761076949f, -0.03203065542324168f,
	-0.03170620073393326f, -0.03138277267213718f, -0.0310603703622152f,
	-0.0307389929236157f, -0.03041863947089051f, -0.03009930911370517f,
	-0.02978100095685753f, -0.02946371410029646f, -0.02914744763912713f,
	-0.02883220066363811f, -0.02851797225930896f, -0.02820476150682793f,
	-0.02789256748210666f, -0.02758138925630015f, -0.02727122589581831f,
	-0.02696207646233572f, -0.02665394001282006f, -0.02634681559954055f,
	-0.02604070227007682f, -0.02573559906734956f, -0.02543150502962321f,
	-0.02512841919053121f, -0.02482634057907961f, -0.02452526821967682f,
	-0.02422520113213932f, -0.02392613833170642f, -0.02362807882906903f,
	-0.02333102163036837f, -0.02303496573722263f, -0.02273991014673981f,
	-0.02244585385153241f, -0.02215279583973339f, -0.02186073509501484f,
	-0.02156967059659953f, -0.02127960131927908f, -0.02099052623343045f,
	-0.02070244430502876f, -0.02041535449566733f, -0.02012925576257007f,
	-0.01984414705860837f, -0.01956002733231843f, -0.01927689552791278f,
	-0.01899475058530297f, -0.01871359144011242f, -0.01843341702368794f,
	-0.01815422626312201f, -0.01787601808126604f, -0.01759879139674458f,
	-0.01732254512397934f, -0.01704727817319096f, -0.01677298945042826f,
	-0.01649967785757766f, -0.01622734229238043f, -0.01595598164845135f,
	-0.01568559481529208f, -0.01541618067830219f, -0.01514773811880765f,
	-0.01488026601406611f, -0.0146137632372878f, -0.01434822865765195f,
	-0.01408366114031656f, -0.01382005954644638f, -0.01355742273321736f,
	-0.01329574955383971f, -0.01303503885757173f, -0.01277528948973216f,
	-0.01251650029172779f, -0.01225867010105652f, -0.01200179775133269f,
	-0.01174588207229954f, -0.01149092188984024f, -0.01123691602600196f,
	-0.01098386329901934f, -0.01073176252330565f, -0.01048061250949583f,
	-0.01023041206444608f, -0.009981159991252486f, -0.009732855089279457f,
	-0.00948549615415839f, -0.009239081977815644f, -0.008993611348483199f,
	-0.008749083050719974f, -0.008505495865424261f, -0.008262848569845271f,
	-0.008021139937613774f, -0.007780368738744325f, -0.007540533739661015f,
	-0.007301633703205911f, -0.007063667388659933f, -0.006826633551759275f,
	-0.006590530944708739f, -0.006355358316204373f, -0.006121114411441475f,
	-0.005887797972135011f, -0.005655407736540052f, -0.005423942439461537f,
	-0.005193400812271153f, -0.004963781582928206f, -0.004735083475996049f,
	-0.00450730521264564f, -0.004280445510691954f, -0.004054503084601535f,
	-0.003829476645495599f, -0.003605364901193564f, -0.003382166556203713f,
	-0.003159880311754736f, -0.002938504865807711f, -0.002718038913069431f,
	-0.002498481145014608f, -0.002279830249898751f, -0.002062084912773709f,
	-0.001845243815509878f, -0.001629305636800637f, -0.001414269052193439f,
	-0.001200132734096914f, -0.0009868953517959688f, -0.0007745555714766538f,
	-0.000563112056230608f, -0.0003525634660901388f, -0.0001429084580220063f,
	0.00006585431404726449f, 0.000273726199200297f, 0.0004807085495350804f,
	0.0006868027201409887f, 0.0008920100690721355f, 0.001096331957345597f,
	0.001299769748915657f, 0.001502324810659594f, 0.001703998512367022f,
	0.001904792226709695f, 0.00210470732924417f, 0.002303745198380724f,
	0.002501907215369136f, 0.002699194764290702f, 0.002895609232028917f,
	0.003091152008265929f, 0.003285824485455002f, 0.003479628058820516f,
	0.003672564126313559f, 0.003864634088628804f, 0.004055839349165424f,
	0.004246181314011998f, 0.004435661391948286f, 0.00462428099440526f,
	0.004812041535463329f, 0.004998944431835461f, 0.005184991102844982f,
	0.005370182970410475f, 0.005554521459032457f, 0.00573800799577917f,
	0.005920644010260822f, 0.006102430934626035f, 0.00628337020353431f,
	0.006463463254146262f, 0.006642711526101408f, 0.006821116461512843f,
	0.006998679504937044f, 0.007175402103373862f, 0.007351285706230115f,
	0.007526331765316918f, 0.007700541734839916f, 0.007873917071363756f,
	0.008046459233811198f, 0.008218169683437359f, 0.008389049883822607f,
	0.008559101300852134f, 0.008728325402689307f, 0.008896723659786331f,
	0.009064297544837174f, 0.009231048532777563f, 0.009396978100776998f,
	0.009562087728196111f, 0.00972637889660266f, 0.00988985308972623f,
	0.01005251179346533f, 0.01021435649585455f, 0.01037538868706011f,
	0.01053560985935586f, 0.0106950215071091f, 0.01085362512676635f,
	0.01101142221684092f, 0.01116841427788806f, 0.01132460281249247f,
	0.01147998932525418f, 0.011634575322776f, 0.01178836231363344f,
	0.01194135180837907f, 0.01209354531950523f, 0.01224494436144762f,
	0.0123955504505524f, 0.01254536510507264f, 0.01269438984514525f,
	0.01284262619278297f, 0.01299007567184506f, 0.01313673980803287f,
	0.01328262012887115f, 0.01342771816368859f, 0.01357203544360974f,
	0.01371557350152663f, 0.01385833387209878f, 0.0140003180917203f,
	0.01414152769852172f, 0.01428196423233796f, 0.01442162923470213f,
	0.01456052424882336f, 0.01469865081959209f, 0.01483601049351879f,
	0.01497260481876772f, 0.01510843534511252f, 0.01524350362393178f,
	0.01537781120818682f, 0.01551135965240835f, 0.01564415051268053f,
	0.01577618534662672f, 0.01590746571339618f, 0.01603799317364185f,
	0.01616776928950702f, 0.01629679562461383f, 0.01642507374404278f,
	0.01655260521431767f, 0.01667939160339404f, 0.01680543448064408f,
	0.01693073541682821f, 0.01705529598409594f, 0.01717911775596636f,
	0.01730220230730328f, 0.01742455121431163f, 0.0175461660545082f,
	0.01766704840672783f, 0.01778719985108789f, 0.01790662196897851f,
	0.01802531634305015f, 0.01814328455720026f, 0.01826052819654755f,
	0.01837704884742663f, 0.01849284809737206f, 0.01860792753509965f,
	0.01872228875048964f, 0.01883593333457156f, 0.01894886287951713f,
	0.0190610789786163f, 0.01917258322626569f, 0.01928337721794548f,
	0.019393462550223f, 0.01950284082072073f, 0.01961151362810031f,
	0.01971948257206523f, 0.01982674925332084f, 0.01993331527358233f,
	0.02003918223554368f, 0.02014435174286521f, 0.02024882540017536f,
	0.02035260481303158f, 0.02045569158791415f, 0.02055808733221731f,
	0.02065979365422787f, 0.02076081216311909f, 0.02086114446891418f,
	0.02096079218250235f, 0.02105975691559702f, 0.02115804028073942f,
	0.02125564389126566f, 0.02135256936130591f, 0.02144881830577372f,
	0.02154439234033578f, 0.02163929308140932f, 0.02173352214613721f,
	0.02182708115237996f, 0.02191997171870507f, 0.02201219546436394f,
	0.022103754009275f, 0.02219464897403256f, 0.02228488197984379f,
	0.02237445464857934f, 0.0224633686026916f, 0.0225516254652609f,
	0.02263922685993247f, 0.02272617441092883f, 0.02281246974303474f,
	0.02289811448155987f, 0.02298311025236277f, 0.02306745868179405f,
	0.02315116139671591f, 0.02323422002447284f, 0.02331663619287294f,
	0.02339841153018618f, 0.02347954766511595f, 0.0235600462268044f,
	0.0236399088447925f, 0.02371913714902884f, 0.02379773276983865f,
	0.02387569733792105f, 0.02395303248433489f, 0.02402973984047207f,
	0.02410582103805936f, 0.02418127770913169f, 0.02425611148602602f,
	0.02433032400135992f, 0.0244039168880219f, 0.02447689177917133f,
	0.02454925030819765f, 0.02462099410871143f, 0.02469212481456395f,
	0.02476264405978412f, 0.02483255347860247f, 0.02490185470541295f,
	0.02497054937478004f, 0.02503863912140502f, 0.02510612558012237f,
	0.0251730103858927f, 0.02523929517377876f, 0.02530498157892502f,
	0.02537007123656831f, 0.02543456578199165f, 0.02549846685054557f,
	0.02556177607760901f, 0.02562449509857689f, 0.02568662554886902f,
	0.02574816906389099f, 0.02580912727903417f, 0.02586950182965175f,
	0.0259292943510605f, 0.02598850647851946f, 0.02604713984721396f,
	0.02610519609224315f, 0.02616267684860762f, 0.02621958375120669f,
	0.02627591843479137f, 0.0263316825340043f, 0.02638687768332381f,
	0.02644150551705326f, 0.02649556766933613f, 0.02654906577411608f,
	0.02660200146513513f, 0.02665437637591772f, 0.02670619213975822f,
	0.02675745038971122f, 0.02680815275857728f, 0.02685830087887453f,
	0.02690789638285639f, 0.02695694090246902f, 0.02700543606936367f,
	0.02705338351485142f, 0.02710078486992806f, 0.02714764176523232f,
	0.0271939558310601f, 0.02723972869731738f, 0.02728496199353003f,
	0.02732965734883752f, 0.02737381639194946f, 0.0274174407511758f,
	0.02746053205438148f, 0.02750309192896782f, 0.02754512200190983f,
	0.0275866238996798f, 0.0276275992482784f, 0.02766804967320979f,
	0.02770797679946035f, 0.02774738225150219f, 0.02778626765327452f,
	0.02782463462814988f, 0.02786248479896258f, 0.02789981978797229f,
	0.02793664121684091f, 0.02797295070665217f, 0.02800874987786627f,
	0.02804404035032614f, 0.02807882374325743f, 0.02811310167521252f,
	0.0281468757641079f, 0.02818014762719478f, 0.02821291888101917f,
	0.02824519114145473f, 0.02827696602367257f, 0.0283082451421075f,
	0.02833903011048199f, 0.02836932254177071f, 0.028399124048196f,
	0.02842843624121726f, 0.02845726073153187f, 0.02848559912901471f,
	0.0285134530427733f, 0.02854082408109448f, 0.02856771385142664f,
	0.02859412396041527f, 0.02862005601383899f, 0.02864551161661132f,
	0.02867049237279317f, 0.0286949998855519f, 0.02871903575718448f,
	0.02874260158905883f, 0.02876569898163694f, 0.02878832953446242f,
	0.02881049484612852f, 0.02883219651429591f, 0.02885343613564295f,
	0.02887421530590117f, 0.02889453561978783f, 0.02891439867106981f,
	0.02893380605246775f, 0.02895275935570573f, 0.02897126017148998f,
	0.02898931008945559f, 0.02900691069823047f, 0.0290240635853447f,
	0.02904077033728391f, 0.02905703253943769f, 0.02907285177611029f,
	0.02908822963049217f, 0.02910316768467069f, 0.02911766751960165f,
	0.02913173071510222f, 0.02914535884985092f, 0.02915855350135387f,
	0.02917131624596969f, 0.02918364865886857f, 0.02919555231402171f,
	0.0292070287842101f, 0.02921807964100153f, 0.0292287064547505f,
	0.02923891079456808f, 0.02924869422832898f, 0.02925805832265382f,
	0.02926700464290377f, 0.0292755347531699f, 0.02928365021624301f,
	0.02929135259364556f, 0.02929864344557486f, 0.02930552433092792f,
	0.0293119968072677f, 0.02931806243083023f, 0.02932372275650685f,
	0.02932897933782996f, 0.02933383372696241f, 0.02933828747471345f,
	0.02934234213048725f, 0.02934599924229885f, 0.02934926035676532f,
	0.02935212701908618f, 0.02935460077302742f, 0.02935668316094464f,
	0.02935837572372257f, 0.02935968000081778f, 0.02936059753020359f,
	0.02936112984838246f, 0.02936127849040381f, 0.02936104498978231f,
	0.02936043087856532f, 0.02935943768727078f, 0.02935806694490139f,
	0.02935632017893397f, 0.02935419891530344f, 0.02935170467839576f,
	0.02934883899103368f, 0.02934560337448921f, 0.02934199934843739f,
	0.02933802843098654f, 0.02933369213863024f, 0.02932899198627758f,
	0.02932392948722295f, 0.02931850615311049f, 0.02931272349398739f,
	0.02930658301824529f, 0.02930008623263447f, 0.0292932346422301f,
	0.0292860297504518f, 0.02927847305905117f, 0.02927056606807809f,
	0.0292623102759002f, 0.02925370717917452f, 0.02924475827285633f,
	0.02923546505016894f, 0.02922582900261971f, 0.02921585161996098f,
	0.02920553439022199f, 0.02919487879966453f, 0.02918388633277935f,
	0.02917255847230215f, 0.02916089669918342f, 0.02914890249257773f,
	0.02913657732984553f, 0.02912392268654429f, 0.02911094003641778f,
	0.02909763085139438f, 0.02908399660154969f, 0.02907003875515457f,
	0.02905575877859511f, 0.02904115813644025f, 0.02902623829136175f,
	0.02901100070419815f, 0.02899544683386423f, 0.02897957813742735f,
	0.02896339607003106f, 0.02894690208493422f, 0.02893009763347897f,
	0.02891298416508369f, 0.02889556312725005f, 0.02887783596553816f,
	0.02885980412356303f, 0.02884146904299988f, 0.02882283216355752f,
	0.0288038949229783f, 0.02878465875703994f, 0.02876512509953776f,
	0.02874529538227221f, 0.02872517103504712f, 0.0287047534856768f,
	0.02868404415995229f, 0.02866304448164846f, 0.02864175587252759f,
	0.02862017975229314f, 0.02859831753863417f, 0.02857617064717565f,
	0.02855374049150327f, 0.02853102848312616f, 0.02850803603148222f,
	0.02848476454395942f, 0.0284612154258319f, 0.02843739008029899f,
	0.02841328990845681f, 0.02838891630931072f, 0.02836427067973623f,
	0.02833935441449675f, 0.02831416890624005f, 0.02828871554547518f,
	0.02826299572056001f, 0.02823701081773144f, 0.02821076222105567f,
	0.0281842513124495f, 0.0281574794716537f, 0.02813044807625963f,
	0.02810315850164712f, 0.02807561212104126f, 0.02804781030545555f,
	0.02801975442370441f, 0.02799144584241197f, 0.02796288592597839f,
	0.02793407603660469f, 0.02790501753423058f, 0.02787571177660552f,
	0.02784616011922658f, 0.02781636391534192f, 0.02778632451595441f,
	0.02775604326981273f, 0.02772552152341312f, 0.02769476062096387f,
	0.0276637619044191f, 0.02763252671345028f, 0.02760105638543031f,
	0.02756935225544765f, 0.02753741565630285f, 0.0275052479184783f,
	0.02747285037015601f, 0.02744022433719983f, 0.02740737114316083f,
	0.02737429210924702f, 0.02734098855434829f, 0.02730746179501331f,
	0.02727371314543525f, 0.02723974391748207f, 0.02720555542064317f,
	0.02717114896206851f, 0.02713652584652237f, 0.02710168737641005f,
	0.0270666348517583f, 0.02703136957019758f, 0.02699589282700465f,
	0.02696020591503156f, 0.02692431012474649f, 0.0268882067442f,
	0.02685189705906232f, 0.02681538235255764f, 0.02677866390552274f,
	0.02674174299633769f, 0.02670462090098091f, 0.02666729889297592f,
	0.02662977824342327f, 0.02659206022097571f, 0.02655414609182926f,
	0.0265160371197286f, 0.02647773456597057f, 0.0264392396893669f,
	0.02640055374628857f, 0.02636167799060196f, 0.02632261367372024f,
	0.02628336204457504f, 0.02624392434958267f, 0.02620430183270094f,
	0.02616449573537593f, 0.02612450729654902f, 0.02608433775264806f,
	0.02604398833762111f, 0.02600346028288136f, 0.02596275481731247f,
	0.02592187316729166f, 0.02588081655667195f, 0.02583958620676973f,
	0.02579818333635053f, 0.02575660916165745f, 0.0257148648963863f,
	0.02567295175165895f, 0.02563087093609972f, 0.02558862365571457f,
	0.02554621111398169f, 0.02550363451181958f, 0.02546089504755144f,
	0.02541799391694787f, 0.02537493231319665f, 0.02533171142689916f,
	0.02528833244608108f, 0.02524479655617639f, 0.02520110494002736f,
	0.02515725877785612f, 0.02511325924734286f, 0.02506910752350499f,
	0.0250248047787771f, 0.024980352182979f, 0.02493575090333166f,
	0.02489100210441463f, 0.02484610694819622f, 0.0248010665940157f,
	0.02475588219859403f, 0.02471055491601248f, 0.02466508589771621f,
	0.02461947629251071f, 0.02457372724656892f, 0.02452783990339924f,
	0.02448181540389171f, 0.02443565488625409f, 0.02438935948605802f,
	0.02434293033620349f, 0.02429636856694372f, 0.02424967530584964f,
	0.02420285167785252f, 0.02415589880517288f, 0.02410881780743068f,
	0.02406160980144989f, 0.02401427590149651f, 0.02396681721909388f,
	0.02391923486306168f, 0.02387152993961905f, 0.02382370355217489f,
	0.02377575680153398f, 0.02372769078577263f, 0.02367950660027773f,
	0.02363120533772544f, 0.02358278808809188f, 0.02353425593864955f,
	0.02348560997394599f, 0.02343685127584649f, 0.02338798092348071f,
	0.02333899999327115f, 0.02328990955890475f, 0.02324071069137545f,
	0.02319140445891676f, 0.02314199192708699f, 0.02309247415864845f,
	0.0230428522137025f, 0.02299312714957579f, 0.02294330002085231f,
	0.02289337187941953f, 0.02284334377440089f, 0.02279321675215584f,
	0.02274299185636152f, 0.02269267012786713f, 0.02264225260486441f,
	0.02259174032271715f, 0.0225411343140891f, 0.02249043560887997f,
	0.02243964523419705f, 0.02238876421444402f, 0.02233779357123921f,
	0.02228673432344052f, 0.02223558748714538f, 0.02218435407570495f,
	0.02213303509966024f, 0.0220816315668344f, 0.02203014448224749f,
	0.02197857484816978f, 0.021926923664072f, 0.0218751919266964f,
	0.02182338062996791f, 0.02177149076505457f, 0.02171952332034621f,
	0.02166747928144374f, 0.02161535963118765f, 0.02156316534959046f,
	0.02151089741393619f, 0.02145855679869512f, 0.02140614447554511f,
	0.02135366141341066f, 0.0213011085783954f, 0.02124848693380698f,
	0.02119579744020683f, 0.02114304105532127f, 0.02109021873409133f,
	0.02103733142868691f, 0.0209843800884748f, 0.02093136566000097f,
	0.0208782890870367f, 0.02082515131054663f, 0.02077195326873138f,
	0.02071869589692809f, 0.02066538012771701f, 0.02061200689088593f,
	0.0205585771133947f, 0.02050509171940007f, 0.02045155163028766f,
	0.02039795776458674f, 0.02034431103807676f, 0.02029061236370566f,
	0.02023686265160051f, 0.0201830628091244f, 0.02012921374079468f,
	0.02007531634833981f, 0.02002137153067096f, 0.01996738018391042f,
	0.0199133432013312f, 0.0198592614734423f, 0.01980513588793542f,
	0.01975096732968495f, 0.01969675668071602f, 0.0196425048203288f,
	0.01958821262492804f, 0.01953388096816865f, 0.0194795107208705f,
	0.0194251027510468f, 0.01937065792387571f, 0.01931617710175714f,
	0.0192616611442844f, 0.01920711090821214f, 0.01915252724749905f,
	0.01909791101326518f, 0.01904326305388792f, 0.01898858421485272f,
	0.01893387533887747f, 0.01887913726589474f, 0.0188243708329594f,
	0.01876957687438363f, 0.01871475622158769f, 0.01865990970328113f,
	0.01860503814530289f, 0.0185501423706853f, 0.01849522319968599f,
	0.018440281449692f, 0.0183853179353477f, 0.01833033346844814f,
	0.01827532885801019f, 0.01822030491023696f, 0.01816526242847515f,
	0.01811020221335013f, 0.01805512506262019f, 0.01800003177126541f,
	0.01794492313145568f, 0.0178897999325791f, 0.01783466296115676f,
	0.01777951300097768f, 0.01772435083301004f, 0.01766917723539407f,
	0.01761399298349886f, 0.01755879884989752f, 0.01750359560435299f,
	0.01744838401381088f, 0.01739316484245989f, 0.01733793885167145f,
	0.01728270680002452f, 0.01722746944331632f, 0.01717222753453384f,
	0.01711698182387166f, 0.0170617330587639f, 0.0170064819838025f,
	0.01695122934086512f, 0.01689597586897306f, 0.01684072230439781f,
	0.01678546938060776f, 0.01673021782830019f, 0.01667496837538351f,
	0.01661972174698789f, 0.0165644786654866f, 0.01650923985040719f,
	0.01645400601858426f, 0.01639877788401022f, 0.01634355615793126f,
	0.01628834154882952f, 0.01623313476239474f, 0.01617793650156329f,
	0.01612274746647202f, 0.01606756835453992f, 0.01601239986038649f,
	0.0159572426758423f, 0.01590209749005211f, 0.01584696498931847f,
	0.01579184585722614f, 0.01573674077460296f, 0.01568165041949853f,
	0.01562657546726242f, 0.01557151659038424f, 0.0155164744587104f,
	0.01546144973930552f, 0.01540644309643823f, 0.01535145519170555f,
	0.01529648668389782f, 0.01524153822911245f, 0.01518661048067215f,
	0.01513170408920672f, 0.01507681970249308f, 0.01502195796576089f,
	0.01496711952132301f, 0.01491230500888818f, 0.01485751506535493f,
	0.01480275032497146f, 0.01474801141920423f, 0.01469329897680893f,
	0.01463861362381635f, 0.01458395598356787f, 0.01452932667665507f,
	0.01447472632099433f, 0.01442015553175224f, 0.01436561492140953f,
	0.01431110509969002f, 0.01425662667373117f, 0.01420218024780339f,
	0.01414776642364046f, 0.01409338580013752f, 0.01403903897361757f,
	0.01398472653760762f, 0.01393044908300922f, 0.01387620719800963f,
	0.01382200146810319f, 0.01376783247613033f, 0.01371370080219946f,
	0.01365960702380775f, 0.01360555171574873f, 0.01355153545010878f,
	0.01349755879632752f, 0.01344362232120488f, 0.01338972658881942f,
	0.01333587216061715f, 0.01328205959543637f, 0.01322828944932652f,
	0.0131745622758288f, 0.01312087862572042f, 0.01306723904719575f,
	0.01301364408575977f, 0.01296009428428845f, 0.01290659018304296f,
	0.01285313231960572f, 0.01279972122895856f, 0.01274635744339036f,
	0.0126930414926889f, 0.01263977390382109f, 0.01258655520131668f,
	0.01253338590697694f, 0.01248026654000966f, 0.01242719761700072f,
	0.01237417965199227f, 0.01232121315627665f, 0.01226829863868772f,
	0.01221543660533797f, 0.01216262755983876f, 0.01210987200313695f,
	0.01205717043361431f, 0.01200452334703783f, 0.01195193123662363f,
	0.01189939459298727f, 0.01184691390414371f, 0.01179448965555707f,
	0.01174212233009797f, 0.01168981240806488f, 0.01163756036721252f,
	0.01158536668272347f, 0.01153323182717258f, 0.01148115627064782f,
	0.01142914048060816f, 0.01137718492205408f, 0.01132529005732862f,
	0.01127345634631637f, 0.01122168424632974f, 0.01116997421214449f,
	0.01111832669597134f, 0.0110667421475199f, 0.01101522101400576f,
	0.01096376374004393f, 0.01091237076780515f, 0.01086104253688802f,
	0.01080977948436867f, 0.0107585820448719f, 0.01070745065050715f,
	0.01065638573080462f, 0.01060538771287156f, 0.01055445702129276f,
	0.01050359407818746f, 0.01045279930310272f, 0.01040207311323371f,
	0.0103514159231679f, 0.01030082814509825f, 0.01025031018869526f,
	0.01019986246121362f, 0.01014948536737847f, 0.01009917930946357f,
	0.01004894468736239f, 0.009998781898389097f, 0.009948691337498871f,
	0.009898673397167101f, 0.009848728467446221f, 0.009798856935908872f,
	0.009749059187733166f, 0.009699335605631631f, 0.009649686569915161f,
	0.009600112458478804f, 0.009550613646759131f, 0.009501190507812395f,
	0.009451843412243476f, 0.009402572728291147f, 0.00935337882178544f,
	0.009304262056112122f, 0.009255222792340589f, 0.009206261389067549f,
	0.009157378202516497f, 0.009108573586601664f, 0.009059847892750383f,
	0.009011201470094931f, 0.008962634665373059f, 0.008914147822899565f,
	0.008865741284758144f, 0.008817415390502958f, 0.008769170477449961f,
	0.008721006880584525f, 0.00867292493242644f, 0.00862492496326439f,
	0.008577007300999639f, 0.008529172271224183f, 0.008481420197142597f,
	0.008433751399699929f, 0.008386166197503541f, 0.008338664906823112f,
	0.008291247841619053f, 0.008243915313585148f, 0.008196667632063281f,
	0.008149505104100285f, 0.008102428034476361f, 0.008055436725669551f,
	0.008008531477834424f, 0.007961712588937075f, 0.007914980354513545f,
	0.007868335068010878f, 0.007821777020467379f, 0.007775306500704459f,
	0.007728923795298214f, 0.007682629188558109f, 0.007636422962491451f,
	0.007590305396966812f, 0.0075442767695435f, 0.007498337355528406f,
	0.007452487428018628f, 0.007406727257894374f, 0.007361057113776325f,
	0.007315477262160641f, 0.007269987967184476f, 0.007224589490867572f,
	0.007179282092991456f, 0.00713406603117761f, 0.007088941560830619f,
	0.007043908935138176f, 0.006998968405106609f, 0.006954120219596404f,
	0.006909364625244052f, 0.006864701866597044f, 0.006820132185900718f,
	0.006775655823339832f, 0.006731273016924887f, 0.006686984002470808f,
	0.00664278901370352f, 0.006598688282124953f, 0.006554682037155146f,
	0.006510770506096719f, 0.006466953914042505f, 0.006423232484053187f,
	0.006379606437022289f, 0.006336075991697498f, 0.006292641364751716f,
	0.006249302770768849f, 0.006206060422172754f, 0.006162914529348029f,
	0.006119865300554749f, 0.006076912941963996f, 0.006034057657728908f,
	0.005991299649778625f, 0.005948639118180665f, 0.005906076260707493f,
	0.00586361127322732f, 0.00582124434950515f, 0.005778975681238307f,
	0.005736805458084859f, 0.005694733867642298f, 0.005652761095539915f,
	0.005610887325232738f, 0.00556911273832128f, 0.005527437514260213f,
	0.005485861830557325f, 0.005444385862602985f, 0.005403009783918832f,
	0.005361733765873566f, 0.005320557977995576f, 0.005279482587688733f,
	0.005238507760438437f, 0.005197633659726363f, 0.005156860447037558f,
	0.005116188281938605f, 0.005075617321971037f, 0.005035147722743715f,
	0.004994779637847557f, 0.004954513219004752f, 0.004914348615962182f,
	0.004874285976519843f, 0.004834325446488207f, 0.004794467169844551f,
	0.004754711288548207f, 0.00471505794266136f, 0.004675507270391676f,
	0.004636059407921777f, 0.004596714489593978f, 0.00455747264787476f,
	0.004518334013297931f, 0.004479298714457513f, 0.00444036687808591f,
	0.004401538629167589f, 0.004362814090633548f, 0.004324193383617114f,
	0.00428567662732604f, 0.004247263939234358f, 0.004208955434783945f,
	0.004170751227775326f, 0.004132651430055034f, 0.00409465615148008f,
	0.0040567655003656f, 0.004018979582966153f, 0.003981298503838104f,
	0.003943722365640667f, 0.00390625126927091f, 0.003868885313792702f,
	0.003831624596521976f, 0.003794469212849094f, 0.003757419256416483f,
	0.003720474819232322f, 0.00368363599131527f, 0.003646902861049738f,
	0.003610275514844829f, 0.003573754037667242f, 0.003537338512415999f,
	0.003501029020384294f, 0.003464825641103175f, 0.003428728452298912f,
	0.003392737530028f, 0.00335685294862742f, 0.003321074780529897f,
	0.003285403096683126f, 0.00324983796618028f, 0.0032143794563666f,
	0.003179027632995712f, 0.003143782559988039f, 0.003108644299771867f,
	0.00307361291277175f, 0.003038688457934313f, 0.003003870992515089f,
	0.002969160572092732f, 0.002934557250540592f, 0.002900061080012505f,
	0.002865672111028061f, 0.002831390392586285f, 0.002797215971853006f,
	0.002763148894402434f, 0.002729189204288218f, 0.002695336943730808f,
	0.002661592153430092f, 0.002627954872508553f, 0.002594425138354949f,
	0.00256100298685169f, 0.002527688452232723f, 0.002494481567069328f,
	0.002461382362440645f, 0.002428390867677876f, 0.002395507110762196f,
	0.002362731117926841f, 0.002330062913799224f, 0.002297502521599881f,
	0.002265049962787202f, 0.002232705257412703f, 0.002200468423893653f,
	0.002168339479140968f, 0.002136318438516582f, 0.002104405315819235f,
	0.002072600123312895f, 0.002040902871755179f, 0.002009313570397353f,
	0.001977832226899067f, 0.001946458847541521f, 0.001915193437014295f,
	0.001884035998415356f, 0.001852986533563694f, 0.001822045042544573f,
	0.001791211524206914f, 0.001760485975722758f, 0.001729868392914113f,
	0.001699358770054004f, 0.001668957100008583f, 0.001638663374137649f,
	0.001608477582394129f, 0.001578399713281442f, 0.001548429753825075f,
	0.001518567689629435f, 0.001488813504877839f, 0.001459167182275677f,
	0.001429628703291996f, 0.001400198047718959f, 0.00137087519418344f,
	0.001341660119663856f, 0.001312552799973332f, 0.001283553209418641f,
	0.001254661320828631f, 0.001225877105866857f, 0.001197200534704734f,
	0.00116863157603575f, 0.001140170197459156f, 0.001111816364939954f,
	0.001083570043206805f, 0.001055431195624123f, 0.001027399784248927f,
	0.0009994757697455725f, 0.0009716591114852235f, 0.0009439497675600705f,
	0.0009163476945417414f, 0.0008888528478934176f, 0.0008614651816714058f,
	0.0008341846486672466f, 0.0008070112003224494f, 0.0007799447868279685f,
	0.0007529853570815703f, 0.0007261328586167792f, 0.0006993872377734078f,
	0.0006727484396122918f, 0.0006462164078726573f, 0.0006197910851568622f,
	0.000593472412617757f, 0.0005672603302571133f, 0.0005411547768545688f,
	0.000515155689953417f, 0.0004892630057753422f, 0.0004634766593625272f,
	0.0004377965845208109f, 0.0004122227139049527f, 0.0003867549788338919f,
	0.0003613933095181209f, 0.0003361376348323119f, 0.000310987882670588f,
	0.0002859439794775653f, 0.0002610058507030998f, 0.0002361734205749144f,
	0.0002114466120133329f, 0.0001868253469154979f, 0.0001623095459990508f,
	0.0001378991287026565f, 0.0001135940134702195f, 0.00008939411746666792f,
	0.00006529935674848275f, 0.00004130964619264432f, 0.00001742489961031878f,
	-6.354970224720091E-6f, -0.00003003005191715146f, -0.00005360043505220346f,
	-0.00007706621026670745f, -0.0001004274694338391f, -0.0001236843054499559f,
	-0.0001468368123056507f, -0.0001698850851710176f, -0.0001928292201682779f,
	-0.0002156693146559973f, -0.0002384054669306578f, -0.0002610377764398208f,
	-0.0002835663437394941f, -0.0003059912702383371f, -0.0003283126587803053f,
	-0.0003505306128346319f, -0.0003726452372205812f, -0.0003946566376384907f,
	-0.0004165649208687227f, -0.0004383701948285079f, -0.0004600725682450956f,
	-0.0004816721510962906f, -0.0005031690541557054f, -0.0005245633894048751f,
	-0.0005458552697348295f, -0.0005670448089460933f, -0.0005881321220186919f,
	-0.0006091173247995129f, -0.0006300005340591496f, -0.0006507818678471721f,
	-0.0006714614448384281f, -0.0006920393847735795f, -0.0007125158084875238f,
	-0.0007328908376820209f, -0.0007531645948972709f, -0.0007733372038813968f,
	-0.0007934087890788532f, -0.0008133794760567525f, -0.0008332493911069605f,
	-0.0008530186616440005f, -0.0008726874160345232f, -0.0008922557832704569f,
	-0.0009117238935232307f, -0.0009310918778311361f, -0.0009503598679856395f,
	-0.0009695279968866543f, -0.0009885963981588474f, -0.001007565206478489f,
	-0.001026434557132915f, -0.001045204586560544f, -0.001063875432009808f,
	-0.001082447231382843f, -0.001100920123718651f, -0.001119294248837832f,
	-0.001137569747257316f, -0.001155746760602482f, -0.001173825431067143f,
	-0.001191805901797238f, -0.001209688316919255f, -0.001227472821213382f,
	-0.001245159560113506f, -0.001262748680318281f, -0.001280240328995319f,
	-0.001297634654179091f, -0.001314931804714092f, -0.001332131930382729f,
	-0.00134923518145058f, -0.001366241709320092f, -0.00138315166604741f,
	-0.001399965204242903f, -0.001416682477554331f, -0.001433303640382632f,
	-0.001449828847810863f, -0.001466258255533148f, -0.001482592020252582f,
	-0.00149883029934017f, -0.001514973250920093f, -0.001531021033656543f,
	-0.001546973807336371f, -0.001562831732101699f, -0.001578594968876245f,
	-0.001594263679521645f, -0.001609838026411125f, -0.001625318172841616f,
	-0.001640704282380056f, -0.001655996519744462f, -0.001671195050192864f,
	-0.00168630003948067f, -0.001701311654429105f, -0.001716230062157819f,
	-0.001731055430681749f, -0.001745787928612685f, -0.001760427725344015f,
	-0.001774974990667033f, -0.001789429895325156f, -0.001803792610445498f,
	-0.001818063308121509f, -0.001832242160645591f, -0.00184632934133333f,
	-0.001860325023926634f, -0.001874229382963221f, -0.001888042593407135f,
	-0.001901764830961383f, -0.001915396271925828f, -0.001928937093140348f,
	-0.001942387472070095f, -0.001955747586947609f, -0.001969017616318069f,
	-0.001982197739465618f, -0.001995288136356521f, -0.002008288987298101f,
	-0.002021200473308226f, -0.002034022776086885f, -0.002046756077589861f,
	-0.002059400560682433f, -0.002071956408684627f, -0.00208442380511542f,
	-0.002096802934659081f, -0.002109093981999876f, -0.002121297132646304f,
	-0.002133412572675297f, -0.002145440488391159f, -0.002157381066979269f,
	-0.002169234495852379f, -0.002181000963304313f, -0.002192680657657319f,
	-0.002204273768086295f, -0.002215780484192464f, -0.002227200996031797f,
	-0.002238535494228699f, -0.002249784169634949f, -0.002260947214040243f,
	-0.002272024819433227f, -0.002283017178086765f, -0.002293924483296905f,
	-0.002304746928217582f, -0.002315484706969073f, -0.002326138013700074f,
	-0.002336707043269825f, -0.002347191990992314f, -0.002357593052522588f,
	-0.002367910423913599f, -0.002378144302042528f, -0.002388294883473918f,
	-0.002398362365966022f, -0.002408346947277095f, -0.002418248825534874f,
	-0.002428068199606059f, -0.002437805268613146f, -0.002447460231877585f,
	-0.002457033289346099f, -0.002466524641334899f, -0.002475934488529674f,
	-0.002485263032042439f, -0.002494510473383115f, -0.002503677014260574f,
	-0.0025127628569237f, -0.002521768203791907f, -0.002530693258165683f,
	-0.002539538223118142f, -0.002548303302404519f, -0.002556988699922158f,
	-0.002565594620136835f, -0.002574121267798545f, -0.002582568847969923f,
	-0.002590937565969397f, -0.002599227627598565f, -0.002607439238914821f,
	-0.002615572606259775f, -0.002623627936344519f, -0.002631605436192785f,
	-0.002639505313140944f, -0.002647327774951691f, -0.002655073029330878f,
	-0.002662741284694902f, -0.002670332749744375f, -0.002677847632924112f,
	-0.002685286143673693f, -0.002692648491290583f, -0.002699934885527f,
	-0.002707145536248845f, -0.00271428065380519f, -0.002721340448601949f,
	-0.002728325131528208f, -0.002735234913501471f, -0.002742070005893992f,
	-0.002748830620305398f, -0.00275551696827847f, -0.002762129262151802f,
	-0.00276866771420714f, -0.002775132536442015f, -0.002781523942331887f,
	-0.002787842144385876f, -0.002794087355937335f, -0.002800259790490144f,
	-0.002806359661434498f, -0.002812387182927977f, -0.00281834256892921f,
	-0.002824226033624199f, -0.002830037791540007f, -0.002835778057459492f,
	-0.002841447045994982f, -0.002847044972497769f, -0.002852572051978086f,
	-0.002858028500099862f, -0.002863414532214392f, -0.002868730364355087f,
	-0.002873976212242723f, -0.002879152292280195f, -0.002884258820444074f,
	-0.002889296013449893f, -0.002894264087842657f, -0.002899163260281056f,
	-0.002903993747793265f, -0.002908755767350612f, -0.00291344953629391f,
	-0.002918075271793441f, -0.002922633191502654f, -0.00292712351287605f,
	-0.002931546453794453f, -0.002935902231996578f, -0.002940191065533781f,
	-0.002944413172599524f, -0.002948568771216741f, -0.002952658079919956f,
	-0.002956681316987896f, -0.002960638701068774f, -0.002964530450753954f,
	-0.002968356784720072f, -0.002972117921814287f, -0.002975814081253247f,
	-0.002979445481571474f, -0.002983012342298252f, -0.002986514882167057f,
	-0.002989953320735594f, -0.00299332787741946f, -0.002996638771179505f,
	-0.002999886221772385f, -0.003003070448841071f, -0.003006191671573787f,
	-0.003009250109869299f, -0.003012245983398997f, -0.003015179511805854f,
	-0.003018050914988634f, -0.003020860412590309f, -0.003023608224566487f,
	-0.003026294570787513f, -0.003028919671265839f, -0.003031483745957075f,
	-0.003033987014532613f, -0.003036429697601761f, -0.003038812014665381f,
	-0.003041134185878036f, -0.003043396431451128f, -0.003045598971311846f,
	-0.003047742025614752f, -0.00304982581425861f, -0.003051850557653779f,
	-0.003053816475357962f, -0.003055723787923625f, -0.003057572715249534f,
	-0.003059363477206034f, -0.003061096294175058f, -0.003062771385799578f,
	-0.003064388972234155f, -0.003065949273548085f, -0.003067452509469603f,
	-0.003068898900011163f, -0.003070288664957843f, -0.003071622024179987f,
	-0.003072899197803735f, -0.003074120404932045f, -0.003075285865520527f,
	-0.003076395799581632f, -0.003077450426303585f, -0.003078449965386198f,
	-0.003079394636415599f, -0.00308028465855159f, -0.003081120251408719f,
	-0.003081901634146788f, -0.003082629026067706f, -0.003083302646359697f,
	-0.003083922713898346f, -0.003084489447928717f, -0.003085003067099023f,
	-0.003085463790768017f, -0.003085871836987053f, -0.003086227424773824f,
	-0.003086530772776541f, -0.003086782099444462f, -0.00308698162294263f,
	-0.003087129561777146f, -0.0030872261339141f, -0.003087271557433268f,
	-0.003087266050442849f, -0.00308720983070998f, -0.003087103115944955f,
	-0.003086946123801226f, -0.003086739071591182f, -0.003086482176854588f,
	-0.003086175656903833f, -0.003085819728596561f, -0.003085414609074632f,
	-0.003084960515025159f, -0.003084457663305784f, -0.003083906270546776f,
	-0.003083306553264719f, -0.003082658727294074f, -0.003081963009094579f,
	-0.003081219614557539f, -0.003080428759517417f, -0.003079590659751829f,
	-0.003078705530811021f, -0.003077773587847332f, -0.003076795046240476f,
	-0.003075770120858578f, -0.003074699026853977f, -0.003073581978696893f,
	-0.003072419190743858f, -0.003071210877806151f, -0.003069957253728716f,
	-0.003068658532697554f, -0.003067314928046016f, -0.003065926654244321f,
	-0.003064493924114231f, -0.003063016951159625f, -0.003061495948031733f,
	-0.003059931128234438f, -0.003058322704021065f, -0.003056670887644941f,
	-0.003054975892212041f, -0.003053237928838825f, -0.003051457210062835f,
	-0.003049633947114216f, -0.003047768351621016f, -0.003045860634870223f,
	-0.003043911007807764f, -0.00304191968109535f, -0.003039886865451535f,
	-0.003037812770969594f, -0.003035697608311238f, -0.003033541587058152f,
	-0.003031344916905709f, -0.003029107807151376f, -0.003026830467319996f,
	-0.003024513105913229f, -0.003022155932171699f, -0.003019759154426537f,
	-0.003017322980895187f, -0.003014847619567717f, -0.003012333278206824f,
	-0.0030097801641773f, -0.00300718848524184f, -0.003004558447912586f,
	-0.003001890259270112f, -0.002999184125542342f, -0.002996440252957199f,
	-0.002993658848026825f, -0.002990840115842274f, -0.00298798426211988f,
	-0.002985091492178071f, -0.002982162010823685f, -0.002979196022636187f,
	-0.002976193732251886f, -0.002973155343227062f, -0.002970081060027496f,
	-0.002966971085811564f, -0.002963825623965021f, -0.002960644877248341f,
	-0.00295742904893359f, -0.002954178340644375f, -0.002950892955198014f,
	-0.002947573094388644f, -0.002944218959157751f, -0.002940830751242629f,
	-0.002937408671755292f, -0.002933952920727733f, -0.00293046369898775f,
	-0.002926941206396804f, -0.002923385642986886f, -0.002919797207709962f,
	-0.002916176100484335f, -0.002912522519295634f, -0.002908836663095826f,
	-0.002905118730211597f, -0.002901368918060143f, -0.002897587424854464f,
	-0.002893774447500163f, -0.00288993018267547f, -0.002886054827399675f,
	-0.002882148578123633f, -0.002878211630559235f, -0.002874244180134155f,
	-0.002870246422389755f, -0.002866218552526333f, -0.002862160765118915f,
	-0.00285807325423093f, -0.002853956214380559f, -0.002849809838494365f,
	-0.002845634320408407f, -0.002841429852935561f, -0.002837196629059235f,
	-0.002832934840739653f, -0.002828644679937042f, -0.002824326338611626f,
	-0.00281998000735939f, -0.002815605877970028f, -0.00281120414013003f,
	-0.002806774984946969f, -0.002802318601482056f, -0.002797835179705998f,
	-0.002793324909021066f, -0.00278878797746529f, -0.002784224574043037f,
	-0.002779634886621806f, -0.002775019103296472f, -0.002770377411138724f,
	-0.002765709996992882f, -0.002761017047930636f, -0.002756298749602592f,
	-0.002751555288341478f, -0.002746786849741056f, -0.002741993618656124f,
	-0.002737175779998324f, -0.00273233351839508f, -0.002727467017507478f,
	-0.00272257646122398f, -0.002717662032637235f, -0.002712723915010428f,
	-0.002707762290583559f, -0.002702777341539785f, -0.002697769249493831f,
	-0.002692738196174104f, -0.002687684362342679f, -0.002682607928647939f,
	-0.002677509075283523f, -0.002672387982215695f, -0.002667244828558068f,
	-0.002662079793594784f, -0.002656893056098397f, -0.002651684793647746f,
	-0.00264645518512907f, -0.002641204407382247f, -0.002635932637474525f,
	-0.002630640052302624f, -0.002625326828251672f, -0.002619993140626775f,
	-0.002614639165415155f, -0.002609265077353484f, -0.002603871051235273f,
	-0.002598457261626663f, -0.00259302388172955f, -0.002587571085769013f,
	-0.002582099046207986f, -0.002576607935736774f, -0.002571097927045684f,
	-0.002565569191290251f, -0.002560021900080755f, -0.002554456224970635f,
	-0.002548872335466967f, -0.002543270402554753f, -0.002537650595570539f,
	-0.002532013083907713f, -0.002526358036675446f, -0.002520685622187102f,
	-0.002514996008528669f, -0.002509289363217703f, -0.002503565853885447f,
	-0.002497825646685214f, -0.002492068908907185f, -0.002486295805454119f,
	-0.002480506502081425f, -0.002474701164771886f, -0.002468879957177705f,
	-0.002463043044258483f, -0.002457190589211677f, -0.002451322755973706f,
	-0.002445439706434626f, -0.002439541604587702f, -0.0024336286118114f,
	-0.002427700890052619f, -0.002421758599780332f, -0.002415801902770908f,
	-0.002409830958356451f, -0.002403845927460679f, -0.002397846969074635f,
	-0.002391834242189361f, -0.002385807905397996f, -0.002379768116952618f,
	-0.002373715034650558f, -0.002367648815948086f, -0.002361569617505665f,
	-0.002355477595415322f, -0.002349372906110147f, -0.00234325570488636f,
	-0.002337126146812806f, -0.002330984386958334f, -0.0023248305785728f,
	-0.002318664876156617f, -0.002312487433187015f, -0.002306298401663298f,
	-0.002300097934835321f, -0.002293886184020266f, -0.002287663301103748f,
	-0.002281429436948201f, -0.002275184742643432f, -0.002268929367460259f,
	-0.002262663462147429f, -0.002256387175066265f, -0.002250100655373898f,
	-0.002243804051545339f, -0.002237497511259789f, -0.002231181182310137f,
	-0.002224855211238718f, -0.002218519745156299f, -0.002212174929468346f,
	-0.002205820910376132f, -0.002199457832489315f, -0.00219308584121336f,
	-0.00218670508024843f, -0.002180315693635748f, -0.002173917824507043f,
	-0.002167511615994044f, -0.002161097210546358f, -0.00215467475038622f,
	-0.002148244376030561f, -0.002141806229701614f, -0.002135360451120504f,
	-0.002128907181372596f, -0.002122446559042145f, -0.002115978723622902f,
	-0.002109503814494928f, -0.002103021969560359f, -0.002096533326721328f,
	-0.002090038023084161f, -0.002083536195641499f, -0.00207702798070386f,
	-0.002070513514695448f, -0.002063992933358349f, -0.00205746637050197f,
	-0.002050933961868395f, -0.002044395840925972f, -0.002037852141711482f,
	-0.002031302997920647f, -0.002024748540975451f, -0.002018188904003181f,
	-0.002011624218994256f, -0.002005054616347479f, -0.001998480227371146f,
	-0.001991901183259869f, -0.001985317612934522f, -0.0019787296459981f,
	-0.001972137412053598f, -0.001965541038998708f, -0.001958940655072183f,
	-0.001952336387944342f, -0.00194572836505813f, -0.001939116712719624f,
	-0.001932501555984345f, -0.001925883022977359f, -0.001919261237503633f,
	-0.001912636324846062f, -0.001906008408582238f, -0.001899377613085562f,
	-0.001892744061592566f, -0.001886107877680842f, -0.001879469183108994f,
	-0.001872828100090373f, -0.001866184749474086f, -0.001859539253246111f,
	-0.001852891731573436f, -0.001846242304736733f, -0.001839591092107184f,
	-0.001832938213510715f, -0.00182628378706795f, -0.001819627930899514f,
	-0.001812970763126031f, -0.001806312400390197f, -0.001799652960471576f,
	-0.001792992558875994f, -0.001786331312473521f, -0.001779669335292055f,
	-0.001773006743860605f, -0.001766343651979696f, -0.001759680173336164f,
	-0.001753016421730535f, -0.001746352510508586f, -0.001739688551197104f,
	-0.001733024657823989f, -0.001726360940438098f, -0.001719697510452533f,
	-0.001713034479962516f, -0.00170637195776635f, -0.001699710054026581f,
	-0.001693048878109948f, -0.001686388539496874f, -0.001679729145394048f,
	-0.001673070805054521f, -0.001666413624775486f, -0.001659757712673126f,
	-0.001653103174135139f, -0.00164645011614084f, -0.00163979864396424f,
	-0.001633148862765665f, -0.001626500876909631f, -0.001619854790874342f,
	-0.001613210708455881f, -0.00160656873310927f, -0.00159992896692529f,
	-0.001593291513358963f, -0.001586656472795766f, -0.001580023948463349f,
	-0.001573394039496633f, -0.001566766847759026f, -0.001560142472499137f,
	-0.001553521013534009f, -0.001546902570339625f, -0.001540287240459292f,
	-0.001533675123596367f, -0.001527066315929914f, -0.001520460915457988f,
	-0.0015138590188144f, -0.001507260722860337f, -0.001500666122865368f,
	-0.001494075314440124f, -0.001487488392513114f, -0.001480905451444414f,
	-0.001474326584911977f, -0.001467751887162194f, -0.001461181450736148f,
	-0.001454615369084422f, -0.001448053733497545f, -0.00144149663628923f,
	-0.00143494416829526f, -0.001428396420919852f, -0.001421853483293489f,
	-0.001415315446934073f, -0.001408782400403651f, -0.001402254432264271f,
	-0.001395731631760099f, -0.001389214087339496f, -0.001382701885290771f,
	-0.001376195113948597f, -0.00136969385903285f, -0.001363198208423455f,
	-0.001356708245339177f, -0.001350224057887317f, -0.001343745729286638f,
	-0.00133727334480227f, -0.001330806987425603f, -0.001324346741739645f,
	-0.001317892690622102f, -0.001311444916609616f, -0.001305003501101964f,
	-0.001298568526863164f, -0.001292140075520364f, -0.001285718226313292f,
	-0.001279303061323844f, -0.001272894659450685f, -0.001266493101184096f,
	-0.001260098464285874f, -0.00125371082822312f, -0.001247330270643942f,
	-0.001240956870560694f, -0.001234590703575122f, -0.001228231847335337f,
	-0.00122188037869364f, -0.001215536372910719f, -0.001209199905019886f,
	-0.00120287105164607f, -0.001196549886799402f, -0.001190236483125772f,
	-0.001183930916795361f, -0.001177633259430876f, -0.001171343584474016f,
	-0.001165061964684355f, -0.001158788471684601f, -0.001152523178006958f,
	-0.001146266152090902f, -0.001140017467150755f, -0.001133777193217611f,
	-0.001127545398730944f, -0.001121322154858717f, -0.001115107529585657f,
	-0.001108901591351241f, -0.001102704407912824f, -0.001096516047709883f,
	-0.001090336577135531f, -0.00108416606440187f, -0.00107800457567464f,
	-0.001071852175300591f, -0.001065708929218089f, -0.001059574904502369f,
	-0.001053450163453817f, -0.001047334771328678f, -0.001041228792018955f,
	-0.001035132288961904f, -0.001029045324685284f, -0.001022967961489484f,
	-0.001016900262129638f, -0.001010842288224012f, -0.001004794101163497f,
	-0.0009987557614294928f, -0.0009927273290486482f, -0.0009867088660939771f,
	-0.0009807004287267773f, -0.0009747020790200622f, -0.000968713874954119f,
	-0.0009627358742818614f, -0.0009567681358930713f, -0.0009508107170859148f,
	-0.0009448636735669424f, -0.0009389270633164414f, -0.0009330009434052044f,
	-0.0009270853681755397f, -0.0009211803935613716f, -0.0009152860739050083f,
	-0.0009094024653677479f, -0.000903529621382404f, -0.0008976675960639113f,
	-0.0008918164417082152f, -0.0008859762126576242f, -0.0008801469609807099f,
	-0.0008743287392007914f, -0.0008685215982495719f, -0.0008627255904229969f,
	-0.0008569407664253958f, -0.0008511671755968563f, -0.0008454048715975659f,
	-0.0008396539003570069f, -0.0008339143121247616f, -0.0008281861578325333f,
	-0.0008224694838645518f, -0.0008167643402430257f, -0.0008110707735795585f,
	-0.000805388831622622f, -0.0007997185614385671f, -0.0007940600080473814f,
	-0.0007884132203344051f, -0.0007827782428648788f, -0.0007771551215682848f,
	-0.0007715439003277424f, -0.0007659446250727341f, -0.0007603573383221373f,
	-0.0007547820853233133f, -0.0007492189101867552f, -0.0007436678552039666f,
	-0.0007381289626664511f, -0.0007326022753204597f, -0.0007270878350027487f,
	-0.0007215856837774481f, -0.0007160958612075773f, -0.0007106184102667612f,
	-0.000705153370518019f, -0.0006997007822064915f, -0.0006942606842130771f,
	-0.0006888331174650375f, -0.0006834181174326658f, -0.0006780157264074659f,
	-0.0006726259803144785f, -0.0006672489182619756f, -0.0006618845773118664f,
	-0.0006565329929344443f, -0.0006511942049201024f, -0.0006458682471475185f,
	-0.0006405551550869859f, -0.000635254967619403f, -0.0006299677156675898f,
	-0.0006246934367482026f, -0.0006194321651946665f, -0.0006141839335214172f,
	-0.0006089487767440004f, -0.0006037267294232151f, -0.0005985178220271336f,
	-0.0005933220886618073f, -0.000588139560250056f, -0.0005829702708979311f,
	-0.0005778142515282524f, -0.0005726715314722241f, -0.000567542143016908f,
	-0.0005624261170851241f, -0.0005573234832354501f, -0.0005522342714812111f,
	-0.0005471585106988641f, -0.000542096230219613f, -0.00053704745801042f,
	-0.000532012225676226f, -0.0005269905577733879f, -0.0005219824818141205f,
	-0.0005169880269022542f, -0.0005120072207773773f, -0.0005070400882232206f,
	-0.0005020866558425041f, -0.000497146950692695f, -0.0004922209966480295f,
	-0.0004873088203112274f, -0.0004824104471481405f, -0.0004775258985318941f,
	-0.0004726552026568242f, -0.0004677983815781772f, -0.0004629554589428153f,
	-0.0004581264586249744f, -0.0004533114019977801f, -0.0004485103133902157f,
	-0.0004437232141754066f, -0.0004389501266359729f, -0.0004341910696439299f,
	-0.0004294460695746238f, -0.000424715144390575f, -0.0004199983143280405f,
	-0.0004152956003053986f, -0.0004106070209672907f, -0.0004059326006426999f,
	-0.0004012723509276838f, -0.0003966262977428414f, -0.0003919944563222088f,
	-0.0003873768450830539f, -0.0003827734822152706f, -0.0003781843870456214f,
	-0.0003736095757176371f, -0.0003690490646022226f, -0.0003645028705250297f,
	-0.0003599710109938314f, -0.0003554534996510483f, -0.0003509503567329375f,
	-0.0003464615947450511f, -0.000341987228466678f, -0.0003375272726771072f,
	-0.0003330817439746169f, -0.000328650655092133f, -0.0003242340196720761f,
	-0.0003198318520389875f, -0.0003154441656079143f, -0.0003110709740212769f,
	-0.0003067122893298801f, -0.000302368120628671f, -0.0002980384856527962f,
	-0.000293723392587708f, -0.0002894228539389587f, -0.0002851368824394739f,
	-0.0002808654876389482f, -0.0002766086779502074f, -0.0002723664672430459f,
	-0.0002681388641576631f, -0.0002639258773342589f, -0.0002597275183688907f,
	-0.0002555437956743844f, -0.0002513747176635661f, -0.0002472202895660302f,
	-0.0002430805268431868f, -0.0002389554329056409f, -0.0002348450150293501f,
	-0.000230749284128251f, -0.0002266682431582012f, -0.0002226019032605108f,
	-0.0002185502685279061f, -0.0002145133421436185f, -0.0002104911368405737f,
	-0.0002064836530735192f, -0.0002024908981184125f, -0.0001985128783417167f,
	-0.0001945495973814104f, -0.0001906010593302198f, -0.0001866672714641026f,
	-0.0001827482324188167f, -0.0001788439517440565f, -0.0001749544312588113f,
	-0.0001710796691440918f, -0.0001672196772233291f, -0.0001633744532227865f,
	-0.0001595439980519586f, -0.0001557283185320557f, -0.0001519274128440883f,
	-0.0001481412841712881f, -0.0001443699347873916f, -0.000140613364692399f,
	-0.0001368715738863102f, -0.0001331445650976093f, -0.0001294323383262963f,
	-0.0001257348912986344f, -0.0001220522281073499f, -0.0001183843446597165f,
	-0.000114731241865229f, -0.0001110929192691401f, -0.0001074693732334708f,
	-0.0001038606055772106f, -0.0001002666140266228f, -0.00009668739585322327f,
	-0.0000931229487832752f, -0.00008957327054304187f, -0.00008603835931353387f,
	-0.0000825182114567724f, -0.00007901282333477865f, -0.00007552219449280528f,
	-0.00007204631901913671f, -0.0000685851937305415f, -0.00006513880998681997f,
	-0.00006170717188069829f, -0.00005829026986248209f, -0.00005488809847520315f,
	-0.00005150065589987207f, -0.00004812793349628918f, -0.00004476992944546509f,
	-0.00004142663374295807f, -0.00003809804593402077f, -0.00003478415555946412f,
	-0.00003148495579807786f, -0.00002820044301188318f, -0.00002493060719643835f,
	-0.00002167544380426988f, -0.0000184349451046728f, -0.00001520910564067889f,
	-0.00001199791176986764f, -8.801359854260226E-6f, -5.619441708404337E-6f,
	-2.45214960159501E-6f, 7.005291990935802E-7f, 3.838600605376996E-6f,
	6.962074166949605E-6f, 0.00001007095806926372f, 0.00001316526277150842f,
	0.00001624499827812542f, 0.00001931017368406173f, 0.00002236080035800114f,
	0.00002539688648539595f, 0.00002841844388967729f, 0.00003142548530377098f,
	0.00003441801800363464f, 0.00003739605472219409f, 0.00004035960728288046f,
	0.00004330868705437751f, 0.00004624330676961108f, 0.00004916347552352817f,
	0.00005206920923228608f, 0.00005496051608133711f, 0.00005783741198683856f,
	0.00006069990786272683f, 0.0000635480178061698f, 0.00006638175364059861f,
	0.00006920113219166523f, 0.00007200616300906403f, 0.00007479686064471025f,
	0.0000775732414695085f, 0.00008033531594264786f, 0.00008308309952553827f,
	0.00008581660858908435f, 0.00008853585677570663f, 0.00009124085909206769f,
	0.00009393163009008276f, 0.00009660818386691971f, 0.00009927053861247259f,
	0.0001019187066049198f, 0.0001045527078531449f, 0.000107172555544821f,
	0.0001097782651413581f, 0.0001123698552873975f, 0.0001149473405348544f,
	0.0001175107377093809f, 0.0001200600650008709f, 0.0001225953378707345f,
	0.0001251165758731076f, 0.0001276237935599056f, 0.0001301170109400118f,
	0.0001325962425653415f, 0.0001350615098090202f, 0.0001375128308609419f,
	0.0001399502211825165f, 0.0001423736971446487f, 0.0001447832810299587f,
	0.0001471789914830878f, 0.0001495608498771616f, 0.0001519288703093479f,
	0.0001542830736980249f, 0.0001566234782330866f, 0.0001589501052876585f,
	0.0001612629744158766f, 0.0001635621042623824f, 0.0001658475157455541f,
	0.0001681192306932643f, 0.0001703772677501547f, 0.0001726216432871297f,
	0.000174852382770041f, 0.000177069506207772f, 0.0001792730354281957f,
	0.000181462988621206f, 0.000183639393071644f, 0.0001858022601481934f,
	0.0001879516189546848f, 0.0001900874890452541f, 0.0001922098908835323f,
	0.0001943188517543603f, 0.0001964143866644008f, 0.0001984965210795053f,
	0.0002005652740990626f, 0.00020262067710064f, 0.0002046627441814052f,
	0.000206691499442968f, 0.0002087069692606746f, 0.0002107091740981559f,
	0.000212698136238032f, 0.0002146738797819125f, 0.0002166364324693859f,
	0.0002185858102166093f, 0.0002205220412179187f, 0.0002224451486654288f,
	0.0002243551580249913f, 0.0002262520929434685f, 0.0002281359743392386f,
	0.0002300068294971424f, 0.0002318646811545477f, 0.0002337095556868007f,
	0.000235541475831269f, 0.0002373604684180463f, 0.000239166559822479f,
	0.0002409597723271872f, 0.0002427401323075173f, 0.0002445076593176054f,
	0.0002462623897372395f, 0.0002480043399373244f, 0.0002497335444786585f,
	0.0002514500170036626f, 0.0002531537911636405f, 0.0002548448978814121f,
	0.0002565233517088927f, 0.0002581891853878914f, 0.00025984242438426f,
	0.0002614830937091028f, 0.0002631112265589763f, 0.0002647268406690272f,
	0.0002663299669620755f, 0.0002679206340872042f, 0.0002694988661460229f,
	0.0002710646886043832f, 0.0002726181328398524f, 0.0002741592243182822f,
	0.0002756879885055241f, 0.0002772044590528821f, 0.000278708655059745f,
	0.0002802006147248903f, 0.0002816803544192225f, 0.0002831479041560669f,
	0.0002846033021342009f, 0.0002860465656340238f, 0.0002874777292163344f,
	0.0002888968137995107f, 0.0002903038584918249f, 0.0002916988823926658f,
	0.0002930819164248532f, 0.0002944529933301964f, 0.0002958121376650524f,
	0.0002971593785332515f, 0.0002984947450386243f, 0.0002998182681039907f,
	0.0003011299759236862f, 0.0003024298957825521f, 0.0003037180576939135f,
	0.000304994493490085f, 0.0003062592313654022f, 0.0003075123004236957f,
	0.0003087537270403117f, 0.0003099835466855438f, 0.0003112017848252435f,
	0.0003124084705632412f, 0.0003136036420983145f, 0.0003147873148918733f,
	0.0003159595353281474f, 0.0003171203197780414f, 0.0003182697100783116f,
	0.000319407724418852f, 0.0003205344037269242f, 0.0003216497716493904f,
	0.0003227538618375547f, 0.0003238467043047421f, 0.0003249283281547832f,
	0.0003259987670389818f, 0.0003270580473326845f, 0.0003281062035966897f,
	0.0003291432667538174f, 0.0003301692677268874f, 0.0003311842310722568f,
	0.0003321881968076922f, 0.0003331811913085402f, 0.0003341632491355994f,
	0.0003351344012116896f, 0.0003360946720931679f, 0.0003370440981598221f,
	0.0003379827130629564f, 0.0003389105440874118f, 0.0003398276248844922f,
	0.0003407339891055016f, 0.0003416296640352811f, 0.000342514685144124f,
	0.0003433890797168714f, 0.0003442528850428061f, 0.0003451061293162638f,
	0.000345948844369559f, 0.0003467810638539958f, 0.0003476028214208781f,
	0.0003484141470835311f, 0.0003492150672173011f, 0.0003500056282064178f,
	0.0003507858518787543f, 0.000351555763700162f, 0.0003523154118738602f,
	0.0003530648209562059f, 0.0003538040236890083f, 0.0003545330509950872f,
	0.0003552519365257467f, 0.0003559607175702694f, 0.0003566594205040019f,
	0.0003573480789782479f, 0.0003580267266443115f, 0.0003586953998819808f,
	0.0003593541205191286f, 0.0003600029294830164f, 0.0003606418649724218f,
	0.000361270947905723f, 0.0003618902173911919f, 0.0003624997079896274f,
	0.00036309944880486f, 0.0003636894743976881f, 0.0003642698129624477f,
	0.0003648405090643791f, 0.0003654015845313551f, 0.0003659530802906374f,
	0.0003664950208985828f, 0.0003670274454634636f, 0.0003675503912745625f,
	0.0003680638819787418f, 0.0003685679594127577f, 0.0003690626490424619f,
	0.0003695479917951161f, 0.0003700240076796035f, 0.0003704907467181328f,
	0.0003709482371050398f, 0.0003713965033966815f, 0.000371835587429814f,
	0.0003722655228557414f, 0.0003726863369593047f, 0.0003730980743057443f,
	0.0003735007530849543f, 0.0003738944224096485f, 0.0003742791041076998f,
	0.0003746548372873803f, 0.00037502165287151f, 0.0003753795872398768f,
	0.0003757286740437848f, 0.0003760689442060538f, 0.000376400427740009f,
	0.0003767231673919013f, 0.0003770371913560666f, 0.000377342532374314f,
	0.0003776392268264316f, 0.0003779273101827129f, 0.0003782068115469883f,
	0.0003784777645705617f, 0.0003787402110901894f, 0.0003789941692957654f,
	0.0003792396892094984f, 0.00037947679629724f, 0.0003797055205723154f,
	0.0003799259038714808f, 0.0003801379762080614f, 0.0003803417730523506f,
	0.000380537328965147f, 0.000380724670321797f, 0.0003809038362305727f,
	0.000381074863980757f, 0.0003812377799476962f, 0.0003813926259681466f,
	0.0003815394293269491f, 0.0003816782227659132f, 0.0003818090444838162f,
	0.0003819319281319621f, 0.0003820469064521603f, 0.0003821540085482411f,
	0.0003822532780759502f, 0.000382344741410634f, 0.0003824284340225858f,
	0.0003825043868346256f, 0.0003825726380455307f, 0.0003826332203971105f,
	0.0003826861602647113f, 0.0003827315022135735f, 0.0003827692762570222f,
	0.0003827995087704039f, 0.0003828222452284535f, 0.000382837516553991f,
	0.0003828453518508467f, 0.0003828457893177983f, 0.000382838855330192f,
	0.0003828245917247841f, 0.0003828030239674262f, 0.00038277419298538f,
	0.0003827381251539918f, 0.000382694855943555f, 0.0003826444335572887f,
	0.0003825868707281188f, 0.0003825222083833068f, 0.0003824504847216303f,
	0.0003823717288469197f, 0.0003822859753199736f, 0.0003821932496066438f,
	0.0003820936035481281f, 0.0003819870516963419f, 0.0003818736377070308f,
	0.0003817533925030147f, 0.0003816263488261029f, 0.0003814925385086098f,
	0.0003813520015683025f, 0.0003812047598330536f, 0.0003810508624155772f,
	0.0003808903184108203f, 0.0003807231933024013f, 0.0003805494925472885f,
	0.000380369261620217f, 0.0003801825314440065f, 0.0003799893365794559f,
	0.000379789707949385f, 0.000379583678295603f, 0.0003793712821789085f,
	0.0003791525559790898f, 0.0003789275269809877f, 0.0003786962279264116f,
	0.0003784586988331284f, 0.0003782149597100215f, 0.0003779650505748577f,
	0.000377709011445404f, 0.000377446867787512f, 0.0003771786541619803f,
	0.0003769043960346607f, 0.0003766241388802882f, 0.0003763379027077462f,
	0.0003760457311727805f, 0.0003757476533792214f, 0.0003754436911549419f,
	0.000375133889974677f, 0.0003748182825802359f, 0.0003744968944374704f,
	0.0003741697637451579f, 0.0003738369141501607f, 0.0003734983838512562f,
	0.0003731542146852007f, 0.0003728044230228988f, 0.000372449037968181f,
	0.0003720881159097189f, 0.0003717216641234699f, 0.0003713497299031587f,
	0.0003709723387146368f, 0.0003705895269376924f, 0.0003702013218571664f,
	0.0003698077543958788f, 0.0003694088645715964f, 0.0003690046742121921f,
	0.0003685952233354328f, 0.00036818053740717f, 0.0003677606509882025f,
	0.0003673355968203395f, 0.0003669053967314539f, 0.0003664701034722384f,
	0.0003660297370515763f, 0.0003655843192973406f, 0.0003651338920462876f,
	0.0003646784971351735f, 0.0003642181400209665f, 0.0003637528734543593f,
	0.0003632827101682778f, 0.0003628077065513934f, 0.0003623278735176427f,
	0.0003618432547227712f, 0.000361353859261726f, 0.0003608597435231786f,
	0.0003603609329729806f, 0.0003598574458010261f, 0.0003593493293010396f,
	0.0003588366016629151f, 0.0003583192974474513f, 0.0003577974530344363f,
	0.0003572710938897216f, 0.0003567402472981484f, 0.0003562049514584941f,
	0.0003556652263796422f, 0.0003551211193553172f, 0.000354572648575413f,
	0.0003540198449627496f, 0.0003534627430781256f, 0.0003529013665684033f,
	0.0003523357536323601f, 0.0003517659297358477f, 0.0003511919276206754f,
	0.0003506137618387583f, 0.0003500314942357363f, 0.0003494451302685774f,
	0.0003488547063170699f, 0.0003482602478470653f, 0.0003476617930573411f,
	0.0003470593692327383f, 0.0003464529982011299f, 0.0003458427217992721f,
	0.0003452285673120059f, 0.0003446105511102359f, 0.0003439887113927397f,
	0.0003433630845393054f, 0.0003427336941967951f, 0.0003421005603740923f,
	0.0003414637358218897f, 0.0003408232132642297f, 0.0003401790600037202f,
	0.00033953127967834f, 0.0003388799159438349f, 0.0003382249851711094f,
	0.0003375665291969198f, 0.000336904560754192f, 0.0003362391271366504f,
	0.0003355702356202527f, 0.0003348979353177128f, 0.0003342222516948822f,
	0.0003335431993036763f, 0.0003328608163428725f, 0.0003321751355542801f,
	0.0003314861678518354f, 0.0003307939623482525f, 0.0003300985372334253f,
	0.0003293999197921948f, 0.0003286981391283916f, 0.0003279932261648355f,
	0.0003272852045483887f, 0.0003265741052018711f, 0.0003258599481341661f,
	0.0003251427715440513f, 0.0003244225936214206f, 0.0003236994616599986f,
	0.000322973379297764f, 0.0003222443829145049f, 0.0003215124997950624f,
	0.0003207777554052881f, 0.0003200401788490125f, 0.0003192998065060237f,
	0.0003185566511092474f, 0.0003178107399435248f, 0.0003170621166646014f,
	0.000316310788548435f, 0.0003155567919748136f, 0.0003148001542285783f,
	0.0003140408971376018f, 0.0003132790534436935f, 0.0003125146504316944f,
	0.0003117476953775621f, 0.0003109782410319894f, 0.000310206300127902f,
	0.0003094319090450881f, 0.0003086550805164733f, 0.0003078758363699307f,
	0.0003070942293561529f, 0.000306310255837161f, 0.0003055239449167856f,
	0.0003047353620786452f, 0.0003039444836758775f, 0.0003031513679161434f,
	0.0003023560184374218f, 0.0003015584679815219f, 0.0003007587547472212f,
	0.0002999568823724985f, 0.0002991528945130994f, 0.0002983467966259922f,
	0.0002975386378238908f, 0.0002967284272017423f, 0.0002959162011393345f,
	0.0002951019723695935f, 0.0002942857681773602f, 0.000293467612209497f,
	0.0002926475572166964f, 0.0002918255831900751f, 0.0002910017465183045f,
	0.0002901760490203741f, 0.0002893485379900084f, 0.0002885192243411438f,
	0.0002876881335396319f, 0.0002868552764994092f, 0.0002860207205230835f,
	0.0002851844365068245f, 0.0002843464790203142f, 0.0002835068844433408f,
	0.0002826656345860101f, 0.0002818227949319407f, 0.0002809783472912386f,
	0.0002801323753374163f, 0.0002792848354147281f, 0.0002784358111966866f,
	0.0002775852772174403f, 0.000276733269856777f, 0.0002758798254944849f,
	0.0002750249695964157f, 0.0002741687167144846f, 0.0002733110741246491f,
	0.0002724520927586127f, 0.0002715917871682904f, 0.00027073016462964f,
	0.0002698672687984071f, 0.0002690031069505494f, 0.0002681377263797912f,
	0.0002672710979823023f, 0.0002664033017936162f, 0.0002655343305377755f,
	0.0002646641951287165f, 0.0002637929537741001f, 0.0002629206101119052f,
	0.0002620471823320258f, 0.0002611726849863771f, 0.000260297158092726f,
	0.0002594206234789453f, 0.0002585430702310986f, 0.0002576645711087621f,
	0.0002567850933701265f, 0.0002559047170507255f, 0.0002550234166847076f,
	0.0002541412213759031f, 0.0002532581638661213f, 0.000252374265983235f,
	0.0002514895604690536f, 0.0002506040364096406f, 0.0002497177229088265f,
	0.0002488306672603357f, 0.0002479428694641683f, 0.0002470543477102182f,
	0.0002461651238263584f, 0.0002452752269164193f, 0.0002443846824462525f,
	0.0002434934795019216f, 0.0002426016653771512f, 0.0002417092764517292f,
	0.0002408162981737405f, 0.000239922748733079f, 0.0002390286863374058f,
	0.0002381341146246995f, 0.0002372390226810239f, 0.0002363434578001033f,
	0.0002354474454477895f, 0.0002345509819861035f, 0.00023365411470877f,
	0.0002327568508917465f, 0.0002318592014489695f, 0.0002309611991222482f,
	0.0002300628402736037f, 0.0002291641721967607f, 0.0002282652058056555f,
	0.0002273659447382669f, 0.0002264664217364042f, 0.0002255666695418767f,
	0.0002246666699647903f, 0.0002237664739368483f, 0.0002228660778200719f,
	0.000221965521632228f, 0.0002210648053733166f, 0.0002201639581471681f,
	0.0002192629981436766f, 0.0002183619435527361f, 0.0002174607980123255f,
	0.0002165595979022327f, 0.0002156583577743731f, 0.0002147570849047042f,
	0.0002138557902071624f, 0.0002129545355273876f, 0.0002120532990375068f,
	0.000211152098927414f, 0.0002102509497490245f, 0.0002093498987960629f,
	0.000208448946068529f, 0.0002075480879284441f, 0.0002066473753075115f,
	0.0002057468336715828f, 0.0002048464157269336f, 0.0002039461978711187f,
	0.0002030461801041383f, 0.0002021463806158863f, 0.0002012468212342355f,
	0.0002003474801313132f, 0.0001994484337046742f, 0.000198549656488467f,
	0.0001976511848624795f, 0.0001967530151887331f, 0.0001958551838470157f,
	0.0001949577199411578f, 0.0001940606016432866f, 0.0001931638471432961f,
	0.0001922675110108684f, 0.0001913715859700459f, 0.0001904760647448711f,
	0.0001895810019050259f, 0.0001886863938125316f, 0.0001877922732091974f,
	0.0001868986146291717f, 0.0001860054799180943f, 0.0001851128690759651f,
	0.0001842207675508689f, 0.0001833292262745089f, 0.0001824382634367793f,
	0.000181547860847786f, 0.0001806580548873171f, 0.0001797688673832453f,
	0.0001788802983355708f, 0.0001779923768481239f, 0.0001771051101968623f,
	0.0001762185020197648f, 0.0001753325668687466f, 0.0001744473411235958f,
	0.0001735628138703759f, 0.0001726790324028115f, 0.0001717959639790933f,
	0.0001709136631689034f, 0.0001700321299722418f, 0.0001691513862169813f,
	0.0001682714173512067f, 0.0001673922561167273f, 0.0001665139388933312f,
	0.0001656364293012302f, 0.0001647597891860641f, 0.0001638840149098541f,
	0.0001630090810067486f, 0.0001621350929781328f, 0.0001612619598745368f,
	0.0001603897726454306f, 0.0001595184876350685f, 0.0001586481375852599f,
	0.0001577787843416444f, 0.000156910355144646f, 0.0001560429263918194f,
	0.0001551764653413556f, 0.0001543110411148518f, 0.0001534466027806047f,
	0.0001525832085462752f, 0.0001517208766017574f, 0.0001508595669292844f,
	0.0001499993377365171f, 0.0001491401926614344f, 0.0001482821317040361f,
	0.0001474251512263435f, 0.000146569320349954f, 0.0001457146026950795f,
	0.0001448610237275715f, 0.000144008587085409f, 0.0001431573036825284f,
	0.0001423072171746753f, 0.000141458302095998f, 0.0001406105802743695f,
	0.0001397640444338321f, 0.0001389187527820467f, 0.0001380746834911406f,
	0.0001372318511130288f, 0.0001363902701996266f, 0.0001355499407509341f,
	0.0001347109209746122f, 0.0001338731381110846f, 0.0001330366940237581f,
	0.0001322015086770989f, 0.0001313676693825982f, 0.0001305351397604681f,
	0.000129703948914539f, 0.0001288741405005566f, 0.0001280456417589448f,
	0.000127218518173322f, 0.000126392777019646f, 0.0001255684255738742f,
	0.0001247454711119644f, 0.0001239239500137045f, 0.0001231037749676033f,
	0.0001222851060447283f, 0.0001214678050018846f, 0.0001206519955303519f,
	0.0001198376339743845f, 0.0001190247203339822f, 0.0001182132909889332f,
	0.0001174033168354071f, 0.0001165948924608528f, 0.0001157879596576094f,
	0.0001149825038737617f, 0.0001141785833169706f, 0.000113376161607448f,
	0.0001125753187807276f, 0.0001117760184570215f, 0.0001109782679122872f,
	0.0001101820962503552f, 0.0001093874525395222f, 0.0001085944168153218f,
	0.000107802974525839f, 0.000107013140222989f, 0.000106224906630814f,
	0.0001054382810252718f, 0.0001046532706823199f, 0.0001038699119817465f,
	0.0001030881612678058f, 0.0001023080985760316f, 0.0001015296438708901f,
	0.0001007528990157879f, 0.00009997779125114902f, 0.00009920435695676133f,
	0.00009843263251241296f, 0.00009766257426235824f, 0.00009689427679404616f,
	0.00009612763824407011f, 0.00009536272409604862f, 0.00009459953434998169f,
	0.00009383806172991171f, 0.00009307836444349959f, 0.00009232039883499965f,
	0.00009156415035249665f, 0.00009080969175556674f, 0.00009005697211250662f,
	0.00008930607873480767f, 0.00008855693158693611f, 0.00008780955977272242f,
	0.00008706396329216659f, 0.00008632021490484476f, 0.00008557827823096886f,
	0.00008483811689075082f, 0.00008409980364376679f, 0.00008336328028235584f,
	0.00008262859773822128f, 0.00008189577783923596f, 0.00008116478420561179f,
	0.00008043565321713685f, 0.00007970836304593831f, 0.00007898289186414331f,
	0.00007825938519090414f, 0.00007753766840323805f, 0.00007681789429625496f,
	0.00007609996100654825f, 0.00007538393401773646f, 0.00007466981332981958f,
	0.0000739575843908824f, 0.00007324726175284013f, 0.00007253882358781993f,
	0.0000718323717592284f, 0.00007112779712770134f, 0.00007042515790089964f,
	0.00006972447590669617f, 0.00006902567110955715f, 0.00006832884537288919f,
	0.0000676340059726499f, 0.00006694108742522075f, 0.00006625011883443221f,
	0.0000655611147521995f, 0.00006487408245448023f, 0.0000641890219412744f,
	0.00006350593321258202f, 0.00006282483809627592f, 0.00006214570748852565f,
	0.0000614685850450769f, 0.00006079345621401444f, 0.00006012036465108394f,
	0.00005944923032075166f, 0.00005878008960280567f, 0.00005811298615299165f,
	0.00005744791269535198f, 0.00005678481102222576f, 0.00005612377572106197f,
	0.00005546476313611492f, 0.00005480777326738461f, 0.00005415279156295582f,
	0.0000534998980583623f, 0.00005284901271807029f, 0.00005220022285357117f,
	0.00005155340477358549f, 0.00005090871127322316f, 0.00005026605504099279f,
	0.00004962542152497917f, 0.0000489868689328432f, 0.00004835041181650012f,
	0.00004771596286445856f, 0.00004708366759587079f, 0.00004645342414733022f,
	0.00004582521069096401f, 0.00004519911453826352f, 0.00004457511386135593f,
	0.0000439532013842836f, 0.00004333336255513131f, 0.00004271560464985668f,
	0.00004210000042803585f, 0.00004148642619838938f, 0.00004087499110028147f,
	0.00004026565875392407f, 0.00003965842188335955f, 0.00003905328048858791f,
	0.00003845027822535485f, 0.00003784934961004182f, 0.00003725058923009783f,
	0.0000366538661182858f, 0.00003605931851780042f, 0.00003546688822098076f,
	0.00003487660433165729f, 0.00003428845229791477f, 0.00003370239573996514f,
	0.00003311845648568123f, 0.00003253670729463919f, 0.00003195705357939004f,
	0.00003137955354759469f, 0.00003080419264733791f, 0.00003023094177478924f,
	0.00002965984458569437f, 0.00002909087197622284f, 0.00002852410398190841f,
	0.0000279594532912597f, 0.00002739691262831911f, 0.00002683657658053562f,
	0.00002627835056046023f, 0.00002572229277575388f, 0.00002516836684662848f,
	0.00002461658004904165f, 0.00002406699786661192f, 0.00002351954753976315f,
	0.00002297425817232578f, 0.00002243110793642699f, 0.00002189016959164291f,
	0.0000213513703783974f, 0.00002081466664094477f, 0.00002028016024269163f,
	0.00001974783663172274f, 0.00001921766670420765f, 0.00001868967956397682f,
	0.00001816381700336933f, 0.00001764015178196132f, 0.00001711858203634619f,
	0.00001659926783759146f, 0.00001608209277037531f, 0.00001556701317895203f,
	0.00001505418913438916f, 0.00001454356242902576f, 0.00001403498754370957f,
	0.00001352865365333855f, 0.00001302445889450609f, 0.00001252244692295789f,
	0.00001202260318677872f, 0.00001152491313405334f, 0.000011029391316697f,
	0.00001053606683854013f, 0.00001004485238809138f, 9.555820724926888E-6f,
	9.069015504792332E-6f, 8.584320312365889E-6f, 8.101807907223701E-6f,
	7.621434633620083E-6f, 7.143258699215948E-6f, 6.667236448265612E-6f,
	6.193382432684302E-6f, 5.721740308217704E-6f, 5.252222763374447E-6f,
	4.784844350069761E-6f, 4.319546860642731E-6f, 3.856650437228381E-6f,
	3.395733074285089E-6f, 2.936983946710824E-6f, 2.4804612621665E-6f,
	2.026063157245516E-6f, 1.573789631947875E-6f, 1.123757101595401E-6f,
	6.758054951205849E-7f, 2.300948835909366E-7f, -2.135057002305984E-7f,
	-6.549962563440203E-7f, -1.094304025173187E-6f, -1.531472662463784E-6f,
	-1.966443960554897E-6f, -2.399319782853126E-6f, -2.830056473612785E-6f,
	-3.258610377088189E-6f, -3.685010597109794E-6f, -4.109286237508058E-6f,
	-4.531408194452524E-6f, -4.951449227519333E-6f, -5.369263817556202E-6f,
	-5.784924724139273E-6f, -6.198533810675144E-6f, -6.610003765672445E-6f,
	-7.019276381470263E-6f, -7.426468073390424E-6f, -7.831506081856787E-6f,
	-8.234477718360722E-6f, -8.635179256089031E-6f, -9.033887181431055E-6f,
	-9.430368663743138E-6f, -9.824871085584163E-6f, -0.00001021713251248002f,
	-0.00001060732756741344f, -0.00001099533983506262f, -0.00001138140214607119f,
	-0.00001176519435830414f, -0.00001214690564665943f, -0.00001252656511496752f,
	-0.00001290405634790658f, -0.00001327948120888322f, -0.00001365286880172789f,
	-0.00001402405905537307f, -0.00001439319748897105f, -0.00001476018223911523f,
	-0.0000151251588249579f, -0.00001548798172734677f, -0.00001584876736160367f,
	-0.00001620744296815246f, -0.0000165639939950779f, -0.00001691849320195615f,
	-0.00001727094058878719f, -0.00001762137981131672f, -0.000017969636246562f,
	-0.00001831579720601439f, -0.00001865999365691095f, -0.00001900206552818417f,
	-0.00001934211468324065f, -0.00001968005381058901f, -0.00002001598477363586f,
	-0.00002034989302046597f, -0.00002068167668767273f, -0.00002101146674249321f,
	-0.00002133910311385989f, -0.00002166480408050119f, -0.00002198849688284099f,
	-0.00002231006510555744f, -0.0000226296397158876f, -0.00002294710429850965f,
	-0.00002326267713215202f, -0.0000235760526265949f, -0.00002388758002780377f,
	-0.00002419704105705022f, -0.00002450447937007993f, -0.00002480988041497766f,
	-0.00002511327329557389f, -0.00002541467256378382f, -0.00002571407821960747f,
	-0.00002601153391879051f, -0.00002630692324601113f, -0.00002660034806467592f,
	-0.00002689173561520874f, -0.00002718117320910096f, -0.00002746863174252212f,
	-0.00002775418397504836f, -0.00002803762617986649f, -0.00002831917663570493f,
	-0.00002859870437532663f, -0.00002887628215830773f, -0.00002915201184805482f,
	-0.0000294256315100938f, -0.00002969733031932264f, -0.00002996712282765656f,
	-0.00003023495082743465f, -0.00003050084342248737f, -0.00003076480061281472f,
	-0.00003102682239841669f, -0.00003128689422737807f, -0.00003154503065161406f,
	-0.00003180130443070083f, -0.00003205554094165563f, -0.00003230792935937643f,
	-0.00003255836782045662f, -0.00003280703094787895f, -0.00003305356949567794f,
	-0.00003329825995024293f, -0.00003354120417498052f, -0.00003378218389116227f,
	-0.00003402121365070343f, -0.00003425836621318012f, -0.00003449367068242281f,
	-0.00003472717071417719f, -0.00003495864802971482f, -0.00003518835001159459f,
	-0.00003541613114066421f, -0.00003564215148799121f, -0.00003586619277484714f,
	-0.00003608853148762136f, -0.00003630889113992452f, -0.00003652738814707845f,
	-0.00003674409526865929f, -0.0000369589397450909f, -0.00003717205254361033f,
	-0.00003738325904123485f, -0.00003759257378987967f, -0.00003780017141252756f,
	-0.00003800593549385666f, -0.000038209866033867f, -0.00003841199213638901f,
	-0.00003861231380142271f, -0.000038810889236629f, -0.00003900760202668607f,
	-0.00003920253948308527f, -0.00003939573070965707f, -0.00003958708839491009f,
	-0.00003977678716182708f, -0.00003996450686827301f, -0.00004015056765638291f,
	-0.00004033494042232632f, -0.00004051739233545958f, -0.00004069830174557864f,
	-0.00004087723209522664f, -0.00004105450352653861f, -0.00004123008693568408f,
	-0.00004140401142649352f, -0.00004157607327215373f, -0.00004174644709564745f,
	-0.00004191504558548331f, -0.00004208201426081359f, -0.00004224723670631647f,
	-0.00004241071292199194f, -0.00004257253021933138f, -0.00004273257218301296f,
	-0.00004289104253984987f, -0.00004304776666685938f, -0.00004320283187553286f,
	-0.00004335606354288756f, -0.00004350781091488897f, -0.00004365787026472389f,
	-0.00004380621248856186f, -0.00004395286669023334f, -0.00004409794928506016f,
	-0.00004424146027304232f, -0.00004438307951204478f, -0.0000445231853518635f,
	-0.00004466163227334618f, -0.00004479853669181466f, -0.00004493366577662527f,
	-0.00004506736877374351f, -0.00004519920912571251f, -0.00004532956518232822f,
	-0.00004545834963209927f, -0.00004558544605970382f, -0.00004571099998429417f,
	-0.0000458349531982094f, -0.00004595733480527997f, -0.00004607820301316678f,
	-0.00004619744140654802f, -0.00004631507908925414f, -0.00004643117426894605f,
	-0.00004654558142647147f, -0.00004665847518481314f, -0.00004676994285546243f,
	-0.0000468798098154366f, -0.0000469881051685661f, -0.0000470948580186814f,
	-0.00004720012657344341f, -0.00004730379441753029f, -0.00004740600707009434f,
	-0.00004750664811581373f, -0.00004760589217767119f, -0.00004770356463268399f,
	-0.00004779972368851304f, -0.00004789439844898879f, -0.00004798744339495897f,
	-0.00004807929508388042f, -0.00004816945875063538f, -0.0000482581672258675f,
	-0.00004834547871723771f, -0.00004843121860176324f, -0.00004851561971008777f,
	-0.00004859847831539809f, -0.00004867985262535512f, -0.00004875994636677205f,
	-0.0000488384102936834f, -0.00004891553544439375f, -0.0000489911762997508f,
	-0.00004906553658656775f, -0.00004913832526654005f, -0.00004920971696265041f,
	-0.00004927979898639023f, -0.00004934851313009858f, -0.0000494156265631318f,
	-0.00004948143032379448f, -0.00004954586620442569f, -0.00004960896330885589f,
	-0.00004967054701410233f, -0.00004973108298145234f, -0.00004978996003046631f,
	-0.00004984755651094019f, -0.00004990372690372169f, -0.00004995858762413263f,
	-0.00005001210956834256f, -0.00005006429273635149f, -0.00005011516623198986f,
	-0.0000501646427437663f, -0.0000502128095831722f, -0.00005025981226935982f,
	-0.00005030533066019415f, -0.00005034959758631885f, -0.00005039249663241207f,
	-0.00005043434794060885f, -0.0000504745403304696f, -0.00005051368498243391f,
	-0.00005055157816968858f, -0.00005058792885392904f, -0.00005062323180027306f,
	-0.00005065716686658561f, -0.0000506899959873408f, -0.00005072142812423408f,
	-0.00005075175431556999f, -0.00005078062531538307f, -0.00005080844857729971f,
	-0.00005083496216684579f, -0.00005086016608402132f, -0.00005088435136713087f,
	-0.00005090699414722621f, -0.00005092856008559465f, -0.00005094913649372756f,
	-0.00005096831591799855f, -0.00005098630208522081f, -0.00005100315320305526f,
	-0.00005101898568682372f, -0.0000510333920828998f, -0.00005104654701426625f,
	-0.00005105868331156671f, -0.00005106965545564889f, -0.00005107946344651281f,
	-0.00005108819459564983f, -0.00005109576159156858f, -0.00005110198981128633f,
	-0.00005110708298161625f, -0.00005111127393320202f, -0.00005111406790092587f,
	-0.00005111587233841419f, -0.00005111671634949743f, -0.00005111630889587104f,
	-0.00005111470818519592f, -0.00005111232167109847f, -0.00005110853817313909f,
	-0.00005110405618324875f, -0.00005109794437885284f, -0.00005109101766720414f,
	-0.00005108298500999808f, -0.00005107378819957375f, -0.00005106377648189663f,
	-0.00005105260061100125f, -0.00005104028969071805f, -0.00005102693103253841f,
	-0.00005101258284412324f, -0.0000509970705024898f, -0.0000509808596689254f,
	-0.00005096333916299045f, -0.00005094491643831133f, -0.00005092541687190532f,
	-0.00005090486956760287f, -0.0000508833909407258f, -0.00005086086457595229f,
	-0.00005083729047328233f, -0.00005081290146335959f, -0.00005078734830021858f,
	-0.00005076098022982478f, -0.00005073344800621271f, -0.00005070504266768693f,
	-0.00005067576421424746f, -0.00005064537981525063f, -0.00005061400588601827f,
	-0.00005058193346485495f, -0.00005054892972111701f, -0.00005051452899351716f,
	-0.0000504797208122909f, -0.00005044369027018547f, -0.00005040661199018359f,
	-0.00005036889342591166f, -0.00005033030174672603f, -0.00005029060412198305f,
	-0.00005025009158998727f, -0.00005020882235839962f, -0.00005016656359657645f,
	-0.00005012337351217865f, -0.00005007925210520625f, -0.00005003419937565922f,
	-0.00004998844815418124f, -0.00004994188202545046f, -0.00004989438457414507f,
	-0.00004984572296962141f, -0.00004979677032679319f, -0.00004974647890776395f,
	-0.0000496956636197865f, -0.00004964409163221716f, -0.00004959129728376865f,
	-0.00004953803727403283f, -0.00004948378773406147f, -0.00004942854866385459f,
	-0.00004937296034768223f, -0.00004931626608595252f, -0.00004925898974761366f,
	-0.00004920043284073472f, -0.0000491415848955512f, -0.00004908180562779307f,
	-0.00004902121145278215f, -0.0000489596277475357f, -0.00004889752017334103f,
	-0.00004883453948423266f, -0.00004877097671851515f, -0.0000487067736685276f,
	-0.00004864134825766086f, -0.00004857563180848956f, -0.00004850886762142181f,
	-0.00004844169598072767f, -0.00004837336018681526f, -0.00004830467514693737f,
	-0.00004823494236916303f, -0.00004816468572244048f, -0.00004809402162209153f,
	-0.00004802236799150705f, -0.00004795001586899161f, -0.00004787690704688429f,
	-0.00004780309973284602f, -0.00004772871034219861f, -0.00004765362245962023f,
	-0.00004757801070809364f, -0.0000475013512186706f, -0.00004742410965263843f,
	-0.00004734634421765804f, -0.00004726805491372942f, -0.00004718918353319168f,
	-0.00004710908979177474f, -0.00004702887963503599f, -0.00004694785457104444f,
	-0.00004686624743044376f, -0.00004678405821323394f, -0.00004670099588111042f,
	-0.00004661770071834325f, -0.00004653353244066238f, -0.00004644872387871146f,
	-0.00004636339144781231f, -0.00004627765156328678f, -0.00004619127139449119f,
	-0.00004610395990312099f, -0.00004601641558110713f, -0.00004592828918248414f,
	-0.00004583934787660837f, -0.00004574970807880163f, -0.00004565995186567306f,
	-0.00004556967178359627f, -0.00004547846037894487f, -0.00004538643406704068f,
	-0.00004529458237811923f, -0.00004520191578194499f, -0.00004510855069383978f,
	-0.00004501506919041275f, -0.00004492048174142837f, -0.00004482583608478307f,
	-0.00004473020089790225f, -0.00004463444929569959f, -0.00004453805740922689f,
	-0.00004444108344614505f, -0.00004434393486008048f, -0.00004424602957442402f,
	-0.00004414777504280209f, -0.00004404876381158828f, -0.00004394946154206991f,
	-0.00004384975181892514f, -0.00004374957643449306f, -0.00004364858614280819f,
	-0.00004354759585112333f, -0.00004344584885984659f, -0.00004334375262260437f,
	-0.0000432410161010921f, -0.000043138163164258f, -0.00004303455352783203f,
	-0.00004293065285310149f, -0.00004282640293240547f, -0.00004272180376574397f,
	-0.00004261656431481242f, -0.00004251085920259356f, -0.00004240480484440922f,
	-0.0000422984012402594f, -0.00004219153197482228f, -0.00004208448808640241f,
	-0.00004197662929072976f, -0.00004186853766441345f, -0.00004176032962277531f,
	-0.00004165124846622347f, -0.00004154187627136707f, -0.00004143250407651066f,
	-0.0000413224333897233f, -0.00004121212987229228f, -0.00004110141890123486f,
	-0.0000409905333071947f, -0.0000408790074288845f, -0.00004076719051226973f,
	-0.00004065549001097679f, -0.00004054256714880466f, -0.0000404299353249371f,
	-0.00004031707067042589f, -0.00004020327469334006f, -0.00004008942050859332f,
	-0.00003997562453150749f, -0.00003986078081652522f, -0.00003974634455516934f,
	-0.00003963144263252615f, -0.00003951590042561292f, -0.00003940012538805603f,
	-0.00003928464138880372f, -0.00003916776040568947f, -0.00003905087942257523f,
	-0.00003893434768542647f, -0.00003881723387166857f, -0.00003869994543492794f,
	-0.00003858184209093451f, -0.000038463796954602f, -0.00003834557719528675f,
	-0.00003822706639766693f, -0.00003810878843069076f, -0.00003798957914113998f,
	-0.00003787002060562372f, -0.00003775057848542928f, -0.00003763090353459119f,
	-0.00003751099575310945f, -0.00003739073872566223f, -0.00003727024886757135f,
	-0.00003714952617883682f, -0.00003702857065945863f, -0.00003690714947879314f,
	-0.00003678572829812765f, -0.00003666442353278398f, -0.00003654242027550935f,
	-0.00003642064984887838f, -0.00003629829734563827f, -0.00003617606125771999f,
	-0.0000360533595085144f, -0.00003593077417463064f, -0.00003580725751817226f,
	-0.00003568420652300119f, -0.00003556080628186464f, -0.00003543740604072809f,
	-0.00003531319089233875f, -0.00003518990706652402f, -0.00003506580833345651f,
	-0.00003494124393910169f, -0.00003481656312942504f, -0.00003469223156571388f,
	-0.00003456790000200271f, -0.00003444333560764789f, -0.00003431783989071846f,
	-0.00003419246058911085f, -0.00003406754694879055f, -0.00003394193481653928f,
	-0.00003381632268428802f, -0.00003369094338268041f, -0.00003356498200446367f,
	-0.0000334389042109251f, -0.00003331294283270835f, -0.00003318674862384796f,
	-0.00003306020516902208f, -0.00003293412737548351f, -0.00003280770033597946f,
	-0.00003268045838922262f, -0.00003255438059568405f, -0.00003242737147957086f,
	-0.00003230036236345767f, -0.00003217312041670083f, -0.000032045878469944f,
	-0.00003191933501511812f, -0.0000317917438223958f, -0.00003166438546031713f,
	-0.00003153702709823846f, -0.00003140990156680345f, -0.00003128184471279382f,
	-0.00003115460276603698f, -0.00003102701157331466f, -0.00003089930396527051f,
	-0.00003077101428061723f, -0.00003064330667257308f, -0.00003051571547985076f,
	-0.00003038765862584114f, -0.00003025948535650968f, -0.00003013166133314371f,
	-0.00003000360447913408f, -0.00002987508196383714f, -0.00002974714152514934f,
	-0.00002961920108646154f, -0.00002949079498648643f, -0.0000293627381324768f,
	-0.00002923444844782352f, -0.00002910604234784841f, -0.00002897775266319513f,
	-0.00002884981222450733f, -0.00002872152253985404f, -0.00002859346568584442f,
	-0.00002846471033990383f, -0.00002833642065525054f, -0.00002820859663188457f,
	-0.00002808019053190946f, -0.00002795190084725618f, -0.00002782337833195924f,
	-0.00002769520506262779f, -0.00002756703179329633f, -0.00002743862569332122f,
	-0.00002731033600866794f, -0.00002718262840062379f, -0.00002705457154661417f,
	-0.0000269259326159954f, -0.00002679775934666395f, -0.00002666993532329797f,
	-0.00002654187846928834f, -0.0000264141708612442f, -0.00002628576476126909f,
	-0.00002615840639919042f, -0.00002603046596050262f, -0.00002590217627584934f,
	-0.00002577481791377067f, -0.00002564722672104835f, -0.00002551963552832603f,
	-0.00002539262641221284f, -0.00002526433672755956f, -0.00002513662911951541f,
	-0.00002500973641872406f, -0.00002488261088728904f, -0.00002475583460181951f,
	-0.0000246287090703845f, -0.00002450146712362766f, -0.00002437434159219264f,
	-0.00002424744889140129f, -0.00002412078902125358f, -0.00002399436198174953f,
	-0.00002386746928095817f, -0.00002374092582613229f, -0.00002361496444791555f,
	-0.00002348830457776784f, -0.00002336222678422927f, -0.00002323591616004705f,
	-0.00002311018761247396f, -0.00002298445906490087f, -0.00002285849768668413f,
	-0.00002273288555443286f, -0.00002260692417621612f, -0.00002248166128993034f,
	-0.00002235604915767908f, -0.00002223090268671512f, -0.0000221063382923603f,
	-0.00002198107540607452f, -0.00002185686025768518f, -0.00002173113171011209f,
	-0.0000216071493923664f, -0.00002148258499801158f, -0.00002135848626494407f,
	-0.00002123392187058925f, -0.00002110993955284357f, -0.00002098642289638519f,
	-0.00002086255699396133f, -0.0000207388075068593f, -0.00002061482518911361f,
	-0.00002049177419394254f, -0.00002036849036812782f, -0.00002024602144956588f,
	-0.00002012285403907299f, -0.0000200006179511547f, -0.00001987803261727094f,
	-0.00001975568011403083f, -0.00001963367685675621f, -0.00001951120793819427f,
	-0.00001938967034220695f, -0.00001926836557686328f, -0.00001914671156555414f,
	-0.00001902505755424499f, -0.0000189041020348668f, -0.00001878279726952314f,
	-0.00001866207458078861f, -0.0000185410026460886f, -0.00001842109486460685f,
	-0.00001830141991376876f, -0.00001818174496293067f, -0.00001806137152016162f,
	-0.00001794216223061084f, -0.00001782272011041641f, -0.00001770327799022197f,
	-0.00001758383587002754f, -0.00001746485941112041f, -0.00001734634861350059f,
	-0.00001722737215459346f, -0.00001710932701826095f, -0.00001699151471257209f,
	-0.00001687300391495227f, -0.00001675589010119438f, -0.00001663831062614917f,
	-0.00001652096398174762f, -0.00001640454865992069f, -0.00001628743484616279f,
	-0.00001617125235497951f, -0.00001605437137186527f, -0.00001593725755810737f,
	-0.00001582177355885505f, -0.00001570628955960273f, -0.00001559010706841945f,
	-0.00001547508873045444f, -0.00001536007039248943f, -0.00001524528488516807f,
	-0.00001513073220849037f, -0.00001501687802374362f, -0.00001490185968577861f,
	-0.00001478893682360649f, -0.00001467438414692878f, -0.00001456076279282569f,
	-0.00001444783993065357f, -0.00001433468423783779f, -0.00001422129571437835f,
	-0.00001410930417478084f, -0.00001399754546582698f, -0.00001388508826494216f,
	-0.00001377309672534465f, -0.00001366203650832176f, -0.00001354981213808059f,
	-0.000013439217582345f, -0.00001332862302660942f, -0.00001321826130151748f,
	-0.00001310789957642555f, -0.00001299730502068996f, -0.00001288880594074726f,
	-0.00001277797855436801f, -0.00001266878098249435f, -0.00001255958341062068f,
	-0.00001245131716132164f, -0.00001234258525073528f, -0.00001223455183207988f,
	-0.00001212628558278083f, -0.00001202011480927467f, -0.00001191021874547004f,
	-0.00001180451363325119f, -0.00001169927418231964f, -0.00001159124076366424f,
	-0.00001148413866758346f, -0.0000113779678940773f, -0.0000112729612737894f,
	-0.00001116679050028324f, -0.00001106131821870803f, -0.00001095561310648918f,
	-0.0000108520034700632f, -0.00001074769534170627f, -0.00001064268872141838f,
	-0.0000105390790849924f, -0.00001043593510985374f, -0.00001033232547342777f,
	-0.00001022941432893276f, -0.00001012603752315044f, -0.0000100242905318737f,
	-9.922543540596961E-6f, -9.819632396101951E-6f, -9.71788540482521E-6f
};



float *Interp::gimx = 0;

void Interp::init_gimx()
{
	const int size = 100;
	gimx = new float[size * size * size];
	const float g = (float) (10.4 / (M_PI * M_PI));	// magic number here

	for (int k = 0; k < size; k++) {
		for (int j = 0; j < size; j++) {
			for (int i = 0; i < size; i++) {
				float r = Util::hypot3(i / 39.0f, j / 39.0f, k / 39.0f);
				gimx[i + j * size + k * size * size] = exp(-r / g);
			}
		}
	}
}
