/*! \mainpage EMAN2 Documentation
 *
 * \section intro_sec Introduction
 * Welcome to VERSION 2 of EMAN, a open-source Software for Single
 * Particle Analysis and Electron Micrograph Analysis. EMAN2 is
 * designed to handle both small, low-symmetry single particles and
 * large, high symmetry viruses. It uses more object-oriented
 * technologies for better modular design, has convenient and flexible
 * interfaces to promote extendibility, emphases easy and efficient
 * use in Python, and many new capabilities.
 *
 *
 * \section install_sec Installation
 *  Here are the <a href="http://blake.bcm.edu/emanwiki/EMAN2/Install"> Installation Instruction</a>.
 *
 * \section manual_sec Manuals
 *  <ul>
 *    <li> <a href="../processors.html"> Manual of Individual Processor</a>
 *    <li> <a href="../processor_groups.html"> Manual of Grouped Processors</a>
 * 	  <li> <a href="../aligners.html"> Manual of Individual Aligner</a>
 *    <li> <a href="../analyzers.html"> Manual of Individual Analyzer</a>
 *    <li> <a href="../averagers.html"> Manual of Individual Averager</a>
 *    <li> <a href="../cmps.html"> Manual of Individual Comparator</a>
 *    <li> <a href="../projectors.html"> Manual of Individual Projector</a>
 *    <li> <a href="../reconstructors.html"> Manual of Individual Reconstructor</a>
 *    <li> <a href="../developer-guide.html"> Developer's FAQ</a>
 *    <li> <a href="../adding_processor.html"> Adding New Processor How-to</a>
 *    <li> <a href="../coding_style.html"> EMAN2 Coding Style</a>
 *    <li> <a href="../cvshowto.html"> EMAN2 developer CVS Howto</a>
 *    <li> <a href="../development_policy_faq.html"> EMAN2 Development Policy FAQ</a>
 *    <li> <a href="../develop_system_setup.html"> EMAN2 Development System Setup</a>
 *    <li> <a href="../exception_faq.html"> EMAN2 Exception FAQ</a>
 *    <li> <a href="../header_naming.html"> EMAN2 Header Naming</a>
 *    <li> <a href="../testing.html"> EMAN2 Tesing Framework</a>
 *    <li> Documentation (<a href="../EMAN2.dvi"> dvi</a>, <a href="../EMAN2.ps"> ps</a>, <a href="../EMAN2.pdf"> pdf</a>, <a href="../EMAN2.html/index.html"> html</a>)
 *  </ul>
 */
/** @defgroup CUDA_ENABLED a function or class that is CUDA enabled */
/** @defgroup tested0 code not yet complete  */
/** @defgroup tested1 code complete but untested */
/** @defgroup tested2 code complete but contains bugs */
/** @defgroup tested3 tested */
/** @defgroup tested3a manual testing
 *  @ingroup tested3 */
/** @defgroup tested3b unit test in C++
 * 		@ingroup tested3 */
/** @defgroup tested3c unit test in Python
 *  	@ingroup tested3 */
/** @defgroup tested3d incorporated into successful regression test
 * 		@ingroup tested3 */
