package com.sap.ip.me.mdk.api.awt.gui.page;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseListener;

import com.sap.ip.me.mdk.api.awt.gui.component.ComponentConstants;
import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.ListHeaderPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.ListPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
import com.sap.ip.me.mdk.api.awt.gui.panel.navigation.PageNavPanel;
import com.sap.ip.me.mdk.api.awt.gui.panel.navigation.TopNavLink;

/**
 * Generates a detail page with a table with 2 columns. The left column contains a link that can be
 * clicked to get details about this entry.
 */
public abstract class DetailListPage extends BasicPage {

	private LinkButton homeLink = null;
	protected LinkButton createLink = null;
	protected LinkButton backLink = null;
	private ListPanel listTable = null;
	private ListHeaderPanel listTableHeaderLeft = null;
	private ListHeaderPanel listTableHeaderRight = null;
	private TopNavLink topLink = null;
	private PageNavPanel pageNav = null;
	protected MouseListener actionHandler = null;
	protected static Image imgNew = ComponentConstants.getImage(ComponentConstants.iconNew);
	protected static Image imgBack = ComponentConstants.getImage(ComponentConstants.iconBackToTop);

	private DetailListPage() {
	}
	public DetailListPage(MouseListener actionHandler) {
		super();
		this.actionHandler = actionHandler;

		/* No home link in detail page		homeLink = new LinkButton(Constants.TXT_HOME);
				homeLink.setTargetPage(Constants.TP_CONHOME);
				homeLink.setTargetHandler(Constants.HND_SHOWHOME);
				homeLink.addMouseListener(this.actionHandler); 
				topLink = new TopNavLink();
				topLink.setLinks(new LinkButton[]{homeLink});
				this.setTopLink(topLink); */

		/* Icon to add an entry */
		createLink = new LinkButton(imgNew);
		createLink.addMouseListener(actionHandler);
		createLink.setName("Add new car");
		this.setActionBarLinks(new LinkButton[] { createLink });

		listTableHeaderLeft = new ListHeaderPanel();
		listTableHeaderRight = new ListHeaderPanel();
		//this.setBodyHeader(listTableHeader); 

		listTable = new ListPanel();
		this.setBody(listTable);

		pageNav = new PageNavPanel();
		pageNav.setCommonActionHandler(actionHandler);
		this.setFooterNavBar(pageNav);

	}
	public void setBackActionAttributes(String targetPage, String targetHandler) {
		if (backLink == null)
			backLink = new LinkButton(imgBack);
		backLink.addMouseListener(actionHandler);
		backLink.setTargetPage(targetPage);
		backLink.setTargetHandler(targetHandler);
		this.setActionBarLinks(new LinkButton[] { createLink, backLink });
		validate();
	}
	public void setCreateActionAttributes(String targetPage, String targetHandler) {
		createLink.setTargetPage(targetPage);
		createLink.setTargetHandler(targetHandler);
	}
	public void setPageNavHandlers(String[] handlerNames) {
		pageNav.setTargetHandler(handlerNames);
	}
	public void setTopLinkCommand(String targetPage, String handlerName) {
		homeLink.setTargetPage(targetPage);
		homeLink.setTargetHandler(handlerName);
	}
	public void setFooterMessage(String msgText) {
		pageNav.setMessageText(msgText);
	}
	public void setPagingContols(Component[] c) {
		pageNav.addToLeft(c);
	}
	public void removePageNav() {
		this.remove(pageNav);
		validate();
	}

	public void setList(LinkButton[] links, TextLabel[] texts) {
		listTable.removeAll();
		int count = links.length < texts.length ? links.length : texts.length;
		listTable.appendLine(listTableHeaderLeft, listTableHeaderRight);
		for (int i = 0; i < count; i++)
			listTable.appendLine(links[i], texts[i]);
		listTable.validate();
	}

	public void setListHeader(LinkButton[] links, TextLabel[] texts) {
		listTableHeaderLeft.removeAll();
		listTableHeaderRight.removeAll();
		int count = links.length < texts.length ? links.length : texts.length;
		for (int i = 0; i < count; i++) {
			listTableHeaderLeft.appendLine(links[i]);
			listTableHeaderRight.appendLine(texts[i]);
		}
//		listTableHeader.validate();
	}

	public void disableFirstPrevPageNav() {
		pageNav.disableFirstAndPrevious();
	}
	public void disableNextLastPageNav() {
		pageNav.disableNextAndLast();
	}
	public void enableFirstPrevPageNav() {
		pageNav.enableFirstAndPrevious();
	}
	public void enableNextLastPageNav() {
		pageNav.enableNextAndLast();
	}

	abstract public void initializePage();
	abstract public void destroyPage();
	abstract public void updatePage();
}
