package com.sap.ip.me.mdk.api.awt.gui.page;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseListener;

import com.sap.ip.me.mdk.api.awt.gui.component.ComponentConstants;
import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.ListPanel;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;

/**
 * Basic implementation of a create page. It conatins the save and cancel button.
 */
public abstract class CreatePage extends BasicPage {

	protected LinkButton saveButton = null;
	protected LinkButton cancelButton = null;
	private ListPanel listTable = null;
	protected MouseListener actionHandler = null;

	protected static Image imgSave = ComponentConstants.getImage(ComponentConstants.iconSave);
	protected static Image imgDSave = ComponentConstants.getImage(ComponentConstants.iconDSave);
	protected static Image imgCancel = ComponentConstants.getImage(ComponentConstants.iconCancel);

	private CreatePage() {
	}
	public CreatePage(MouseListener actionHandler) {
		super();
		this.actionHandler = actionHandler;

		saveButton = new LinkButton(imgSave, imgDSave);
		saveButton.addMouseListener(actionHandler);
		cancelButton = new LinkButton(imgCancel);
		cancelButton.addMouseListener(actionHandler);
		this.setActionBarLinks(new LinkButton[] { saveButton, cancelButton });

		listTable = new ListPanel();
		this.setBody(listTable);

	}
	public void setSaveActionAttributes(String targetPage, String targetHandler) {
		saveButton.setTargetPage(targetPage);
		saveButton.setTargetHandler(targetHandler);
	}
	public void setCancelActionAttributes(String targetPage, String targetHandler) {
		cancelButton.setTargetPage(targetPage);
		cancelButton.setTargetHandler(targetHandler);
	}

	/**
	 * Method setCancelActionAttributes.- different pages if it is clicked All or another char
	 * @param String - targetPages and targetHandlers
	 */
	public void setCancelActionAttributes(String targetPageAll, String targetHandlerAll, String targetPageChar, String targetHandlerChar) {
		cancelButton.setTargetPage(targetPageAll, targetPageChar, (String) getAttribute(ATTR_CUR_NAV_CHAR));
		cancelButton.setTargetHandler(targetHandlerAll, targetHandlerChar, (String) getAttribute(ATTR_CUR_NAV_CHAR));
	}

	public void setFormField(TextLabel text, Component[] field) {
		listTable.appendLine(text, field);
	}
	public void setFormFields(TextLabel[] texts, Component[][] fields) {
		listTable.removeAll();
		int count = fields.length < texts.length ? fields.length : texts.length;
		for (int i = 0; i < count; i++)
			listTable.appendLine(texts[i], fields[i]);
		listTable.validate();
	}

	abstract public void initializePage();
	abstract public void destroyPage();
	abstract public void updatePage();
}
