package com.sap.ip.me.mdk.api.awt.gui.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;

/**
 * ActionPanel is used by the BasicPage method. It generates the basic layout for the center page.
 */
public class ActionPanel extends Panel {
	private BorderedPanel centerPanel = null;
	private BorderedPanel leftPanel = null;
	private BorderedPanel rightPanel = null;

	public ActionPanel() {
		this(null, null);
	}
	public ActionPanel(Component[] left, Component[] right) {
		super(new BorderLayout());
		leftPanel = new BorderedPanel(new FlowLayout(FlowLayout.LEFT, 0, 0));
		leftPanel.enableBGDraw(true);
		leftPanel.enableBorderDraw(false);
		rightPanel = new BorderedPanel(new FlowLayout(FlowLayout.RIGHT, 0, 0));
		rightPanel.enableBGDraw(true);
		rightPanel.enableBorderDraw(false);
		centerPanel = new BorderedPanel(new FlowLayout(FlowLayout.CENTER, 0, 0));
		centerPanel.enableBGDraw(true);
		centerPanel.enableBorderDraw(false);
		add(BorderLayout.WEST, leftPanel);
		add(BorderLayout.EAST, rightPanel);
		add(BorderLayout.CENTER, centerPanel);
		if (left != null)
			addToLeft(left);
		if (right != null)
			addToRight(right);
	}

	public void addToLeft(Component[] c) {
		leftPanel.removeAll();
		for (int i = 0; i < c.length; i++)
			leftPanel.add(c[i]);
	}
	public void addToRight(Component[] c) {
		rightPanel.removeAll();
		for (int i = 0; i < c.length; i++)
			rightPanel.add(c[i]);
	}
	public void setBackground(Color c) {
		leftPanel.setBackgroundColor(c);
		centerPanel.setBackgroundColor(c);
		rightPanel.setBackgroundColor(c);
	}
}
