package com.sap.ip.me.mdk.api.awt.gui.panel;

import java.awt.Component;
import java.awt.Image;
import java.awt.event.MouseListener;

import com.sap.ip.me.mdk.api.awt.gui.component.LinkButton;
import com.sap.ip.me.mdk.api.awt.gui.component.TextLabel;
/**
 * Creates a navigation panel with icons and sets the events.
 */
public class ImageNavPanel extends NavPanel {

	public static final int FIRST = 0;
	public static final int PREV = 1;
	public static final int NEXT = 2;
	public static final int LAST = 3;

	TextLabel txtMessage = null;
	LinkButton[] navButtons = null;
	Image[] enableImages = null;
	Image[] disableImages = null;

	public ImageNavPanel(Image[] eImages, Image[] dImages, MouseListener commonListener, String[] targetPages, String[] targetHandlers) {
		enableImages = eImages;
		disableImages = dImages;
		initializeButtons(targetPages);
		addToRight(navButtons);
		if (commonListener != null)
			setCommonActionHandler(commonListener);
		if (targetPages != null)
			setTargetPage(targetPages);
		if (targetHandlers != null)
			setTargetHandler(targetHandlers);
	}
	private void initializeButtons(String[] actionString) {
		if (enableImages != null) {
			navButtons = new LinkButton[enableImages.length];
			for (int i = 0; i < navButtons.length; i++)
				navButtons[i] = new LinkButton(enableImages[i]);
		} else {
			navButtons = new LinkButton[actionString.length];
			for (int i = 0; i < navButtons.length; i++)
				navButtons[i] = new LinkButton(actionString[i]);
		}
	}
	public void setCommonActionHandler(MouseListener msListener) {
		for (int i = 0; i < navButtons.length; i++)
			setActionHandler(i, msListener);
	}
	public void disableFirstAndPrevious() {
		navButtons[FIRST].setEnabled(false);
		navButtons[PREV].setEnabled(false);
		setDisabledImage(FIRST);
		setDisabledImage(PREV);
		invalidate();
	}
	public void disableNextAndLast() {
		navButtons[NEXT].setEnabled(false);
		navButtons[LAST].setEnabled(false);
		setDisabledImage(NEXT);
		setDisabledImage(LAST);
		invalidate();
	}
	public void enableFirstAndPrevious() {
		navButtons[FIRST].setEnabled(true);
		navButtons[PREV].setEnabled(true);
		setEnabledImage(FIRST);
		setEnabledImage(PREV);
		invalidate();
	}
	public void enableNextAndLast() {
		navButtons[NEXT].setEnabled(true);
		navButtons[LAST].setEnabled(true);
		setEnabledImage(NEXT);
		setEnabledImage(LAST);
		invalidate();
	}
	public void setActionHandler(int whichButton, MouseListener msListener) {
		if (whichButton <= LAST && whichButton >= FIRST)
			navButtons[whichButton].addMouseListener(msListener);
	}
	public void setTargetPage(String[] actionString) {
		for (int i = 0; i < actionString.length; i++)
			setTargetPage(i, actionString[i]);
	}
	public void setTargetPage(int whichButton, String targetPage) {
		if (whichButton <= LAST && whichButton >= FIRST)
			navButtons[whichButton].setTargetPage(targetPage);
	}
	public void setTargetHandler(String[] targetHandlers) {
		for (int i = 0; i < targetHandlers.length; i++)
			setTargetHandler(i, targetHandlers[i]);
	}
	public void setTargetHandler(int whichButton, String targetHandler) {
		if (whichButton <= LAST && whichButton >= FIRST)
			navButtons[whichButton].setTargetHandler(targetHandler);
	}
	public void setMessageText(String messageText) {
		if (txtMessage == null) {
			txtMessage = new TextLabel(messageText);
			Component[] msg = { txtMessage };
			addToLeft(msg);
		} else {
			txtMessage.setLabel(messageText);
		}
		super.validate();
	}
	public void setActionAttributes(int whichButton, String targetPage, String targetHandler) {
		setTargetPage(whichButton, targetPage);
		setTargetHandler(whichButton, targetHandler);
	}
	private void setDisabledImage(int whichButton) {
		if (whichButton <= LAST && whichButton >= FIRST)
			navButtons[whichButton].setImage(disableImages[whichButton]);
	}
	private void setEnabledImage(int whichButton) {
		if (whichButton <= LAST && whichButton >= FIRST)
			navButtons[whichButton].setImage(enableImages[whichButton]);
	}
}
