package com.sap.ip.me.mdk.api.awt.gui.component;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Panel;

import com.sap.ip.me.mdk.api.awt.gui.util.Utilities;

/**
 * Generated a panel with sepcified background and a frame.
 */
public class BorderedPanel extends Panel {
	private boolean bDrawBorder = true;
	private boolean bDrawBackGround = true;
	protected Color bgColor = Utilities.menuBodyBGColor;
	private String lineMask = "TBLR"; //top,bottom,left,right

	public BorderedPanel() {
		super();
	}
	public BorderedPanel(LayoutManager lm) {
		super(lm);
	}
	public void setBackgroundColor(Color c) {
		bgColor = c;
	}
	public void enableBGDraw(boolean st) {
		bDrawBackGround = st;
	}
	public void enableBorderDraw(boolean st) {
		bDrawBorder = st;
	}
	public void setBorderMask(String mask) {
		lineMask = mask;
		repaint();
	}

	public void paint(Graphics g) {

		if (bDrawBackGround) {
			g.setColor(bgColor);
			g.fillRect(1, 1, getSize().width, getSize().height);
		}
		if (bDrawBorder) {
			g.setColor(Color.gray);
			
			if (lineMask.indexOf("T") > -1)
				drawTopLine(g);
			if (lineMask.indexOf("B") > -1)
				drawBottomLine(g);
			if (lineMask.indexOf("R") > -1)
				drawRightLine(g);
			if (lineMask.indexOf("L") > -1)
				drawLeftLine(g);
		}

		super.paint(g);
	}
	private void drawTopLine(Graphics g) {
		g.drawLine(0, 0, getSize().width, 0);
	}
	private void drawBottomLine(Graphics g) {
		g.drawLine(0, getSize().height - 1, getSize().width, getSize().height - 1);
	}
	private void drawLeftLine(Graphics g) {
		g.drawLine(0, 0, 0, getSize().height - 1);
	}
	private void drawRightLine(Graphics g) {
		g.drawLine(getSize().width - 1, 0, getSize().width - 1, getSize().height);
	}
}
