package persistenceexample2.datafactory;

import persistenceexample2.Constants;

import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
/**
 *  Car entity - represents the car type (manufacturer)
 *               A Car entity can have a relation to one License entity
 */

public class Car implements PersistableEntity {

  final static String CLASSTYPE = "Car-Query";

 
  public PersistenceContainer getPersistedObject() {
	return this.obj;
  }

  private final PersistenceContainer obj;

  /**
   *  Constructor for the Car object
   *
   *@param  entityKey  Description of the Parameter
   */
  Car(PersistenceContainer obj) {
	this.obj = obj;
  }

  /**
   *  Gets the entityKey attribute of the Car object
   *
   *@return    The entityKey value
   */
  public String getEntityKey() {
    return this.obj.getKey();
  }

  /**
   *  Gets the classtype attribute of the Car object
   *
   *@return    The classtype value
   */
  public String getClasstype() {
    return CLASSTYPE;
  }

  public void setValues(String make, String mod, String engtyp, int cylnum, int valves) {
  	obj.setAttribute(0, make);
  	obj.setAttribute(1,mod);
  	obj.setAttribute(2, engtyp);
    Integer integer_value = new Integer(cylnum);
    obj.setAttribute(3, integer_value);
	integer_value = new Integer(valves);
	obj.setAttribute(4, integer_value);
  }

  /**
   *  Sets the license attribute of the Car object
   *
   *@param  License  The new License value
   */
  void setLicense(License license) {
  	obj.setSingleLink(0, (PersistableEntity) license);
  }

  public String toString() {
  	String rawText = this.obj.getKey();
// Convert String into HTML compliant string
    return rawText;
  }

  public String licToString() {
  	PersistableEntity pe = this.obj.getSingleLink(0);  
	String temp = Constants.NOT_REGISTERED;
	if (pe != null) temp = (String)this.obj.getSingleLink(0).toString();
	return temp;
  }
  
  public String modelToString() {
     return (String) obj.getAttribute(1);
  }
  
  public String makeToString() {
    return (String) obj.getAttribute(0);
  }

  public String engineToString() {
   return this.obj.getAttribute(2).toString();
  }
  
  public String cylToString() {
   return this.obj.getAttribute(3).toString();
  }

  public String valveToString() {
  	 return this.obj.getAttribute(4).toString();
  }
}
