package genericsyncexample1;
import genericsyncexample1.bean.UserInformation;

import java.io.Serializable;

import com.sap.ip.me.api.logging.Severities;
import com.sap.ip.me.api.sync.InboundContainer;
import com.sap.ip.me.api.sync.InboundContainerElement;
import com.sap.ip.me.api.sync.InboundProcessor;

/**
 * The InboundProcessor serves as event handler. When ever a inbound container arrives
 * an event is generated and the "process" method of the InboundProcessor is called.
 * 
 * Implementations of the InboundProcessor must be implemented "Serializable" !
 */
public class InboundProcessing implements InboundProcessor, Constants, Serializable {

/**
 *@return    The r3 method name
 */

  public String getMethodName() {
    return R3_METHOD_GET_USER_INFO;
  }

/**
 *  Processes incoming datacontainer. Adds received user information to user
 *  information list.
 *
 *@param  inbound  The inbound data container
 */

  public void process(InboundContainer inbound) {
	GenericSyncExample.aLogger.log(Severities.INFO, "CookbookExampleInboundProcessing: Processing incoming data container");
    dumpContainer(inbound);
    InboundContainerElement[] userInfos = inbound.getElementsWithFieldName(DC_E_USER_INFORMATION);

    for (int i = 0; i < userInfos.length; i++) {
      String info = userInfos[i].getFieldValue();
      // evaluate incoming data container items

      UserInformation userInfo = UserInformation.getInstance();
      try {
        userInfo.setMandant(info.substring(0, 3).trim());
        userInfo.setUserName(info.substring(3, 15).trim());
        userInfo.setFirstName(info.substring(15, 45).trim());
        userInfo.setLastName(info.substring(45, 75).trim());
        userInfo.setCompanyName(info.substring(75, 105).trim());
        userInfo.setSalut(info.substring(105, 120).trim());
        userInfo.setBuilding(info.substring(120, 126).trim());
        userInfo.setRoom(info.substring(126, 132).trim());
        userInfo.setCountry(info.substring(132, 135).trim());
        userInfo.setPhone(info.substring(135).trim());
      }
      catch (StringIndexOutOfBoundsException outOfBounds) {
        // do not care about shortened datacontainer values
      }
    }
	GenericSyncExample.aLogger.log(Severities.DEBUG, "GenericSyncExampleInboundProcessing: Processing incoming data container done.");
  }

/**
 *  Dumps the container content to the trace log with trace level
 *  DEVELOP_LEVEL. For test purposes only.
 *
 *@param  container  The inbound data container
 */
  private void dumpContainer(InboundContainer container) {
    InboundContainerElement elements[] = container.getAllElements();
	GenericSyncExample.aLogger.log(Severities.DEBUG, "GenericSyncExampleInboundProcessing: ************************************************************");
	GenericSyncExample.aLogger.log(Severities.DEBUG, "GenericSyncExampleInboundProcessing:  Datacontainer contains {0} Elements", new Integer(elements.length));
    for (int i = 0; i < elements.length; i++) {
		GenericSyncExample.aLogger.log(Severities.DEBUG, "GenericSyncExampleInboundProcessing:   {0}. Element: name={1}[{2}]", new Integer(i), elements[i].getFieldName(), elements[i].getLineNumber());
		GenericSyncExample.aLogger.log(Severities.DEBUG, "GenericSyncExampleInboundProcessing:            value={0}", elements[i].getFieldValue());
    }
	GenericSyncExample.aLogger.log(Severities.DEBUG, "GenericSyncExampleInboundProcessing: ************************************************************");
  }

}
