package genericsyncexample1;
import genericsyncexample1.bean.TableViewBean;
import genericsyncexample1.bean.UserInformation;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.PropertyKeys;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AbstractLogging;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Severities;
import com.sap.ip.me.api.runtime.jsp.AbstractMEHttpServlet;
import com.sap.ip.me.api.sync.InboundProcessorRegistry;
import com.sap.ip.me.api.sync.OutboundContainer;
import com.sap.ip.me.api.sync.OutboundContainerFactory;
import com.sap.ip.me.api.sync.SyncException;
import com.sap.ip.me.api.sync.SyncManager;
import com.sap.ip.me.api.sync.SyncPasswordException;

// Display information about your ME client installation

public class GenericSyncExample extends AbstractMEHttpServlet implements Constants {
	private TableViewBean dataBean;
	private String headLine;
    public static AbstractLogging aLogger=null;    

	/**
	 * Must be overwritten - return the name of the application
	 */
	public String getApplicationName() {
		return MI_APPLICATION_NAME;
	}

	/**
	 * doIntialize - called when the servlet is activated the first time
	 */
	public void doInitialize() throws ServletException {
		/* No resource bundle used    setResourceBundle("ResourceBundle"); */
		//	Prepare a log output - Level DEBUG - Information about classloader
		ClassLoader cl = getClass().getClassLoader();
		aLogger = AppLog.getInstance(MI_APPLICATION_NAME);
		aLogger.log(Severities.DEBUG, "MIClientInfo: Create MIClientInfoServlet.doInitialize with Classloader {0}", (cl == null ? "(null)" : cl.toString())); //$NON-NLS-1$ //$NON-NLS-2$

		// register class for datacontainer import
		InboundProcessing ip = new InboundProcessing();
		InboundProcessorRegistry.getInstance().register(ip);
		aLogger.log(Severities.INFO, "GenericSyncExample servlet: Inbound processing class for function ''{0}'' registered.", R3_METHOD_GET_USER_INFO);
	}

	/**
	 * doHandleEvent - called any subsequent time when an event on the web client occurs.
	 */

	public String doHandleEvent(String eventName, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// Set the name of the JSP that has to be called when this method is finished.
		// INITIAL_JSP ist defined in the interface Constants.java and refers to welcome.jsp. This JSP displays a welcome message
		// and asks for your name. Welcome.jsp has a submit button which generates the event EVENT_NAME. When this event occurs,
		// the tableView.jsp is called and displays system information.
		// The welcome.jsp is called by default - if the servlet is called the first time or an unknown event occurs.

		// Initialize error message - hopefully it will stay null = no error
		String errorMessage = null;

		// Set default JSP.
		String nextJSP = INITIAL_JSP;

		// Set default text for headline
		headLine = WELCOME_MESSAGE;

		if (eventName.equals(EVENT_NAME)) {
			// Event occurs when the submit button has been pressed.
			// We take the content of the inputfield in the JSP named NAME_OF_USER and store it in the bean.
			// This string is displayed as head line together with the WELCOME_MESSAGE_TRAILER and the WELCOME_MESSAGE_END
			// when the TABLEVIEW_JSP is displayed.
			String userName = (String) request.getParameter(NAME_OF_USER);
			String syncPassword = (String) request.getParameter(SYNC_PASSWORD);
			headLine = WELCOME_MESSAGE_TRAILER + userName.toUpperCase() + WELCOME_MESSAGE_FOR_USER;

			// getUserInfo reads the inbound container. It returns an error message when synchonization did not work
			errorMessage = getUserInfo(userName, syncPassword);

			// In case a errorMessage is delivered we change the headline to inform the user
			if (errorMessage != null) {
				headLine = WELCOME_MESSAGE_TRAILER + userName.toUpperCase() + ERROR_MESSAGE_FOR_USER;
			}

			//  TABLEVIEW_JSP handles the display of the userdata and error message
			nextJSP = TABLEVIEW_JSP;
		}
		// Get bean, if there is one, in the session context, otherwise create a new instance.
		getBeansFromContext(request);

		//  load bean with userInfo
		loadBean(errorMessage);

		// Put bean in the session context.
		putBeansIntoContext(request);

		// Exit with name of JSP.
		return nextJSP;
	}

	/**
	 *  Requests the user information from the R/3 system for a given R/3 user
	 *  name.
	 *
	 *@param  userName           Description of the Parameter
	 *@exception  SyncException  Description of the Exception
	 */
	public String getUserInfo(String userName, String syncPassword) {
		String errormessage = null;
		aLogger.log(Severities.DEBUG, "systemInfo.getUserInfo() reads R/3 user information for user: {0}", userName);
		try {
			// get user out of the SyncSettings
			String user = Configuration.getInstance().getProperty(PropertyKeys.SYNCSETTINGS_USER, userName);

			// create a new SyncOutboundContainer for the current user and the
			// R3 function "ZME_COOKBOOK_EXAMPLE"; wait for response
			OutboundContainerFactory outfactory = OutboundContainerFactory.getInstance();
			if (outfactory == null) {
				errormessage = "OutboundContainerFactory.getInstance failed";
			} else {
				OutboundContainer out = outfactory.createOutboundContainer(VisibilityType.SEPARATED, R3_METHOD_GET_USER_INFO, OutboundContainer.TYPE_REQUEST);

				// add the name that has been typed into the JSP
				out.addItem(DC_I_USER_NAME, userName.toUpperCase());
				out.close();

				// trigger synchronization. When a inbound container arrives a event is generated.
				// To process the event you have to implement the InboundProcess (see InboundPorcessing.java)
				SyncManager sm = SyncManager.getInstance(); 
				if (sm.isSyncCredentialAvailable() == false) {
					System.out.println("Sync password not set yet. Set Sync password");
					sm.setSyncPasswordOfCurrentUser(syncPassword);
				}
				sm.synchronizeWithBackend();
			}
		} catch (SyncException ex) {
			errormessage = ex.getMessage();
		} catch (SyncPasswordException e) {
			errormessage = e.getMessage();
			System.out.println("Password could not be set: "+e);
		} finally {
			aLogger.log(Severities.DEBUG, "UserInformationManager: Get information from R3 for user done.");
		}
		return errormessage;
	}

	private void getBeansFromContext(HttpServletRequest request) {
		// Get bean from session context. There is a bean, when this servlet has already been called once.
		dataBean = (TableViewBean) request.getSession().getAttribute(CONTEXT_BEAN);

		// No bean in session context - create a new instance.
		if (dataBean == null)
			dataBean = new TableViewBean();
	}

	public void loadBean(String errorMessage) {
		dataBean.setString(headLine);

		// if errorMessage is null - no error occured on sync - so we load the user info in the bean
		// Otherwise the errorMessage is loaded in the bean
		if (errorMessage == null) {

			// Get instance of Configuration
			UserInformation ui = UserInformation.getInstance();
			int i = 0;

			// Load array in bean with information from the inbound container, i is the index for the entries
			dataBean.setTableContent(i, 0, "Name");
			dataBean.setTableContent(i, 1, "Value");

			i++;
			dataBean.setTableContent(i, 0, "First name");
			dataBean.setTableContent(i, 1, stringLoad(ui.getFirstName()));

			i++;
			dataBean.setTableContent(i, 0, "Last name");
			dataBean.setTableContent(i, 1, stringLoad(ui.getLastName()));

			i++;
			dataBean.setTableContent(i, 0, "Company");
			dataBean.setTableContent(i, 1, stringLoad(ui.getCompanyName()));

			i++;
			dataBean.setTableContent(i, 0, "Building");
			dataBean.setTableContent(i, 1, stringLoad(ui.getBuilding()));

			i++;
			dataBean.setTableContent(i, 0, "Country");
			dataBean.setTableContent(i, 1, stringLoad(ui.getCountry()));

			i++;
			dataBean.setTableContent(i, 0, "Phone");
			dataBean.setTableContent(i, 1, stringLoad(ui.getPhone()));

			i++;
			// Set length and width of the array.
			dataBean.setTableRows(i);
			dataBean.setTableColumns(2);

		} else {
			// load only errormessage
			dataBean.setTableContent(0, 0, errorMessage);
			dataBean.setTableRows(1);
			dataBean.setTableColumns(1);
		}

	}

	// method to supply
	public String stringLoad(String var) {
		// This method checks if a String is null - if so, it uses a standard text
		// The string will be encoded for HTML output
		String vartmp = encodeForHtml(var);
		if ((vartmp == null) || (vartmp.length() == 0))
			vartmp = "<I>Value not found in inbound container</I>";

		return vartmp;
	}

	private void putBeansIntoContext(HttpServletRequest request) {
		// Put bean in session context
		if (dataBean == null) {
			request.getSession().removeAttribute(CONTEXT_BEAN);
		} else {
			request.getSession().setAttribute(CONTEXT_BEAN, dataBean);
		}
	}

}