package mdkInventory1.bean;

import java.util.Vector;

import mdkInventory1.Constants;
import mdkInventory1.dataAccess.SmartSyncDBAccess;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.smartsync.SmartSyncException;

public class BasicDataHandler implements Constants {
	private static int columns;
	private static Vector tableHeaderNamesToDisplay;
	private static MeIterator rows;
	private Vector retSubVec;
	private static BasicDataHandler bdh = null;
	private static SmartSyncDBAccess dbAccess = null;
	private static int start_index;
	private static int sort_index;
	private static boolean sort_ascending;
	private static int recCount;
	private int tablecolumns;
	private static String miHomeFolder;

	public static int rows_in_dataset;
	public static int tablerows;
	public static int current_index;

	/**
	 * int start: start index of items to display - the index is set by the navigation
	 * int count: number of rows to display - depends on the settings in Constants.java
	 * int sortIndex: column index which whould be sorted
	 * int sort_type: ascending/decending sorting
	 * String filter_String: item filter. Only items starting with a certain letter are displayed
	 */
	public static BasicDataHandler instance(boolean refreshSyncBoCount, int start, int count, int sortIndex, boolean sort_type, String filter_string) {
		if (bdh == null)
			bdh = new BasicDataHandler();
		if (dbAccess == null) 
			dbAccess = new SmartSyncDBAccess();
		// We need the amount of synbos for the navigation. So we get the counter only once and 
		// update our the counter in the programm. Iterating over the syncbos should be done
		// too often.
		// To do that, we get all entities (sortindex =-1). The row_in_dataset index is than
		// updated in the application, for example incremented in the addEntry method.
		if (refreshSyncBoCount == true)	
			rows_in_dataset = dbAccess.getNumberOfSyncBos();
		

		rows = dbAccess.readEntitiesFromDB(start, count, sortIndex, sort_type, filter_string);
		setColumns(dbAccess.getColumns());
		sort_ascending = sort_type;
		sort_index = sortIndex;
		return bdh;
	}

	//	get the syncbos in a vector
	//  The result is returned and also kept locally as retSubVec to be retrieved by the bean

	public void getDataArray() {
		retSubVec = dbAccess.getEntities(rows, 0, -1);
		return;
	}

	//	returns a specific entry of the current subarray
	public String getCurrentSubTableContent(int row, int column) {
		//Check for end of Vector
		if (row >= retSubVec.size()) {
			// If there is no more data, return an empty string
			return "";
		}
		// Vector data = (Vector) retSubVec.get(row);
		Vector data = (Vector) retSubVec.elementAt(row);
		// return data.get(column).toString();
		return data.elementAt(column).toString();
	}

	/**
	 * used to set the MI homefolder from the main application
	 */
	public void setMiHomeFolder(String string) {
		miHomeFolder = string;
	}

	public String getMiHomeFolder() {
		return miHomeFolder;
	}

	public String getTableHeaderName(int col) {
		return dbAccess.getTableHeaderName(col);
	}

	public int getColumns() {
		return columns;
	}

	public static void setColumns(int col) {
		columns = col;
	}

	// returns the header vector
	public Vector getTableHeader() {
		return tableHeaderNamesToDisplay;
	}

	// Definition of table header
	public void initTableHeader(int noFields) {
		tableHeaderNamesToDisplay = new Vector();
		for (int i = 0; i < noFields; i++) {
			// tableHeaderNamesToDisplay.add(" ");
			tableHeaderNamesToDisplay.addElement(" ");
		}
	}

	public void setTableHeader(Vector vector) {
		tableHeaderNamesToDisplay = vector;
	}

	// public void setTableHeaderEntry(int col, String entry) {
	public void setTableHeaderEntry(String entry, int col) {		
		// tableHeaderNamesToDisplay.set(col, entry);
		tableHeaderNamesToDisplay.setElementAt(entry, col);
	}

	// returns the number of the rows of the currently displayed table
	public int getTableRows() {
		return tablerows;
	}

	public String getHeaderContent(int column) {
		// if (tableHeaderNamesToDisplay.get(column) == null) {
		if (tableHeaderNamesToDisplay.elementAt(column) == null) {
			return null;
		} else {
			// String ret = tableHeaderNamesToDisplay.get(column).toString();
			String ret = tableHeaderNamesToDisplay.elementAt(column).toString();
			if (column == I_PRODUCTID) {
				// Column 1 is returned as link - so that it can be clicked and the sortorder can be changed 
				ret = ("<a href=\"?event=" + EVENT_SORTBYPRODUCTID + "\" > <img src=\"" + getMimeProductIDFileName() + "\" border=\"0\">" + ret + "</a>");
			}
			return ret;
		}
	}

	/**
	 * Method getMimeModelFileName. - gets the apporiate filename to indicate sorting direction for model
	 * @return String
	 */
	private String getMimeProductIDFileName() {
		String mime = "mimes/ascending.gif";
		if (sort_ascending == false)
			mime = "mimes/descending.gif";
		return mime;
	}

	// sets the number of the rows of the currently displayed table
	public void setTableRows(int i) {
		tablerows = i;
	}

	public int getTableColumns() {
		return tablecolumns;
	}

	public void setTableColumns(int col) {
		tablecolumns = col;
	}

	// Get and set methods for number of rows in the dataset
	public void setRowsInDataset(int i) {
		rows_in_dataset = i;
	}
	public int getRowsInDataset() {
		return rows_in_dataset;
	}

	// Get and set methods for the current index
	public int getCurrentIndex() {
		return current_index;
	}

	public void setCurrentIndex(int i) {
		current_index = i;
	}

	/**
	 * @param synckey - syncbo key of entry
	 * @param newValue - new value for entry
	 * @param col - column index which has to be changed
	 */
	public boolean modifyEntry(String synckey, String newValue, int col) {
		boolean suc = true;
		try {
			dbAccess.modifyRowInDB(null, synckey, newValue, col);
		} catch (SmartSyncException e) {
			System.out.println(e);
			suc = false;
		} catch (PersistenceException e) {
			System.out.println(e);
			suc = false;
		}
		return suc;
	}

	/**
	 * @param newValues - array that contains the new values
	 */
	public boolean addEntry(String[] newValues) {
		boolean suc = true;
		try {
			dbAccess.addRowInDB(null, newValues);
			rows_in_dataset++;
		} catch (SmartSyncException e) {
			System.out.println(e);
			suc = false;
		} catch (PersistenceException e) {
			System.out.println(e);
			suc = false;
		}
		// Update record count
		return suc;
	}
}
